/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2009 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////
#include "lib_pictureviewer.h"

PictureViewLibrary* picture_viewer_lib_cache = NULL;

static PictureViewLibrary* CheckPictureViewLib(LONG offset)
{
	return (PictureViewLibrary*)CheckLib(C4D_PICTUREVIEWER_LIBRARY_ID, offset, (C4DLibrary**)&picture_viewer_lib_cache);
}

PictureViewer* CreatePictureViewer(LONG type)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, CreatePictureViewer));
	if (!lib || !lib->CreatePictureViewer) return NULL;
	return (PictureViewer*)lib->CreatePictureViewer(type);
}

Bool PictureViewer::Open()
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, Open));
	if (!lib || !lib->Open) return FALSE;
	return (((iPictureViewer*)this)->*(lib->Open))(); 
}

Bool PictureViewer::ShowFile(const Filename &File)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, ShowFile));
	if (!lib || !lib->ShowFile) return NULL;
	return (((iPictureViewer*)this)->*(lib->ShowFile))(File);  
}

Bool PictureViewer::ShowImage(BaseBitmap *Bmp, const String &Name)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, ShowImage));
	if (!lib || !lib->ShowImage) return NULL;
	return (((iPictureViewer*)this)->*(lib->ShowImage))(Bmp,Name);  
}

Bool PictureViewer::AddSound(GeListNode *pNode, const BaseTime &from, const BaseTime &to, BaseSound *sound)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, AddSound));
	if (!lib || !lib->AddSound) return NULL;
	return (((iPictureViewer*)this)->*(lib->AddSound))(pNode,from,to,sound);  
}

GeListNode* PictureViewer::OpenRendering(const String &Name,Real Fps,LONG lStart,LONG lEnd,BaseContainer* bcrender )
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, OpenRendering));
	if (!lib || !lib->OpenRendering) return NULL;
	return (((iPictureViewer*)this)->*(lib->OpenRendering))(Name,Fps,lStart,lEnd,bcrender); 
}

Bool PictureViewer::AddRenderingEx(GeListNode *pNode, BaseBitmap *Bmp,const String &Name,const BaseTime &Time,LONG Frame,
																 const Filename &savename,Bool fully_saved,Filename **filename_list,LONG filename_count)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, AddRenderingEx));
	if (!lib || !lib->AddRenderingEx) return NULL;
	return (((iPictureViewer*)this)->*(lib->AddRenderingEx))(pNode,Bmp,Name,Time,Frame,savename,fully_saved,filename_list,filename_count);  
}

Bool PictureViewer::CloseRenderingEx(GeListNode *&pNode, LONG action)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, CloseRenderingEx));
	if (!lib || !lib->CloseRenderingEx) return NULL;
	return (((iPictureViewer*)this)->*(lib->CloseRenderingEx))(pNode,action); 
}

Bool PictureViewer::Message(LONG id, void *t_data)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, Message));
	if (!lib || !lib->Message) return NULL;
	return (((iPictureViewer*)this)->*(lib->Message))(id,t_data); 
}

Bool PictureViewer::AddRendering(GeListNode *pNode, BaseBitmap *Bmp,const String &Name,const BaseTime &Time,LONG Frame,
																 const Filename &savename,Bool fully_saved,Filename **filename_list,LONG filename_count, Bool bAlwaysCopy)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, AddRendering));
	if (!lib || !lib->AddRendering) return NULL;
	return (((iPictureViewer*)this)->*(lib->AddRendering))(pNode,Bmp,Name,Time,Frame,savename,fully_saved,filename_list,filename_count,bAlwaysCopy);  
}

Bool PictureViewer::CloseRendering(GeListNode *&pNode, LONG action, Bool bAlwaysCopy)
{
	PictureViewLibrary *lib = CheckPictureViewLib(LIBOFFSET(PictureViewLibrary, CloseRendering));
	if (!lib || !lib->CloseRendering) return NULL;
	return (((iPictureViewer*)this)->*(lib->CloseRendering))(pNode,action,bAlwaysCopy); 
}
