#include "lib_snapping.h"

//////////////////////////////////////////////////////////////////////////

DetectSnappingLib *lib_snapping = NULL;

static DetectSnappingLib *CheckDetectSnappingLib(LONG offset)
{
	return (DetectSnappingLib*)CheckLib(LIBRARY_SNAPPING,offset,(C4DLibrary**)&lib_snapping);
}

#define DetectSnappingLibCall(b) 		DetectSnappingLib *lib = CheckDetectSnappingLib(LIBOFFSET(DetectSnappingLib, b)); \
															if (!lib || !lib->b) return; \
															(((iDetectSnapping*)this)->*lib->b)

#define DetectSnappingLibCallR(a,b)  DetectSnappingLib *lib = CheckDetectSnappingLib(LIBOFFSET(DetectSnappingLib, b)); \
															if (!lib || !lib->b) return a; \
															return (((iDetectSnapping*)this)->*lib->b)

DetectSnapping* DetectSnapping::Alloc()
{
	DetectSnappingLib *lib = CheckDetectSnappingLib(LIBOFFSET(DetectSnappingLib,Alloc)); if (!lib) return NULL;
	return (DetectSnapping*)lib->Alloc();	
}

void DetectSnapping::Free(DetectSnapping *&p)
{
	if (!p) return;
	DetectSnappingLib *lib = CheckDetectSnappingLib(LIBOFFSET(DetectSnappingLib,Free)); if (!lib) return;
	iDetectSnapping* i = (iDetectSnapping*)p;
	lib->Free(i);
	p = NULL;
}

//////////////////////////////////////////////////////////////////////////

void DetectSnapping::Init(BaseDocument *t_doc, BaseDraw *t_clip, BaseObject *t_aop, const Vector &initial, LONG initial_pid, Bool selftest, Bool axismode, Bool allow_cplane)
{
	DetectSnappingLibCall(Init)(t_doc,t_clip,t_aop,initial,initial_pid,selftest,axismode,allow_cplane);
}

Bool DetectSnapping::SnapTo(const Vector &t_p, Vector *delta)
{
	DetectSnappingLibCallR(FALSE,SnapTo)(t_p,delta);
}

Bool DetectSnapping::IsEnabled(BaseDocument *pDoc)
{
	DetectSnappingLibCallR(FALSE,IsEnabled)(pDoc);
}

LONG DetectSnapping::GetRadius(BaseDocument *pDoc, LONG def)
{
	DetectSnappingLibCallR(def,GetRadius)(pDoc,def);
}
