/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _LIB_SNAPPING_H_
#define _LIB_SNAPPING_H_

#include "c4d_library.h"

class iDetectSnapping;
class SnapDetect;
class BaseDocument;
class BaseDraw;
class BaseObject;

class DetectSnapping
{
private:

	DetectSnapping();
	~DetectSnapping();

public:

	static DetectSnapping *Alloc();
	static void Free(DetectSnapping *&p);

	void Init(BaseDocument *t_doc, BaseDraw *t_clip, BaseObject *t_aop, const Vector &initial, LONG initial_pid, Bool selftest, Bool axismode, Bool allow_cplane);
	Bool SnapTo(const Vector &t_p, Vector *delta);
	Bool IsEnabled(BaseDocument *pDoc);
	LONG GetRadius(BaseDocument *pDoc, LONG def);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

//////////////////////////////////////////////////////////////////////////
#define LIBRARY_SNAPPING	1015841
//////////////////////////////////////////////////////////////////////////

struct DetectSnappingLib : public C4DLibrary
{
	iDetectSnapping *(*Alloc)();
	void (*Free)(iDetectSnapping *&p);

	void (iDetectSnapping::*Init)(BaseDocument *t_doc, BaseDraw *t_clip, BaseObject *t_aop, const Vector &initial, LONG initial_pid, Bool selftest, Bool axismode, Bool allow_cplane);
	Bool (iDetectSnapping::*SnapTo)(const Vector &t_p, Vector *delta);
	Bool (iDetectSnapping::*IsEnabled)(BaseDocument *pDoc);
	LONG (iDetectSnapping::*GetRadius)(BaseDocument *pDoc, LONG def);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
