/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __C4DOBJECTDATA_H
#define __C4DOBJECTDATA_H

#include "c4d_nodedata.h"
 
class  SplineObject;
class  BaseBitmap;
class  BaseDraw;
class  BaseDrawHelp;
class  Particle;
class  BaseThread;
class  HierarchyHelp;
class  BaseObject;
class  PriorityList;
struct BaseParticle;

#define GETHANDLE_INVALID_HANDLE MAXREAL

class ObjectData : public NodeData
{
	public:
		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max, ULONG flags);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////

		virtual void GetDimension(BaseObject *op, Vector *mp, Vector *rad);
		virtual Bool Draw(BaseObject *op, LONG drawpass, BaseDraw *bd, BaseDrawHelp *bh);
		virtual LONG DetectHandle(BaseObject *op, BaseDraw *bd, LONG x, LONG y, LONG qualifier);
		virtual Bool MoveHandle(BaseObject *op, BaseObject *undo, const Matrix &tm, LONG hit_id, LONG qualifier);
		virtual Bool AddToExecution(BaseObject *op, PriorityList *list);
		virtual LONG Execute(BaseObject *op, BaseDocument *doc, BaseThread *bt, LONG priority, LONG flags);
		virtual void GetModelingAxis(BaseObject *op, BaseDocument *doc, Matrix &axis);

		// generator
		virtual BaseObject* GetVirtualObjects(BaseObject *op, HierarchyHelp *hh);

		// modifier
		virtual Bool ModifyObject(BaseObject *mod, BaseDocument *doc, BaseObject *op, const Matrix &op_mg, const Matrix &mod_mg, Real lod, LONG flags, BaseThread *thread);
		virtual void CheckDirty(BaseObject *op, BaseDocument *doc);
		
		// spline
		virtual SplineObject* GetContour(BaseObject *op, BaseDocument *doc, Real lod, BaseThread *bt);

		// particle
		virtual void ModifyParticles(BaseObject *op, Particle *pp, BaseParticle *ss, LONG pcnt, Real diff);

		// helper routines
		virtual LONG GetHandleCount(BaseObject *op);
		virtual Vector GetHandle(BaseObject *op, LONG i);
		virtual void SetHandle(BaseObject *op, LONG i, Vector p);
};

Bool RegisterObjectPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, BaseBitmap *icon, LONG disklevel, void *emulation=NULL);
Bool RegisterObjectPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, String icon, LONG disklevel);
Bool RegisterObjectPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, LONG disklevel);

#endif
