/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef __c4d_plugin_h__
#define __c4d_plugin_h__

#include "ge_math.h"

#define C4DPL_VERSION 0x0003

// error
#define C4DPL_ERROR					-1
#define C4DPL_ERROR_TYPE		-2
#define C4DPL_ERROR_VERSION	-3
#define C4DPL_ERROR_OS			-4
#define C4DPL_ERROR_MEM			-5

// action
#define C4DPL_INIT_SYS			 1
#define C4DPL_INIT					 2
#define C4DPL_END						 3
#define C4DPL_INIT_VERSION	 4
#define C4DPL_MESSAGE				 6

#define C4DMSG_PRIORITY			 0
#define C4DPL_BUILDMENU			 1001188

// priorities
#define C4DPL_INIT_PRIORITY_XTENSIONS				20000
#define C4DPL_INIT_PRIORITY_OBJECTS					19000
#define C4DPL_INIT_PRIORITY_MODELING        18500
#define C4DPL_INIT_PRIORITY_SHADER					18000
#define C4DPL_INIT_PRIORITY_ADVANCEDRENDER	17000
#define C4DPL_INIT_PRIORITY_MOCCA						15000
#define C4DPL_INIT_PRIORITY_NEWMAN					12000
#define C4DPL_INIT_PRIORITY_SLA								850

#define C4DPL_INIT_PRIORITY_MODULES		 10000
#define C4DPL_INIT_PRIORITY_PLUGINS				 0

// messages
#define C4DPL_STARTACTIVITY		1000
#define C4DPL_ENDACTIVITY			1001
#define C4DPL_COMMANDLINEARGS	1002
	struct C4DPL_CommandLineArgs
	{
		LONG	argc;
		char	**argv;
		LONG	argc_w; // only available on Windows - unicode encoding of the parameters
		UWORD **argv_w;
	};
#define C4DPL_EDITIMAGE				1003
	struct C4DPL_EditImage
	{
		class Filename *imagefn;
		Bool return_processed;
	};

#define C4DPL_ENDPROGRAM		1001084
#define C4DPL_DEVICECHANGE	1001190
	struct C4DPL_DeviceChange
	{
		class String	*name;
		Bool					eject;
	};

#define C4DPL_PROGRAM_STARTED	450000215

// the interface
Bool PluginStart(void);
void PluginEnd(void);
Bool PluginMessage(LONG id, void *data);

#define SetPluginPriority(data,i) { *((LONG*)(data))=i; }

#endif
