/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _FILTER_PREVIEW_H_
#define _FILTER_PREVIEW_H_

#include "filterthread.h"

//----------------------------------------------------------------------------------------
// PreviewKlasse (UserArea)
//----------------------------------------------------------------------------------------
class PreviewBmp : public GeUserArea
{
		BM_FILTER_SETTINGS		*settings;
		BM_REF								bm;
		AutoAlloc<BaseBitmap>	bmp;
		Bool									bmp_valid;
		FT_APPLY_EFFECT				*apply_effect;
		Bool									real_time;												// FALSE: use preview thread TRUE: immediate redraw of preview
		LONG									down_scale;												// index of the preview scaling factor
		LONG									offset_x;													// offset is relative to the center of the selection
		LONG									offset_y;
		LONG									last_x;														// last offset the preview was displayed with
		LONG									last_y;

		FilterThread preview_thread;
		FilterThread document_thread;
		Bool	document_preview;
		Bool	changed_settings;
		
		void	ClipOffsets( RECT32 *r );

		friend class	PreviewGroup;
		friend LONG	preview_effect( BM_REF bm, const RECT32 *src_rect, BM_TILE *dt, PreviewBmp *pv, Bool update_view, BaseThread *thread );
		
	public:

		PreviewBmp(void);
		~PreviewBmp(void);
		virtual Bool	GetMinSize   (LONG &w,LONG &h);
		virtual void	DrawMsg      (LONG x1,LONG y1,LONG x2,LONG y2, const BaseContainer &msg);
		virtual Bool	InputEvent   (const BaseContainer &msg);
		virtual Bool	InitValues   (void);
		virtual LONG	Message      (const BaseContainer &msg,BaseContainer &result);

		void	SetBitmap( BM_REF bm, FT_APPLY_EFFECT *apply_effect, BM_FILTER_SETTINGS *settings, Bool redraw=TRUE );
		Bool	UpdateBitmap( Bool do_effect );
		void	SetOffset( LONG x, LONG y,Bool do_effect, Bool scale_xy = TRUE );
		void	SetDragEffect(Bool showeffect);
		LONG	Shrink( Bool do_effect, Bool redraw );
		LONG	Grow( Bool do_effect, Bool redraw );
		LONG	GetScale( void );
		void	SetDocumentPreview( Bool document_preview );
};

class PreviewGroup
{
	private:

	GeDialog  *dlg;
	LONG	src_preview_id;
	LONG	dst_preview_id;
	LONG	zoom_in_id;
	LONG	zoom_out_id;
	LONG	zoom_percent_id;
	Bool	real_time;

	PreviewBmp	src_preview;
	PreviewBmp	dst_preview;

	void	AddPreview( GeDialog *dlg, LONG w, LONG h, PreviewBmp &preview, LONG preview_id );

	public:

	PreviewGroup( void );
	~PreviewGroup( void );

	void	Create( GeDialog *_dlg, LONG group_id );
	void	SetSource( BM_REF bm, BM_FILTER_SETTINGS *settings = 0, Bool redraw = TRUE );
	void	SetDestination( BM_REF bm, FT_APPLY_EFFECT *apply_effect, BM_FILTER_SETTINGS *settings, Bool redraw = TRUE, Bool document_preview = FALSE );
	void	UpdateSource( Bool do_effect = TRUE );
	void	UpdateDestination( Bool do_effect = TRUE );
	void	SetDocumentPreview( Bool document_preview );
	void	ChangedSettings( void );
	void	FinishDocumentUpdate( void );

	Bool	Command( LONG id, const BaseContainer &msg );

	void	ZoomIn( void );
	void	ZoomOut( void );
	void	Update( void );
};

LONG	preview_effect( BM_REF bm, const RECT32 *src_rect, BM_TILE *dt, PreviewBmp *pv, Bool update_view, BaseThread *thread );

#endif
