/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef	__X4D_FILTER_THREADS__
#define	__X4D_FILTER_THREADS__

#include "c4d_thread.h"
#include "x4d_filter.h"

struct BM_FILTER_SETTINGS
{
};

typedef	LONG 	FT_APPLY_EFFECT( BM_REF bm, const RECT32 *src_rect, BM_TILE *dt, BM_FILTER_SETTINGS *settings, Bool update_view, class BaseThread *thread );

class FilterThread : public C4DThread
{
		BM_REF	bm;
		BM_TILE	*dt;
		const RECT32	*src_rect;
		RECT32	r;
		FT_APPLY_EFFECT	   *apply_effect;
		BM_FILTER_SETTINGS *settings;
		Bool	redraw;
		LONG	err;
		volatile Bool	done;

	public:

		FilterThread( void );
		void	Main( void );
		virtual const CHAR *GetThreadName() { return "FilterThread"; }
		void	Init( BM_REF bm, const RECT32 *src_rect, BM_TILE *dt, FT_APPLY_EFFECT *apply_effect, BM_FILTER_SETTINGS *settings, Bool redraw );
		LONG	GetErr( void );
		Bool	IsDone( void );
		void	WaitforCompletion( void );
};

#endif