/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

#ifndef _SDK_ADD_H_
#define _SDK_ADD_H_

#include "filter_prefs.h"

enum																												// BF_PREFS_GLOBAL
{
	BF_PREFS_PSF_ENABLED = BF_PREFS_DOCUMENT_PREVIEW + 1,			// (LONG) FALSE: disable photoshop filters TRUE: enable photoshop filters 			
	BF_PREFS_NO_PS_PATHS,																			// (LONG) number of PS filter directories
	BF_PREFS_PS_PATH0,																				// (String)
	BF_PREFS_PS_PATH_XXX = BF_PREFS_PS_PATH0+999,
	BF_PREFS_NO_PS_APP_PATHS = BF_PREFS_PS_PATH_XXX + 1,			// (LONG)
	BF_PREFS_PS_APP_PATH0,																		// (String) Plugin host path
	BF_PREFS_PS_APP_PATH_XXX = BF_PREFS_PS_APP_PATH0+99,
	BF_PREFS_PS_APP_VERSION0,																	// (Real) Plugin host version
	BF_PREFS_PS_APP_VERSION_XXX = BF_PREFS_PS_APP_PATH0+99
};

enum
{
	BF_PREFS_PSF_ENABLED_DFLT = FALSE,												// (LONG) FALSE: disable photoshop filters at first startup
	BF_PREFS_NO_PS_PATHS_DFLT = 0,														// (LONG) 0: no search paths defined (start automatic scanning)
	BF_PREFS_NO_PS_APP_PATHS_DFLT = 0
};

Bool	BfpGetPSFEnabledFlag( BaseContainer *x_prefs=NULL );
void	BfpSetPSFEnabledFlag( Bool enable_ps_plugins , BaseContainer *x_prefs=NULL );

// Handling of plugin directories
LONG	BfpGetNoPSPaths( BaseContainer *x_prefs=NULL );
void	BfpSetNoPSPaths( LONG no_paths , BaseContainer *x_prefs=NULL);
String	BfpGetPSPath( LONG index , BaseContainer *x_prefs=NULL);
void	BfpSetPSPath( LONG index, String path , BaseContainer *x_prefs=NULL);

// Handling of host directories
LONG	BfpGetNoPSAppPaths( BaseContainer *x_prefs=NULL );
void	BfpSetNoPSAppPaths( LONG no_paths, BaseContainer *x_prefs=NULL );
void	BfpSetPSAppPath( String path, Real version, BaseContainer *x_prefs=NULL );
Real	BfpIsInPSAppPath( String path, BaseContainer *x_prefs=NULL );	// return the host version number if the plugin is in its directory


#endif
