#include "operatingsystem.h"
#include "c4d_memory.h"
#include "c4d_general.h"
#include "c4d_shaderplugin.h"
#include "c4d_resource.h"
#ifndef __API_INTERN__
	#include "c4d_tools.h"
#else
	#include "shdlist.h"
#endif

LONG ShaderData::GetRenderInfo(PluginShader *chn)
{
	return 0;
}

LONG ShaderData::InitRender(PluginShader *chn, InitRenderStruct *irs)
{
	return LOAD_OK;
}

void ShaderData::FreeRender(PluginShader *chn)
{
}

Vector ShaderData::Output(PluginShader *chn, ChannelData *cd)
{
	return 0.0;
}

Bool ShaderData::Draw(PluginShader *chn, BaseObject *op, BaseTag *tag, BaseDraw *bd, BaseDrawHelp *bh)
{
	return TRUE;
}

LONG ShaderData::GlMessage(PluginShader *sh, LONG type, void *msgdata)
{
	return FALSE;
}

LONG ShaderData::InitGLImage(PluginShader *sh, BaseDocument* doc, BaseThread* th, BaseBitmap *bmp, Bool alpha)
{
	return 0;
}

void FillShaderPlugin(SHADERPLUGIN *np, DataAllocator *npalloc, LONG info, LONG disklevel, void *emulation)
{
	FillNodePlugin(np,info,npalloc,NULL,disklevel,emulation);

	np->Draw								= &ShaderData::Draw;
	np->GetRenderInfo				= &ShaderData::GetRenderInfo;
	np->InitRender					= &ShaderData::InitRender;
	np->FreeRender					= &ShaderData::FreeRender;
	np->Output							= &ShaderData::Output;
	np->GlMessage						= &ShaderData::GlMessage;
	np->InitGLImage					= &ShaderData::InitGLImage;
}

Bool RegisterShaderPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, LONG disklevel, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	SHADERPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillShaderPlugin(&np,npalloc,info,disklevel,emulation);
	return GeRegisterPlugin(C4DPL_SHADER,id,str,&np,sizeof(np));
}
