#ifndef __MACMATH_H
#define __MACMATH_H
#include <CoreServices/CoreServices.h>
#define GCC34T this->

struct Matrix;
struct Vector;

#ifndef NULL
#define NULL 0
#endif

#ifndef NIL
#define NIL 0
#endif

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

typedef void*	Hndl;
typedef int Bool;

typedef char	CHAR;
typedef unsigned char	UCHAR;
typedef short int	SWORD;
typedef unsigned short int	UWORD;

#ifdef __C4D_64BIT
typedef int LONG;
typedef unsigned int ULONG;
#else
typedef long LONG;
typedef unsigned long	ULONG;
#endif

typedef signed long long LLONG;
typedef unsigned long long LULONG;

typedef int	INT;
typedef unsigned int UINT;
typedef float	Real;
typedef float	SReal;
typedef double	LReal;

#ifdef __C4D_64BIT
typedef unsigned long long	VULONG;
typedef signed long long		VLONG;
#else
typedef unsigned long	VULONG;
typedef signed long		VLONG;
#endif

#undef MAXLONG // windows header have MINLONG defines as 0x80000000
#undef MINLONG // windows header have MINLONG defines as 0x80000000

#define MAXLONGl					0x7fffffff  
#define MAXLONGf					2147483520.0f		// 0x7FFFFF80 - rounding MAXLONG to Real results in 0x80000000
#define MAXLONGd					LReal(MAXLONGl)		
#define MINLONGl					(-0x7fffffff)		// explicitly not 0x80000000
#define MINLONGf					-2147483520.0f	// -0x7FFFFF80 - rounding MINLONG to Real results in 0x80000000
#define MINLONGd					LReal(MINLONGl)		

#ifndef MAXULONG
	#define MAXULONG					0xffffffff
#endif
#ifndef MAXWORD
	#define MAXWORD						32767L
#endif
#ifndef MAXUWORD
	#define MAXUWORD					65535L
#endif

typedef float								Real;
#define MAXREAL							( 9.0e18)
#define MINREAL							(-9.0e18)

#define NOTOK								(-1)

// use this defines to define float consts!
// e.g. instead of 10.0f write RC(10.0)
// speed up the 64 bit version some percent!
#define SCO(x)		SReal(x)	// defines float constants to SReal
#define RCO(x)		Real(x)		// defines float constants to Real
#define LCO(x)		LReal(x)	// defines float constants to LReal

#define pi			3.1415926535897932384626433832795
#define piinv		0.31830988618379067153776752674508	// 1/pi
#define pi2			6.283185307179586476925286766559
#define pi2inv	0.15915494309189533576888376337251	// 1/pi2
#define pi05		1.5707963267948966192313216916398
#define pi05inv 0.63661977236758134307553505349036	// 1/pi05

inline Real  FMin(Real a,  Real b) { if (a<b) return a; return b; }
inline LReal FMin(LReal a, LReal b) { if (a<b) return a; return b; }
inline VLONG VMin(VLONG a, VLONG b) { if (a<b) return a; return b; }
inline LONG  LMin(LONG a,  LONG b) { if (a<b) return a; return b; }
inline Real  FMax(Real a, Real b) { if (a<b) return b; return a; }
inline LReal FMax(LReal a, LReal b) { if (a<b) return b; return a; }
inline LONG  LMax(LONG a, LONG b) { if (a<b) return b; return a; }
inline VLONG VMax(VLONG a, VLONG b) {if (a<b) return b; return a; }
inline Real  FCut(Real  a,Real b,Real c) { if (a<b) return b; if (a>c) return c; return a; }
inline LReal FCut(LReal a,Real b,Real c) { if (a<b) return b; if (a>c) return c; return a; }
inline LONG  LCut(LONG  a,LONG b,LONG c) { if (a<b) return b; if (a>c) return c; return a; }
inline VLONG VCut(VLONG a,VLONG b, VLONG c) { if (a<b) return b; if (a>c) return c; return a; }
template <class A> inline A TCut(A a,A b,A c) { if (a<b) return b; if (a>c) return c; return a; }
template <class X> inline X Abs(X f) { if (f<0) return -f; return f; }
#define Mod(a,b)		((a)<0?((a)-(((a)-(b)+1)/(b))*(b)):(a)%(b))
#define FMod(r,s)		fmod(r,s)
#define Sin(r) 			sin(r)
#define Cos(r) 			cos(r)
#define Tan(r) 			tan(r)
#define ATan(r) 		atan(r)
#define Exp(r)			exp(r)
#define Ln(r) 			log(r)
#define Ld(r)				(log(r) / 0.69314718055994530941723212145818)
#define Ln10(r) 		log10(r)
#define Sqrt(r)			sqrt(r)
#define Floor(r)		floor(r)
#define Ceil(r)			ceil(r)
#define Pow(r,s)		pow((r),(s))
#define Cosh(r)			cosh(r)
#define Sinh(r)			sinh(r)
#define Tanh(r)			tanh(r)

inline void SinCos(Real w, Real &sn, Real &cn)
{
	sn = Sin(w);
	cn = Cos(w);
}

inline void SinCos(LReal w, LReal &sn, LReal &cn)
{
	sn = Sin(w);
	cn = Cos(w);
}

inline Real ASin(Real val)
{
	if (val >= 1.0) return pi05;
	else if (val <= -1.0) return -pi05;
	return asin((double)val);
}

inline LReal ASin(LReal val)
{
	if (val >= 1.0) return pi05;
	else if (val <= -1.0) return -pi05;
	return asin(val);
}

inline Real ACos(Real val)
{
	if (val >= 1.0) return 0.0;
	else if (val <= -1.0) return pi;
	return acos((double)val);
}

inline LReal ACos(LReal val)
{
	if (val >= 1.0) return 0.0;
	else if (val <= -1.0) return pi;
	return acos(val);
}

inline Real Rad(Real r)
{
	return ((r)*pi / 180.0);
}
inline LReal Rad(LReal r)
{
	return ((r)*pi / 180.0);
}

inline Real Deg(Real r)
{
	return ((r)*180.0 / pi);
}

inline LReal Deg(LReal r)
{
	return ((r)*180.0 / pi);
}

inline LONG SAFELONG(Real x)
{
	if (x<=MINLONGf) return MINLONGl;
	else if (x>=MAXLONGf) return MAXLONGl;
	return LONG(x);
}

inline LONG SAFELONG(LReal x)
{
	if (x<=MINLONGd) return MINLONGl;
	else if (x>=MAXLONGd) return MAXLONGl;
	return LONG(x);
}

inline LONG LFloor(Real r ) { return LONG(Floor(r)); }
inline LONG LFloor(LReal r) { return LONG(Floor(r)); }
inline LONG LCeil (Real r ) { return LONG(Ceil(r)); }
inline LONG LCeil (LReal r) { return LONG(Ceil(r)); }

#define FtoL(x) LONG(x)

#endif
