/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

// Interface Functions

#ifndef __GEPREPASS_H
#define __GEPREPASS_H

#include "ge_math.h"

// HyperFile::GetError
#define FILEERROR_NONE    	           0 // no error
#define FILEERROR_OPEN							  -1 // problems opening the file
#define FILEERROR_CLOSE								-2 // problems closing the file
#define FILEERROR_READ   							-3 // problems reading the file
#define FILEERROR_WRITE								-4 // problems writing the file
#define FILEERROR_SEEK								-5 // problems seeking the file
#define FILEERROR_INVALID							-6 // invalid parameter or operation (e.g. writing in read-mode)
#define FILEERROR_MEMORY							-7 // not enough memory
#define FILEERROR_USERBREAK						-8 // user break
#define FILEERROR_WRONG_VALUE       -100 // other value detected than expected
#define FILEERROR_CHUNK_NUMBER      -102 // wrong number of chunks or sub chunks detected
#define FILEERROR_VALUE_NO_CHUNK    -103 // there was a value without any enclosing START/STOP chunks
#define FILEERROR_FILE_END          -104 // the file end was reached without finishing reading
#define FILEERROR_UNKNOWN_VALUE     -105 // unknown value detected

// BaseFile::Open
#define GE_READ				1
#define GE_WRITE			2
#define GE_APPEND			0
#define GE_READWRITE	3

#define FILE_NODIALOG		0
#define FILE_DIALOG			1
#define FILE_IGNOREOPEN	2

#define MACTYPE_CINEMA		'C4DC'
#define MACCREATOR_CINEMA	'C4D1'

// BaseFile::Seek
#define GE_START		0
#define GE_RELATIVE	2

// BaseFile::Filer
#define GE_SAVE				1
#define GE_DIRECTORY	2

// BaseBitmap::Init
#define IMAGE_OK					 1
#define IMAGE_NOTEXISTING	-1
#define IMAGE_WRONGTYPE 	-2
#define IMAGE_NOMEM				-3
#define IMAGE_DISKERROR	  -4
#define IMAGE_FILESTRUCT	-5

// BaseBitmap::Save
#define FILTER_TIF								1100
#define FILTER_TGA								1101
#define FILTER_BMP								1102
#define FILTER_IFF								1103
#define FILTER_JPG								1104
#define FILTER_PICT								1105
#define FILTER_PSD								1106
#define FILTER_RLA								1107
#define FILTER_RPF								1108
#define FILTER_B3D								1109
#define FILTER_TIF_B3D						1110
#define FILTER_AVI								1122
#define FILTER_MOVIE							1125
#define FILTER_QTVRSAVER_PANORAMA	1150
#define FILTER_QTVRSAVER_OBJECT		1151
#define FILTER_HDR								1001379
#define FILTER_PNG								1023671

#define AVISAVER_FCCTYPE					10000
#define AVISAVER_FCCHANDLER				10001
#define AVISAVER_LKEY							10002
#define AVISAVER_LDATARATE				10003
#define AVISAVER_LQ								10004

#define QTSAVER_COMPRESSOR				10010
#define QTSAVER_QUALITY						10011
#define QTSAVER_TEMPQUAL					10012
#define QTSAVER_FRAMERATE					10013
#define QTSAVER_KEYFRAMES					10014
#define QTSAVER_PLANES						10015
#define QTSAVER_DATARATE					10016
#define QTSAVER_FRAMEDURATION			10017
#define QTSAVER_MINQUALITY				10018
#define QTSAVER_MINTEMPQUAL				10019
#define QTSAVER_FIXEDFRAMERATE		10020

#define JPGSAVER_QUALITY					10021
#define IMAGESAVER_DPI						10022
#define RLA_OPTIONS								10024
#define PSD_PS7SUPPORT						10025

#define RLA_Z											(1<<0)
#define RLA_OBJECTBUFFER					(1<<2)
#define RLA_UV										(1<<3)
#define RLA_NORMAL								(1<<4)
#define RLA_ORIGCOLOR							(1<<5)
#define RLA_COVERAGE							(1<<6)
#define RLA_OBJECTID							(1<<8)
#define RLA_COLOR									(1<<9)
#define RLA_TRANSPARENCY					(1<<10)
#define RLA_SUBPIXEL_WEIGHT				(1<<12)
#define RLA_SUBPIXEL_MASK					(1<<13)

#define PNG_INTERLACED						11000

// savebits
#define SAVEBIT_ALPHA								(1<<0)
#define SAVEBIT_MULTILAYER					(1<<1)
#define SAVEBIT_USESELECTEDLAYERS		(1<<2)
#define SAVEBIT_16BITCHANNELS				(1<<3)
#define SAVEBIT_GREYSCALE						(1<<4)
#define SAVEBIT_32BITCHANNELS				(1<<8)
#define SAVEBIT_SAVERENDERRESULT		(1<<9)

// GeGetCurrentOS
#define GE_WIN										1
#define GE_MAC										2
#define GE_UNIX										3

// GeGetByteOrder
#define GE_MOTOROLA								1
#define GE_INTEL									2

// GeOutString
#define GEMB_OK										0x0000
#define GEMB_OKCANCEL							0x0001
#define GEMB_ABORTRETRYIGNORE			0x0002
#define GEMB_YESNOCANCEL					0x0003
#define GEMB_YESNO								0x0004
#define GEMB_RETRYCANCEL					0x0005

#define GEMB_ICONSTOP							0x0010
#define GEMB_ICONQUESTION					0x0020
#define GEMB_ICONEXCLAMATION			0x0030
#define GEMB_ICONASTERISK					0x0040
#define GEMB_MULTILINE						0x0080

#define GEMB_R_OK									1
#define GEMB_R_CANCEL							2
#define	GEMB_R_ABORT							3
#define GEMB_R_RETRY							4
#define GEMB_R_IGNORE							5
#define GEMB_R_YES								6
#define GEMB_R_NO									7

// result code for mousedrag...
#define MOUSEDRAG_ESCAPE						(1)
#define MOUSEDRAG_FINISHED					(2)
#define MOUSEDRAG_CONTINUE					(3)

// flags for mousedrag...
#define MOUSEDRAG_DONTHIDEMOUSE					(1<<0)				// mousepointer should be visible
#define MOUSEDRAG_NOMOVE								(1<<1)				// mousedrag returns if no mousemove was done
#define MOUSEDRAG_EVERYPACKET						(1<<2)				// receive every packet of the queue, otherwise only data of the last packet
#define MOUSEDRAG_COMPENSATEVIEWPORTORG	(1<<3)				// compensates the viewport origin during drag

// BaseChannel::InitTexture
#define LOAD_OK            0
#define LOAD_NOMEM			-100
#define LOAD_NOTFOUND   -101
#define LOAD_UNKNOWN    -102
#define LOAD_DOUBLENAME	-105

// hyperfile values
#define HFILE_START   	 1
#define HFILE_STOP 		   2
#define HFILE_CSTOP      3
#define HFILE_CHAR			11
#define HFILE_UCHAR			12
#define HFILE_WORD			13
#define HFILE_UWORD			14
#define HFILE_LONG			15
#define HFILE_ULONG			16
#define HFILE_LLONG			17
#define HFILE_LULONG		18
#define HFILE_REAL			19
#define HFILE_LREAL			20
#define HFILE_BOOL			21
#define HFILE_TIME			22
#define HFILE_VECTOR		23
#define HFILE_LVECTOR		24
#define HFILE_MATRIX		25
#define HFILE_LMATRIX		26

// spline type
#define Tlinear		0
#define Tcubic		1
#define Takima		2
#define Tbspline	3
#define Thermite	4

// spline interpolation
#define Inone			0
#define Inatural	1
#define Iuniform	2
#define Iadaptive	3
#define Isubdiv   4

// particle bits
#define PARTICLE_VISIBLE	(1<<0)
#define PARTICLE_ALIVE		(1<<1)

///////////////////bits/////////////////////

// baselist bits
#define BIT_ACTIVE					(1<<1) // active element
#define BIT_AAMAN						(1<<4) // depricated: DONT USE ANY MORE !!!
#define BIT_AFOLD						(1<<7) // folded in timeline

// baselist bits nach neuer definition
#define NBIT_TL1_FOLD    1
#define NBIT_TL2_FOLD    2
#define NBIT_TL3_FOLD    3
#define NBIT_TL4_FOLD    4

#define NBIT_TL1_SELECT  5
#define NBIT_TL2_SELECT  6
#define NBIT_TL3_SELECT  7
#define NBIT_TL4_SELECT  8

#define NBIT_TL1_TDRAW	 9
#define NBIT_TL2_TDRAW	 10
#define NBIT_TL3_TDRAW	 11
#define NBIT_TL4_TDRAW	 12

#define NBIT_CKEY_ACTIVE 13 // active point of animation path in editor

#define NBIT_OM1_FOLD    14 
#define NBIT_OM2_FOLD    15 
#define NBIT_OM3_FOLD    16 
#define NBIT_OM4_FOLD    17 

//defines if the tracks if the object are shown
#define NBIT_TL1_FOLDTR	 18
#define NBIT_TL2_FOLDTR	 19
#define NBIT_TL3_FOLDTR	 20
#define NBIT_TL4_FOLDTR	 21

#define NBIT_TL1_FOLDFC		22
#define NBIT_TL2_FOLDFC		23
#define NBIT_TL3_FOLDFC		24
#define NBIT_TL4_FOLDFC		25

#define NBIT_SOURCEOPEN		26

#define NBIT_TL1_HIDE			27
#define NBIT_TL2_HIDE			28
#define NBIT_TL3_HIDE			29
#define NBIT_TL4_HIDE			30

#define NBIT_SOLO_ANIM    31
#define NBIT_SOLO_LAYER		32

#define NBIT_TL1_SELECT2  33
#define NBIT_TL2_SELECT2  34
#define NBIT_TL3_SELECT2  35
#define NBIT_TL4_SELECT2  36

//cat added for solo motion layer
#define NBIT_SOLO_MOTION	37

#define NBIT_CKEY_LOCK_T	38
#define NBIT_CKEY_LOCK_V	39
#define NBIT_CKEY_MUTE		40
#define NBIT_CKEY_CLAMP		41

#define NBIT_CKEY_BREAK   42
#define NBIT_CKEY_LOCK_O  44
#define NBIT_CKEY_LOCK_L	45
#define NBIT_CKEY_AUTO  	46
#define NBIT_CKEY_ZERO_O	48
#define NBIT_CKEY_ZERO_L	49

#define NBIT_TL1_FCSELECT	50
#define NBIT_TL2_FCSELECT	51
#define NBIT_TL3_FCSELECT	52
#define NBIT_TL4_FCSELECT	53

#define NBIT_CKEY_BREAKDOWN 54

//Cat added for motion TL
#define NBIT_TL1_FOLDMOTION 55
#define NBIT_TL2_FOLDMOTION 56
#define NBIT_TL3_FOLDMOTION 57
#define NBIT_TL4_FOLDMOTION 58

//Cat added for motion TL
#define NBIT_TL1_SELECTMOTION 59
#define NBIT_TL2_SELECTMOTION 60
#define NBIT_TL3_SELECTMOTION 61
#define NBIT_TL4_SELECTMOTION 62

// for David, hiding objects in OM
#define NBIT_OHIDE            63  // Hide object in OM
#define NBIT_TL_TBAKE					64
//#define NBIT_TL_TBAKE2				65

//Cat added for sourcemanager in TL
#define NBIT_TL1_FOLDSM 66
#define NBIT_TL2_FOLDSM 67
#define NBIT_TL3_FOLDSM 68
#define NBIT_TL4_FOLDSM 69

// materials
#define BIT_MATMARK					(1<<2) // marked material
#define BIT_ENABLEPAINT			(1<<3) // enable painting
#define BIT_MFOLD						(1<<6) // folded in material manager
#define BIT_BP_FOLDLAYERS		(1<<9) // fold layers in materialmanger

// objects
#define BIT_IGNOREDRAW			(1<<2) // ignore object during draw
#define BIT_OFOLD						(1<<6) // folded in object manager
#define BIT_CONTROLOBJECT		(1<<9) // control object
#define BIT_RECMARK	        (1<<11)// help bit for recursive operations
#define BIT_EDITOBJECT			(1<<13)	// edit object from sds

// tracks
#define BIT_TRACKPROCESSED				(1<<16) // track has been processed, avoid recursions
#define BIT_ANIM_OFF 							(1<<17) // is sequence inactive
#define BIT_ANIM_SOLO							(1<<18) 
#define BIT_ANIM_CONSTANTVELOCITY	(1<<19)

// videopost
#define BIT_VPDISABLED			(1<<2) // videopost effect is disabled

// document
#define BIT_DOCUMENT_CHECKREWIND	(1<<2)	// doc needs to check for a rewind

// renderdata
#define BIT_ACTIVERENDERDATA			(1<<28)

// object info
#define OBJECT_MODIFIER						(1<<0)
#define OBJECT_HIERARCHYMODIFIER	(1<<1)
#define OBJECT_GENERATOR					(1<<2)
#define OBJECT_INPUT							(1<<3)
#define OBJECT_PARTICLEMODIFIER		(1<<5)
#define OBJECT_NOCACHESUB					(1<<6)
#define OBJECT_ISSPLINE						(1<<7)
#define OBJECT_UNIQUEENUMERATION  (1<<8)
#define OBJECT_CAMERADEPENDENT		(1<<9)
#define OBJECT_USECACHECOLOR			(1<<10)
#define OBJECT_POINTOBJECT				(1<<11)
#define OBJECT_POLYGONOBJECT			(1<<12)
#define OBJECT_NO_PLA             (1<<13)
#define OBJECT_DONTFREECACHE			(1<<14)

// animation info
#define ANIMINFO_QUICK						(1<<0)

// material groups
#define MATERIALGROUP_ID				100
#define MATERIALGROUP_NAME			101
#define MATERIALGROUP_SELECTED	102

///////////////////ID's/////////////////////

// list elements
#define Tbaselist2d											110050
#define Tbaselist4d											110051
#define Tundoablelist										110068
#define Tgelistnode											110069

// materials
#define Mbase														5702
#define Mmaterial												5703
#define Mplugin													5705
#define Mfog														8803
#define Mterrain												8808
#define Mdanel                          1011117
#define Mbanji                          1011118
#define Mbanzi                          1011119
#define Mcheen                          1011120
#define Mmabel                          1011121
#define Mnukei                          1011122

// videopost
#define VPbase													5709

// objects
#define Opolygon												5100
#define Ospline													5101
#define Olight													5102
#define Ocamera													5103
#define Ofloor													5104
#define Osky														5105
#define Oenvironment										5106
#define Oloft														5107
#define Offd														5108
#define Oparticle												5109
#define Odeflector											5110
#define Ogravitation										5111
#define Orotation												5112
#define Owind														5113
#define Ofriction												5114
#define Oturbulence											5115
#define Oextrude												5116
#define Olathe													5117
#define Osweep													5118
#define Oattractor											5119
#define Obezier													5120
#define Oforeground											5121
#define Obackground											5122
#define Obone														5123
#define Odestructor											5124
#define Ometaball												5125
#define Oinstance												5126
#define Ohypernurbs											5127
#define Obend														5128
#define Obulge													5129
#define Oshear													5131
#define Otaper													5133
#define Otwist													5134
#define Owave														5135
#define Ostage													5136
#define Oline														5137
#define Omicrophone											5138
#define Oloudspeaker										5139
#define Onull														5140
#define Osymmetry												5142
#define Owrap														5143
#define Oboole													1010865
#define Oexplosion											5145
#define Oformula												5146
#define Omelt														5147
#define Oshatter												5148
#define Owinddeform											5149
#define Oarray													5150
#define Oheadphone											5151
#define Oconplane												5153
#define Oplugin													5154
#define Obase														5155
#define Opoint													5156
#define Obasedeform											5157
#define Opolyreduction									1001253
#define Oshowdisplacement								1001196
#define Ojoint													1019362
#define Oskin														1019363
#define Oweighteffector									1019677

// primitive objects
#define Ocube														5159
#define Osphere													5160
#define Oplatonic												5161
#define Ocone														5162
#define Otorus													5163
#define Odisc														5164
#define Otube														5165
#define Ofigure													5166
#define Opyramid												5167
#define Oplane													5168
#define Ofractal												5169
#define Ocylinder												5170
#define Ocapsule												5171
#define Ooiltank												5172
#define Orelief													5173
#define Osinglepoly											5174

// spline primitive objects
#define Osplineprofile									5175
#define Osplineflower										5176
#define Osplineformula									5177
#define Osplinetext											5178
#define Osplinenside										5179
#define Ospline4side										5180
#define Osplinecircle										5181
#define Osplinearc											5182
#define Osplinecissoid									5183
#define Osplinecycloid									5184
#define Osplinehelix										5185
#define Osplinerectangle								5186
#define Osplinestar											5187
#define Osplinecogwheel									5188
#define Osplinecontour									5189

#define Oselection											5190
#define Osds												 1007455
#define Osplinedeformer							 1008982
#define Osplinerail									 1008796
#define Oatomarray									 1001002
#define Ospherify										 1001003
#define Oexplosionfx								 1002603

// small listnode plugin
#define Yplugin												110061

// big listnode plugin
#define Zplugin												110062

// DLayerStruct object
#define Olayer                        100004801

// listhead
#define ID_LISTHEAD										110063

// render data
#define ID_RENDERDATA									110304
#define Rbase                         ID_RENDERDATA

#define MY_ACTIVE						          (1<<29)


// shader plugins
#define Xbase														5707
#define Xcolor													5832
#define Xbitmap													5833
#define Xbrick													5804
#define Xcheckerboard										5800
#define Xcloud													5802
#define Xcolorstripes										5822
#define Xcyclone												5821
#define Xearth													5825
#define Xfire														5803
#define Xflame													5817
#define Xgalaxy													5813
#define Xmetal													5827
#define Xsimplenoise										5807
#define Xrust														5828
#define Xstar														5816
#define Xstarfield											5808
#define Xsunburst												5820
#define Xsimpleturbulence								5806
#define Xvenus													5826
#define Xwater													5818
#define Xwood														5823
#define Xplanet													5829
#define Xmarble													5830
#define Xspectral												5831
#define Xgradient                       1011100
#define Xfalloff                        1011101
#define Xtiles                          1011102
#define Xfresnel                        1011103
#define Xlumas                          1011105
#define Xproximal                       1011106
#define Xnormaldirection                1011107
#define Xtranslucency                   1011108
#define Xfusion                         1011109
#define Xposterizer                     1011111
#define Xcolorizer                      1011112
#define Xdistorter                      1011114
#define Xprojector                      1011115
#define Xnoise                          1011116
#define Xlayer                          1011123
#define Xspline                         1011124
#define Xfilter                         1011128
#define Xripple													1011199
#define Xdirt														1011136
#define Xvertexmap											1011137
#define Xsss														1001197
#define Xambientocclusion								1001191
#define Xchanlum												1007539
#define Xmosaic													1022119

// tags
#define Tpoint													5600
#define	Tanchor													5608
#define	Tphong													5612
#define	Tdisplay												5613
#define	Tkinematic											5614
#define	Ttexture												5616
#define	Thermite2d											5617
#define	Tprotection											5629
#define	Tparticle												5630
#define	Tmotionblur											5636
#define	Tcompositing										5637
#define	Twww														5647
#define	Tsavetemp												5650
#define Tpolygon												5604
#define	Tuvw														5671
#define	Tsegment												5672
#define	Tpolygonselection								5673
#define	Tpointselection									5674
#define Tcoffeeexpression								5675
#define	Ttargetexpression								5676
#define	Tfixexpression									5677
#define	Tsunexpression									5678
#define	Tikexpression										5679
#define Tline														5680
#define Tvertexmap											5682
#define Trestriction										5683
#define	Tmetaball												5684
#define	Tbakeparticle										5685
#define Tmorph													5689
#define Tsticktexture										5690
#define	Tplugin 												5691
#define	Tstop														5693
#define Tbase														5694
#define Tvariable												5695
#define Tvibrate												5698
#define Taligntospline									5699
#define Taligntopath										5700
#define	Tedgeselection									5701
#define Tclaudebonet										5708
#define Tnormal													5711
#define Tcorner													5712
#define Tsds														1007579
#define Tlookatcamera										1001001
#define Texpresso												1001149
#define Tsoftselection									1016641
#define Tbaketexture										1011198
#define Tsdsdata												1018016
#define Tweights						1019365

// new anim system
#define CTbase													5350	// new anim system
#define CSbase													5351
#define CKbase													5352

// new nla system
#define NLAbase													5349	


#define CTpla														100004812
#define CTsound													100004813
#define CTp2p														100001744
#define CTmorph													100004822
#define CTtime													-1

#define GVbase													1001101

// modeling commands
#define MCOMMAND_SPLINE_HARDINTERPOLATION				100
#define MCOMMAND_SPLINE_SOFTINTERPOLATION				101
#define MCOMMAND_SPLINE_REORDER									102
#define MCOMMAND_SPLINE_REVERSE									103
#define MCOMMAND_SPLINE_MOVEDOWN								104
#define MCOMMAND_SPLINE_MOVEUP									105
#define MCOMMAND_SPLINE_JOINSEGMENT							109
#define MCOMMAND_SPLINE_BREAKSEGMENT						110
#define MCOMMAND_SPLINE_EQUALLENGTH							111
#define MCOMMAND_SPLINE_EQUALDIRECTION					112
#define MCOMMAND_SPLINE_LINEUP									113
#define MCOMMAND_SPLINE_CREATEOUTLINE						114
#define MCOMMAND_SPLINE_PROJECT									115
#define MCOMMAND_SPLINE_ADDPOINT								116
#define MCOMMAND_SELECTALL											200
#define MCOMMAND_DESELECTALL										201
#define MCOMMAND_SELECTINVERSE									202
#define MCOMMAND_SELECTCONNECTED								203
#define MCOMMAND_SELECTGROW											204
#define MCOMMAND_SELECTSHRINK										205
#define MCOMMAND_SELECTPOINTTOPOLY							206
#define MCOMMAND_SELECTPOLYTOPOINT							207
#define MCOMMAND_SELECTADJACENT									208
#define MCOMMAND_GENERATESELECTION							209
#define MCOMMAND_HIDESELECTED										211
#define MCOMMAND_HIDEUNSELECTED									212
#define MCOMMAND_HIDEINVERT											213
#define MCOMMAND_UNHIDE													214
#define MCOMMAND_REVERSENORMALS									217
#define MCOMMAND_ALIGNNORMALS										218
#define MCOMMAND_SPLIT													220
#define MCOMMAND_TRIANGULATE										221
#define MCOMMAND_UNTRIANGULATE									222
#define MCOMMAND_DELETE													224
#define MCOMMAND_OPTIMIZE												227
#define MCOMMAND_DISCONNECT											228
#define MCOMMAND_MAKEEDITABLE										230
#define MCOMMAND_MIRROR													237
#define MCOMMAND_MATRIXEXTRUDE									238
#define MCOMMAND_SUBDIVIDE											242
#define MCOMMAND_EXPLODESEGMENTS								243
#define MCOMMAND_KNIFE													244
#define MCOMMAND_CURRENTSTATETOOBJECT						245
#define MCOMMAND_JOIN														246
#define MCOMMAND_CONVERTSELECTION								247
#define MCOMMAND_EDGE_TO_SPLINE							    251
#define MCOMMAND_BREAKPHONG											255
#define MCOMMAND_UNBREAKPHONG										256
#define MCOMMAND_PHONGTOSELECTION								257
#define MCOMMAND_MELT														264
#define MCOMMAND_RESETSYSTEM										265

// tool settings for selection commands
#define MDATA_SPLINE_FREEHANDTOLERANCE						2020 // REAL
#define MDATA_SPLINE_OUTLINE											2021 // REAL
#define MDATA_SPLINE_PROJECTMODE									2022 // LONG
#define MDATA_SPLINE_ADDPOINTSEGMENT							2023 // LONG
#define MDATA_SPLINE_ADDPOINTPOSITION							2024 // REAL
#define MDATA_DISCONNECT_PRESERVEGROUPS						2028 // BOOL
#define MDATA_MIRROR_SNAPPOINTS										2069 // BOOL
#define MDATA_MIRROR_DUPLICATE										2070 // BOOL
#define MDATA_MIRROR_WELD													2071 // BOOL
#define MDATA_MIRROR_TOLERANCE										2072 // REAL
#define MDATA_MIRROR_SYSTEM												2067 // LONG
#define MDATA_MIRROR_PLANE												2068 // LONG
#define MDATA_MIRROR_VALUE												2073 // REAL
#define MDATA_MIRROR_POINT												2074 // VECTOR
#define MDATA_MIRROR_VECTOR												2075 // VECTOR
#define MDATA_OPTIMIZE_TOLERANCE									2076 // REAL
#define MDATA_OPTIMIZE_POINTS											2077 // BOOL
#define MDATA_OPTIMIZE_POLYGONS										2078 // BOOL
#define MDATA_OPTIMIZE_UNUSEDPOINTS								2079 // BOOL
#define	MDATA_SPLINE_OUTLINESEPARATE							2080 // BOOL
#define MDATA_CROSSSECTION_ANGLE									2082 // REAL
#define MDATA_SUBDIVIDE_HYPER											2098 // BOOL
#define MDATA_SUBDIVIDE_ANGLE											2099 // REAL
#define MDATA_SUBDIVIDE_SPLINESUB									2100 // LONG
#define MDATA_SUBDIVIDE_SUB												2101 // LONG
#define MDATA_MIRROR_SELECTIONS										2120 // BOOL
#define MDATA_UNTRIANGULATE_ANGLE									2121 // BOOL
#define MDATA_MIRROR_ONPLANE											2122 // BOOL
#define MDATA_CONVERTSELECTION_LEFT								2126 // LONG
#define MDATA_CONVERTSELECTION_RIGHT							2127 // LONG
#define MDATA_CONVERTSELECTION_TOLERANT						2128 // BOOL
#define MDATA_CURRENTSTATETOOBJECT_INHERITANCE		2140 // BOOL
#define MDATA_CURRENTSTATETOOBJECT_KEEPANIMATION	2141 // BOOL
#define MDATA_ROTATECAMERA												2142 // BOOL
#define MDATA_RING_EDGE                           2154 // LONG
#define MDATA_RING_SELECTION                      2155 // LONG (must be SELECTION_NEW, SELECTION_ADD or SELECTION_SUB)
#define MDATA_RING_SKIP                           2156 // LONG
#define MDATA_FILLSEL_START_POLY                  2157 // LONG
#define MDATA_FILLSEL_SELECTION                   2158 // LONG (must be SELECTION_NEW, SELECTION_ADD or SELECTION_SUB)
#define MDATA_OUTLINESEL_START_POLY               2159 // LONG
#define MDATA_OUTLINESEL_SELECTION                2160 // LONG (must be SELECTION_NEW, SELECTION_ADD or SELECTION_SUB)
#define MDATA_UNTRIANGULATE_NGONS									2143 // BOOL
#define MDATA_UNTRIANGULATE_ANGLE_RAD							2161 // REAL
#define MDATA_CURRENTSTATETOOBJECT_NOGENERATE			2162 // BOOL
#define MDATA_RESETSYSTEM_NORM										2163 // BOOL
#define MDATA_RESETSYSTEM_ORTHO										2164 // BOOL
#define MDATA_RESETSYSTEM_COMPENSATE							2165 // BOOL
#define MDATA_RESETSYSTEM_RECURSIVE								2166 // BOOL
#define MDATA_JOIN_MERGE_SELTAGS									2167 // BOOL

#define MDATA_SETVERTEX_VALUE											4000 // REAL
#define MDATA_SETVERTEX_MODE											4001 // LONG


// send modeling command
enum
{
	MODIFY_ALL              = 0,
	MODIFY_POINTSELECTION   = 1,
	MODIFY_POLYGONSELECTION = 2,
	MODIFY_EDGESELECTION		= 3
};

// world preferences
#define WPREF_UNITS_BASIC										 10000 // LONG
#define WPREF_UNITS_TIME										 10001 // LONG
#define OBSOLETE_WPREF_UNITS_COLOR					 10002 // LONG
#define WPREF_UNITS_USEUNITS								 10003 // BOOL
#define WPREF_REFRESHTIME										 10004 // LONG
#define WPREF_RATIO_X												 10005 // REAL
#define WPREF_RATIO_Y												 10006 // REAL

#define WPREF_HPB_SYSTEM											1001 // BOOL
#define WPREF_CENTER													1002 // BOOL
#define WPREF_BACKUP													1003 // BOOL
#define WPREF_RENDERMATS_EX										1004 // BOOL
#define WPREF_TABLET													1005 // BOOL
#define WPREF_OPENGL													1008 // BOOL
#define WPREF_LINK_SELECTION									1009 // BOOL
#define WPREF_ONLY_ACTIVEVIEW									1010 // BOOL
#define WPREF_SAVE_OPENGL											1012 // BOOL
#define WPREF_SAVE_PARTICLES									1013 // BOOL
#define WPREF_SAVE_LAYOUT											1014 // BOOL
#define WPREF_DELETEATQUADS										1015 // BOOL
#define WPREF_INSERTAT												1016 // LONG
#define WPREF_PASTEAT													1017 // LONG
#define WPREF_MAX_UNDOS												1018 // LONG
#define WPREF_MAX_LAST												1019 // LONG
#define WPREF_CAMERAROTATION									1020 // LONG
#define WPREF_MULTISPLINEDRAW									1021 // BOOL

#define WPREF_OPENGL_PERSPECT									1024 // BOOL
#define WPREF_OPENGL_TEXTURE_FILTERING				1025 // LONG (formerly _MIPMAP which was wrong)
	#define WPREF_OPENGL_TEXTURE_FILTERING_NEAREST					0
	#define WPREF_OPENGL_TEXTURE_FILTERING_LINEAR						1
	#define WPREF_OPENGL_TEXTURE_FILTERING_LINEAR_MIPMAP		2
#define WPREF_USE_TEXTURES										1026 // BOOL
#define WPREF_OPENGL_FASTREDRAW								1027 // BOOL
#define WPREF_OPENGL_FASTLIVESELECTION				1028 // BOOL
#define WPREF_USE_QUICKTIME										1029 // BOOL
#define WPREF_TABLET_HIRES										1030 // BOOL
#define WPREF_3DGRID													1032 // Bool: draw grid lines as 3d?
#define WPREF_OPENGL_POLYLINES                1034 // Bool: use polylines
#define WPREF_OPENGL_LIGHTING                 1035 // Bool: use opengl lighting
#define WPREF_OPENGL_DUALPLANES_ACTIVE				1036 // Bool: allow dualplanes in glmode (gl extension)
#define WPREF_OPENGL_GLPOINTS									1037 // Bool: allow real gl points
#define WPREF_OPENGL_HIGHENDSHADING						1038 // Bool
#define WPREF_ONLY_ACTIVEVIEW_ANIMATION				1039 // Bool
#define WPREF_REALTIMESPINNER								  1040 // BOOL
#define WPREF_REALTIMEMANAGER									1042 // BOOL
#define WPREF_MAX_BACKUP											1043 // LONG
#define WPREF_CENTERAXIS											1044 // BOOL
#define WPREF_REWIND													1045 // BOOL
#define WPREF_CPUCOUNT												30010 // LONG
#define WPREF_CPUCUSTOM												30014 // BOOL
#define WPREF_OPENGL_DUALPLANES_ARB						1047 // Bool: use dualplane ARB extension
#define WPREF_MATPREVIEW_DEFAULTSIZE					1048 // LONG
#define WPREF_DESCRIPTIONLIMIT								1049 // LONG
#define WPREF_MATPREVIEW_DEFAULTOBJECT_MAT		1050 // LONG
#define WPREF_MATPREVIEW_DEFAULTUSERSCENE_MAT	1051 // String
#define WPREF_MATPREVIEW_DEFAULTOBJECT_SHD		1052 // LONG
#define WPREF_MATPREVIEW_DEFAULTUSERSCENE_SHD	1053 // String
#define WPREF_MATPREVIEW_AUTO_UPDATE          1054 // Bool
#define WPREF_MATPREVIEW_REDRAW_TIME          1055 // LONG: max. redraw time in ms
#define WPREF_MATPREVIEW_FPS                  1056 // LONG
#define WPREF_MATPREVIEW_LENGTH               1057 // Real
#define WPREF_MATPREVIEW_MAX_MEM              1058 // LONG
#define WPREF_SUBPIXELLIMIT										1062 // LONG
#define WPREF_OPENGL_BACKIMAGEMODE            1063 // LONG: use opengl lighting
	#define OGL_SET_BACKIMAGEMODE_OLD							0
	#define OGL_SET_BACKIMAGEMODE_TEX_NEAREST			1
	#define OGL_SET_BACKIMAGEMODE_TEX_INTERPOL		2
#define WPREF_OPENGL_ROTATEQUADS							1064 // BOOL: rotate quads 90 degree to get another subdivision
#define WPREF_OPENGL_SHAREDLISTS							1065
#define WPREF_OPENGL_DUALPLANES_HIGHLIGHT			1066 // Bool: allow dualplanes in glmode (gl extension)
#define WPREF_VIEWGAMMA												1067 // REAL
#define WPREF_ALLOWBUGREPORTS									1068 // Bool
#define WPREF_OPENGL_HIGHQUALITY							1069 // BOOL
#define WPREF_OPENGL_COMPILER									1070 // LONG
	#define WPREF_OPENGL_COMPILER_GLSL						0
	#define WPREF_OPENGL_COMPILER_CG							1
#define WPREF_OPENGL_MAX_TRANS_DEPTH					1071 // LONG
#define WPREF_OPENGL_MAX_LIGHTS								1072 // LONG
#define WPREF_OPENGL_MAX_SHADOWS							1073 // LONG
#define WPREF_SAVE_CACHES											1074 // BOOL
#define WPREF_OPENGL_ANTIALIAS								1084 // LONG
#define WPREF_OPENGL_MULTITHREADED						1085 // Bool

#define WPREF_MOVEACCELERATION							 	1081 // REAL
#define WPREF_SCALEACCELERATION							 	1082 // REAL
#define WPREF_ROTATEACCELERATION						 	1083 // REAL

#define WPREF_COLOR_SYSTEM_C4D								1100 // LONG
#define WPREF_COLOR_SYSTEM_BP									1101 // LONG
	#define COLORSYSTEM_HSVTAB						22
	#define COLORSYSTEM_TABLE							30
	#define COLORSYSTEM_RGB								10
	#define COLORSYSTEM_RGB_COLOR					11
	#define COLORSYSTEM_HSV								20
	#define COLORSYSTEM_HSV_COLOR					21
#define WPREF_COLOR_RGBRANGE									1102 // LONG
#define WPREF_COLOR_HRANGE										1103 // LONG
#define WPREF_COLOR_SVRANGE										1104 // LONG
	#define COLORSYSTEM_RANGE_PERCENT			0
	#define COLORSYSTEM_RANGE_DEGREE			3
	#define COLORSYSTEM_RANGE_255					1
	#define COLORSYSTEM_RANGE_65535				2
#define WPREF_COLOR_QUICK_C4D									1105
#define WPREF_COLOR_QUICK_BP									1106
#define WPREF_COLOR_MIX_C4D										1107
#define WPREF_COLOR_MIX_BP										1108

#define WPREF_COLOR_QUICKPRESET								1200 // Vector
#define WPREF_COLOR_QUICKPRESET_LAST					1299 // Vector
#define WPREF_COLOR_MIXING_1									1301 // Vector
#define WPREF_COLOR_MIXING_2									1302 // Vector
#define WPREF_COLOR_MIXING_3									1303 // Vector
#define WPREF_COLOR_MIXING_4									1304 // Vector
#define WPREF_COLOR_SYSTEM_COLORCHOOSER				1305 // BOOL

#define WPREF_AUTOSAVE_ENABLE									1400 // Bool
#define WPREF_AUTOSAVE_MIN										1401 // LONG
#define WPREF_AUTOSAVE_LIMIT_TO								1402 // Bool
#define WPREF_AUTOSAVE_LIMIT_NUM							1403 // LONG
#define WPREF_AUTOSAVE_MODE										1404 // LONG
	#define WPREF_AUTOSAVE_CURRENTDOC		0
	#define WPREF_AUTOSAVE_ALLDOCS			1
#define WPREF_AUTOSAVE_DEST										1405 // LONG
	#define WPREF_AUTOSAVE_DEST_BACKUPDIR		0
	#define WPREF_AUTOSAVE_DEST_USERDIR			1
	#define WPREF_AUTOSAVE_DEST_STARTUPDIR	2
#define WPREF_AUTOSAVE_DEST_PATH							1406 // Filename


#define WPREF_BUBBLEHELP1										 	21001
#define WPREF_BUBBLEHELP2										 	21002
#define WPREF_THREADPRIORITY								 	21003
#define WPREF_MENUICON											 	21004
#define WPREF_MENUSHORTCUT									 	21005
#define WPREF_INACTIVEBORDER								 	21006
#define WPREF_ACTIVEBORDER									 	21007
#define WPREF_DIALOGSTYLE										 	21008
#define WPREF_DIALOGALIGN										 	21009
#define WPREF_DELAY_MENU										 	21010
#define WPREF_DELAY_MENUSCROLL							 	21011
#define WPREF_DELAY_CMDPOPUP								 	21012
#define WPREF_DELAY_DRAGSCROLL							 	21013
#define WPREF_DELAY_SCROLLER1								 	21014
#define WPREF_DELAY_SCROLLER2								 	21015
#define WPREF_DELAY_TABSWITCH								 	21016
#define WPREF_PATTERN_TIMESLIDER						 	21040
#define WPREF_PATTERN_BG										 	21041
#define WPREF_PATTERN_BGEDIT								 	21042
#define WPREF_PATTERN_BGGADGET							 	21043
#define WPREF_PATTERN_BGFOCUS								 	21044
#define WPREF_PATTERN_DBARBG1								 	21045
#define WPREF_PATTERN_DBARBG2								 	21046
#define WPREF_FONT_STANDARD									 	21050
#define WPREF_FONT_MONO											 	21051
#define WPREF_PATTERN_USE										 	21060
//#define WPREF_NAVSERVICE									 	21061
#define WPREF_MAC_EXCHNGCTRLCMD							 	21062
//#define WPREF_MAC_HIDEMENU								 	21063
#define WPREF_MAC_ALLOWSTOPSLEEP						 	21064 // Bool: deny mac power cycling
#define WPREF_UV_RELAX_DATA					         	21065 // BaseContainer
#define WPREF_UV_OPTIMAL_MAPPING_DATA	       	21066 // BaseContainer
#define WPREF_UV_PROJECTION_DATA	           	21067 // BaseContainer
#define WPREF_UV_TAB_SEL    	               	21068 // BaseContainer
#define WPREF_UV_TRANSFORM_DATA              	21069 // BaseContainer
#define WPREF_LINUX_BROWSERPATH							 	21070 // Filename
#define WPREF_MOUSEOVER_AUTO							   	21071 // Bool
#define WPREF_MOUSEOVER_SHORTCUT						 	21072 // Bool
#define WPREF_MOUSEOVER_TIME								 	21073 // LONG
#define WPREF_ONLINEHELP_MODE								 	21074 //
	#define ONLINEHELP_MODE_LOCAL		0
	#define ONLINEHELP_MODE_HTTP		1
#define WPREF_ONLINEHELP_PATH								 	21075 // path
#define WPREF_ONLINEHELP_URL								 	21076
#define WPREF_LINUX_IMAGEEDITPATH						 	21077 // Filename
#define WPREF_LOCKINTERFACE										21078 // Bool
#define WPREF_TOOLCURSOR_BASIC								21079 // Bool
#define WPREF_TOOLCURSOR_ADVANCED							21080 // Bool

#define WPREF_ONLINEUPDATER_AUTO_CHECK				40000 // bool
#define WPREF_ONLINEUPDATER_CHECKSUM					40001 // private
#define WPREF_ONLINEUPDATER_SHOW_INSTALLED		40003 // bool
#define WPREF_ONLINEUPDATER_AUTORESTART				40004 // bool
#define WPREF_ONLINEUPDATER_BACKUP						40005 // bool
#define WPREF_ONLINEUPDATER_BACKUP_PATH				40014 // Filename
#define WPREF_ONLINEUPDATER_PROXYSERVER				40008 // String
#define WPREF_ONLINEUPDATER_PROXYPORT					40009 // LONG
#define WPREF_ONLINEUPDATER_MD_PATH1					40010 // private
#define WPREF_ONLINEUPDATER_LAST_OPEN_DAY			40011 // LONG
#define WPREF_ONLINEUPDATER_LAST_OPEN_HOUR		40012 // Real
#define WPREF_ONLINEUPDATER_REMOVE_FILES			40013 // bool
#define WPREF_ONLINEUPDATER_MD_PATH2					40020 // private
#define WPREF_ONLINEUPDATER_MD_PATH3					40021 // private
#define WPREF_ONLINEUPDATER_MD_PATH4					40022 // private

#define WPREF_FILEPATH_ALL					90000
#define WPREF_FILEPATH_TEX					90001
#define WPREF_FILEPATH_MAT					90002
#define WPREF_FILEPATH_DOC					90003
#define WPREF_FILEPATH_PRF					90004
#define WPREF_FILEPATH_CAT					90005
#define WPREF_FILEPATH_WAV					90006
#define WPREF_FILEPATH_COF					90007
#define WPREF_FILEPATH_FCV					90008
#define WPREF_FILEPATH_BP						90022

#define	WPREF_PV_RENDER_VIEW				430000690				// LONG - the index id of the PictureViewer dialog that receives render output

// mouse cursors
#define MOUSE_HIDE								 0
#define MOUSE_SHOW							 	 1
#define MOUSE_NORMAL							 2
#define MOUSE_BUSY								 3
#define MOUSE_CROSS								 4
#define MOUSE_QUESTION						 5
#define MOUSE_ZOOM_IN							 6
#define MOUSE_ZOOM_OUT						 7
#define MOUSE_FORBIDDEN						 8
#define MOUSE_DELETE							 9
#define MOUSE_COPY								10
#define MOUSE_INSERTCOPY					11
#define MOUSE_INSERTCOPYDOWN			12
#define MOUSE_MOVE								13
#define MOUSE_INSERTMOVE					14
#define MOUSE_INSERTMOVEDOWN			15
#define MOUSE_ARROW_H							16
#define MOUSE_ARROW_V							17
#define MOUSE_ARROW_HV						18
#define MOUSE_POINT_HAND					19
#define MOUSE_MOVE_HAND						20
#define MOUSE_IBEAM								21
#define MOUSE_SELECT_LIVE					22
#define MOUSE_SELECT_FREE					23
#define MOUSE_SELECT_RECT					24
#define MOUSE_SELECT_POLY					25
#define MOUSE_SPLINETOOLS					26
#define MOUSE_EXTRUDE    					27
#define MOUSE_NORMALMOVE 					28
#define MOUSE_ADDPOINTS  					29
#define MOUSE_ADDPOLYGONS					30
#define MOUSE_BRIDGE     					31
#define MOUSE_MIRROR     					32
#define MOUSE_PAINTMOVE						33
#define MOUSE_PAINTSELECTRECT			34
#define MOUSE_PAINTSELECTCIRCLE		35
#define MOUSE_PAINTSELECTPOLY			36
#define MOUSE_PAINTSELECTFREE			37
#define MOUSE_PAINTMAGICWAND			38
#define MOUSE_PAINTCOLORRANGE			39
#define MOUSE_PAINTFILL						40
#define MOUSE_PAINTPICK						41
#define MOUSE_PAINTBRUSH					42
#define MOUSE_PAINTCLONE					43
#define MOUSE_PAINTTEXT						44
#define MOUSE_PAINTCROP						45
#define MOUSE_PAINTLINE						46
#define MOUSE_PAINTPOLYSHAPE			47

// global events
#define EVMSG_CHANGE								604
#define EVMSG_DOCUMENTRECALCULATED	'drcl' // view has been animated, expression are executed, some manager data may have changed
#define	EVMSG_TOOLCHANGED						0xfff36465
#define	EVMSG_GRAPHVIEWCHANGED			400008000
#define EVMSG_AUTKEYMODECHANGED			200000009
#define	EVMSG_UPDATEHIGHLIGHT				200000073

#define	EVMSG_SHOWIN_SB             -200000074  
#define	EVMSG_SHOWIN_TL             -200000075
#define	EVMSG_SHOWIN_FC             -200000076
#define	EVMSG_SHOWIN_LM             -200000077
#define	EVMSG_TLOM_MERGE            -465001000

//Cat added for Show ni Motion
#define	EVMSG_SHOWIN_MT             -200000078


#define EVMSG_TIMELINESELECTION			-1001
#define EVMSG_BROWSERCHANGE					-1002
#define EVMSG_MATERIALSELECTION			-1009
#define EVMSG_FCURVECHANGE					-1010

#define EVMSG_RAYTRACER_FINISHED    -1003
#define EVMSG_FRAME_SCENE           -1005
#define EVMSG_MATERIALPREVIEW				-1008
#define EVMSG_ACTIVEVIEWCHANGED			'acvw'
#define EVMSG_ASYNCEDITORMOVE		    'edmv'
		#define MOVE_START			0
		#define MOVE_CONTINUE		1
		#define MOVE_END				2 // -> par2 == ESC
#define	EVMSG_TIMECHANGED						'tchg'

enum EVENTFLAGS
{
	EVENT_0										= 0,
	EVENT_FORCEREDRAW					= (1<<0),
	EVENT_ANIMATE							= (1<<1),
	EVENT_NOEXPRESSION				= (1<<2),
	EVENT_GLHACK							= (1<<3),
	EVENT_CAMERAEXPRESSION		= (1<<4)
};

// draw flags
#define DA_NO_THREAD							(1<<1)
#define DA_NO_REDUCTION						(1<<2)
#define DA_WAIT_GL_FINISHED				(1<<3)	// wait until opengl has been finished, useful for synchronous redraws!
#define DA_NO_ANIMATION						(1<<8)
#define DA_ONLY_ACTIVE_VIEW				(1<<10)
#define DA_NO_EXPRESSIONS					(1<<12)
#define DA_INDRAG									(1<<13)
#define DA_ONLY_CAMERAEXPRESSION	(1<<16)
#define DA_FORCEFULLREDRAW				(1<<15)
#define DA_NODUALPLANE						(1<<20)
#define DA_ONLY_BASEDRAW					(1<<22) // draw specific basedraw only
#define DA_IRR										(1<<23) // for IRR only - doesn't stop IRR on view redraw

#define DA_ONLY_HIGHLIGHT					((1<<18)|DA_IRR)
#define DA_STATICBREAK						((1<<19)|DA_NO_THREAD)

// animate scene/object flags
#define ANIMATE_NO_PARTICLES			(1<<2)
#define ANIMATE_QUICK							(1<<3)
#define ANIMATE_NO_CHILDS					(1<<6)
#define ANIMATE_INRENDER					(1<<7)
#define ANIMATE_NO_MINMAX       	(1<<8)  // only internal !!! used for LONG/REAL
#define ANIMATE_NO_NLA          	(1<<9)  // only internal
#define ANIMATE_NLA_SUM         	(1<<10) // only internal


// undo types
#define UNDO_CHANGE							40
#define UNDO_CHANGE_NOCHILDS		41
#define UNDO_CHANGE_SMALL				42
#define UNDO_CHANGE_SELECTION		43

#define UNDO_NEW								44
#define UNDO_DELETE							45

#define UNDO_ACTIVATE						46
#define UNDO_DEACTIVATE					47

#define UNDO_BITS								48

// handle types
#define HANDLE_MINI				0
#define HANDLE_SMALL			1
#define HANDLE_MIDDLE			2
#define HANDLE_BIG				3

// viewport colors
#define VIEWCOLOR_C4DBACKGROUND						 0
#define VIEWCOLOR_FILMFORMAT							 1
#define VIEWCOLOR_HORIZON									 2
#define VIEWCOLOR_GRID_MAJOR							 3
#define VIEWCOLOR_GRID_MINOR							 4
#define VIEWCOLOR_SPLINESTART							 5
#define VIEWCOLOR_SPLINEEND								 6
#define VIEWCOLOR_CAMERA									 7
#define VIEWCOLOR_PARTICLE								 8
#define VIEWCOLOR_PMODIFIER								 9
#define VIEWCOLOR_BONE										10
#define VIEWCOLOR_MODIFIER								11
#define VIEWCOLOR_ACTIVEPOINT							12
#define VIEWCOLOR_INACTIVEPOINT						13
#define VIEWCOLOR_TANGENT									14
#define VIEWCOLOR_ACTIVEPOLYGON						15
#define VIEWCOLOR_INACTIVEPOLYGON 				16
#define VIEWCOLOR_TEXTURE									17
#define VIEWCOLOR_TEXTUREAXIS							18
#define VIEWCOLOR_ACTIVEBOX								19
#define VIEWCOLOR_ANIMPATH								20
#define VIEWCOLOR_XAXIS										21
#define VIEWCOLOR_YAXIS										22
#define VIEWCOLOR_ZAXIS										23
#define VIEWCOLOR_WXAXIS									24
#define VIEWCOLOR_WYAXIS									25
#define VIEWCOLOR_WZAXIS									26
#define VIEWCOLOR_SELECT_AXIS							27
#define VIEWCOLOR_VERTEXSTART							36
#define VIEWCOLOR_VERTEXEND								37
#define VIEWCOLOR_UVMESH_GREYED						38
#define VIEWCOLOR_UVMESH_APOLY						39
#define VIEWCOLOR_UVMESH_IAPOLY						40
#define VIEWCOLOR_UVMESH_APOINT						41
#define VIEWCOLOR_UVMESH_IAPOINT					42
#define VIEWCOLOR_NORMAL									43
#define VIEWCOLOR_ACTIVECHILDBOX					44
#define VIEWCOLOR_ACTIVEPOLYBOX						45
#define VIEWCOLOR_ACTIVEPOLYCHILDBOX			46
#define VIEWCOLOR_SELECTION_PREVIEW				47
#define VIEWCOLOR_MEASURETOOL     				48
#define VIEWCOLOR_AXIS_BAND								49
#define VIEWCOLOR_SHADEDWIRE							50
#define VIEWCOLOR_NGONLINE								51
#define VIEWCOLOR_FRONTFACING							52
#define VIEWCOLOR_BACKFACING							53
#define VIEWCOLOR_MINSOFTSELECT						54
#define VIEWCOLOR_MAXSOFTSELECT						55
#define VIEWCOLOR_MINHNWEIGHT							56
#define VIEWCOLOR_ZEROHNWEIGHT						57
#define VIEWCOLOR_MAXHNWEIGHT							58
#define VIEWCOLOR_IRR											59

#define VIEWCOLOR_MAXCOLORS								60

// dirty flags
#define DIRTY_MATRIX						(1<<1)
#define DIRTY_DATA							(1<<2)
#define DIRTY_SELECT						(1<<3)
#define DIRTY_CACHE							(1<<4)
#define DIRTY_CHILDREN					(1<<5)

// vflags
#define VFLAG_INTERNALRENDERER	(1<<1)
#define VFLAG_EXTERNALRENDERER	(1<<2)
#define VFLAG_ISOPARM						(1<<3)
#define VFLAG_POLYGONAL				  (1<<4)

// hierarchy clone flags
#define HCLONE_ASIS							(1<<0)
#define HCLONE_ASPOLY						(1<<1)
#define HCLONE_ASLINE						(1<<2)
#define HCLONE_ASSPLINE					(1<<3)

// error string dialog
#define IS_NOTHING			0
#define IS_DEGREE				1
#define IS_PERCENT			2
#define IS_METER				3
#define IS_LONG					5

#define Greater					0
#define GreaterOrEqual	1
#define Less						2
#define LessOrEqual			3
#define Between					4
#define BetweenOrEqual	5
#define BetweenOrEqualX	6
#define BetweenOrEqualY	7
#define Different				8

// paintmesh bits
#define PAINTMESH_QUAD   (1<<1) // polygon is quadrangle
#define PAINTMESH_SEL    (1<<6) // polygon selected

// im-/export formats
#define FORMAT_PREF				1000
#define FORMAT_WAV				1018
#define FORMAT_FCV				1019
#define FORMAT_L4D				1020
#define FORMAT_C4D_6_XML	1021
#define FORMAT_P4D				1022

#define FORMAT_C4DIMPORT		1001025
#define FORMAT_C4DEXPORT		1001026
#define FORMAT_XMLIMPORT		1001027
#define FORMAT_XMLEXPORT		1001028
#define FORMAT_C4D4IMPORT		1001029
#define FORMAT_C4D5IMPORT		1001030
#define FORMAT_VRML1IMPORT	1001031
#define FORMAT_VRML1EXPORT	1001032
#define FORMAT_VRML2IMPORT	1001033
#define FORMAT_VRML2EXPORT	1001034
#define FORMAT_DXFIMPORT		1001035
#define FORMAT_DXFEXPORT		1001036
#define FORMAT_3DSIMPORT		1001037
#define FORMAT_3DSEXPORT		1001038
#define FORMAT_OBJIMPORT		1001039
#define FORMAT_OBJEXPORT		1001040
#define FORMAT_Q3DIMPORT		1001041
#define FORMAT_Q3DEXPORT		1001042
#define FORMAT_LWSIMPORT		1001043
#define FORMAT_LWOIMPORT		1001044
#define FORMAT_AIIMPORT			1001045
#define FORMAT_DEMIMPORT		1001046
#define FORMAT_D3DEXPORT		1001047

// registry
#define RE_WINDOW						   1
#define RE_OBJECT						   3
#define RE_TRACK						   4
#define	RE_SEQUENCE					   5
#define RE_KEY							   6
#define RE_TAG							   7
#define RE_MATERIAL					   8
#define RE_SHADER2D					   9
#define RE_SHADER3D					  10
#define RE_COFFEE_EXT				  11
#define RE_IO_IMAGE						12
#define RE_IO_MOVIE		        13
#define RE_IO_SCENE		        14
#define RE_IO_PREF	         	15
#define RE_IO_CATALOG         17
#define RE_IO_SOUND           18
#define RE_IO_IMAGESAVER_EX		19
#define RE_IO_FCV							20
#define RE_IO_LAYOUT          21
#define RE_BITMAP_FILTER			22
#define RE_VIDEOPOST					23
#define RE_SCENEHOOK					24
#define RE_NODE								25
#define RE_DESCRIPTION				27
#define RE_LIBRARY						28
#define RE_CUSTOMDATATYPE			29
#define RE_RESOURCEDATATYPE		30
#define RE_CTRACK						  34
#define RE_CSEQ               35
#define RE_CKEY  						  36

#define RE_PAINTER						50

#define HIGHLIGHT_TRANSPARENCY -140

#define HERMITEFAK						4.0

#define CREATE_GL_HAS_ROOT		1
#define CREATE_GL_IS_ROOT			2

#define DELETE_GL_HAS_ROOT		1
#define DELETE_GL_IS_ROOT			2

class BaseBitmap;

struct IconData
{
	IconData() { bmp=NULL; x=y=w=h=0; }

	BaseBitmap	*bmp;
	LONG				x,y,w,h;
};

#define RESOURCEIMAGE_PIN													9000
#define RESOURCEIMAGE_SUBGROUP										12678
#define RESOURCEIMAGE_UNLOCKED										12679
#define RESOURCEIMAGE_LOCKED											-12679
#define RESOURCEIMAGE_HISTOGRAM										12680
#define RESOURCEIMAGE_PLUS												300000118
#define RESOURCEIMAGE_MINUS												300000119
#define RESOURCEIMAGE_ANIM												200000122
#define RESOURCEIMAGE_KEY													300000121
#define RESOURCEIMAGE_SEQUENCE										300000122
#define RESOURCEIMAGE_FOLDER											300000123
#define RESOURCEIMAGE_OPENED											300000124
#define RESOURCEIMAGE_CLOSED											300000125
#define RESOURCEIMAGE_ARROWLEFT										300000126
#define RESOURCEIMAGE_ARROWRIGHT									300000127
#define RESOURCEIMAGE_ARROWUP											300000128
#define RESOURCEIMAGE_AMDUPLICATE									300000129
#define RESOURCEIMAGE_MOVE												13563
#define RESOURCEIMAGE_SCALE												13564
#define RESOURCEIMAGE_ROTATE											13565
#define RESOURCEIMAGE_VIEWCHANGE									13640
#define RESOURCEIMAGE_FULLSCREEN									17301
#define RESOURCEIMAGE_CLOSERRELEASED							12097
#define RESOURCEIMAGE_CLOSERPRESSED								-12097
#define RESOURCEIMAGE_CANCEL											300000130
#define RESOURCEIMAGE_OK													300000131
#define RESOURCEIMAGE_OKCANCEL										300000132
#define RESOURCEIMAGE_BOOLGROUP										300000133
#define RESOURCEIMAGE_ADAPTERGROUP								300000134
#define RESOURCEIMAGE_CALCULATEGROUP							300000135
#define RESOURCEIMAGE_DEFAULTGROUP								300000136
#define RESOURCEIMAGE_DEFAULTOPERATOR							300000137
#define RESOURCEIMAGE_GENERALGROUP								300000138
#define RESOURCEIMAGE_ITERATORGROUP								300000139
#define RESOURCEIMAGE_LOGICALGROUP								300000140
#define RESOURCEIMAGE_TPGROUP											300000141
#define RESOURCEIMAGE_COFFEESCRIPT								300000142
#define RESOURCEIMAGE_UVWTAG_SECONDSTATE					300000143
#define RESOURCEIMAGE_INSTANCEOBJECT_SECONDSTATE	300000144
#define RESOURCEIMAGE_LIGHT_SHADOWS								300000145
#define RESOURCEIMAGE_LIGHT_SPOT									300000146
#define RESOURCEIMAGE_LIGHT_SPOTSHADOWS						300000147
#define RESOURCEIMAGE_LIGHT_PARALLEL							300000148
#define RESOURCEIMAGE_LIGHT_PARALLELSHADOWS				300000149
#define RESOURCEIMAGE_LIGHT_AREA									300000150
#define RESOURCEIMAGE_LIGHT_AREASHADOWS						300000151
#define RESOURCEIMAGE_BASEDRAW										300000152
#define RESOURCEIMAGE_CTRACK											300000153
#define RESOURCEIMAGE_BASEKEY											300000154
#define RESOURCEIMAGE_BASESEQUENCE								300000155
#define RESOURCEIMAGE_BASETRACK										300000156
#define RESOURCEIMAGE_UNKNOWN											300000157
#define RESOURCEIMAGE_BASESHADER									300000158
#define RESOURCEIMAGE_PAINTBITMAP									300000159
#define RESOURCEIMAGE_MULTIPLE										300000160
#define RESOURCEIMAGE_EYEACTIVE   								300000161
#define RESOURCEIMAGE_EYEINACTIVE 								300000162
#define RESOURCEIMAGE_PENACTIVE   								300000163
#define RESOURCEIMAGE_PENINACTIVE 								300000164
#define RESOURCEIMAGE_ALPHAACTIVE 								300000165
#define RESOURCEIMAGE_ALPHAINACTIVE 							300000166
#define RESOURCEIMAGE_LINKEDACTIVE 								300000167
#define RESOURCEIMAGE_LINKEDINACTIVE 							300000168
#define RESOURCEIMAGE_BPAXIS 											300000169
#define RESOURCEIMAGE_BPCROSSED 									300000170
#define RESOURCEIMAGE_MOCCATREEVIEWNO							300000171
#define RESOURCEIMAGE_MOCCATREEVIEWYES						300000172
#define RESOURCEIMAGE_MOCCATREEVIEWLOCKED					300000173
#define RESOURCEIMAGE_MOCCAIKTAG1									300000174
#define RESOURCEIMAGE_MOCCAIKTAG2									300000175
#define RESOURCEIMAGE_MOCCAIKTAG3									300000176
#define RESOURCEIMAGE_MOCCAIKTAG4									300000177
#define RESOURCEIMAGE_MOCCAIKTAG5									300000178
#define RESOURCEIMAGE_MOCCAIKTAG6									300000185
#define RESOURCEIMAGE_BITMAPFILTERPLUS						300000179
#define RESOURCEIMAGE_BITMAPFILTERMINUS						300000180
#define RESOURCEIMAGE_CLOTHING1										300000181
#define RESOURCEIMAGE_CLOTHING2										300000182
#define RESOURCEIMAGE_CLOTHING3										300000183
#define RESOURCEIMAGE_CLOTHING4										300000184
#define RESOURCEIMAGE_CLEARSELECTION							300000187
#define RESOURCEIMAGE_GENERICCOMMAND							300000188
#define RESOURCEIMAGE_TIMELINE_KEY1								300000191
#define RESOURCEIMAGE_TIMELINE_KEY2								300000192
#define RESOURCEIMAGE_AMMODELOCK_1								300000193
#define RESOURCEIMAGE_AMMODELOCK_2								300000194
#define RESOURCEIMAGE_SCENEBROWSER_HOME						300000195
#define RESOURCEIMAGE_SCENEBROWSER_FILTER1				300000196
#define RESOURCEIMAGE_SCENEBROWSER_FILTER2				300000197
#define RESOURCEIMAGE_SCENEBROWSER_FIND1					300000198
#define RESOURCEIMAGE_SCENEBROWSER_FIND2					300000199
#define RESOURCEIMAGE_SCENEBROWSER_PATH1					300000200
#define RESOURCEIMAGE_SCENEBROWSER_PATH2					300000201
#define RESOURCEIMAGE_TIMELINE_STATE1							300000202 
#define RESOURCEIMAGE_TIMELINE_STATE2							300000203 
#define RESOURCEIMAGE_TIMELINE_STATE3							300000204 
#define RESOURCEIMAGE_TIMELINE_STATE4							300000205 
#define RESOURCEIMAGE_TIMELINE_STATE5							300000206 
#define RESOURCEIMAGE_TIMELINE_STATE6							300000207 
#define RESOURCEIMAGE_TIMELINE_KEYSTATE1					300000208 
#define RESOURCEIMAGE_TIMELINE_KEYSTATE2					300000209 
#define RESOURCEIMAGE_TIMELINE_KEYSTATE3					300000210 
#define RESOURCEIMAGE_TIMELINE_KEYSTATE4					300000211 
#define RESOURCEIMAGE_LAYERMANAGER_STATE1					300000212 
#define RESOURCEIMAGE_LAYERMANAGER_STATE2					300000213 
#define RESOURCEIMAGE_LAYERMANAGER_STATE3					300000214 
#define RESOURCEIMAGE_LAYERMANAGER_STATE4					300000215 
#define RESOURCEIMAGE_LAYERMANAGER_STATE5					300000216 
#define RESOURCEIMAGE_LAYERMANAGER_STATE6					300000217 
#define RESOURCEIMAGE_LAYERMANAGER_STATE7					300000218 
#define RESOURCEIMAGE_LAYERMANAGER_STATE8					300000219 
#define RESOURCEIMAGE_LAYERMANAGER_STATE9					300000220 
#define RESOURCEIMAGE_LAYERMANAGER_STATE10				300000221 
#define RESOURCEIMAGE_LAYERMANAGER_STATE11				300000222 
#define RESOURCEIMAGE_LAYERMANAGER_STATE12				300000223 
#define RESOURCEIMAGE_LAYERMANAGER_STATE13				300000224 
#define RESOURCEIMAGE_LAYERMANAGER_STATE14				300000225 
#define RESOURCEIMAGE_LAYERMANAGER_STATE15				300000226 
#define RESOURCEIMAGE_LAYERMANAGER_STATE16				300000227 
#define RESOURCEIMAGE_LAYERMANAGER_STATE17				300000228 
#define RESOURCEIMAGE_LAYERMANAGER_STATE18				300000229 
#define RESOURCEIMAGE_OBJECTMANAGER_STATE1				300000230 
#define RESOURCEIMAGE_OBJECTMANAGER_STATE2				300000231 
#define RESOURCEIMAGE_OBJECTMANAGER_STATE3				300000232 
#define RESOURCEIMAGE_OBJECTMANAGER_STATE4				300000233 
#define RESOURCEIMAGE_OBJECTMANAGER_DOT1					300000234 
#define RESOURCEIMAGE_OBJECTMANAGER_DOT2					300000235 
#define RESOURCEIMAGE_OBJECTMANAGER_DOT3					300000236 
#define RESOURCEIMAGE_OBJECTMANAGER_DOT4					300000237 
#define RESOURCEIMAGE_OBJECTMANAGER_LOCK					300000238 
#define RESOURCEIMAGE_TIMELINE_FOLDER1						300000239 
#define RESOURCEIMAGE_TIMELINE_FOLDER2						300000240 
#define RESOURCEIMAGE_TIMELINE_FOLDER3						300000241 
#define RESOURCEIMAGE_TIMELINE_FOLDER4						300000242 
#define RESOURCEIMAGE_TIMELINE_ROOT1							300000243 
#define RESOURCEIMAGE_TIMELINE_ROOT2							300000244 
#define RESOURCEIMAGE_TIMELINE_ROOT3							300000245 
#define RESOURCEIMAGE_OBJECTMANAGER_DISP1					300000246 
#define RESOURCEIMAGE_OBJECTMANAGER_DISP2					300000247 
#define RESOURCEIMAGE_OBJECTMANAGER_DISP3					300000248 
#define RESOURCEIMAGE_OBJECTMANAGER_DISP4					300000249 
#define RESOURCEIMAGE_BROWSER_DESKTOP							300000251 
#define RESOURCEIMAGE_BROWSER_HOME								300000252 
#define RESOURCEIMAGE_BROWSER_PRESET							300000253 
#define RESOURCEIMAGE_BROWSER_CATALOG							300000254 
#define RESOURCEIMAGE_BROWSER_SEARCH							300000255 
#define RESOURCEIMAGE_BROWSER_PLAY								300000256 
#define RESOURCEIMAGE_BROWSER_PAUSE								300000257 
#define RESOURCEIMAGE_BROWSER_SMALLVIEW						300000258 
#define RESOURCEIMAGE_BROWSER_BIGVIEW							300000259 
#define RESOURCEIMAGE_ONLINEHELP_HOME							300000260 
#define RESOURCEIMAGE_ARROWDOWN										300000263
#define RESOURCEIMAGE_EYETRISTATE 								300000264
#define RESOURCEIMAGE_PREVIOUSPAGE								1022433
#define RESOURCEIMAGE_FOLLOWINGPAGE								1022434

#define HOTKEY_CAMERA_MOVE		13563
#define HOTKEY_CAMERA_SCALE		13564
#define HOTKEY_CAMERA_ROTATE	13565

#define HOTKEY_OBJECT_MOVE		13566
#define HOTKEY_OBJECT_SCALE		13567
#define HOTKEY_OBJECT_ROTATE	13568

#define HOTKEY_MODEL_SCALE    13569
#define HOTKEY_ZOOM           13570
#define HOTKEY_SELECT_FREE    13571
#define HOTKEY_SELECT_LIVE    13572
#define HOTKEY_SELECT_RECT    13573

#define IDM_UNDO							12105
#define IDM_REDO							12297
#define IDM_CUT								12106
#define IDM_COPY							12107
#define IDM_PASTE							12108
#define IDM_DELETE						12109
#define IDM_SELECTALL					12112
#define IDM_SELECTNONE				12113
#define IDM_INVERSION					12374

#endif
