#ifndef _MATRIX4_H_
#define _MATRIX4_H_

#include "ge_matrix.h"
#include "ge_vector.h"
#include "vector4.h"

class Matrix4
{
public:
	Matrix4(_DONTCONSTRUCT v)
	{
	}

	Matrix4()
	{
		_00 = 1.0f; _01 = 0.0f; _02 = 0.0f; _03 = 0.0f;
		_10 = 0.0f; _11 = 1.0f; _12 = 0.0f; _13 = 0.0f;
		_20 = 0.0f; _21 = 0.0f; _22 = 1.0f; _23 = 0.0f;
		_30 = 0.0f; _31 = 0.0f; _32 = 0.0f; _33 = 1.0f;
	}

	Matrix4(Real m00, Real m01, Real m02, Real m03,
					Real m10, Real m11, Real m12, Real m13,
					Real m20, Real m21, Real m22, Real m23,
					Real m30, Real m31, Real m32, Real m33)
	{
		_00 = m00; _01 = m01; _02 = m02; _03 = m03;
		_10 = m10; _11 = m11; _12 = m12; _13 = m13;
		_20 = m20; _21 = m21; _22 = m22; _23 = m23;
		_30 = m30; _31 = m31; _32 = m32; _33 = m33;
	}

	explicit Matrix4(Real* p)
	{
		LONG i;
		for (i = 0; i < 16; i++)
			m_prArray[i] = p[i];
	}

	Matrix4(const Matrix4 &m)
	{
		LONG i;
		for (i = 0; i < 16; i++)
			m_prArray[i] = m.m_prArray[i];
	}

	explicit Matrix4(const Matrix &m)
	{
		_00 = m.v1.x; _01 = m.v2.x; _02 = m.v3.x; _03 = m.off.x;
		_10 = m.v1.y; _11 = m.v2.y; _12 = m.v3.y; _13 = m.off.y;
		_20 = m.v1.z; _21 = m.v2.z; _22 = m.v3.z; _23 = m.off.z;
		_30 = 0.0f;   _31 = 0.0f;   _32 = 0.0f;   _33 = 1.0f;
	}

	friend const Matrix4 operator * (const Matrix4 &m1, const Matrix4 &m2)
	{
		LONG i, j, k;
		Matrix4 r(DC);
		r.SetZero();

		for (i = 0; i < 4; i++)
		{
			for (k = 0; k < 4; k++)
			{
				for (j = 0; j < 4; j++)
				{
					r.m_prElements[i][j] += m1.m_prElements[i][k] * m2.m_prElements[k][j];
				}
			}
		}
		return r;
	}

	friend const Vector4 operator * (const Matrix4 &m, const Vector4 &v)
	{
		Vector4 r(0.0f);
		LONG i, k;

		for (i = 0; i < 4; i++)
		{
			for (k = 0; k < 4; k++)
			{
				r.m_prElements[i] += m.m_prElements[i][k] * v.m_prElements[k];
			}
		}
		return r;
	}

	friend const Vector operator * (const Matrix4 &m, const Vector &v)
	{
		Vector4 t(v);
		Vector4 r(0.0f);
		LONG i, k;

		for (i = 0; i < 4; i++)
		{
			for (k = 0; k < 4; k++)
			{
				r.m_prElements[i] += m.m_prElements[i][k] * t.m_prElements[k];
			}
		}
		r.MakeVector3();
		return Vector(r.x, r.y, r.z);
	}

	Matrix4 GetTranspose() const
	{
		Matrix4 r(DC);
		LONG i, j;
		for (i = 0; i < 4; i++)
		{
			for (j = 0; j < 4; j++)
				r.m_prElements[i][j] = m_prElements[j][i];
		}
		return r;
	}

	friend const Matrix4 operator ! (const Matrix4 &m)
	{
		Matrix4 r(DC);

		r._00 =  Det(m._11, m._12, m._13, m._21, m._22, m._23, m._31, m._32, m._33);
		r._01 = -Det(m._01, m._02, m._03, m._21, m._22, m._23, m._31, m._32, m._33);
		r._02 =  Det(m._01, m._02, m._03, m._11, m._12, m._13, m._31, m._32, m._33);
		r._03 = -Det(m._01, m._02, m._03, m._11, m._12, m._13, m._21, m._22, m._23);
		r._10 = -Det(m._10, m._12, m._13, m._20, m._22, m._23, m._30, m._32, m._33);
		r._11 =  Det(m._00, m._02, m._03, m._20, m._22, m._23, m._30, m._32, m._33);
		r._12 = -Det(m._00, m._02, m._03, m._10, m._12, m._13, m._30, m._32, m._33);
		r._13 =  Det(m._00, m._02, m._03, m._10, m._12, m._13, m._20, m._22, m._23);
		r._20 =  Det(m._10, m._11, m._13, m._20, m._21, m._23, m._30, m._31, m._33);
		r._21 = -Det(m._00, m._01, m._03, m._20, m._21, m._23, m._30, m._31, m._33);
		r._22 =  Det(m._00, m._01, m._03, m._10, m._11, m._13, m._30, m._31, m._33);
		r._23 = -Det(m._00, m._01, m._03, m._10, m._11, m._13, m._20, m._21, m._23);
		r._30 = -Det(m._10, m._11, m._12, m._20, m._21, m._22, m._30, m._31, m._32);
		r._31 =  Det(m._00, m._01, m._02, m._20, m._21, m._22, m._30, m._31, m._32);
		r._32 = -Det(m._00, m._01, m._02, m._10, m._11, m._12, m._30, m._31, m._32);
		r._33 =  Det(m._00, m._01, m._02, m._10, m._11, m._12, m._20, m._21, m._22);
		Real det = m._00 * r._00 + m._10 * r._01 + m._20 * r._02 + m._30 * r._03;
		if (det == 0)
		{
			r = Matrix4();
			return r;
		}
    det = 1.0f / det;
		r = det * r;
		return r;
	}

	friend const Matrix4 operator * (const Real s, const Matrix4 &m)
	{
		Matrix4 r(DC);
		LONG i;
		for (i = 0; i < 16; i++)
			r.m_prArray[i] = m.m_prArray[i] * s;
		return r;
	}

	void SetZero()
	{
		_00 = _01 = _02 = _03 = 0.0f;
		_10 = _11 = _12 = _13 = 0.0f;
		_20 = _21 = _22 = _23 = 0.0f;
		_30 = _31 = _32 = _33 = 0.0f;
	}

	void SetOffset(const Vector& v)
	{
		_03 = v.x;
		_13 = v.y;
		_23 = v.z;
	}

	void Scale(Real r)
	{
		_33 /= r;
	}

	void ScaleDirections(Real r)
	{
		_00 *= r; _01 *= r; _02 *= r;
		_10 *= r; _11 *= r; _12 *= r;
		_20 *= r; _21 *= r; _22 *= r;
	}

	union
	{
		struct { Real _00, _01, _02, _03, 
									_10, _11, _12, _13,
									_20, _21, _22, _23,
									_30, _31, _32, _33; };
		Real m_prElements[4][4];
		Real m_prArray[16];
	};

protected:
	static Real Det(Real a1, Real a2, Real a3, Real b1, Real b2, Real b3, Real c1, Real c2, Real c3)
	{
		return a1 * (b2 * c3 - b3 * c2) - b1 * (a2 * c3 - a3 * c2) + c1 * (a2 * b3 - a3 * b2);
	}
};

#endif // _MATRIX4_H_
