/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2008 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

// interface functions

#ifndef __OPERATINGSYSTEM_H
#define __OPERATINGSYSTEM_H

#include "ge_math.h"
#include "ge_vector.h"
#include "ge_prepass.h"
#include "c4d_basetime.h"

class CCurve;
class C4DAtom;
class C4DAtomGoal;
class AtomArray;
class NodeData;
class GeListNode;
class GeListHead;
class GeMarker;
class AliasTrans;
class Registry;
class CDialog;
class CUserArea;
class _GeListView;
class _SimpleListView;
class BaseTag;
class MPBaseThread;
class Semaphore;
class VariableTag;
class BaseTime;
class BaseChannel;
class BaseContainer;
class BaseDocument;
class BaseSelect;
class HyperFile;
class MemoryFileStruct;
class BaseList2D;
class BaseList4D;
class BaseObject;
class SplineObject;
class PluginShader;
class PointObject;
class PolygonObject;
class LineObject;
class MultipassObject;
class BaseDraw;
class BaseDrawHelp;
class BaseView;
class BaseLink;
class String;
class BaseBitmap;
class MemoryPool;
class BaseMaterial;
class Material;
class PluginMaterial;
class PluginVideoPost;
class RenderData;
class LocalFileTime;
class Render;
class TextureTag;
class MovieSaver;
class IpConnection;
class BrowseFiles;
class BrowseVolumes;
class Parser;
class BaseFile;
class AESFile;
class SelectionTag;
class PluginTag;
class LassoSelection;
class UVWTag;
class ObjectSafety;
class PluginSceneHook;
class ParticleTag;
class StickTextureTag;
class Particle;
class LocalResource;
class HierarchyHelp;
class BaseKey;
class PLAKey;
class FolderSequence;
class SoundSequence;
class BaseSound;
class Stratified2DRandom;
class BaseThread;
class EnumerateEdges;
class PaintTexture;
class PaintLayer;
class PaintLayerBmp;
class SDKBrowserURL;
class PaintLayerMask;
class PaintLayerFolder;
class PaintBitmap;
class PaintMaterial;
class LayerSetSelection;
class UVClass;
class EditorWindow;
class VPBuffer;
class PluginKey;
class PluginSequence;
class PluginTrack;
class GeData;
class Description;
class DescID;
class DynamicDescription;
class Description;
class DescID;
class _TextureGroup;
class BaseContainer;
class Filename;
class VideoPostData;
class BasePlugin;
class PriorityList;
class LensGlowStruct;
class CBaseFrame;
class RayFilter;
class PolyTriangulate;
class ViewportSelect;
class Pgon;
class NgonBase;
class MultipassBitmap;
class Coffee;
class VALUE;
class GeData;
class CKey;
class CCurve;
class CTrack;
class GeClipMap;
class CAnimInfo;
class DLayerStruct;
class GlString;
class Gradient;
class GlProgramFactory;
class Matrix4;
class Vector4;
class GlFrameBuffer;
class GlVertexBuffer;
class LayerObject;
class C4DObjectList;
class LayerSetHelper;
class BaseBitmapLink;
class BitmapLoaderPlugin;

typedef UCHAR PIX;

struct GetAllStringData;
struct LayerData;
struct CustomDataType;
struct C4D_Painter;
struct C4D_BitmapFilter;
struct ParticleDetails;
struct PolyInfo;
struct IlluminanceSurfacePointData;
struct SData;
struct VolumeData;
struct Ray;
struct Tangent;
struct UVWStruct;
struct Segment;
struct CPolygon;
struct TimingStruct;
struct LVector;
struct RayHitID;
struct LMatrix;
struct InitRenderStruct;
struct C4D_Key;
struct C4D_Sequence;
struct C4D_Track;
struct RayObject;
struct RayLight;
struct PolyVector;
struct TexData;
struct VideoPostStruct;
struct SurfaceData;
struct PMStruct;
struct VIDEOPOST;
struct RayPolyWeight;
struct CHANNELSHADER;
struct VOLUMESHADER;
struct VP_DATA;
struct MouseDownInfo;
struct DrawInfo;
struct RayLightCache;
struct IconData;
struct C4D_GraphView;
struct NODEPLUGIN;
struct VPFragment;
struct BranchInfo;
struct AnimValue;
struct ObjectColorProperties;
struct PixelFragment;
struct ChannelData;
struct CUSTOMDATATYPEPLUGIN;
struct RESOURCEDATATYPEPLUGIN;
struct TempUVHandle;
struct TextureSize;
struct ViewportPixel;
struct NgonNeighbor;
struct SurfaceIntersection;
struct ARRAY;
struct OBJECT;
struct STRING;
struct CLASS;
struct C4DPL_CommandLineArgs;
typedef BaseBitmap AlphaBitmap;
struct BakeProgressInfo;
struct GlLight;
struct GlGetIdentity;
struct OITInfo;
class ParserCache;
struct SoundInfo;
struct BitmapRenderRegion;

#ifndef __API_INTERN__
	#define PluginObject BaseObject
#endif

#define API_VERSION	11500

#define C4DPL_SHADER							 2
#define C4DPL_MATERIAL						 3
#define C4DPL_COFFEEMESSAGE				 4
#define C4DPL_COMMAND							 7
#define C4DPL_OBJECT							 8
#define C4DPL_TAG									10
#define C4DPL_BITMAPFILTER				12
#define C4DPL_VIDEOPOST						13
#define C4DPL_TOOL								14
#define C4DPL_SCENEHOOK						15
#define C4DPL_NODE								16
#define C4DPL_LIBRARY							18
#define C4DPL_BITMAPLOADER				22
#define C4DPL_BITMAPSAVER					23
#define C4DPL_SCENELOADER					24
#define C4DPL_SCENESAVER					25
#define C4DPL_COREMESSAGE					26
#define C4DPL_CUSTOMGUI						27
#define C4DPL_CUSTOMDATATYPE			28
#define C4DPL_RESOURCEDATATYPE		29
#define C4DPL_MANAGERINFORMATION	30
#define C4DPL_CTRACK							31

#ifndef C4D_GL_VARS_DEFINED
#if defined __PC
typedef	UINT C4DGLuint;
typedef INT C4DGLint;
#elif defined __MAC
#if !defined( MAC_OS_X_VERSION_10_5 ) || ( MAC_OS_X_VERSION_MAX_ALLOWED < MAC_OS_X_VERSION_10_5 )	// Xcode < 3?
typedef unsigned long	C4DGLuint;
typedef long					C4DGLint;
#else																												// MacOS 10.5 32 bit & LP64
typedef unsigned int	C4DGLuint;
typedef int						C4DGLint;
#endif
#elif defined __LINUX
typedef	UINT C4DGLuint;
typedef INT C4DGLint;
#endif
typedef VLONG GlProgramParameter;
#define C4D_GL_VARS_DEFINED
#endif

enum
{
	DIALOG_PIN = 1,						// LONG flags
	DIALOG_CHECKBOX,					// LONG id, LONG flags, String *name
	DIALOG_STATICTEXT,				// LONG id, LONG flags, String *name, LONG borderstyle
	DIALOG_BUTTON,						// LONG id, LONG flags, String *name
	DIALOG_ARROWBUTTON,				// LONG id, LONG flags, LONG arrowtype
	DIALOG_EDITTEXT,					// LONG id, LONG flags
	DIALOG_EDITNUMBER,				// LONG id, LONG flags
	DIALOG_EDITNUMBERUD,			// LONG id, LONG flags
	DIALOG_EDITSLIDER,				// LONG id, LONG flags
	DIALOG_SLIDER,						// LONG id, LONG flags
	DIALOG_COLORFIELD,				// LONG id, LONG flags
	DIALOG_COLORCHOOSER,			// LONG id, LONG flags
	DIALOG_USERAREA,					// LONG id, LONG flags
	DIALOG_RADIOGROUP,				// LONG id, LONG flags
	DIALOG_COMBOBOX,					// LONG id, LONG flags
	DIALOG_POPUPBUTTON,				// LONG id, LONG flags
	DIALOG_CHILD,							// LONG id, LONG subid, String *child);
	DIALOG_FREECHILDS,				// LONG id
	DIALOG_DLGGROUP,					// LONG flags
	DIALOG_SETTITLE,					// String *name
	DIALOG_GROUPSPACE,				// spacex,spacey
	DIALOG_GROUPBORDER,				// borderstyle
	DIALOG_GROUPBORDERSIZE,	  // left, top, right, bottom
	DIALOG_SETIDS,						// left, top, right, bottom
	DIALOG_LAYOUTCHANGED,			// relayout dialog
	DIALOG_ACTIVATE,					// activate gadget
	DIALOG_ADDSUBMENU,				// add submenu, text
	DIALOG_ENDSUBMENU,				// add submenu, text
	DIALOG_ADDMENUCMD,				// add menutext, text, cmdid
	DIALOG_FLUSHMENU,					// delete all menu entries
	DIALOG_INIT,							// create new layout
	DIALOG_CHECKNUMBERS,			// range check of all dialog elements
	DELME_DIALOG_SETGROUP,					// set group as insert group
	DIALOG_FLUSHGROUP,				// flush all elements of this group and set insert point to this group
	DIALOG_SETMENU,						// set and display menu in manager
	DIALOG_SCREEN2LOCALX,			// Screen2Local coordinates
	DIALOG_SCREEN2LOCALY,			// Screen2Local coordinates
	DIALOG_ADDMENUSTR,				// add menutext, text, id
	DIALOG_RADIOBUTTON,				// LONG id, LONG flags, String *name
	DIALOG_ADDMENUSEP,				// add menu separator
	DIALOG_SEPARATOR,					// add separator
	DIALOG_MULTILINEEDITTEXT, // add multiline editfield
	DIALOG_INITMENUSTR,				// enable/disable/check/uncheck menustrings
	DIALOG_RADIOTEXT,
	DIALOG_MENURESOURCE,			// private for painter
	DIALOG_LISTVIEW,					// LONG id, LONG flags
	DIALOG_SUBDIALOG,					// LONG id, LONG flags
	DIALOG_CHECKCLOSE,				// CheckCloseMessage for dialog
	DIALOG_GETTRISTATE,				// get TriState-flag of the specified gadget
	DIALOG_SDK,								// LONG id, LONG flags, String *name
	DIALOG_SCROLLGROUP,				// create ScrollGroup
	DIALOG_ISOPEN,						// returns TRUE if the dialog is open
	DIALOG_REMOVEGADGET,			// removes an element from the layout
	DIALOG_MENUGROUPBEGIN,
	DIALOG_NOMENUBAR,					// removes the menubar
	DIALOG_SAVEWEIGHTS,				// store the weights of a group
	DIALOG_LOADWEIGHTS,				// restore the weights of a group
	DIALOG_EDITSHORTCUT,			// editfield to enter shortcuts
	DIALOG_ISVISIBLE,					// returns TRUE if the dialog is visible (e.g. FALSE if tabbed behind)
	DIALOG_HIDEELEMENT,				// TRUE - hides the element
	DIALOG_PROGRESSBAR,				// creates a c4d progressbar with spinner and textfield
	DIALOG_SETDEFAULTCOLOR,		// set the mapcolor for an color to anotehr value e.g. COLOR_BG = 1,1,1

	DIALOG_
};

#define EDITTEXT_PASSWORD		(1<<0)		// creates a passwordfield

enum
{
	LV_GETLINECOUNT    = 1,  // request the number of lines of the listview
	LV_GETCOLUMNCOUNT  = 2,  // request the number of columns of listview
	LV_GETLINEHEIGHT   = 3,  // ask for the line height of the specific 'line'
	LV_GETCOLUMNWIDTH  = 4,  // ask for the width of the specific 'column' in 'line'
	LV_GETCOLUMTYPE    = 5,  // ask for the type of the column in 'line',
		LV_COLUMN_TEXT      = C4D_FOUR_BYTE(0,'t','x','t'),
		LV_COLUMN_EDITTEXT  = C4D_FOUR_BYTE(0,'e','d','t'),
		LV_COLUMN_BMP       = C4D_FOUR_BYTE(0,'b','m','p'),
		LV_COLUMN_CHECKBOX  = C4D_FOUR_BYTE(0,'c','h','k'),
		LV_COLUMN_BUTTON    = C4D_FOUR_BYTE(0,'b','t','n'),
		LV_COLUMN_USERDRAW  = C4D_FOUR_BYTE(0,'u','s','r'),
		LV_COLUMN_COLORVIEW = C4D_FOUR_BYTE(0,'c','l','v'),

	LV_GETCOLUMDATA    = 6,  // ask for the data of the column in 'line',
	LV_GETLINESELECTED = 7,  // ask if the line is selected
	LV_GETCOLSPACE     = 8,  // ask for space in pixels between two columns
	LV_GETLINESPACE    = 9,  // ask for space in pixels between two lines
	LV_GETFIXEDLAYOUT  = 10, // ask for fixed layout: FALSE...indiv. layout, TRUE...fixed layout
	LV_DESTROYLISTVIEW = 11, // destroy listview and all data
	LV_INITCACHE       = 12, // (internal) before call the listview
	LV_NOAUTOCOLUMN		 = 13, // ask for fast layout: FALSE...eachline is ask for the width, TRUE...only the first line is asked for the columnwidth -> huge speedup

	LV_LMOUSEDOWN       = 50, // mouse down at line, col,
	LV_ACTION						= 51, // gadget command, col, data1 = msg,
	LV_USERDRAW					= 52,
	LV_REDRAW						= 53, // redraw the listview (supermessage)
	LV_DATACHANGED		  = 54, // layout data has changed
	LV_SHOWLINE					= 55, // scroll line into the visible area
	LV_DRAGRECEIVE			= 56,	// drag receive

	LV_SIMPLE_SELECTIONCHANGED = 100, // simplelistview: selection changed
	LV_SIMPLE_CHECKBOXCHANGED  = 101, // simplelistview: checkbox changed
	LV_SIMPLE_FOCUSITEM        = 102, // simplelistview: set focus to item
	LV_SIMPLE_BUTTONCLICK      = 103, // simplelistview: button click
		LV_SIMPLE_ITEM_ID	= 1,
		LV_SIMPLE_COL_ID	= 2,
		LV_SIMPLE_DATA    = 3,
	LV_SIMPLE_DOUBLECLICK      = 104, // doubleclick occured
	LV_SIMPLE_FOCUSITEM_NC     = 105, // focus item, but no change

	// result types
	LV_RES_LONG        = 'long',
	LV_RES_BITMAP      = C4D_FOUR_BYTE(0,'b','m','p'),
	LV_RES_STRING      = 'strg',
	LV_RES_VECTOR      = C4D_FOUR_BYTE(0,'v','e','c'),
	LV_RES_NIL         = C4D_FOUR_BYTE(0,'n','i','l'),

	LV__
};

#ifndef _C4D_GL_H_
enum GlProgramType { VertexProgram = 1, FragmentProgram = 2 };
enum GlUniformParamType { UniformFloat1 = 0, UniformFloat2 = 1, UniformFloat3 = 2, UniformFloat4 = 3,
														UniformFloatMatrix2 = 4, UniformFloatMatrix3 = 5, UniformFloatMatrix4 = 6,
														UniformTexture1D = 7, UniformTexture2D = 8, UniformTexture3D = 9, UniformTextureCube = 10 };
#endif

// predefined calling points for tags and scenehooks
#define	EXECUTION_INITIAL							1000
#define EXECUTION_ANIMATION						2000
#define EXECUTION_EXPRESSION				  3000
#define EXECUTION_DYNAMICS						4000
#define EXECUTION_GENERATOR					  5000

#define EXECUTION_RESULT_OK						0
#define EXECUTION_RESULT_USERBREAK		1
#define EXECUTION_RESULT_MEMORYERROR	2

enum
{
	DLG_OK     = 1,
	DLG_CANCEL = 2,
	DLG_HELP   = 4,
	DLG_
};

enum StringEncoding
{
	StXbit		= 0,
	St8bit		= 1,
	St7bit		= 2,
	St7bithex	= 3,
	StUTF8	  = 4,
	StHTML		= 5
};

enum FINDANIM_TYPE
{
	FINDANIM_EXACT,
	FINDANIM_LEFT,
	FINDANIM_RIGHT
};

enum CCurveType
{
	CC_CURVE     = 1,
	CC_HLE_BASE  = 2,
	CC_HLE_CURVE = 3,
	CC_SS_CURVE  = 4,
  //Cat added for multiple Snapshots
  CC_SS_CURVE2 = 5,
  CC_SS_CURVE3 = 6,
  CC_SS_CURVE4 = 7,
  CC_SS_CURVE5 = 8,
	//Cat added for Scale and Move HLE Curve
	CC_HLE_SCALE = 9,
	CC_HLE_MOVE  =10,

	_CC_DUM
};

enum CLoopType
{
	CLOOP_OFF          = 0,
	CLOOP_CONSTANT     = 1,
	CLOOP_CONTINUE     = 2,
	CLOOP_REPEAT       = 3,
	CLOOP_OFFSETREPEAT = 4,
	CLOOP_OSCILLATE    = 5,

	CLOOP_DUM
};

enum CInterpolation
{
	CINTER_SPLINE = 1,
	CINTER_LINEAR = 2,
	CINTER_STEP   = 3,

	CINTER_DUM
};

enum ClipboardType
{
	CLIPBOARDTYPE_EMPTY  =0,
	CLIPBOARDTYPE_STRING =1,
	CLIPBOARDTYPE_BITMAP =2,

	CLIPBOARDTYPE_DUM
};

enum EdgeSelectionType
{
	EDGES_SELECTION = 0,
	EDGES_HIDDEN    = 1,
	EDGES_PHONG     = 2
};

#define MODELINGCOMMANDFLAG_CREATEUNDO	(1<<0)
#define MODELINGCOMMANDFLAG_NONEWNODES	(1<<1)

struct ModelingCommandData
{
	ModelingCommandData() { doc=NULL; op=NULL; bc=NULL; mode=0; flags=0; result_ex=NULL; result=NULL; version=1; arr=NULL; }
	~ModelingCommandData();

	BaseDocument*		doc;
	BaseObject*			op;
	BaseContainer*	bc;
	LONG						mode;
	LONG						flags;

	BaseObject*			result_ex; // don't use
	LONG 						version;
	AtomArray*      arr;
	AtomArray*      result;
};

#define SETTINGS_GENERAL							0
#define SETTINGS_MODELER							1
#define SETTINGS_DOCUMENT							2
#define SETTINGS_OBJECTMANAGER				3
#define SETTINGS_MATERIALMANAGER			4
#define SETTINGS_COORDINATEMANAGER		5
#define SETTINGS_ANIMATIONSYSTEM			7

// GeGetSerialInfo
#define SERIAL_CINEMA4D			0
#define SERIAL_MULTILICENSE	2

// GeGetVersionType
#define VERSION_CINEMA4D						(1<<0)
#define VERSION_BODYPAINT						(1<<1)
#define VERSION_NET									(1<<2)
#define VERSION_SERVER							(1<<3)
#define VERSION_DEMO								(1<<4)
#define VERSION_BENCHMARK						(1<<6)
#define VERSION_BODYPAINT2_EX				(1<<7)
#define VERSION_MODELER							(1<<8)
// 1<<9 somehow used in GeGetVersionTypeSDK
#define VERSION_BPSTANDALONE				(1<<10)
#define VERSION_UPDATER							(1<<11)
#define VERSION_SAVABLEDEMO					(1<<12)
#define VERSION_SAVABLEDEMO_ACTIVE	(1<<13)
#define VERSION_INSTALLER						(1<<14)

// GeGetSystemInfo
#define SYSTEMINFO_OSX			(1<<0)
#define SYSTEMINFO_NOGUI		(1<<1)

// file selector type
#define FSTYPE_ANYTHING								0
#define FSTYPE_IMAGES									1
#define FSTYPE_SCENES									2
#define FSTYPE_COFFEE									3

// document IDs
#include "ddoc.h"

#define DOCUMENT_KEYFRAMESELECTIONOBJECT		50004 // LINK
#define DOCUMENT_MULTISELECTIONWORLD				50005 // LINK
#define DOCUMENT_SELECTIONFILTER						50006 // LONG
#define DOCUMENT_DISPLAYFILTER							50007 // LONG
#define DOCUMENT_RESTRICTEDITORSELECTION		50008 // BOOL

#define DOCUMENT_SENDBACKTO									50010 // LONG
#define DOCUMENT_TGAFORCE										50011 // BOOL
#define DOCUMENT_SECONDARYPATH							50012 // FILENAME
#define DOCUMENT_MULTISELECTIONHIGHLIGHT		50013 // private!
#define DOCUMENT_STICKY											50014 // LONG
#define DOCUMENT_CLONING_HINT								50015 // LONG
	#define DOCUMENT_CLONING_HINT_DEFAULT					0
	#define DOCUMENT_CLONING_HINT_EDITOR					1
	#define DOCUMENT_CLONING_HINT_SUBFRAME				2

//Cat added for NLA
#define ID_MT_SOURCECOUNTER							465001520 //LONG

#define	SELECTIONFILTERBIT_NULL				(1<<0)
#define	SELECTIONFILTERBIT_POLYGON		(1<<1)
#define	SELECTIONFILTERBIT_SPLINE			(1<<2)
#define	SELECTIONFILTERBIT_GENERATOR	(1<<3)
#define	SELECTIONFILTERBIT_HYPERNURBS (1<<4)
#define	SELECTIONFILTERBIT_BONE				(1<<5)
#define	SELECTIONFILTERBIT_DEFORMER		(1<<6)
#define	SELECTIONFILTERBIT_CAMERA			(1<<7)
#define	SELECTIONFILTERBIT_LIGHT			(1<<8)
#define	SELECTIONFILTERBIT_SCENE			(1<<9)
#define	SELECTIONFILTERBIT_PARTICLE		(1<<10)
#define	SELECTIONFILTERBIT_OTHER			(1<<11)
#define	SELECTIONFILTERBIT_JOINT			(1<<25)

// get/set mode flags
#define MODE_EDITOR	0
#define MODE_RENDER	1
#define MODE_DEFORM	2

// maximum number of texture paths
#define MAX_GLOBAL_TEXTURE_PATHS	10

// display filter	(NULL to OTHER match SELECTIONFILTERBIT_)

#define	DISPLAYFILTER_NULL				(1<<0)
#define	DISPLAYFILTER_POLYGON			(1<<1)
#define	DISPLAYFILTER_SPLINE			(1<<2)
#define	DISPLAYFILTER_GENERATOR			(1<<3)
#define	DISPLAYFILTER_HYPERNURBS		(1<<4)
#define	DISPLAYFILTER_BONE				(1<<5)
#define	DISPLAYFILTER_DEFORMER			(1<<6)
#define	DISPLAYFILTER_CAMERA			(1<<7)
#define	DISPLAYFILTER_LIGHT				(1<<8)
#define	DISPLAYFILTER_SCENE				(1<<9)
#define	DISPLAYFILTER_PARTICLE			(1<<10)
#define	DISPLAYFILTER_OTHER				(1<<11)
#define	DISPLAYFILTER_NULLBONES			(1<<12)
#define	DISPLAYFILTER_GRID				(1<<13)
#define	DISPLAYFILTER_HORIZON			(1<<14)
#define	DISPLAYFILTER_WORLDAXIS			(1<<15)
#define	DISPLAYFILTER_BOUNDS			(1<<16)
#define	DISPLAYFILTER_HUD				(1<<17)
#define	DISPLAYFILTER_SDS				(1<<18)
#define	DISPLAYFILTER_HIGHLIGHTING		(1<<19)
#define	DISPLAYFILTER_MULTIAXIS			(1<<20)
#define	DISPLAYFILTER_OBJECTHANDLES		(1<<21)
#define	DISPLAYFILTER_HANDLEBANDS		(1<<22)
#define	DISPLAYFILTER_SDSCAGE			(1<<23)
#define	DISPLAYFILTER_NGONLINES			(1<<24)
#define	DISPLAYFILTER_JOINT				(1<<25)

// display edit state

#define DISPLAY_EDITSTATE_SDS			(1<<0)
#define DISPLAY_EDITSTATE_DEFORM	(1<<1)

// identify thread
#define THREADTYPE_EDITORREDRAW		(1<<0)
#define THREADTYPE_RENDEREDITOR		(1<<1)
#define THREADTYPE_RENDEREXTERNAL	(1<<2)

typedef LONG CDialogMessage(CDialog *cd, CUserArea *cu, BaseContainer *msg);
typedef void ListViewCallBack(LONG &res_type,void *&result,void *userdata,void *secret,LONG cmd,LONG line,LONG col,void *data1);
typedef void IlluminationModel(VolumeData *sd, RayLightCache *rlc, void *dat);
typedef Bool COFFEE_ERRORHANDLER(void *priv_data, const BaseContainer &bc);
typedef void* (*GlProgramFactoryAllocPrivate)();
typedef void (*GlProgramFactoryFreePrivate)(void* pData);
typedef void* (*GlProgramFactoryAllocDescription)();
typedef void (*GlProgramFactoryFreeDescription)(void* pData);
typedef void (*GlProgramFactoryCreateFnCallback)(const Real* prIn, Real* prOut, void* pData);
typedef LONG (*GlProgramFactoryErrorHandler)(GlProgramType type, const char* pszError);
typedef void (*GlVertexBufferDrawFanCallback)(LONG nFan, void* pData);
typedef Bool (*BaseDrawMessageHook)(BaseDraw* bd, BaseDocument* doc, LONG type, void* data);
typedef void (*BrowserPopupCallback)(void *userdata, LONG cmd, SDKBrowserURL &url);

typedef void ThreadMain(void *data);
typedef Bool ThreadTest(void *data);
typedef const CHAR *ThreadName(void *data);
typedef void ProgressHook(Real p, void *private_data);
typedef void BakeProgressHook(BakeProgressInfo* info);

typedef void *HierarchyAlloc(void *main);
typedef void HierarchyFree(void *main, void *data);
typedef void HierarchyCopyTo(void *main, void *src, void *dst);
typedef Bool HierarchyDo(void *main, void *data, BaseObject *op, const Matrix &mg, Bool controlobject);

typedef void PopupEditTextCallback(LONG mode, const String &text, void *userdata);

typedef void (*LASTCURSORINFOFUNC)();

#define GETBRANCHINFO_ONLYWITHCHILDREN	(1<<1)
#define GETBRANCHINFO_GELISTNODES				(1<<3)

#define BRANCHINFO_ANIMATE						(1<<0)
#define BRANCHINFO_HIDEINTIMELINE			(1<<4)

#define VPGETINFO_XRESOLUTION	0
#define VPGETINFO_YRESOLUTION	1
#define VPGETINFO_BITDEPTH		2
#define VPGETINFO_CPP					3
#define VPGETINFO_VISIBLE			4
#define VPGETINFO_LINEOFFSET	5 // offset of component in line

#define DRAWPOLYOBJECT_FORCELINES		(1<<0)
#define DRAWPOLYOBJECT_NOBACKCULL		(1<<1)
#define DRAWPOLYOBJECT_LOCALMATRIX	(1<<2)
#define DRAWPOLYOBJECT_EDITMODE			(1<<3)
#define DRAWPOLYOBJECT_FORCEBASE		(1<<9)

#define RENDERFLAG_EXTERNAL					(1<<0)
#define RENDERFLAG_NODOCUMENTCLONE	(1<<1)
#define RENDERFLAG_SHOWERRORS				(1<<2)
#define RENDERFLAG_PREVIEWRENDER		(1<<3)
#define RENDERFLAG_IRR							(1<<4)

#define SOUNDCOMMAND_START				0
#define SOUNDCOMMAND_DRAGSTART		1
#define SOUNDCOMMAND_DRAGCONTINUE	2

// CheckIsRunning
#define CHECKISRUNNING_ANIMATIONRUNNING				0
#define CHECKISRUNNING_VIEWDRAWING						1
#define CHECKISRUNNING_EDITORRENDERING				2
#define CHECKISRUNNING_EXTERNALRENDERING			3
#define CHECKISRUNNING_PAINTERUPDATING				4
#define CHECKISRUNNING_MATERIALPREVIEWRUNNING	5

// HandleShaderPopup
#define SHADERPOPUP_LOADIMAGE					99991
#define SHADERPOPUP_EDITPARAMS				99999
#define SHADERPOPUP_RELOADIMAGE				99998
#define SHADERPOPUP_EDITIMAGE					99997
#define SHADERPOPUP_COPYCHANNEL				99995
#define SHADERPOPUP_PASTECHANNEL			99994
#define SHADERPOPUP_CREATENEWTEXTURE	99993
#define SHADERPOPUP_CLEARSHADER				99992

#define SHADERPOPUP_SETFILENAME				99990
#define SHADERPOPUP_SETSHADER					99989

#define DEFAULTFILENAME_SHADER_SURFACES		1001
#define DEFAULTFILENAME_SHADER_EFFECTS		1002
#define DEFAULTFILENAME_SHADER_VOLUME			1003

// Background handler
#define BACKGROUNDHANDLER_ISRUNNING	100
#define BACKGROUNDHANDLER_STOP			101
#define BACKGROUNDHANDLER_START			102
#define BACKGROUNDHANDLER_REMOVE		103

#define BACKGROUNDHANDLER_PRIORITY_RENDERACTIVEMATERIAL			 5000
#define BACKGROUNDHANDLER_PRIORITY_REDRAWVIEW								 4000
#define BACKGROUNDHANDLER_PRIORITY_RENDERINACTIVEMATERIALS	 3000

#define BACKGROUNDHANDLER_PRIORITY_RENDEREXTERNAL						-1000
#define BACKGROUNDHANDLER_PRIORITY_REDRAWANTS								-2000

#define BACKGROUNDHANDLER_FLAGS_VIEWREDRAW					(1<<0)
#define BACKGROUNDHANDLER_FLAGS_EDITORRENDDER				(1<<1)
#define BACKGROUNDHANDLER_FLAGS_MATERIALPREVIEW			(1<<2)
#define BACKGROUNDHANDLER_FLAGS_RENDEREXTERNAL			(1<<3)
#define BACKGROUNDHANDLER_FLAGS_VIEWREDRAW_SPECIAL	(1<<4)

#define BACKGROUNDHANDLER_TYPECLASS_C4D					1000

typedef Bool BackgroundHandler(void *data, LONG command, LONG parm);

// Identify File
#define IDENTIFYFILE_SCENE					(1<<0)
#define IDENTIFYFILE_IMAGE					(1<<1)
#define IDENTIFYFILE_MOVIE					(1<<2)
#define IDENTIFYFILE_SKIPQUICKTIME	(1<<3)
#define IDENTIFYFILE_SCRIPT					(1<<4)
#define IDENTIFYFILE_COFFEE					(1<<5)
#define IDENTIFYFILE_SOUND					(1<<6)
#define IDENTIFYFILE_LAYOUT					(1<<7)

// COFFEE Scripts
#define ID_COFFEESCRIPT									1001085

#define COFFEESCRIPT_TEXT								1000
#define COFFEESCRIPT_SHOWINMENU					1002
#define COFFEESCRIPT_ADDEVENT						1003
#define COFFEESCRIPT_SCRIPTENABLE				1006

#define COFFEESCRIPT_CONTAINER					65536 // + language identification

#define COFFEESCRIPT_SCRIPTNAME					1
#define COFFEESCRIPT_SCRIPTHELP					2

#define MSG_COFFEESCRIPT_EXECUTE				1001184 // no arguments
#define MSG_COFFEESCRIPT_RETRIEVEBITMAP	1001185 // pass pointer to bitmap pointer

#define BASEDRAW_DRAWPORTTYPE			1888
#define BASEDRAW_ISSHADOWPASS			1889
#define BASEDRAW_ISRENDERASEDITOR	1890
#define BASEDRAW_ISOGL_PREPASS		1891

#define MULTIPASSCHANNEL_IMAGELAYER						1
#define MULTIPASSCHANNEL_MATERIALCHANNEL			2

struct MultiPassChannel
{
	LONG   id;
	String *name;
	LONG	 flags;
};


struct C4D_Shader
{
	Real						(*SNoise							)(Vector p);
	Real						(*SNoiseT							)(Vector p, Real t);
	Real						(*Noise								)(Vector p);
	Real						(*NoiseT							)(Vector p, Real t);
	Real						(*PNoise							)(Vector p, Vector d);
	Real						(*PNoiseT							)(Vector p, Real t, Vector d, Real dt);
	Real						(*Turbulence					)(Vector p, Real oct, Bool abs);
	Real						(*TurbulenceT					)(Vector p, Real t, Real oct, Bool abs);
	Real						(*WavyTurbulence			)(Vector p, Real t, Real oct, Real start);
	void						(*InitFbm							)(Real *table, LONG max_octaves, Real lacunarity, Real h);
	Real						(*Fbm									)(Real *table, Vector p, Real oct);
	Real						(*FbmT								)(Real *table, Vector p, Real t, Real oct);
	Real						(*RidgedMultifractal	)(Real *table, Vector p, Real oct, Real offset, Real gain);
	Real						(*CalcSpline					)(Real x, Real *knot, LONG nknots);
	Vector					(*CalcSplineV					)(Real x, Vector *knot, LONG nknots);

	void						(*Illuminance1				)(VolumeData *sd, Vector *diffuse, Vector *specular, Real exponent);
	void						(*Illuminance2				)(VolumeData *sd, Vector *diffuse, Vector *specular, Real exponent, LVector *p, LVector *n, LVector *bumpn, LVector *rayv, LONG calc_shadow);

	LONG						(*GetCurrentCPU				)(VolumeData *sd);
	LONG						(*GetCPUCount					)(VolumeData *sd);
	void*						(*GetRayData					)(VolumeData *sd, LONG i);

	RayObject*			(*GetObj							)(VolumeData *sd, LONG i);
	LONG						(*GetObjCount					)(VolumeData *sd);

	RayLight*				(*GetLight						)(VolumeData *sd, LONG i);
	LONG						(*GetLightCount				)(VolumeData *sd);

	RayObject*			(*ID_to_Obj						)(VolumeData *sd, const RayHitID &id);

	void						(*GetUVW							)(VolumeData *sd, RayObject *op, LONG uvwind, LONG i, PolyVector *uvw);
	Vector					(*GetPointUVW					)(VolumeData *sd, TexData *tdp, const RayHitID &lhit, const LVector &p);
	void						(*GetNormals					)(VolumeData *sd, RayObject *op, LONG polygon, PolyVector *norm);
	TexData*				(*GetTexData					)(VolumeData *sd, RayObject *op, LONG index);
	LVector					(*GetNormal						)(VolumeData *sd, RayObject *op, LONG polygon, Bool second);
	LVector					(*GetSmoothedNormal		)(VolumeData *sd, const RayHitID &hit, const LVector &p);
	Bool						(*GetRS								)(VolumeData *sd, const RayHitID &hit, const LVector &p, Real *r, Real *s);

	void						(*GetRay							)(VolumeData *sd, Real x, Real y, Ray *ray);
	LVector					(*ScreenToCamera			)(VolumeData *sd, const LVector &p);
	LVector					(*CameraToScreen			)(VolumeData *sd, const LVector &p);
	Bool						(*ProjectPoint				)(VolumeData *sd, TexData *tdp, const RayHitID &lhit, const LVector &p, const LVector &n, Vector *uv);

	VolumeData*			(*AllocVolumeData			)(void);
	void						(*FreeVolumeData			)(VolumeData *sd);

	void						(*StatusSetText				)(VolumeData *sd, const String *str);
	void						(*StatusSetBar				)(VolumeData *sd, Real percentage);

	TexData*				(*AllocTexData				)(void);
	void						(*FreeTexData					)(TexData *td);
	void						(*InitTexData					)(TexData *td);

	Vector					(*CalcVisibleLight		)(VolumeData *sd, Ray *ray, Real maxdist, Vector *trans);
	void						(*GetXY								)(VolumeData *sd, LONG *x, LONG *y, LONG *scale);

	LONG						(*Obj_to_Num					)(VolumeData *sd, RayObject *obj);
	LONG						(*Light_to_Num				)(VolumeData *sd, RayLight *light);

	void						(*CopyVolumeData			)(VolumeData *src, VolumeData *dst);

	Bool						(*VPAllocateBuffer		)(Render *render, LONG id, LONG subid, LONG bitdepth, Bool visible);
	VPBuffer*				(*VPGetBuffer					)(Render *render, LONG id, LONG subid);
	LONG						(*VPGetInfo						)(VPBuffer *buf, LONG type);
	Bool						(*VPGetLine						)(VPBuffer *buf, LONG x, LONG y, LONG cnt, void *data, LONG bitdepth, Bool dithering);
	Bool						(*VPSetLine						)(VPBuffer *buf, LONG x, LONG y, LONG cnt, void *data, LONG bitdepth, Bool dithering);

	void						(*OutOfMemory					)(VolumeData *sd);
	Real						(*GetLightFalloff			)(LONG falloff, Real inner, Real outer, Real dist);

	Bool						(*TestBreak						)(VolumeData *sd);

	void						(*VPGetRenderData			)(Render *render, BaseContainer *bc);
	void						(*VPSetRenderData			)(Render *render, const BaseContainer *bc);

	void						(*Illuminance					)(VolumeData *sd, Vector *diffuse, Vector *specular, IlluminationModel *model, void *data);

	PluginVideoPost*(*FindVideoPost				)(VolumeData *sd, LONG i, Bool index);
	VPFragment**		(*VPGetFragments			)(VolumeData *sd, LONG x, LONG y, LONG cnt, LONG flags);
	Bool						(*AddLensGlow					)(VolumeData *sd, LensGlowStruct *lgs, Vector *lgs_pos, LONG lgs_cnt, Real intensity);

	RayLight*				(*AllocRayLight				)(BaseObject *op);
	void						(*FreeRayLight				)(RayLight *lgt);

	LONG						(*TranslateObjIndex		)(VolumeData *sd, LONG index, Bool old_to_new);
	Bool						(*TranslatePolygon		)(VolumeData *sd, RayObject *op, LONG local_index, Vector *previous_points);
	Bool						(*SampleLensFX				)(VolumeData *sd, VPBuffer *rgba, VPBuffer *fx, BaseThread *bt);
	LONG						(*VPAllocateBufferFX	)(Render *render, LONG id, const String &name, LONG bitdepth, Bool visible);

	VolumeData*			(*VPGetInitialVolumeData)(Render *render, LONG cpu);
	Bool						(*SetRayTolerance			)(VolumeData *sd, Real value);

	Bool						(*CalcFgBg						)(VolumeData *sd, Bool foreground, LONG x, LONG y, LONG subx, LONG suby, Vector *color, Real *alpha);
	LONG						(*GetRayPolyState			)(VolumeData *sd, RayObject *op, LONG i);

	void						(*GetWeights					)(VolumeData *sd, const RayHitID &hit, const LVector &p, RayPolyWeight *wgt);
	void						(*InitVolumeData			)(VolumeData *src, VolumeData *dst);

	LONG            (*BakeTextureOld      )(BaseDocument* doc, const BaseContainer &data, BaseBitmap *bmp, BaseThread* th, ProgressHook* hook, void* priv_data);
	BaseDocument*   (*InitBakeTextureOld  )(BaseDocument* doc, TextureTag* textag, UVWTag* texuvw, UVWTag* destuvw);
	BaseDocument*   (*InitBakeTextureAOld )(BaseDocument* doc, TextureTag** textags, UVWTag** texuvws, UVWTag** destuvws, LONG cnt);

	Vector					(*TraceColor					)(VolumeData *sd, Ray *ray, Real maxdist, const RayHitID &lhit, SurfaceIntersection *si);
	Bool  					(*TraceGeometry				)(VolumeData *sd, Ray *ray, Real maxdist, const RayHitID &lhit, SurfaceIntersection *si);
	void  					(*GetSurfaceData		  )(VolumeData *sd, SurfaceData *cd, LONG calc_illum, Bool calc_shadow, Bool calc_refl, Bool calc_trans, Ray *ray, const SurfaceIntersection &si);

	void						(*SkipRenderProcess   )(VolumeData *sd);

	void*						(*VPGetPrivateData    )(Render *render);
	Render*					(*GetRenderInstance   )(VolumeData *sd);

	Vector					(*CentralDisplacePointUV)(VolumeData *sd, RayObject *op, LONG local_id, LONG uu, LONG vv);
	Vector					(*CalcDisplacementNormals)(VolumeData *sd, Real par_u, Real par_v, LONG u0, LONG v0, LONG u1, LONG v1, LONG u2, LONG v2, const Vector &a, const Vector &b, const Vector &c, RayObject *op, LONG polynum);

	Stratified2DRandom* (*SNAlloc										)(void);
	void								(*SNFree										)(Stratified2DRandom *rnd);
	Bool						(Stratified2DRandom::*SNInit		)(LONG initial_value, Bool reset);
	void						(Stratified2DRandom::*SNGetNext	)(Real *xx, Real *yy);
	LONG            (*BakeTexture										)(BaseDocument* doc, const BaseContainer &data, BaseBitmap *bmp, BaseThread* th, BakeProgressHook* hook, BakeProgressInfo* info);
	BaseDocument*   (*InitBakeTexture   						)(BaseDocument* doc, TextureTag* textag, UVWTag* texuvw, UVWTag* destuvw, const BaseContainer &bc, LONG* err, BaseThread* th);
	BaseDocument*   (*InitBakeTextureA   						)(BaseDocument* doc, TextureTag** textags, UVWTag** texuvws, UVWTag** destuvws, LONG cnt, const BaseContainer &bc, LONG* err, BaseThread* th);

	void						(*GetDUDV   										)(VolumeData *vd, TexData *tex, const LVector &p, const LVector &phongn, const LVector &orign, const RayHitID &hitid, Bool forceuvw, Vector *ddu, Vector *ddv);
	void						(*CalcArea											)(VolumeData *sd, RayLight *light, Bool nodiffuse, Bool nospecular, Real specular_exponent, const LVector &ray_vector, const LVector &p, const LVector &bumpn, const LVector &orign, LONG raybits, Vector *diffuse, Vector *specular);
	Bool						(*Illuminate										)(VolumeData *sd, RayLight *light, Vector *col, LVector *lv, const LVector &p, const LVector &bumpn, const LVector &phongn, const LVector &orign, const LVector &ray_vector, LONG calc_shadow, const RayHitID &hitid, LONG raybits, Bool cosine_cutoff, Vector *xshadow);
	void						(*IlluminanceSurfacePoint				)(VolumeData *sd, IlluminanceSurfacePointData *f, Vector *diffuse, Vector *specular);
	Vector					(*IlluminanceAnyPoint						)(VolumeData *sd, const LVector &p, LONG calc_shadow, LONG raybits);
	Vector					(*CalcShadow										)(VolumeData *sd, RayLight *light, const LVector &p, const LVector &bumpn, const LVector &phongn, const LVector &orign, const LVector &rayv, Bool transparency, const RayHitID &hitid, LONG raybits);

	Bool						(*SetRenderProperty							)(Render *render, LONG id, const GeData &dat);
	void						(*SetXY													)(VolumeData *sd, Real x, Real y);
	void						(*InitSurfacePointProperties		)(VolumeData *sd, TexData *td);

	Real						(*SNoiseP												)(Vector p, Real t, LONG t_repeat);
	Real						(*TurbulenceP										)(Vector p, Real t, Real oct, Bool abs, LONG t_repeat);
	Real						(*FbmP													)(Real *table, Vector p, Real t, Real oct, LONG t_repeat);
	Real						(*RidgedMultifractalP						)(Real *table, Vector p, Real t, Real oct, Real offset, Real gain, LONG t_repeat);

	Bool						(*AttachVolumeDataFake					)(VolumeData *sd, BaseObject *camera, const BaseContainer &renderdata, void *priv);
	RayObject*			(*AllocRayObject								)(LONG tex_cnt, void *priv);
	void						(*FreeRayObject									)(RayObject *op);

	Bool  					(*TraceGeometryEnhanced				  )(VolumeData *sd, Ray *ray, Real maxdist, const RayHitID &lhit, LONG raydepth, LONG raybits, LVector *oldray, SurfaceIntersection *si);
	Vector					(*TraceColorDirect							)(VolumeData *sd, Ray *ray, Real maxdist, LONG raydepth, LONG raybits, const RayHitID &lhit, LVector *oldray, SurfaceIntersection *si);

	Vector					(*CalcHardShadow								)(VolumeData *sd, const LVector &p1, const LVector &p2, LONG flags, const RayHitID &lhit, LONG recursion_id, void *recursion_data);
	void						(*StatusSetSpinMode							)(VolumeData *sd, Bool on);
};

struct C4D_HyperFile
{
	Bool						(*WriteChar						)(HyperFile *hf, CHAR  v);
	Bool						(*WriteUChar					)(HyperFile *hf, UCHAR v);
	Bool						(*WriteWord						)(HyperFile *hf, SWORD  v);
	Bool						(*WriteUWord					)(HyperFile *hf, UWORD v);
	Bool						(*WriteLong						)(HyperFile *hf, LONG  v);
	Bool						(*WriteULong					)(HyperFile *hf, ULONG v);
	Bool						(*WriteReal						)(HyperFile *hf, Real  v);
	Bool						(*WriteLReal					)(HyperFile *hf, LReal v);
	Bool						(*WriteBool						)(HyperFile *hf, Bool  v);
	Bool						(*WriteTime						)(HyperFile *hf, const BaseTime &v);
	Bool						(*WriteVector					)(HyperFile *hf, const Vector &v);
	Bool						(*WriteLVector				)(HyperFile *hf, const LVector &v);
	Bool						(*WriteMatrix					)(HyperFile *hf, const Matrix &v);
	Bool						(*WriteLMatrix				)(HyperFile *hf, const LMatrix &v);
	Bool						(*WriteString					)(HyperFile *hf, const String *v);
	Bool						(*WriteFilename				)(HyperFile *hf, const Filename *v);
	Bool						(*WriteImageEx				)(HyperFile *hf, BaseBitmap *v, LONG format, const BaseContainer *data);
	Bool						(*WriteContainer			)(HyperFile *hf, const BaseContainer *v);
	Bool						(*WriteMemory					)(HyperFile *hf, void *data, VLONG count);

	Bool						(*ReadChar						)(HyperFile *hf, CHAR          *v);
	Bool						(*ReadUChar						)(HyperFile *hf, UCHAR         *v);
	Bool						(*ReadWord						)(HyperFile *hf, SWORD          *v);
	Bool						(*ReadUWord					  )(HyperFile *hf, UWORD         *v);
	Bool						(*ReadLong					  )(HyperFile *hf, LONG          *v);
	Bool						(*ReadULong					  )(HyperFile *hf, ULONG         *v);
	Bool						(*ReadReal					  )(HyperFile *hf, Real          *v);
	Bool						(*ReadLReal					  )(HyperFile *hf, LReal         *v);
	Bool						(*ReadBool					  )(HyperFile *hf, Bool          *v);
	Bool						(*ReadTime						)(HyperFile *hf, BaseTime      *v);
	Bool						(*ReadVector					)(HyperFile *hf, Vector        *v);
	Bool						(*ReadLVector					)(HyperFile *hf, LVector       *v);
	Bool						(*ReadMatrix					)(HyperFile *hf, Matrix        *v);
	Bool						(*ReadLMatrix					)(HyperFile *hf, LMatrix       *v);
	Bool						(*ReadString					)(HyperFile *hf, String       *v);
	Bool						(*ReadFilename				)(HyperFile *hf, Filename     *v);
	Bool						(*ReadImage						)(HyperFile *hf, BaseBitmap   *v);
	Bool						(*ReadContainer				)(HyperFile *hf, BaseContainer *v, Bool flush);
	Bool						(*ReadMemory					)(HyperFile *hf, void **data, VLONG *size);

	LONG						(*GetError						)(HyperFile *hf);
	void						(*SetError						)(HyperFile *hf, LONG err);
	Bool						(*ReadValueHeader			)(HyperFile *hf, UCHAR *h);
	Bool						(*SkipValue						)(HyperFile *hf, UCHAR h);
	Bool						(*WriteChunkStart			)(HyperFile *hf, LONG id, LONG level);
	Bool						(*WriteChunkEnd				)(HyperFile *hf);
	Bool						(*ReadChunkStart			)(HyperFile *hf, LONG *id, LONG *level);
	Bool						(*ReadChunkEnd				)(HyperFile *hf);
	Bool						(*SkipToEndChunk			)(HyperFile *hf);
	BaseDocument*		(*GetDocument					)(HyperFile *hf);

	LONG						(*ReadFile						)(BaseDocument *doc, GeListNode *node, const Filename &filename, LONG ident, String *warning_string);
	LONG						(*WriteFile						)(BaseDocument *doc, GeListNode *node, const Filename &filename, LONG ident);

	LONG						(*GetFileVersion			)(HyperFile *hf);

	Bool						(*ReadGeData					)(HyperFile *hf, GeData *v);
	Bool						(*WriteGeData					)(HyperFile *hf, const GeData &v);

	Bool						(*ReadLLong					  )(HyperFile *hf, LLONG *v);
	Bool						(*WriteLLong          )(HyperFile *hf, LLONG v);

	HyperFile*			(*AllocHF             )();
	void						(*FreeHF              )(HyperFile *&hf);
	Bool						(*OpenHF							)(HyperFile *hf,const Filename &filename, LONG mode, LONG ident);
	Bool						(*CloseHF							)(HyperFile *hf);
	Bool						(*WriteImage					)(HyperFile *hf, BaseBitmap *v, LONG format, const BaseContainer *data, LONG savebits);
};

struct C4D_BaseContainer
{
	BaseContainer		*Default;

	// container
	BaseContainer*	(*Alloc								)(LONG id);
	void						(*Free								)(BaseContainer *killme);

	BaseContainer*	(*GetClone						)(const BaseContainer *bc);
	void						(*FlushAll						)(BaseContainer *bc);
	LONG						(*GetId								)(const BaseContainer *bc);
	void						(*SetId								)(BaseContainer *bc, LONG newid);
	Bool						(*Compare							)(const BaseContainer *bc1,const BaseContainer *bc2);

	Bool						(*SetReal							)(BaseContainer *bc, LONG id, Real v);
	Bool						(*SetBool							)(BaseContainer *bc, LONG id, Bool v);
	Bool						(*SetLong							)(BaseContainer *bc, LONG id, LONG v);
	Bool						(*SetString						)(BaseContainer *bc, LONG id, const String *v);
	Bool						(*SetFilename					)(BaseContainer *bc, LONG id, const Filename *v);
	Bool						(*SetBaseTime					)(BaseContainer *bc, LONG id, const BaseTime &v);
	Bool						(*SetContainer				)(BaseContainer *bc, LONG id, const BaseContainer *v);
	Bool						(*SetVector						)(BaseContainer *bc, LONG id, const Vector &v);
	Bool						(*SetMatrix						)(BaseContainer *bc, LONG id, const Matrix &v);

	Real						(*GetRealEx						)(const BaseContainer *bc, LONG id);
	Bool						(*GetBoolEx						)(const BaseContainer *bc, LONG id);
	LONG						(*GetLongEx						)(const BaseContainer *bc, LONG id);
	String*					(*GetStringEx					)(const BaseContainer *bc, LONG id);
	Filename*				(*GetFilenameEx				)(const BaseContainer *bc, LONG id);
	BaseTime				(*GetBaseTimeEx				)(const BaseContainer *bc, LONG id);
	BaseContainer*	(*GetContainer			  )(const BaseContainer *bc, LONG id);
	Vector					(*GetVectorEx					)(const BaseContainer *bc, LONG id);
	Matrix					(*GetMatrixEx				  )(const BaseContainer *bc, LONG id);
	Bool						(*RemoveData					)(BaseContainer *bc, LONG id);
	LONG						(*FindIndex						)(const BaseContainer *bc, LONG id);
	LONG						(*GetIndexId					)(const BaseContainer *bc, LONG index);
	Bool						(*RemoveIndex					)(BaseContainer *bc, LONG index);
	Bool						(*CopyToEx						)(const BaseContainer *bc, BaseContainer *dest);
	LONG						(*GetIndexType				)(const BaseContainer *bc, LONG index);

	GeData*					(*GetIndexData				)(const BaseContainer *bc, LONG index);
	Bool						(*InsDataEx						)(BaseContainer *bc, LONG id, const GeData *n);
	Bool						(*SetDataEx						)(BaseContainer *bc, LONG id, const GeData *n);

	BaseList2D*			(*GetLink							)(const BaseContainer *bc, LONG id, BaseDocument *doc, LONG instanceof);
	Bool						(*SetLink							)(BaseContainer *bc, LONG id, C4DAtomGoal *link);

	void						(*Init								)(BaseContainer *bc, LONG id);

	void*						(*BrowseContainer			)(const BaseContainer *bc, LONG *id, GeData **data, void *handle);
	void						(*MergeContainer			)(BaseContainer *dst, const BaseContainer &src);

	const GeData&		(*GetData							)(const BaseContainer *bc, LONG id);
	Bool						(*GetParameter				)(BaseContainer *dst, const DescID &id, GeData &t_data);
	Bool						(*SetParameter				)(BaseContainer *dst, const DescID &id, const GeData &t_data);
	Bool						(*CopyTo							)(const BaseContainer *bc, BaseContainer *dest,AliasTrans *trans);

	GeData*					(*InsData  						)(BaseContainer *bc, LONG id, const GeData *n);
	GeData*					(*SetData  						)(BaseContainer *bc, LONG id, const GeData *n);
	LLONG						(*GetLLongEx					)(const BaseContainer *bc, LONG id);
	Bool						(*SetLLong						)(BaseContainer *bc, LONG id, LLONG v);
	GeData*					(*InsDataAfter				)(BaseContainer *bc, LONG id, const GeData *n, GeData *last);
	C4DAtomGoal*		(*GetLinkAtom					)(const BaseContainer *bc, LONG id, BaseDocument *doc, LONG instanceof);
	Bool						(*CopyToF							)(const BaseContainer *bc, BaseContainer *dest,AliasTrans *trans, LONG flags);

	void						(*SortContainer       )(BaseContainer &bc);

	Real						(*GetReal							)(const BaseContainer *bc, LONG id, Real preset);
	Bool						(*GetBool							)(const BaseContainer *bc, LONG id, Bool preset);
	LONG						(*GetLong							)(const BaseContainer *bc, LONG id, LONG preset);
	String*					(*GetString						)(const BaseContainer *bc, LONG id, const String& preset);
	Filename*				(*GetFilename					)(const BaseContainer *bc, LONG id, const Filename& preset);
	BaseTime				(*GetBaseTime					)(const BaseContainer *bc, LONG id, const BaseTime& preset);
	Vector					(*GetVector						)(const BaseContainer *bc, LONG id, const Vector& preset);
	Matrix					(*GetMatrix					  )(const BaseContainer *bc, LONG id, const Matrix& preset);
	LLONG						(*GetLLong						)(const BaseContainer *bc, LONG id, LLONG preset);
	void*						(*GetVoid							)(const BaseContainer *bc, LONG id, void* preset);
	const GeData*		(*GetDataPointer			)(const BaseContainer *bc, LONG id);
};

struct C4D_GeData
{
	void            (*Free                )(GeData *data);
	Bool            (*IsEqual             )(const GeData *data,const GeData *data2);
	LONG						(*GetType							)(const GeData *data);
	void            (*CopyData						)(GeData *dest,const GeData *src,AliasTrans *aliastrans);

	Bool						(*SetNil              )(GeData *data);
	Bool						(*SetLong             )(GeData *data,LONG n);
	Bool						(*SetReal             )(GeData *data,Real n);
	Bool						(*SetVector           )(GeData *data,const Vector &n);
	Bool						(*SetMatrix           )(GeData *data,const Matrix &n);
	Bool						(*SetString           )(GeData *data,const String *n);
	Bool            (*SetFilename         )(GeData *data,const Filename *n);
	Bool            (*SetBaseTime         )(GeData *data,const BaseTime &n);
	Bool            (*SetBaseContainer    )(GeData *data,const BaseContainer *n);
	Bool            (*SetLink             )(GeData *data,const BaseLink &n);

	LONG						(*GetLong							)(const GeData *data);
	Real						(*GetReal							)(const GeData *data);
	const Vector&		(*GetVector						)(const GeData *data);
	const Matrix&		(*GetMatrix						)(const GeData *data);
	const String&		(*GetString						)(const GeData *data);
	const Filename&	(*GetFilename					)(const GeData *data);
	const BaseTime&	(*GetTime							)(const GeData *data);
	BaseContainer*	(*GetContainer				)(const GeData *data);
	BaseLink*				(*GetLink             )(const GeData *data);

	Bool            (*SetCustomData				)(GeData *data,LONG type,const CustomDataType &n);
	CustomDataType* (*GetCustomData				)(const GeData *data,LONG type);
	Bool            (*InitCustomData			)(GeData *data,LONG type);

	Bool						(*SetLLong            )(GeData *data,LLONG n);
	LLONG						(*GetLLong						)(const GeData *data);
	void 						(*SetVoid							)(GeData *data, void *v);
};

struct C4D_String
{
	// safety value
	String					*Default;

	// strings
	String*					(*Alloc								)(void);
	String*					(*AllocCString				)(CHAR *txt, LONG count, StringEncoding type);
	String*					(*AllocArray					)(LONG count, UWORD fillchr);
	void						(*Free								)(String *str);
 	String*					(*GetClone						)(const String *src);
	LONG						(*GetLength						)(const String *str);
	Bool						(*Add									)(String *dst,const String *src);

	LONG						(*Compare							)(const String *str1, const String *str2,LONG flag);
	Bool						(*FindFirst						)(const String *str, const String *find, LONG *pos, LONG start);
	Bool						(*FindLast						)(const String *str, const String *find, LONG *pos, LONG start);
	Bool						(*Delete							)(String *str,LONG pos,LONG count);
	void						(*Insert							)(String *str,LONG pos, const String *ins);
	String*					(*SubStr							)(const String *str,LONG start, LONG count);

	Real						(*ToReal							)(const String *str,LONG *error, LONG einheit, LONG winkelart, LONG basis);
	LONG						(*ToLong							)(const String *str, LONG *error);

	String*					(*RealToString				)(Real v, LONG vk, LONG nk, Bool e, UWORD xchar);
	String*					(*LongToString				)(LONG l);

	String*					(*ToUpper							)(const String *str);
	String*					(*ToLower							)(const String *str);

	LONG						(*GetCStringLen				)(const String *str,StringEncoding type);
	LONG						(*GetCString					)(const String *str,CHAR *cstr, LONG max, StringEncoding type);

	UWORD						(*GetChr							)(const String *str,LONG pos);
	void						(*SetChr							)(String *str,LONG pos,UWORD chr);

	void						(*Init								)(String *str);
	void						(*InitCString					)(String *str, const CHAR *txt, LONG count, StringEncoding type);
	void						(*InitArray						)(String *str, LONG count, UWORD fillchr);
	void						(*Flush								)(String *str);
	void						(*CopyTo							)(const String *src, String *dst);

	void						(*GetUcBlock					)(String *str, UWORD *Ubc, LONG Max, Bool zero); 		
	void						(*SetUcBlock					)(String *str, const UWORD *Ubc, LONG Count); 	

	void						(*LLongToString				)(LLONG l, String *dst);

	LONG						(String::*ComparePart		)(const String &Str, LONG cnt, LONG pos) const;

	Bool						(String::*FindFirstCh		)(UWORD ch, LONG *Pos, LONG Start) const;
	Bool						(String::*FindLastCh		)(UWORD ch, LONG *Pos, LONG Start) const;
	Bool						(String::*FindFirstUpper)(const String &find, LONG *pos, LONG start) const;
	Bool						(String::*FindLastUpper	)(const String &find, LONG *pos, LONG start) const;
	void						(*LLongToStringExEx			)(LLONG l, String *dst);
	LONG						(String::*LexComparePart)(const String &Str, LONG cnt, LONG pos) const;
};

struct C4D_Bitmap
{
	BaseBitmap*			(*Alloc								)(void);
	void						(*Free								)(BaseBitmap *bm);
	BaseBitmap*			(*GetClone						)(const BaseBitmap *src);
	LONG						(*GetBw								)(const BaseBitmap *bm);
	LONG						(*GetBh								)(const BaseBitmap *bm);
	LONG						(*GetBt								)(const BaseBitmap *bm);
	LONG						(*GetBpz							)(const BaseBitmap *bm);
	LONG						(*Init1Ex							)(BaseBitmap *bm, LONG x, LONG y, LONG depth);
	LONG					  (*Init2								)(BaseBitmap *bm, const Filename *name, LONG frame, Bool *ismovie);
	void					  (*FlushAll						)(BaseBitmap *bm);
	LONG				    (*Save								)(const BaseBitmap *bm, const Filename *name, LONG format, const BaseContainer *data, LONG savebits);
	void						(*GetLine							)(const BaseBitmap *bm, LONG y, void *data);
	void						(*SetLine							)(BaseBitmap *bm, LONG y, void *data, LONG depth);
	void						(*GetAlphaLineEx			)(const BaseBitmap *bm, LONG y, void *data, AlphaBitmap *channel);
	void						(*SetAlphaLineEx			)(BaseBitmap *bm, LONG y, void *data, AlphaBitmap *channel);
	void						(*SetCMAP							)(BaseBitmap *bm, LONG i, LONG r, LONG g, LONG b);
	void						(*ScaleIt							)(const BaseBitmap *src, BaseBitmap *dst, LONG intens, Bool sample, Bool nprop);
	void						(*SetPen							)(BaseBitmap *bm, LONG r, LONG g, LONG b);
	void						(*Clear								)(BaseBitmap *bm, LONG x1, LONG y1, LONG x2, LONG y2, LONG r, LONG g, LONG b);
	void						(*Line								)(BaseBitmap *bm, LONG x1, LONG y1, LONG x2, LONG y2);
	void						(*SetPixelEx					)(BaseBitmap *bm, LONG x, LONG y, LONG r, LONG g, LONG b);
	void						(*GetPixel						)(const BaseBitmap *bm, LONG x, LONG y, UWORD *r, UWORD *g, UWORD *b);
	AlphaBitmap *		(*AddChannel					)(BaseBitmap *bm, Bool internal, Bool straight);
	void						(*RemoveChannel				)(BaseBitmap *bm, AlphaBitmap *channel);
	void						(*GetAlphaPixel				)(const BaseBitmap *bm, AlphaBitmap *channel, LONG x, LONG y, UWORD *val);
	void						(*SetAlphaPixelEx			)(BaseBitmap *bm, AlphaBitmap *channel, LONG x, LONG y, LONG val);
	LONG						(*SaveChannelEx				)(BaseBitmap *bm, AlphaBitmap *channel, const Filename *name);
	AlphaBitmap *		(*GetInternalChannel	)(BaseBitmap *bm);
	LONG						(*GetChannelCount			)(const BaseBitmap *bm);
	AlphaBitmap *		(*GetChannelNum				)(BaseBitmap *bm, LONG num);
	BaseBitmap*			(*GetClonePart				)(const BaseBitmap *src, LONG x, LONG y, LONG w, LONG h);
	void						(*SetPixelCntEx				)(BaseBitmap *bm, LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc);
	void						(*GetPixelCntEx				)(const BaseBitmap *bm, LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc);
	Bool						(*CopyTo							)(const BaseBitmap *src, BaseBitmap *dst);
	void						(*ScaleBicubic				)(const BaseBitmap *src, BaseBitmap *dest, LONG src_xmin, LONG src_ymin, LONG src_xmax, LONG src_ymax, LONG dst_xmin, LONG dst_ymin, LONG dst_xmax, LONG dst_ymax);
	BaseBitmap*			(*GetAlphaBitmap			)(const BaseBitmap *bm, AlphaBitmap *channel);

	Bool						(*IsMultipassBitmap		)(const BaseBitmap *bm);

	MultipassBitmap*(*MPB_AllocWrapperPB	)(LONG bx, LONG by, LONG mode);
	MultipassBitmap*(*MPB_AllocWrapper    )(BaseBitmap *bmp);
	PaintBitmap*		(*MPB_GetPaintBitmap	)(MultipassBitmap *mp);
	LONG						(*MPB_GetLayerCount		)(const MultipassBitmap *mp);
	LONG						(*MPB_GetAlphaLayerCount)(const MultipassBitmap *mp);
	LONG						(*MPB_GetHiddenLayerCount)(const MultipassBitmap *mp);
	MultipassBitmap*(*MPB_GetLayerNum			)(MultipassBitmap *mp,LONG num);
	MultipassBitmap*(*MPB_GetAlphaLayerNum)(MultipassBitmap *mp,LONG num);
	MultipassBitmap*(*MPB_GetHiddenLayerNum)(MultipassBitmap *mp,LONG num);
	MultipassBitmap*(*MPB_AddLayer				)(MultipassBitmap *mp,MultipassBitmap *insertafter,LONG colormode,Bool hidden);
	MultipassBitmap*(*MPB_AddFolder				)(MultipassBitmap *mp,MultipassBitmap *insertafter,Bool hidden);
	MultipassBitmap*(*MPB_AddAlpha				)(MultipassBitmap *mp,MultipassBitmap *insertafter,LONG colormode);
	Bool						(*MPB_DeleteLayer			)(MultipassBitmap *mp,MultipassBitmap *layer);
	MultipassBitmap*(*MPB_FindUserID			)(MultipassBitmap *mp,LONG id,LONG subid);
	void						(*MPB_ClearImageData	)(MultipassBitmap *mp);
	void						(*MPB_SetMasterAlpha	)(MultipassBitmap *mp, BaseBitmap *master);
	GeData					(*MPB_GetParameter		)(const MultipassBitmap *mp, LONG id);
	Bool						(*MPB_SetParameter		)(MultipassBitmap *mp, LONG id,const GeData &par);
	Bool						(*MPB_SetPixelCntEx		)(MultipassBitmap *bm, LONG x,LONG y,LONG num,void *src,LONG incsrc,LONG srcmode,Bool dithering);
	Bool						(*MPB_GetPixelCntEx		)(const MultipassBitmap *bm, LONG x,LONG y,LONG num,void *dst,LONG incdst,LONG dstmode,Bool dithering);

	ULONG						(*GetDirty						)(const BaseBitmap *bm);

	void						(*SetPixelCntEx2			)(BaseBitmap *bm, LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc, LONG srcmode, LONG flags);
	void						(*GetPixelCnt					)(const BaseBitmap *bm, LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc, LONG dstmode, LONG flags);
	GeData					(*GetBaseBitmapData		)(const BaseBitmap *bm, LONG id, const GeData &t_default);
	Bool						(*SetBaseBitmapData		)(BaseBitmap *bm, LONG id, const GeData &data);

	void						(*SetDirty						)(BaseBitmap *bm);
	Bool						(*CopyPartTo					)(const BaseBitmap *src, BaseBitmap *dst, LONG x, LONG y, LONG w, LONG h);
	
	BaseBitmapLink *(*BBL_Alloc						)(void);	
	void						(*BBL_Free						)(BaseBitmapLink *link);
	BaseBitmap		 *(*BBL_Get							)(BaseBitmapLink *link);
	void						(*BBL_Set							)(BaseBitmapLink *link, BaseBitmap *bmp);

	VLONG           (*GetMemoryInfo  			)(const BaseBitmap *bmp);
	MultipassBitmap*(*MPB_Alloc						)(const Filename &name);
	LONG						(*MPB_GetEnabledLayerCount)(const MultipassBitmap *mp);
	Bool						(*MPB_GetLayers				)(MultipassBitmap *mp, LONG flags, BaseBitmap **&list, LONG &count);
	UCHAR*					(*GetDrawPortBits			)(BaseBitmap *bm);
	Bool						(*GetUpdateRegions		)(const BaseBitmap *mp, BaseContainer &regions);
	LONG						(*Init1								)(BaseBitmap *bm, LONG x, LONG y, LONG depth, LONG flags);
	Bool						(*AddUpdateRegion			)(BaseBitmap *bm, LONG id, LONG type, LONG xmin, LONG xmax, LONG ymin, LONG ymax);
	Bool						(*RemoveUpdateRegion	)(BaseBitmap *bm, LONG id);
	BaseBitmap		 *(*GetUpdateRegionBitmap)(BaseBitmap *bm);
	LONG					  (*Init3								)(BaseBitmap *&bm, const Filename &name, LONG frame, Bool *ismovie, BitmapLoaderPlugin **loaderplugin);
	MultipassBitmap*(*MPB_GetSelectedLayer)(MultipassBitmap *mp);
	Bool						(*SetPixelCnt					)(BaseBitmap *bm, LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc, LONG srcmode, LONG flags);
	Bool						(*SetPixel						)(BaseBitmap *bm, LONG x, LONG y, LONG r, LONG g, LONG b);
	Bool						(*SetAlphaPixel				)(BaseBitmap *bm, AlphaBitmap *channel, LONG x, LONG y, LONG val);
	void						(*MPB_FreeHiddenLayers)(MultipassBitmap *mp);
};

struct C4D_MovieSaver
{
	MovieSaver*			(*Alloc								)(void);
	void						(*Free								)(MovieSaver *ms);
	LONG						(*OpenEx							)(MovieSaver *ms, const Filename *name, BaseBitmap *bm, LONG fps, LONG id, const BaseContainer *data, LONG savebits);
	LONG						(*Write								)(MovieSaver *ms, BaseBitmap *bm);
	void						(*Close								)(MovieSaver *ms);
	Bool						(*Choose							)(MovieSaver *ms, LONG id, BaseContainer *bc);
	LONG						(*Open								)(MovieSaver *ms, const Filename *name, BaseBitmap *bm, LONG fps, LONG id, const BaseContainer *data, LONG savebits,BaseSound *sound);
};

struct C4D_BaseChannel
{
	// channels
	BaseChannel*		(*Alloc								)(void);
	BaseChannel*		(*GetCloneExx 				)(BaseChannel *bc);
	void						(*Free								)(BaseChannel *bc);
	Bool						(*Compare							)(BaseChannel *bc1,BaseChannel *bc2);
	LONG						(*InitTexture					)(BaseChannel *bc, InitRenderStruct *irs);
	void						(*FreeTexture					)(BaseChannel *bc);
	Vector					(*BcSample						)(BaseChannel *bc, VolumeData *vd, Vector *p, Vector *delta, Vector *n, Real t, LONG tflag, Real off, Real scale);
	BaseBitmap*			(*BCGetBitmap					)(BaseChannel *bc);
	void						(*GetData							)(BaseChannel *bc, BaseContainer *ct);
	void						(*SetData							)(BaseChannel *bc, const BaseContainer *ct);
	Bool						(*ReadData						)(HyperFile *hf, BaseChannel *bc);
	Bool						(*WriteData						)(HyperFile *hf, BaseChannel *bc);

	_TextureGroup*	(*DlgAlloc						)(BaseChannel *bc, CDialog *cd, CUserArea *cupreview, LONG idimage, LONG idname, LONG idbluroff, LONG idblurstr, LONG idint, LONG idinfo, LONG idpreview, LONG idedit, LONG idpopup);
	void						(*DlgFree							)(_TextureGroup *tg);
	Bool						(*DlgMessage					)(_TextureGroup *th, const BaseContainer *msg, Bool preview);

	Bool						(*MessageExx          )(BaseChannel *bc, LONG id, void *data);
	void*						(*GetPluginDataExx		)(BaseChannel *bc);
	LONG						(*GetPluginID					)(BaseChannel *bc);

	CHANNELSHADER*	(*GetShaderExx				)(BaseChannel *bc);
	PluginShader*		(*GetPluginShader			)(BaseChannel *bc);

	Bool						(*Attach							)(BaseChannel *bc, GeListNode *element);

	Bool						(*HandleShaderPopup		 )(const BaseContainer &bc, const DescID &descid, LONG value, VLONG param);
	Bool						(*HandleShaderPopupI	 )(BaseList2D *parent, PluginShader *&current, LONG value, VLONG param);
	Bool						(*BuildShaderPopupMenu )(BaseContainer *menu, const BaseContainer &bc, const DescID &descid, VLONG param);
	Bool						(*BuildShaderPopupMenuI)(BaseContainer *menu, BaseList2D *parent, PluginShader *current, VLONG param);

	void						(*HandleShaderMessage )(GeListNode *node, PluginShader *ps, LONG type, void *data);
	Bool            (*ReadDataConvert     )(GeListNode *node, LONG id, HyperFile *hf);

	LONG						(PluginShader::*InitRender		)(InitRenderStruct *irs);
	void						(PluginShader::*FreeRender		)(void);
	Vector					(PluginShader::*Sample				)(ChannelData *vd);
	Vector					(PluginShader::*SampleBump		)(ChannelData *vd, LONG bumpflags);
	BaseBitmap*			(PluginShader::*GetBitmap			)(void);
	LONG						(PluginShader::*GetRenderInfo	)(void);

	PluginShader*		(*PsAlloc											)(LONG type);
	Bool						(PluginShader::*PsCompare			)(PluginShader* dst);

	String					(*GetChannelName							)(LONG channelid);
	LONG						(PluginShader::*GlMessage			)(LONG type, void *data);
};

struct C4D_Filename
{
	// safety value
	Filename				*Default;

	Filename*				(*Alloc								)(void);
	Filename*				(*GetClone						)(const Filename *fn);
	void						(*Free								)(Filename *fn);
	Bool						(*FileSelect					)(Filename *fn,LONG type, LONG flags, const String *title);
	Bool						(*Content							)(const Filename *fn);
	String*					(*GetString						)(const Filename *fn);
	void						(*SetString						)(Filename *fn, const String *str);
	Filename*				(*GetDirectory				)(const Filename *fn);
	Filename*				(*GetFile							)(const Filename *fn);
	void						(*ClearSuffix					)(Filename *fn);
	void						(*SetSuffix						)(Filename *fn, const String *str);
	Bool						(*CheckSuffix					)(const Filename *fn, const String *str);
	void						(*SetDirectory				)(Filename *fn, const Filename *str);
	void						(*SetFile							)(Filename *fn, const Filename *str);
	Bool						(*Compare							)(const Filename *fn1, const Filename *fn2);
	void						(*Add									)(Filename *dst, const Filename *src);

	void						(*Init								)(Filename *fn);
	void						(*Flush								)(Filename *fn);
	void						(*CopyTo							)(const Filename *src, Filename *dst);
	void						(*SetMemoryReadMode		)(Filename *fn, void *adr, VLONG size);
	void						(*SetMemoryWriteMode	)(Filename *fn, MemoryFileStruct *mfs);

	MemoryFileStruct* (*MemoryFileStructAlloc)();
	void						(*MemoryFileStructFree)(MemoryFileStruct *&mfs);
	void						(*MemoryFileStructGetData)(MemoryFileStruct *mfs, void *&data, VLONG &size, Bool release);
	void						(*SetCString					)(Filename *fn, const CHAR *str);
	void						(*ClearSuffixComplete	)(Filename *fn);
};

struct C4D_BrowseFiles
{
	BrowseFiles*		(*Alloc								)(const Filename *dir, LONG flags);
	void						(*Free								)(BrowseFiles *bf);
	Bool						(*GetNext							)(BrowseFiles *bf);
	VLONG						(*GetSize							)(BrowseFiles *bf);
	Bool						(*IsDir								)(BrowseFiles *bf);
	Filename*				(*GetFilename					)(BrowseFiles *bf);
	void						(*Init								)(BrowseFiles *bf, const Filename *dir, LONG flags);

	BrowseVolumes*	(*BvAlloc							)(void);
	void						(*BvFree							)(BrowseVolumes *bv);

	Bool						(*GeGetFileTime				)(const Filename &name, LONG mode, LocalFileTime *out);
	void						(*GeGetCurrentTime		)(LocalFileTime *out);

	Bool						(BrowseFiles::*IsHidden				)(void);
	Bool						(BrowseFiles::*IsBundle				)(void);
	void						(BrowseFiles::*GetFileTime		)(LONG mode, LocalFileTime *out);

	void						(BrowseVolumes::*BvInit				)(void);
	Bool						(BrowseVolumes::*BvGetNext		)(void);
	Filename				(BrowseVolumes::*BvGetFilename)(void);

	Bool						(BrowseFiles::*IsReadOnly			)(void);
	String					(BrowseVolumes::*BvGetVolumeName)( LONG *out_flags );
	Bool						(*GeSetFileTime				)(const Filename &name, LONG mode, const LocalFileTime *in);
};

struct C4D_File
{
	BaseFile*				(*Alloc								)(void);
	void						(*Free								)(BaseFile *fl);
	Bool						(*Open								)(BaseFile *fl, const Filename *name, LONG mode, LONG error_dialog, LONG order, LONG type, LONG creator);
	Bool						(*Close								)(BaseFile *fl);
	void						(*SetOrder						)(BaseFile *fl, LONG order);
	VLONG						(*ReadBytes						)(BaseFile *fl, void *data, VLONG len, Bool just_try_it);
	VLONG						(*WriteBytes					)(BaseFile *fl, const void *data, VLONG len);
	Bool						(*Seek								)(BaseFile *fl, VLONG pos, LONG mode);
	VLONG						(*GetPosition					)(BaseFile *fl);
	VLONG						(*GetLength						)(BaseFile *fl);
	LONG						(*GetError						)(BaseFile *fl);
	void						(*SetError						)(BaseFile *fl, LONG error);
	Bool						(*WriteChar						)(BaseFile *fl, CHAR  v);
	Bool						(*WriteUChar					)(BaseFile *fl, UCHAR v);
	Bool						(*WriteWord						)(BaseFile *fl, SWORD  v);
	Bool						(*WriteUWord					)(BaseFile *fl, UWORD v);
	Bool						(*WriteLong						)(BaseFile *fl, LONG  v);
	Bool						(*WriteULong					)(BaseFile *fl, ULONG v);
	Bool						(*WriteReal						)(BaseFile *fl, Real  v);
	Bool						(*WriteLReal					)(BaseFile *fl, LReal v);
	Bool						(*ReadChar						)(BaseFile *fl, CHAR  *v);
	Bool						(*ReadUChar						)(BaseFile *fl, UCHAR *v);
	Bool						(*ReadWord						)(BaseFile *fl, SWORD  *v);
	Bool						(*ReadUWord						)(BaseFile *fl, UWORD *v);
	Bool						(*ReadLong						)(BaseFile *fl, LONG  *v);
	Bool						(*ReadULong						)(BaseFile *fl, ULONG *v);
	Bool						(*ReadReal						)(BaseFile *fl, Real  *v);
	Bool						(*ReadLReal						)(BaseFile *fl, LReal *v);
	Bool						(*ReadLLong						)(BaseFile *fl, LLONG *v);
	Bool						(*WriteLLong					)(BaseFile *fl, LLONG v);

	AESFile*				(*AESAlloc						)(void);
	Bool						(*AESOpen							)(AESFile *fl, const Filename *name, const char* key, LONG keylen, LONG blocksize, ULONG aes_flags, LONG mode, LONG error_dialog, LONG order, LONG type, LONG creator);
	Bool						(*AESCheckEncryption	)(const Filename& encrypt, const Filename& decrypt, const char* key, LONG keylen, LONG blocksize);
};

struct C4D_Dialog
{
	CDialog*				(*Alloc									)(CDialogMessage *dlgfunc,void *userdata);
	void						(*Free									)(CDialog *cd);
	void*						(*GetUserData						)(CDialog *cd);
	CUserArea*			(*AttachUserAreaEx			)(CDialog *cd, LONG id,void *userdata);
	Bool						(*OpenEx								)(CDialog *cd, Bool async, CDialog *parent, LONG xpos, LONG ypos);
	Bool						(*Close									)(CDialog *cd);
	Bool						(*SendUserAreaMessageEx	)(CDialog *cd, LONG id, BaseContainer *msg,void *gadptr);
	Bool						(*Enable								)(CDialog *cd, LONG id, Bool enabled,void *gadptr);
	void						(*SetTimer							)(CDialog *cd, LONG timer);
	Bool						(*SetLong								)(CDialog *cd, LONG id, LONG value,LONG min,LONG max,LONG step,void *gadptr);
	Bool						(*SetReal								)(CDialog *cd, LONG id, Real value,Real min,Real max,Real step,LONG format,void *gadptr);
	Bool						(*SetVector							)(CDialog *cd, LONG id, const Vector &value,void *gadptr);
	Bool						(*SetString							)(CDialog *cd, LONG id, const String *text,void *gadptr);
	Bool						(*SetColorField					)(CDialog *cd, LONG id, const Vector &color, Real brightness,Real maxbrightness,LONG flags,void *gadptr);
	Bool						(*GetLong								)(CDialog *cd, LONG id, LONG &value,void *gadptr);
	Bool						(*GetReal								)(CDialog *cd, LONG id, Real &value,void *gadptr);
	Bool						(*GetVector							)(CDialog *cd, LONG id, Vector &value,void *gadptr);
	Bool						(*GetString							)(CDialog *cd, LONG id, String *&text,void *gadptr);
	Bool						(*GetColorField					)(CDialog *cd, LONG id, Vector &color, Real &brightness,void *gadptr);
	Bool						(*AddGadgetEx						)(CDialog *cd, LONG type, LONG id, const String *name,LONG par1,LONG par2, LONG par3, LONG par4);
	Bool						(*LoadDialogResource		)(CDialog *cd, LONG id, LocalResource *lr, LONG flags);
	Bool						(*TabGroupBegin					)(CDialog *cd, LONG id, LONG flags,LONG tabtype);
	Bool						(*GroupBegin						)(CDialog *cd, LONG id, LONG flags,LONG cols,LONG rows,const String *title,LONG groupflags);
	Bool						(*GroupSpace						)(CDialog *cd, LONG spacex,LONG spacey);
	Bool						(*GroupBorder						)(CDialog *cd, ULONG borderstyle);
	Bool						(*GroupBorderSize				)(CDialog *cd, LONG left, LONG top,LONG right,LONG bottom);
	Bool						(*GroupEnd							)(CDialog *cd);
	Bool						(*SetPopup							)(CDialog *cd, LONG id, const BaseContainer *bc,void *gadptr);
	Bool						(*Screen2Local					)(CDialog *cd, LONG *x, LONG *y);
	Bool						(*SetVisibleArea				)(CDialog *cd, LONG scrollgroupid, LONG x1, LONG y1,LONG x2,LONG y2);
	Bool						(*GetItemDim						)(CDialog *cd, LONG id, LONG *x, LONG *y, LONG *w, LONG *h,void *gadptr);
	Bool						(*ScrollGroupBeginEx		)(CDialog *cd, LONG id, LONG flags,LONG scrollflags);
	Bool						(*SendRedrawThread			)(CDialog *cd, LONG id);
	Bool            (*GetVisibleArea				)(CDialog *cd, LONG id, LONG *x1,LONG *y1,LONG *x2,LONG *y2);
	Bool						(*RestoreLayout					)(CDialog *cd, void *secret);
	Bool						(*SetMessageResult			)(CDialog *cd, const BaseContainer *result);
	Bool            (*GetDragObjectEx				)(CDialog *cd, const BaseContainer *msg,LONG *type,void **object);

	Bool            (*SetDragDestination		)(CDialog *cd, LONG cursor);
	Bool						(*AttachSubDialog				)(CDialog *parentcd,LONG id,CDialog *cd);
	LONG						(*GetID									)(CDialog *cu);
	void*						(*FindCustomGui					)(CDialog *cd,LONG id);
	Bool						(*AddGadget							)(CDialog *cd, LONG type, LONG id, const String *name,LONG par1,LONG par2, LONG par3, LONG par4,const BaseContainer *customdata,void **resptr);
	Bool						(*ReleaseLink						)(CDialog *cd);
	Bool						(*SendParentMessage			)(CDialog *cd,const BaseContainer *msg);
	Bool						(*Open									)(CDialog *cd, Bool async, CDialog *parent, LONG xpos, LONG ypos,LONG defaultw,LONG defaulth);
	CUserArea*			(*AttachUserArea				)(CDialog *cd, LONG id,void *userdata,LONG userareaflags,void *gadptr);
	Bool            (*GetDragObject					)(CDialog *cd, const BaseContainer *msg,LONG *type,void **object);

	LassoSelection*	(*LSAlloc								)(void);
	void						(*LSFree								)(LassoSelection *ls);
	LONG						(*LSGetMode							)(LassoSelection *ls);
	Bool						(*LSTest								)(LassoSelection *ls, LONG x, LONG y);
	Bool						(*LSCheckSingleClick		)(LassoSelection *ls);
	Bool						(*LSStart								)(LassoSelection *ls, CBaseFrame *cd, LONG mode, LONG start_x, LONG start_y, LONG start_button,LONG sx1, LONG sy1, LONG sx2, LONG sy2);
	Bool						(*LSTestPolygon					)(LassoSelection *ls, const Vector &pa, const Vector &pb, const Vector &pc, const Vector &pd);

	CBaseFrame*			(*CBF_FindBaseFrame			)(CDialog *cd,LONG id);
	Bool						(*CBF_SetDragDestination)(CBaseFrame *cbf,LONG cursor);
	void*						(*CBF_GetWindowHandle		)(CBaseFrame *cbf);
	GeData					(*SendUserAreaMessage		)(CDialog *cd, LONG id, BaseContainer *msg,void *gadptr);
	Bool						(*LSGetRectangle				)(LassoSelection *ls,Real &x1, Real &y1, Real &x2, Real &y2);
	Bool						(*CBF_GetColorRGB				)(CBaseFrame *cbf,LONG colorid, LONG &r, LONG &g, LONG &b);
	Bool						(*RemoveLastCursorInfo	)(LASTCURSORINFOFUNC func);
	String					(*Shortcut2String				)(LONG shortqual,LONG shortkey);

	Bool						(*GetIconCoordInfo			)(LONG &id, const CHAR* ident);
	Bool						(*GetInterfaceIcon			)(LONG type, LONG id_x, LONG id_y, LONG id_w, LONG id_h, IconData &d);
};

struct C4D_UserArea
{
	void						(*Free                )(CUserArea* cu);
	void*						(*GetUserData         )(CUserArea *cu);
	LONG						(*GetWidth            )(CUserArea *cu);
	LONG						(*GetHeight           )(CUserArea *cu);
	LONG						(*GetID               )(CUserArea *cu);
	void						(*SetMinSize          )(CUserArea *cu, LONG w,LONG h);
	void						(*DrawLine            )(CUserArea *cu, LONG x1,LONG y1,LONG x2,LONG y2);
	void						(*DrawRectangle       )(CUserArea *cu, LONG x1,LONG y1,LONG x2,LONG y2);
	void						(*DrawSetPenV         )(CUserArea *cu, const Vector &color);
	void						(*DrawSetPenI         )(CUserArea *cu, LONG id);
	void						(*SetTimer            )(CUserArea *cu, LONG timer);
	Bool						(*GetInputState       )(CBaseFrame *cu, LONG askdevice,LONG askchannel,BaseContainer *res);
	Bool						(*GetInputEvent       )(CBaseFrame *cu, LONG askdevice,BaseContainer *res);
	void						(*KillEvents          )(CBaseFrame *cu);
	void						(*DrawSetFont         )(CUserArea *cu, LONG fontid);
	LONG						(*DrawGetTextWidth    )(CUserArea *cu, const String *text);
	LONG						(*DrawGetFontHeight   )(CUserArea *cu);
	void						(*DrawSetTextColII    )(CUserArea *cu, LONG fg,LONG bg);
	void						(*DrawSetTextColVI    )(CUserArea *cu, const Vector &fg,LONG bg);
	void						(*DrawSetTextColIV    )(CUserArea *cu, LONG fg,const Vector &bg);
	void						(*DrawSetTextColVV    )(CUserArea *cu, const Vector &fg,const Vector &bg);
	void						(*DrawTextEx          )(CUserArea *cu, const String *txt,LONG x,LONG y);
	void						(*DrawBitmap          )(CUserArea *cu, BaseBitmap *bmp,LONG wx,LONG wy,LONG ww,LONG wh,LONG x,LONG y,LONG w,LONG h,LONG mode);
	void						(*SetClippingRegion   )(CUserArea *cu, LONG x,LONG y,LONG w,LONG h);
	void						(*ScrollArea          )(CUserArea *cu, LONG xdiff,LONG ydiff,LONG x,LONG y,LONG w,LONG h);
	void						(*ClearClippingRegion )(CUserArea *cu);
	Bool						(*OffScreenOn         )(CUserArea *cu);

	Bool						(*Global2Local        )(CBaseFrame *cu, LONG *x,LONG *y);
	Bool						(*SendParentMessage   )(CUserArea *cu, const BaseContainer *msg);

	Bool						(*Screen2Local        )(CBaseFrame *cu, LONG *x, LONG *y);
	Bool            (*SetDragDestination  )(CUserArea *cu, LONG cursor);
	Bool            (*HandleMouseDrag     )(CUserArea *cu, const BaseContainer *msg,LONG type,void *data,LONG dragflags);
	Bool						(*IsEnabled           )(CUserArea *cu);

	void						(*GetBorderSize       )(CUserArea *cu,LONG type,LONG *l,LONG *t,LONG *r,LONG *b);
	void            (*DrawBorder          )(CUserArea *cu,LONG type,LONG x1,LONG y1,LONG x2,LONG y2);

	_GeListView*		(*GeListView_Alloc            )(void);
	void						(*GeListView_Free             )(_GeListView *lv);
	Bool            (*GeListView_Attach           )(_GeListView *lv,CDialog *cd,LONG id,ListViewCallBack *callback,void *userdata);
	void            (*GeListView_LvSuperCall      )(_GeListView *lv,LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col);
	void            (*GeListView_Redraw           )(_GeListView *lv);
	void            (*GeListView_DataChanged      )(_GeListView *lv);
	Bool            (*GeListView_ExtractMouseInfo )(_GeListView *lv,void *secret,MouseDownInfo &info,LONG size);
	Bool            (*GeListView_ExtractDrawInfo  )(_GeListView *lv,void *secret,DrawInfo &info,LONG size);
	Bool            (*GeListView_SendParentMessage)(_GeListView *lv,const BaseContainer *msg);
	LONG						(*GeListView_GetId            )(_GeListView *lv);

	_SimpleListView* (*SimpleListView_Alloc       )(void);
	void            (*SimpleListView_Free         )(_SimpleListView *lv);
	Bool            (*SimpleListView_SetLayout    )(_SimpleListView *lv,LONG columns,const BaseContainer &data);
	Bool            (*SimpleListView_SetItem      )(_SimpleListView *lv,LONG id,const BaseContainer &data);
	Bool            (*SimpleListView_GetItem      )(_SimpleListView *lv,LONG id,BaseContainer *data);
	LONG            (*SimpleListView_GetItemCount )(_SimpleListView *lv);
	Bool            (*SimpleListView_GetItemLine  )(_SimpleListView *lv,LONG num,LONG *id,BaseContainer *data);
	Bool            (*SimpleListView_RemoveItem   )(_SimpleListView *lv,LONG id);
	LONG            (*SimpleListView_GetSelection )(_SimpleListView *lv,BaseSelect *selection);
	Bool            (*SimpleListView_SetSelection )(_SimpleListView *lv,BaseSelect *selection);

	LONG            (*SimpleListView_GetProperty  )(_SimpleListView *lv,LONG id);
	Bool            (*SimpleListView_SetProperty  )(_SimpleListView *lv,LONG id,LONG val);

	Bool						(*IsHotkeyDown                )(CUserArea *cu, LONG id);
	Bool						(*HasFocus										)(CUserArea *cu);

	void						(*MouseDragStart							)(CUserArea *cu,LONG Button,Real mx,Real my,LONG flag);
	LONG						(*MouseDrag										)(CUserArea *cu,Real *mx,Real *my,BaseContainer *channels);
	LONG						(*MouseDragEnd								)(CUserArea *cu);
	LONG						(*DrawGetTextWidth_ListNodeName)(CUserArea *cu,BaseList2D *node, LONG fontid);
	Bool						(*OffScreenOnRect							)(CUserArea *cu, LONG x, LONG y, LONG w, LONG h);
	void						(*DrawText										)(CUserArea *cu, const String &txt,LONG x,LONG y,LONG flags);
};

struct C4D_Parser
{
	Parser*					(*Alloc								)(void);
	void						(*Free								)(Parser *pr);
	Bool						(*AddVarEx						)(Parser *pr, const String *str, Real *value);
	Bool						(*Eval								)(Parser *pr, const String *str, LONG *error,Real *res,LONG unit,LONG angletype,LONG basis);
	Bool						(*AddVarLongEx				)(Parser *pr, const String *str, LONG *value);
	Bool						(*EvalLong						)(Parser *pr, const String *str, LONG *error,LONG *res,LONG unit,LONG basis);
	Bool						(*AddVar							)(Parser *pr, const String *str, Real *value, Bool case_sensitive);
	Bool						(*AddVarLong					)(Parser *pr, const String *str, LONG *value, Bool case_sensitive);
	Bool						(*RemoveVar						)(Parser *pr, const String *s, Bool case_sensitive);
	Bool						(*RemoveAllVars				)(Parser *pr);
	void						(*GetParserData				)(Parser *pr, ParserCache *p);
	Bool						(*Init								)(Parser *pr, const String *s, LONG *error, LONG unit, LONG angle_unit, LONG base);
	Bool						(*ReEval							)(Parser *pr, Real *result, LONG *error);
	Bool						(*Calculate						)(Parser *pr, const ParserCache *pdat, Real *result, LONG *error);
	Bool						(*ReEvalLong					)(Parser *pr, LONG *result, LONG *error);
	Bool						(*CalculateLong				)(Parser *pr, const ParserCache *pdat, LONG *result, LONG *error);
	Bool						(*Reset								)(Parser *pr, ParserCache *p);
	ParserCache*		(*AllocPCache					)(void);
	void						(*FreePCache					)(ParserCache *p);
	Bool						(*CopyPCache					)(ParserCache *p, ParserCache *d);
};

struct C4D_Resource
{
	LocalResource*	(*Alloc								)(const Filename *path);
	void						(*Free                )(LocalResource *lr);
	String*					(*LoadStringEx        )(LocalResource *lr,LONG id);
	LocalResource*  (*GetCinemaResource   )(void);
	const String&		(*LoadString          )(LocalResource *lr,LONG id);

	BaseContainer*	(*GetMenuResource			)(const String &menuname);
	void						(*UpdateMenus					)(void);
	Bool						(*ReloadResource			)(LocalResource *lr,const Filename *path);
};

struct C4D_Atom
{
	C4DAtom*				(C4DAtom::*GetClone							)(LONG flags, AliasTrans *trn);
	Bool						(C4DAtom::*CopyTo								)(C4DAtom *dst, LONG flags, AliasTrans *trn);
	LONG						(C4DAtom::*GetType							)(void) const;
	Bool						(C4DAtom::*IsInstanceOf					)(LONG id) const;
	Bool						(C4DAtom::*Message							)(LONG type, void *data);
	Bool						(C4DAtom::*MultiMessage					)(LONG flags, LONG type, void *data);
	Bool            (C4DAtom::*GetDescription				)(Description &res,LONG flags);
	Bool            (C4DAtom::*GetParameter					)(const DescID &id,GeData &t_data,LONG flags);
	Bool            (C4DAtom::*SetParameter					)(const DescID &id,const GeData &t_data,LONG flags);
	DynamicDescription*		(C4DAtom::*GetDynamicDescription)();

	GeListNode*			(GeListNode::*GetNext					)(void) const;
	GeListNode*			(GeListNode::*GetPred					)(void) const;
	GeListNode*			(GeListNode::*GetUp						)(void) const;
	GeListNode*			(GeListNode::*GetDown					)(void) const;
	GeListNode*			(GeListNode::*GetDownLast			)(void) const;
	void						(GeListNode::*InsertBefore		)(GeListNode *bl);
	void						(GeListNode::*InsertAfter			)(GeListNode *bl);
	void						(GeListNode::*InsertUnder			)(GeListNode *bl);
	void						(GeListNode::*InsertUnderLast	)(GeListNode *bl);
	void						(GeListNode::*Remove					)(void);
	GeListHead*			(GeListNode::*GetListHead			)(void);
	BaseDocument*		(GeListNode::*GetDocument			)(void) const;

	GeListNode*			(GeListHead::*GetFirst				)(void) const;
	GeListNode*			(GeListHead::*GetLast					)(void) const;
	void						(GeListHead::*FlushAll				)(void);
	void						(GeListHead::*InsertFirst			)(GeListNode *bn);
	void						(GeListHead::*InsertLast			)(GeListNode *bn);
	void						(GeListHead::*SetParent				)(GeListNode *parent);
	GeListNode*			(GeListHead::*GetParent				)(void) const;

	BaseList2D*			(BaseList2D::*GetMain					)(void) const;
	const String&   (BaseList2D::*GetName					)(void) const;
	void						(BaseList2D::*SetName					)(const String &str);
	Bool						(BaseList2D::*TransferGoalEx	)(BaseList2D *dst);
	Bool						(BaseList2D::*SetAnimatedParameterEx)(const DescID &id,const GeData &t_data1,const GeData &t_data2,Real mix,LONG flags);
	Bool						(BaseList2D::*GetAnimatedParameter)(const DescID &id,GeData &t_data1,GeData &t_data2,Real &mix,LONG flags);

	// AtomArray
	AtomArray*			(*AtomArrayAlloc							)();
	void						(*AtomArrayFree								)(AtomArray *&obj);
	LONG						(AtomArray::*GetCount					)() const;
	C4DAtom *				(AtomArray::*GetIndex					)(LONG idx) const;
	Bool						(AtomArray::*Append						)(C4DAtom *obj);
	void						(AtomArray::*Flush						)();
	Bool						(AtomArray::*AACopyTo					)(AtomArray *dest) const;

	LONG						(AtomArray::*AAGetUserID			)() const;
	void						(AtomArray::*AASetUserID			)(LONG t_userid);

	void*						(AtomArray::*AAGetUserData		)() const;
	void						(AtomArray::*AASetUserData		)(void *t_userdata);

	LONG						(GeListNode::*GetBranchInfoEx	)(BranchInfo *info, LONG max);

	C4DAtom*				(AtomArray::*AAGetPreferred		)() const;
	void						(AtomArray::*AASetPreferred		)(C4DAtom *t_preferred);

	PluginShader*		(BaseList2D::*GetFirstShader  )() const;
	void						(BaseList2D::*InsertShader    )(PluginShader *shader, PluginShader *pred);

	Bool						(BaseList2D::*SetAnimatedParameter)(const DescID &id,const GeData &t_data1,const GeData &t_data2,Real mix,LONG flags,CTrack *track);
	void            (AtomArray::*AAFilterObject   )(LONG type, LONG instance, Bool generators);
	Bool						(AtomArray::*AACopyToFilter	  )(AtomArray *dest, LONG type, LONG instance, Bool generators) const;
	Bool						(AtomArray::*AAAppendArr  	  )(AtomArray *src);
	void						(AtomArray::*AAFilterObjectChildren)();
	Bool						(AtomArray::*AARemove					)(C4DAtom *obj);

	Bool            (C4DAtom::*GetEnabling						)(const DescID &id,const GeData &t_data,LONG flags,const BaseContainer *itemdesc);
	LONG						(AtomArray::*AAGetCountTI			)(LONG type, LONG instance) const;

	Bool						(GeListNode::*IsDocumentRelated)(void) const;
	LONG						(AtomArray::*AAFind						)(C4DAtom *obj);
	Bool            (GeListNode::*GetNBit					)(LONG bit) const;
	Bool            (GeListNode::*ChangeNBit      )(LONG bit, LONG bitmode);
	LONG						(GeListNode::*GetBranchInfo   )(BranchInfo *info, LONG max, ULONG flags);
	LONG						(C4DAtom::*GetClassification	)(void) const;
	Bool						(BaseList2D::*TransferMarker	)(BaseList2D *dst) const;
	const GeMarker&	(BaseList2D::*GetMarker				)(void) const;
	void						(BaseList2D::*SetMarker				)(const GeMarker &m);
	GeMarker*				(*GeMarkerAlloc								)();
	void						(*GeMarkerFree								)(GeMarker *&obj);
	Bool						(GeMarker::*IsEqual						)(const GeMarker &m) const;
	Bool						(GeMarker::*Content						)() const;
	LONG						(C4DAtom::*GetRealType				)(void) const;
	LONG						(GeMarker::*Compare						)(const GeMarker &m) const;
	void						(GeMarker::*GeMarkerSet				)(const GeMarker &m);
	Bool						(GeMarker::*GeMarkerRead			)(HyperFile *hf);
	Bool						(GeMarker::*GeMarkerWrite			)(HyperFile *hf) const;
	Bool						(BaseList2D::*TransferGoal		)(BaseList2D *dst, Bool undolink);
	void						(GeMarker::*GeMarkerGetMemory )(void *&data, LONG &size) const;
	Bool						(BaseList2D::*AddUniqueID     )(LONG appid, const CHAR *const mem, LONG bytes);
	Bool						(BaseList2D::*FindUniqueID    )(LONG appid, const CHAR *&mem, LONG &bytes) const;
	LONG						(BaseList2D::*GetUniqueIDCount)() const;
	Bool						(BaseList2D::*GetUniqueIDIndex)(LONG idx, LONG &id, const CHAR *&mem, LONG &bytes) const;
};

typedef GeData CoffeeEditorCallback(BaseList2D *obj, const BaseContainer &msg);
#define COFFEEEDITOR_GETSTRING	'gets'
#define COFFEEEDITOR_SETSTRING	'sets'
#define COFFEEEDITOR_COMPILE		'comp'
	#define COFFEEEDITOR_GETERROR_RES			'resr'
	#define COFFEEEDITOR_GETERROR_STRING	'ress'
	#define COFFEEEDITOR_GETERROR_LINE		'resl'
	#define COFFEEEDITOR_GETERROR_POS			'resp'
#define COFFEEEDITOR_EXECUTE		'exec'

typedef void (*V_CODE)(Coffee*, VALUE*&, LONG);

struct C4D_Coffee
{
	Coffee*					(*GeCoffeeAlloc								)();
	void						(*GeCoffeeFree								)(Coffee* &cof);
	Bool						(*GeCoffeeCompileString				)(Coffee* cof, const String& src);
	Bool						(*GeCoffeeCompileFile					)(Coffee* cof, const Filename& file);
	VALUE*					(*GeCoffeeAddGlobalSymbol			)(Coffee* cof, const String& name);
	VALUE*					(*GeCoffeeFindGlobalSymbol		)(Coffee* cof, const String& name);
	Bool						(*GeCoffeeExecute							)(Coffee* cof, VALUE* func, GeData* retval, GeData* arg1, GeData* arg2, GeData* arg3);
	Bool						(*GeCoffeeGeData2Value				)(Coffee* cof, const GeData& src, VALUE* dest);
	Bool						(*GeCoffeeValue2GeData				)(Coffee* cof, VALUE *src, GeData* dest);
	Bool						(*GeCoffeeGetLastError				)(Coffee* cof, String *err_string, LONG *err_line, LONG *err_pos);
	Bool						(*CoffeeEditor_Open						)(BaseList2D *obj,CoffeeEditorCallback *callback);

	VALUE*					(*CoValGetObjMember						)(VALUE *val, LONG nr);
	VALUE*					(*CoValGetArrayMember					)(VALUE *val, LONG i);
	void						(*CoValSetArray								)(VALUE *val, ARRAY *a);
	OBJECT*					(*CoValGetObject							)(VALUE *val, LONG *err);
	void						(*CoValSetObject							)(VALUE *val, OBJECT *o);
	void						(*CoValSetString							)(VALUE *val, STRING *s);
	String					(*CoValGetString							)(VALUE *val);
	Bool						(*CoValIsInstanceOf						)(VALUE *val, VALUE *cl, LONG *err);
	LONG						(*CoValGetSize								)(VALUE *val);
	UCHAR*					(*CoValGetBytes								)(VALUE *val);

	VALUE*					(*CoGetGlobalClass						)(Coffee* cof, const String &name);
	CLASS*					(*CoAddGlobalClass						)(Coffee* cof, const String &name, const String &parent);
	Bool						(*CoAddGlobalSymbol						)(Coffee* cof, const String &name, const VALUE *v, LONG type);
	Bool						(*CoAddGlobalFunction					)(Coffee* cof, const String &name, V_CODE fcn);
	Bool						(*CoAddClassMember						)(Coffee* cof, const String &name, CLASS *c, LONG type);
	Bool						(*CoAddClassMethod						)(Coffee* cof, const String &name, CLASS *c, LONG type, V_CODE fcn, LONG argc);
	STRING*					(*CoAllocString								)(Coffee* cof, const String &s);
	OBJECT*					(*CoNewObject									)(Coffee* cof, const String &cl_name);
	ARRAY*					(*CoNewArray									)(Coffee* cof, LONG size);
	void						(*CoWrongcnt									)(Coffee* cof, LONG n, LONG cnt);
	void						(*CoErrCheckType							)(Coffee* cof, VALUE *v, LONG type, LONG *err);
	void						(*CoErrCheckObjectType				)(Coffee* cof, VALUE *v, const String &cl_name, LONG *err);
	void						(*CoErrCheckArgCount					)(Coffee* cof, LONG argc, LONG cnt, LONG *err);
	LONG						(*CoGetType										)(Coffee* cof);
	const Filename&	(*CoGetRootFile								)(Coffee* cof);
	OBJECT*					(*CoAllocDynamic							)(Coffee* cof, BaseList2D *bl, Bool coffeeallocation);
	CLASS*					(*CoAddInheritance						)(Coffee* cof, LONG id, const String &name, const String &from, Bool use_constructor);
	Coffee*					(*CoGetMaster									)(void);
	void						(*CoSetError									)(Coffee* cof, LONG type, const String &s1, const String &s2);
	void						(*CoInstallErrorHook					)(Coffee* cof, COFFEE_ERRORHANDLER *priv_hndl, void *priv_data);
	void						(*CoSetRootFile								)(Coffee* cof, const Filename &fn);
};

struct C4D_BaseList
{
	LONG						(*GetTypeEx						)(C4DAtom *at);
	LONG						(*GetDiskType					)(const C4DAtom *at);
	void						(*GetMarkerEx					)(BaseList2D *bl, ULONG *l1, ULONG *l2);
	GeListNode*			(*NextEx							)(GeListNode *bl);
	GeListNode*			(*PredEx							)(GeListNode *bl);
	void						(*InsertBeforeEx			)(GeListNode *element, GeListNode *bl);
	void						(*InsertAfterEx				)(GeListNode *element, GeListNode *bl);
	void						(*RemoveEx						)(GeListNode *bl);
	void						(*SetAllBits					)(BaseList2D *bl, LONG mask);
	LONG						(*GetAllBits					)(BaseList2D *bl);
	void						(*SetColor						)(BaseList2D *bl, LONG mask);
	LONG						(*GetColor						)(BaseList2D *bl);
	Bool						(*MessageEx						)(C4DAtom *at, LONG type, void *data);
	GeListNode*			(*UpEx								)(GeListNode *bl);
	GeListNode*			(*DownEx							)(GeListNode *bl);
	GeListNode*			(*DownLastEx					)(GeListNode *bl);
	void						(*InsertUnderEx				)(GeListNode *element, GeListNode *bl);
	void						(*InsertUnderLastEx		)(GeListNode *element, GeListNode *bl);
	void						(*Free								)(C4DAtom *at);
	void*						(*GetMainEx						)(BaseList2D *bl);
	Bool						(*Read								)(C4DAtom *at, HyperFile *hf, LONG id, LONG level);
	Bool						(*Write								)(C4DAtom *at, HyperFile *hf);
	Bool						(*ReadObject					)(C4DAtom *bn, HyperFile *hf, Bool readheader);
	Bool						(*WriteObject					)(C4DAtom *bn, HyperFile *hf);
	void						(*GetData							)(BaseList2D *bl, BaseContainer *ct);
	void						(*SetData							)(BaseList2D *bl, const BaseContainer *ct, Bool add);
	BaseContainer*	(*GetDataInstance			)(BaseList2D *bl);

	GeListHead*			(*AllocListHead				)(void);
	GeListNode*			(*AllocListNode				)(LONG bits, LONG *id_array, LONG id_cnt);

	NodeData*				(*GetNodeData					)(GeListNode *bn, LONG index);
	LONG						(*GetNodeID						)(GeListNode *bn, LONG index);
	NODEPLUGIN*			(*RetrieveTable				)(GeListNode *node, LONG index);
	NODEPLUGIN*			(*RetrieveTableX			)(NodeData *node, LONG index);

	GeListNode*			(*GetCustomData				)(GeListNode *bn);
	void						(*SetCustomData				)(GeListNode *bn, GeListNode *custom);
	String					(*GetBubbleHelp				)(BaseList2D *bl);

	void						(BaseList2D::*ClearKeyframeSelection  )();
	Bool						(BaseList2D::*FindKeyframeSelection   )(const DescID &id);
	Bool						(BaseList2D::*SetKeyframeSelection    )(const DescID &id, Bool selection);
	Bool						(BaseList2D::*KeyframeSelectionContent)();

	// layer
	LayerObject*     (BaseList2D::*GetLayerObject         )(BaseDocument *doc);
	Bool             (BaseList2D::*SetLayerObject         )(LayerObject *layer);
	const LayerData* (BaseList2D::*GetLayerData           )(BaseDocument *doc, Bool rawdata) const;
	Bool             (BaseList2D::*SetLayerData           )(BaseDocument *doc, const LayerData &data);

		// new animation system
	GeListHead*      (BaseList2D::*GetCTrackRoot )();
	CTrack*	         (BaseList2D::*GetFirstCTrack)(void);
	CTrack*	         (BaseList2D::*FindCTrack    )(const DescID &id);

	const String &   (BaseList2D::*GetTypeName   )(void);

	void             (BaseList2D::*InsertTrackSorted)(CTrack *track);
	BaseList2D*			 (*Alloc								        )(LONG type);

		// new nla system
	GeListHead*      (BaseList2D::*GetNLARoot         )();
	BaseList2D*      (BaseList2D::*AnimationLayerRemap)(BaseObject **layer);
};

struct C4D_Tag
{
	BaseTag*				(*Alloc								)(LONG type, LONG subtype, LONG count);
	BaseTag*				(*GetCloneEx					)(BaseTag *bt, LONG flags);
	Bool						(*CopyToEx						)(BaseTag *bt, BaseTag *dest, LONG flags);
	LONG						(*GetTagInfoEx				)(BaseTag *bt);
	Bool						(*EditEx							)(BaseTag *bt);
	LONG						(*GetDataCount				)(VariableTag *bt);
	LONG						(*GetDataSize					)(VariableTag *bt);
	void*						(*GetDataAddressW			)(VariableTag *bt);
	void						(*SetDataEx						)(BaseTag *tag, BaseContainer *bc);
	void						(*GetDataEx						)(BaseTag *tag, BaseContainer *bc);
	BaseSelect*			(*GetBaseSelect				)(SelectionTag *tag);
	Bool						(*Record							)(StickTextureTag *stt, BaseObject *op, Bool always);
	LONG						(*GetPluginIDEx				)(PluginTag *tag);
	void*						(*GetPluginDataEx			)(PluginTag *tag);
	void						(*SetPluginDataEx			)(PluginTag *tag,void *mem);

	// UVWs
	void						(*UvGet								)(UVWTag *tag, LONG i, UVWStruct *s);
	void						(*UvSet								)(UVWTag *tag, LONG i, UVWStruct *s);
	void						(*UvCpy								)(UVWTag *tag, LONG dst, UVWTag *srctag, LONG src);

	void						(*GetIconEx						)(BaseList2D *bl, IconData *dat);
	BaseTag*				(*GetOrigin						)(BaseTag *tag);
	const void*			(*GetDataAddressR			)(VariableTag *bt);
	void						(*UvGet2							)(const void *handle, LONG i, UVWStruct *s);
	void						(*UvSet2							)(void *handle, LONG i, const UVWStruct &s);
	void						(*UvCpy2							)(const void *srchandle, LONG src, void *dsthandle, LONG dst);
};

struct C4D_Object
{
	BaseObject*			(*Alloc								)(LONG type, LONG subtype);
	SplineObject*		(*AllocSplineObject		)(LONG pcnt, LONG type);
	BaseObject*			(*AllocPluginObjectEx	)(LONG plug_id);
	LONG						(*GetSubTypeEx				)(BaseObject *op);
	LONG						(*GetLayerTypeEx			)(BaseObject *op);
	BaseContainer*	(*GetDataEx						)(BaseObject *op);
	void						(*GetParameterEx			)(BaseObject *op, BaseContainer *data);
	void						(*SetParameterEx			)(BaseObject *op, const BaseContainer *data);
	Real						(*GetVisibility				)(BaseObject *op, Real parent);
	void						(*SetVisibilityEx			)(BaseObject *op, Real p);
	Vector					(*GetPos							)(BaseObject *op);
	void						(*SetPos							)(BaseObject *op, const Vector &v);
	Vector					(*GetScale						)(BaseObject *op);
	void						(*SetScale						)(BaseObject *op, const Vector &v);
	Vector					(*GetRot							)(BaseObject *op);
	void						(*SetRot							)(BaseObject *op, const Vector &v);
	Matrix					(*GetMl								)(BaseObject *op);
	void						(*SetMlEx							)(BaseObject *op, const Matrix &m);
	Matrix					(*GetMg								)(BaseObject *op);
	void						(*SetMgEx							)(BaseObject *op, const Matrix &m);
	Matrix					(*GetMln							)(BaseObject *op);
	Matrix					(*GetMgn							)(BaseObject *op);
	Matrix					(*GetUpMg							)(BaseObject *op);
	Vector					(*GetMp								)(BaseObject *op);
	Vector					(*GetRad							)(BaseObject *op);
	LONG						(*GetMode							)(BaseObject *op, LONG mode);
	void						(*SetMode							)(BaseObject *op, LONG mode, LONG val);
	void						(*GetNameEx						)(BaseObject *op, String *name);
	void						(*SetNameEx						)(BaseObject *op, const String *name);
	BaseTag*				(*GetFirstTag					)(BaseObject *op);
	BaseTag*				(*GetTag							)(BaseObject *op, LONG type, LONG nr);
	void*						(*GetTagData					)(BaseObject *op, LONG type, LONG nr);
	LONG						(*GetTagDataCount			)(BaseObject *op, LONG type);
	void						(*InsertTag						)(BaseObject *op, BaseTag *tp, BaseTag *pred);
	void						(*KillTag							)(BaseObject *op, LONG type, LONG nr);
	void*						(*GetFirstTrack				)(BaseList2D *op);
	void*						(*GetTrack						)(BaseList2D *op, LONG type);
	void						(*KillAllTracks				)(BaseList2D *op);
	void						(*InsertTrack					)(BaseList2D *op, void *track, void *pred);
	LONG						(*GetInfo							)(GeListNode *op);
	Bool						(*Edit								)(BaseList2D *op);
	BaseObject*			(*GetCache						)(BaseObject *op, HierarchyHelp *hh);
	BaseObject*			(*GetDeformCache			)(BaseObject *op);
	LineObject*			(*GetIsoparm					)(BaseObject *op);
	Bool						(*CopyToEx						)(BaseObject *op, BaseObject *dest, LONG flags);
	Bool						(*CopyTagsToEx				)(BaseObject *op, BaseObject *dest, LONG visible, LONG variable, LONG hierarchical);
	BaseObject*			(*GetCloneEx					)(BaseObject *op, LONG flags);
	Bool						(*IsDirty							)(BaseObject *op, LONG flags);
	void						(*SetDirty						)(C4DAtom *op, LONG flags);
	Bool						(*CheckCache					)(BaseObject *op, HierarchyHelp *hh);
	void						(*SetIsoparm					)(BaseObject *op, LineObject *l);
	BaseObject*			(*GenPrimitive				)(BaseDocument *doc, LONG type, const BaseContainer *bc, Real lod, Bool isoparm, BaseThread *bt);
	BaseObject*			(*GenSplinePrimitive	)(BaseDocument *doc, LONG type, const BaseContainer *bc, Real lod, BaseThread *bt);
	LONG						(*GetPluginIDEx				)(BaseObject *op);
	void*						(*GetPluginDataEx			)(BaseObject *op);
	void						(*SetPluginDataEx			)(BaseObject *op,void *mem);
	Bool						(*IsAddictedEx				)(BaseObject *op,BaseDocument *doc);
	Bool						(*GetActiveDependenceEx)(BaseObject *op);
	void						(*SetActiveDependenceEx)(BaseObject *op, Bool on);
	void						(*NewDependenceList		)(BaseObject *op);
	Bool						(*CmpDependenceList		)(BaseObject *op);
	void						(*TouchDependenceList	)(BaseObject *op);
	void						(*AddDependence				)(BaseObject *op,HierarchyHelp *hh, BaseObject *pp);
	Bool						(*AddTexture					)(BaseList2D *op, const Filename *fn, GetAllStringData *gd);
	BaseObject*			(*GetHierarchyCloneEx	)(BaseObject *op,HierarchyHelp *hh, BaseObject *pp, LONG flags, Bool *dirty);
	BaseObject*			(*GetVirtualLineObject)(BaseObject *op, HierarchyHelp *hh, const Matrix &mloc, Bool keep_spline, Bool recurse, Matrix *mres, Bool *dirty);
	void						(*Touch								)(BaseObject *op);

	// point object
	BaseSelect*			(*PoGetPointS					)(PointObject *op);
	BaseSelect*			(*PoGetPointH					)(PointObject *op);
	Bool						(*PoResizeObject			)(PointObject *op, LONG pcnt);
	Real*						(*PoCalcVertexMap			)(PointObject *op, BaseObject *modifier);

	// line object
	Bool						(*LoResizeObject			)(LineObject *op, LONG pcnt, LONG scnt);

	// polygon object
	BaseSelect*			(*PyGetPolygonS				)(PolygonObject *op);
	BaseSelect*			(*PyGetPolygonH				)(PolygonObject *op);
	Bool						(*PyResizeObject			)(PolygonObject *op, LONG pcnt, LONG vcnt);

	// spline object
	Vector					(*SpGetSplinePoint		)(SplineObject *op, Real t, LONG segment, const Vector *padr);
	Vector					(*SpGetSplineTangent	)(SplineObject *op, Real t, LONG segment, const Vector *padr);
	Bool						(*SpInitLength				)(SplineObject *op, LONG segment, const Vector *padr);
	void						(*SpFreeLength				)(SplineObject *op);
	Real						(*SpUniformToNatural	)(SplineObject *op, Real t);
	Real						(*SpGetLength					)(SplineObject *op);
	Real						(*SpGetSegmentLength	)(SplineObject *op, LONG a, LONG b);
	LineObject*			(*SpGetLineObject			)(SplineObject *op, BaseDocument *doc, Real lod, BaseThread *thread);
	SplineObject*		(*SpGetRealSpline			)(BaseObject *op);
	Bool						(*SpResizeObject			)(SplineObject *op, LONG pcnt, LONG scnt);

	// particle object
	LONG						(*PrGetCount					)(BaseObject *op);
	Real						(*PrGetLifetime				)(BaseObject *op);
	Particle*				(*PrGetParticleW			)(BaseObject *op, ParticleTag *pt, LONG i);
	Bool						(*PrIsMatrixAvailable	)(BaseObject *op);
	ParticleDetails*(*PrGetParticleDetails)(BaseDocument *doc, BaseObject *op);

	// camera object
	LONG						(*CoGetProjection			)(BaseObject *op);
	Real						(*CoGetFocus					)(BaseObject *op);
	Real						(*CoGetZoom						)(BaseObject *op);
	Vector					(*CoGetOffset					)(BaseObject *op);
	Real						(*CoGetAperture				)(BaseObject *op);
	Bool						(*CoSetProjection			)(BaseObject *op, LONG projection);
	Bool						(*CoSetFocus					)(BaseObject *op, Real v);
	Bool						(*CoSetZoom						)(BaseObject *op, Real v);
	Bool						(*CoSetOffset					)(BaseObject *op, const Vector &offset);
	Bool						(*CoSetAperture				)(BaseObject *op, Real v);

	// object safety
	ObjectSafety*		(*OsAlloc							)(BaseObject *op);
	void						(*OsFree							)(ObjectSafety *os, Bool restore);

	// triangulation
	Bool						(*Triangulate					)(const Vector *padr, LONG pcnt, CPolygon **vadr, LONG *vcnt);
	PolygonObject*	(*TriangulateLine			)(LineObject *op, Real regular, BaseThread *bt);
	SplineObject*		(*FitCurve						)(Vector *padr, LONG pcnt, Real error, BaseThread *bt);

	// uv stuff
	UVWTag*					(*GenerateUVW					)(BaseObject *op, const Matrix &opmg, TextureTag *tp, const Matrix &texopmg, BaseView *view);

	void						(*GetIconEx						)(BaseList2D *op, IconData *dat);

	ULONG						(*GetDirty						)(const C4DAtom *op, LONG flags);

	Bool						(*TriangulateStandard )(const Vector *padr, LONG pcnt, const LONG *list, LONG lcnt, CPolygon *&vadr, LONG &vcnt, BaseThread *thread);
	Bool						(*TriangulateRegular	)(const Vector *pinp, LONG pinp_cnt, const LONG *list, LONG lcnt, Vector *&padr, LONG &pcnt, CPolygon *&vadr, LONG &vcnt, Real regular_width, BaseThread *thread);

	Bool						(*SpSetDefaultCoeff		)(SplineObject *op);
	BaseObject*			(*GenerateText				)(BaseContainer *cp, BaseThread *bt, Bool separate);

	BaseSelect*			(*PyGetEdgeS					)(PolygonObject *op);
	BaseSelect*			(*PyGetEdgeH					)(PolygonObject *op);
	void						(*GetColorProperties	)(BaseObject *op, ObjectColorProperties *co);
	void						(*SetColorProperties	)(BaseObject *op, ObjectColorProperties *co);

	void						(*InsertTrackLast			)(BaseList2D *op, void *track);
	void*						(*FindTrack						)(BaseList2D *op, const DescID &id);
	Bool						(*CopyTagsTo					)(BaseObject *op, BaseObject *dest, LONG visible, LONG variable, LONG hierarchical, AliasTrans *trans);
	BaseObject*			(*GetHierarchyClone		)(BaseObject *op,HierarchyHelp *hh, BaseObject *pp, LONG flags, Bool *dirty, AliasTrans *trans);

	BaseObject*			(*GetCacheParent			)(BaseObject *op);
	Bool						(*CheckDisplayFilter	)(BaseObject *op, LONG flags);

	void						(*SetMl								)(BaseObject *op, const Matrix &m, Bool force);
	void						(*SetMg								)(BaseObject *op, const Matrix &m, Bool force);
	BaseSelect*			(*PyGetPhongBreak			)(PolygonObject *op);

	LONG						(*GetUniqueIP					)(BaseObject *op);
	void						(*SetUniqueIP					)(BaseObject *op, LONG ip);

	void						(*SetOrigin						)(BaseObject *op, BaseObject *origin);
	BaseObject*			(*GetOrigin						)(BaseObject *op, Bool safe);

	BaseObject*			(*InternalCalcBooleEx )(BaseObject *curr,LONG booletype, HierarchyHelp *hh);

	Vector*					(*CreatePhongNormals	)(PolygonObject *op);

	// triangulation
	PolyTriangulate* (*PolyTriangAlloc    )();
	void            (*PolyTriangFree      )(PolyTriangulate *&pTriang);
	Bool            (*PolyTriangTriang    )(PolyTriangulate* pTriang, const Vector* pvPoints, const LONG lPointCount, const LONG* plSegments, const LONG lSegCnt,
		CPolygon*& pPolys, LONG& lPolyCount, LONG lFlags, const LONG* plMap, BaseThread* pThread,
		const LONG lConstraints, const LONG* plConstrainedEdges);
	Bool            (*PolyTriangTriangRelease)(PolyTriangulate* pTriang, const Vector* pvPoints, const LONG lPointCount, const LONG* plSegments, const LONG lSegCnt,
		CPolygon*& pPolys, LONG& lPolyCount, LONG lFlags, const LONG* plMap, BaseThread* pThread,
		const LONG lConstraints, const LONG* plConstrainedEdges);

	Bool						(*PyGetPolygonTranslationMap)(PolygonObject *op, LONG &ngoncnt, LONG *&polymap);
	Bool						(*PyGetNGonTranslationMap)(PolygonObject *op, const LONG ngoncnt, const LONG *polymap, LONG **&ngons);
	Pgon*           (*PyGetNgon)(PolygonObject *op);
	LONG            (*PyGetNgonCount)(PolygonObject *op);
	Bool						(*PyResizeObjectNgon	)(PolygonObject *op, LONG pcnt, LONG vcnt, LONG ncnt);
	void						(*PyGetSelectedNgons  )(PolygonObject *op, BaseSelect* sel);
	void						(*PyGetHiddenNgons    )(PolygonObject *op, BaseSelect* sel);
	NgonBase*				(*PyGetNgonBase)(PolygonObject *op);
	Bool						(*PyValidateEdgeSelection)(PolygonObject *op, BaseSelect* sel);
	Bool						(*PyGetEdgeSelection)(PolygonObject *op, BaseSelect* sel, EdgeSelectionType type);

	BaseObject*			(*GetTopOrigin						)(BaseObject *op, Bool parent, Bool safe);
	BaseObject*			(*GetEditObject						)(BaseObject *op, BaseObject **psds, LONG state);
	LONG						(*GetHighlightHandle			)(BaseObject *op, BaseDraw *bd);

	const Matrix &  (*GetModelingAxis)(BaseObject *op, BaseDocument *doc);
	void            (*SetModelingAxis)(BaseObject *op, const Matrix &m);
	Bool            (*PolyTriangHasIdentical)(PolyTriangulate* pTriang);
	Bool            (*CalculateVisiblePoints)(BaseDraw *bd, PolygonObject *op, Vector *padr, UCHAR *pset, Bool select_visibonly);
	LONG            (*PolyTriangGetType)(PolyTriangulate* pTriang);

	Bool            (*HNSubdivideObject)(BaseDocument *doc, BaseObject *pop, LONG sub, LONG subiso, LONG generatebits, BaseThread *thread);
	void            (*PyGetNgonEdgesCompact)(PolygonObject *op, UCHAR *&edges);

	void*						(*GetLastTrack				)(BaseList2D *op);
	LONG						(*IntersectionTest			)(PolygonObject *op, BaseDraw *bd, Real x, Real y, const Matrix &mg, Real *z, LONG mode, UCHAR *pPointSelect, LONG lSelectCount);

	Bool						(*PyValidateEdgeSelectionA)(PolygonObject *op);

	Bool            (*PolyTriangTriangA   )(PolyTriangulate* pTriang, const LVector* pvPoints, const LONG lPointCount, const LONG* plSegments, const LONG lSegCnt,
		CPolygon*& pPolys, LONG& lPolyCount, LONG lFlags, const LONG* plMap, BaseThread* pThread,
		const LONG lConstraints, const LONG* plConstrainedEdges);
	Bool            (*PolyTriangTriangReleaseA)(PolyTriangulate* pTriang, const LVector* pvPoints, const LONG lPointCount, const LONG* plSegments, const LONG lSegCnt,
		CPolygon*& pPolys, LONG& lPolyCount, LONG lFlags, const LONG* plMap, BaseThread* pThread,
		const LONG lConstraints, const LONG* plConstrainedEdges);
	void            (*PolyTriangSetPolygonMatrix)(PolyTriangulate* pTriang, LMatrix* m);
	ULONG           (*PolyTriangGetState)(PolyTriangulate* pTriang);
	const Particle*	(*PrGetParticleR			)(BaseObject *op, ParticleTag *pt, LONG i);

	void						(*GetIcon							)(BaseList2D *op, IconData *dat);

	ULONG						(C4DAtom::*GetHDirty	)(ULONG mask) const;
	void						(C4DAtom::*SetHDirty	)(ULONG mask);

	const void*			(*GetTagDataR					)(BaseObject *op, LONG type, LONG nr);

	void						(*RemoveFromCache			)(BaseObject *op);
	Bool						(*SearchHierarchy)(BaseObject *op, BaseObject *find);
	Bool						(*PyResizeObjectNgonFlags	)(PolygonObject *op, LONG pcnt, LONG vcnt, LONG ncnt, LONG vc_flags);
};

struct C4D_Document
{
	// render data
	RenderData*			(*RdAlloc							)(void);
	void						(*RdGetDataEx					)(RenderData *rd, BaseContainer *bc);
	void						(*RdSetDataEx					)(RenderData *rd, BaseContainer *bc);

	// document
	BaseDocument*		(*Alloc								)(void);
	Bool						(*CopyToEx						)(BaseDocument *src, BaseDocument *dst, LONG flags);
	void						(*FlushAll						)(BaseDocument *doc);
	void						(*GetData							)(BaseDocument *doc, LONG type, BaseContainer *bc);
	void						(*SetData							)(BaseDocument *doc, LONG type, const BaseContainer *bc);
	BaseObject*			(*GetFirstObject			)(BaseDocument *doc);
	BaseMaterial*		(*GetFirstMaterial		)(BaseDocument *doc);
	RenderData*			(*GetFirstRenderData	)(BaseDocument *doc);
	void						(*InsertRenderData		)(BaseDocument *doc, RenderData *rd, RenderData *pred);
	void						(*InsertMaterial			)(BaseDocument *doc, BaseMaterial *mat, BaseMaterial *pred, Bool checknames);
	void						(*InsertObject				)(BaseDocument *doc, BaseObject *op, BaseObject *parent, BaseObject *pred, Bool checknames);
	RenderData*			(*GetActiveRenderData	)(BaseDocument *doc);
	BaseObject*			(*GetActiveObject			)(BaseDocument *doc);
	BaseMaterial*		(*GetActiveMaterial		)(BaseDocument *doc);
	BaseTag*				(*GetActiveTag				)(BaseDocument *doc, BaseObject *active);
	void						(*SetActiveObjectEx		)(BaseDocument *doc, BaseObject *op);
	void						(*SetActiveTagEx			)(BaseDocument *doc, BaseObject *op, BaseTag *ta);
	void						(*SetActiveMaterialEx	)(BaseDocument *doc, BaseMaterial	*mp);
	void						(*SetActiveRenderData	)(BaseDocument *doc, RenderData *rd);
	BaseObject*			(*GetHighest					)(BaseDocument *doc, LONG type, Bool editor);
	BaseMaterial*		(*SearchMaterial			)(BaseDocument *doc, const String *str, Bool inc);
	BaseObject*			(*SearchObject				)(BaseDocument *doc, const String *str, Bool inc);
	Bool						(*StartUndo						)(BaseDocument *doc);
	Bool						(*EndUndo							)(BaseDocument *doc);
	Bool						(*AddUndo							)(BaseDocument *doc, LONG type, void *data);
	Bool						(*DoUndoEx						)(BaseDocument *doc);
	Bool						(*DoRedo							)(BaseDocument *doc);
	void						(*AnimateDocumentEx		)(BaseDocument *doc, LONG flags);
	void						(*AnimateObject				)(BaseDocument *doc, BaseList2D *op, const BaseTime &time, LONG flags);
	BaseDraw*				(*GetActiveBaseDraw		)(BaseDocument *doc);
	BaseDraw*				(*GetRenderBaseDraw		)(BaseDocument *doc);
	BaseDraw*				(*GetBaseDraw					)(BaseDocument *doc, LONG num);
	LONG						(*GetSplinePlane			)(BaseDocument *doc);

	// hierarchy help
	Real						(*HhGetLOD						)(HierarchyHelp *hh);
	LONG						(*HhGetVFlags					)(HierarchyHelp *hh);
	BaseThread*			(*HhGetThread					)(HierarchyHelp *hh);
	BaseDocument*		(*HhGetDocument				)(HierarchyHelp *hh);
	Matrix					(*HhGetMg							)(HierarchyHelp *hh);
	void						(*HhAddVFlags					)(HierarchyHelp *hh, LONG mask);

	// hierarchy
	Bool						(*RunHierarchy				)(void *main, BaseDocument *doc, Bool spheres, Real lod, LONG flags, void *startdata, BaseThread *bt, HierarchyAlloc *ha, HierarchyFree *hf, HierarchyCopyTo *hc, HierarchyDo *hd);

	Bool						(*AnimateDocumentExEx )(BaseDocument *doc,BaseThread *bt,Bool doexpressions,Bool doanim);
	PluginSceneHook*(*FindSceneHook				)(BaseDocument *doc,LONG id);

	void						(BaseDocument::*SetActiveObject		)(BaseObject *op,LONG mode);
	void						(BaseDocument::*GetActiveObjects	)(AtomArray &selection,Bool childs) const;
	void						(BaseDocument::*GetActiveTags			)(AtomArray &selection) const;

	void						(*PrAdd								)(PriorityList *list, GeListNode *node, LONG priority, LONG flags);
	BaseObject*			(*GetHelperAxis				)(BaseDocument *doc);
	PluginVideoPost*(*RdGetFirstVideoPost	)(RenderData *rd);
	void						(*RdInsertVideoPost		)(RenderData *rd, PluginVideoPost *pvp, PluginVideoPost *pred);
	void						(BaseDocument::*GetActiveMaterials)(AtomArray &selection) const;

	Bool						(*SoundCommand				)(BaseDocument *doc, LONG command);
	void						(*SetRewind						)(BaseDocument *doc, LONG flags);

	void						(BaseDocument::*SetActiveTag			)(BaseTag *op,LONG mode);
	void						(BaseDocument::*SetActiveMaterial	)(BaseMaterial *mat,LONG mode);

	PluginVideoPost*(*VpAlloc								)(LONG type);

	LONG						(*MgGetCount						)(BaseDocument *doc);
	BaseContainer*	(*MgAdd									)(BaseDocument *doc,const BaseContainer &g);
	Bool						(*MgRemove							)(BaseDocument *doc,LONG id);
	BaseContainer*	(*MgGetIndex						)(BaseDocument *doc,LONG i);
	BaseContainer*	(*MgGetID								)(BaseDocument *doc,LONG id);
	Bool						(*MgIsVisible						)(BaseDocument *doc,BaseMaterial *mat);

	BaseContainer		(*GetAllTexturesEx			)(BaseDocument *doc);
	BaseList2D*     (*GetUndoPtr            )(BaseDocument *doc);
	void            (*AutoKey               )(BaseDocument *doc, BaseList2D *undo, BaseList2D *op, Bool recursive, Bool pos, Bool scale, Bool rot, Bool param, Bool pla);
	Bool						(*DoUndo								)(BaseDocument *doc, Bool multiple);
	Bool						(*IsCacheBuilt				  )(BaseDocument *doc, Bool force);
	void						(BaseDocument::*GetActivePolygonObjects)(AtomArray &selection,Bool childs) const;
	BaseTime				(*GetUsedTime						)(BaseDocument *doc, BaseList2D *check_op, Bool min);
	void						(*ForceCreateBaseDraw		)(BaseDocument *doc);

	BaseContainer*  (*GetDataInstance				)(BaseDocument *doc, LONG type);
	void						(*RunAnimation					)(BaseDocument *doc, Bool forward, Bool stop);
	void						(*SetDocumentTime				)(BaseDocument *doc, const BaseTime &time);

	BaseDocument*		(*IsolateObjects				)(BaseDocument *doc,const AtomArray &t_objects);

	void						(BaseDocument::*GetSelection)(AtomArray &selection) const;
	void						(BaseDocument::*SetSelection      )(BaseList2D *bl,LONG mode);

	// layers
	LayerObject*		(*DlAlloc							  )(void);
	GeListHead*     (*GetLayerObjectRoot    )(BaseDocument *doc);
	Bool            (*HandleSelectedTextureFilename)(BaseDocument *doc, BaseChannel *bc, const Filename &fn, Filename *resfilename, Bool undo, LONG *already_answered);
	Bool            (*ReceiveMaterials             )(BaseDocument *doc, BaseObject *op, AtomArray *mat, Bool clearfirst);
	Bool            (*ReceiveNewTexture            )(BaseDocument *doc, BaseObject *op, const Filename &filename, Bool sdown, LONG *already_answered);

	void            (*SetKeyDefault         )(BaseDocument *doc, CCurve *seq, LONG kidx);

	void            (*Record                )(BaseDocument *doc);
	BaseContainer		(*GetAllTextures				)(BaseDocument *doc, const AtomArray *ar);
	Bool						(*RecordKey	            )(BaseDocument *doc, BaseList2D *op, const BaseTime &time, const DescID &id, BaseList2D *undo, Bool eval_attribmanager, Bool autokeying, Bool allow_linking);

	Bool						(*CloseAllDocuments			)();
	BaseObject*			(*GetRealActiveObject		)(BaseDocument *doc, AtomArray *help, Bool *multi);
	Bool						(*AddUndoBD							)(BaseDocument *doc, BaseDraw* bd);

	Bool						(*CollectSounds         )(BaseDocument *doc, BaseSound *snd, const BaseTime &from, const BaseTime &to);
	void            (*RecordZero            )(BaseDocument *doc);

	MultipassObject*(*RdGetFirstMultipass   )(RenderData *rd);
	void						(*RdInsertMultipass     )(RenderData *rd, MultipassObject *pvp, MultipassObject *pred);
	MultiPassChannel *multipasschannels;
	void						(*InsertRenderDataLast  )(BaseDocument *doc, RenderData *rd);

	void            (*RecordNoEvent         )(BaseDocument *doc);
	LONG						(*GetDrawTime						)(BaseDocument *doc);
	Bool						(*StopExternalRenderer	)();
	LONG						(*GetBaseDrawCount			)(BaseDocument *doc);
	Bool						(BaseDocument::*ExecutePasses)(BaseThread *bt, Bool animation, Bool expressions, Bool caches);
};

#ifndef __GE_SPINLOCK
#define __GE_SPINLOCK

	typedef volatile LONG	GE_SPINLOCK;

	struct GE_RWSPINLOCK
	{
		GE_RWSPINLOCK() : state(0) { }

		volatile LONG		state;
		//LONG						_dummy_;
	};

#endif

struct C4D_Thread
{
	BaseThread*			(*AllocEx							)(ThreadMain *tm, ThreadTest *tt, void *data);
	void						(*Free								)(BaseThread *bt);
	Bool						(*TestBreak						)(BaseThread *bt);
	Bool						(*TestBaseBreak				)(BaseThread *bt);
	Bool						(*IsRunning						)(BaseThread *bt);
	Bool						(*StartEx							)(BaseThread *bt, Bool back, Bool pri);
	void						(*EndEx								)(BaseThread *bt);
	void						(*ThreadLock					)(void);
	void						(*ThreadUnLock				)(void);
	LONG						(*GetCPUCount					)(void);
	MPBaseThread*		(*MPAllocEx						)(BaseThread *parent, LONG count, ThreadMain *tm, ThreadTest *tt, void **data);
	void						(*MPFree							)(MPBaseThread *mp);
	BaseThread*			(*MPGetThread					)(MPBaseThread *mp, LONG i);
	void*						(*MPWaitForNextFree		)(MPBaseThread *mp);
	void						(*MPWait							)(MPBaseThread *mp);
	void						(*MPEnd								)(MPBaseThread *mp);
	Semaphore*			(*SMAlloc							)(void);
	void						(*SMFree							)(Semaphore *sm);
	Bool						(*SMLock							)(Semaphore *sm);
	Bool						(*SMLockAndWait				)(Semaphore *sm, BaseThread *bt);
	void						(*SMUnLock						)(Semaphore *sm);
	void						(*Wait								)(BaseThread *bt, Bool checkevents);

	BaseThread			*NoThread;

	void						(*SpinLock						)(GE_SPINLOCK *lock);
	void						(*SpinUnlock					)(GE_SPINLOCK *lock);
	void						(*SpinReadLock				)(GE_RWSPINLOCK *rwlock);
	void						(*SpinReadUnlock			)(GE_RWSPINLOCK *rwlock);
	void						(*SpinWriteLock				)(GE_RWSPINLOCK *rwlock);
	void						(*SpinWriteUnlock			)(GE_RWSPINLOCK *rwlock);

	LONG						(*Identify						)(BaseThread *bt);

	Bool						(*Start								)(BaseThread *bt, Bool back, LONG priority, Bool keeprunning);
	BaseThread*			(*Alloc								)(ThreadMain *tm, ThreadTest *tt, void *data, ThreadName *tn);
	MPBaseThread*		(*MPAlloc							)(BaseThread *parent, LONG count, ThreadMain *tm, ThreadTest *tt, void **data, ThreadName *tn);

	ULONG						(*GetCurrentThreadId	)();
	BaseThread*			(*GetCurrentThread		)();

	void						(*End									)(BaseThread *bt, Bool wait);
};

struct C4D_Material
{
	BaseMaterial*		(*Alloc								)(LONG type, LONG shader_id);
	LONG						(*GetPluginIDEx				)(PluginMaterial *mat);
	void*						(*GetPluginDataEx			)(PluginMaterial *mat);
	void						(*GetNameEx						)(BaseMaterial *mat, String *name);
	void						(*SetNameEx						)(BaseMaterial *mat, const String *name);

	void						(*Update							)(BaseMaterial *mat, LONG preview, Bool rttm);
	BaseMaterial*		(*GetCloneEx					)(BaseMaterial *bm, LONG flags);
	Bool						(*CopyToEx						)(BaseMaterial *bm, BaseMaterial *dest, LONG flags);
	Bool						(*EditEx							)(BaseMaterial *bm);
	void						(*SetDataEx						)(BaseMaterial *bm, BaseContainer *bc);
	void						(*GetDataEx						)(BaseMaterial *bm, BaseContainer *bc);
	BaseChannel*		(*GetChannel					)(BaseMaterial *bm, LONG id);
	Bool						(*GetChannelState			)(Material *mat, LONG channel);
	void						(*SetChannelState			)(Material *mat, LONG channel, Bool state);
	Bool						(*Compare							)(BaseMaterial *m1, BaseMaterial *m2);

	VOLUMESHADER*		(*GetShaderEx					)(PluginMaterial *mat);
	BaseBitmap*			(*GetPreview					)(BaseMaterial *bm, LONG flags);

	Vector					(*GetAverageColorEx		)(BaseMaterial *bm);

	void						(BaseMaterial::*Displace				)(VolumeData *sd);
	void						(BaseMaterial::*ChangeNormal		)(VolumeData *sd);
	void						(BaseMaterial::*CalcSurface			)(VolumeData *sd);
	void						(BaseMaterial::*CalcTransparency)(VolumeData *sd);
	void						(BaseMaterial::*CalcAlpha				)(VolumeData *sd);
	void						(BaseMaterial::*CalcVolumetric  )(VolumeData *sd);
	void						(BaseMaterial::*InitCalculation )(VolumeData *sd, LONG type);
	LONG						(BaseMaterial::*GetRenderInfo	  )(void);

	Vector					(*GetAverageColor			)(BaseMaterial *mat, LONG channel);
	LONG						(BaseMaterial::*GlMessage	)(LONG type, void *data);
};

struct C4D_Texture
{
	Vector					(*GetPos							)(BaseList2D *tag);
	Vector					(*GetScale						)(BaseList2D *tag);
	Vector					(*GetRot							)(BaseList2D *tag);
	Matrix					(*GetMl								)(BaseList2D *tag);
	Matrix					(*GetMln							)(BaseList2D *tag);
	void						(*SetPos							)(BaseList2D *tag, const Vector &v);
	void						(*SetScale						)(BaseList2D *tag, const Vector &v);
	void						(*SetRot							)(BaseList2D *tag, const Vector &v);
	void						(*SetMl								)(BaseList2D *tag, const Matrix &m);

	BaseMaterial*		(*GetMaterialEx				)(BaseList2D *tag);
	void						(*SetMaterial					)(BaseList2D *tag, BaseMaterial *mat);

	BaseMaterial*		(*GetSecondMaterialEx	)(TextureTag *tag, Real *fade);
	void						(*SetSecondMaterialEx	)(TextureTag *tag, BaseMaterial *mat, Real fade);

	BaseMaterial*   (*GetInterpolatedMaterialEx)(BaseDocument *doc, TextureTag *tag);
	BaseMaterial*		(*GetMaterial					)(BaseList2D *tag, Bool ignoredoc);
};

struct C4D_BaseSelect
{
	BaseSelect*			(*Alloc								)(void);
	void						(*Free								)(BaseSelect *bs);
	void						(*FlushAll						)(BaseSelect *bs);
	LONG						(*GetCount						)(const BaseSelect *bs);
	LONG						(*GetSegments					)(const BaseSelect *bs);
	Bool						(*Select							)(BaseSelect *bs, LONG num);
	Bool						(*SelectAll						)(BaseSelect *bs, LONG min, LONG max);
	Bool						(*Deselect						)(BaseSelect *bs, LONG num);
	Bool						(*DeselectAll					)(BaseSelect *bs);
	Bool						(*Toggle							)(BaseSelect *bs, LONG num);
	Bool						(*ToggleAll						)(BaseSelect *bs, LONG min, LONG max);
	Bool						(*GetRange						)(const BaseSelect *bs, LONG seg, LONG *a, LONG *b);
	Bool						(*IsSelected					)(const BaseSelect *bs, LONG num);
	Bool						(*CopyTo							)(const BaseSelect *bs, BaseSelect *dest);
	BaseSelect*			(*GetClone						)(const BaseSelect *bs);
	Bool						(*FromArray						)(BaseSelect *bs, UCHAR *selection, LONG count);
	UCHAR*					(*ToArray							)(const BaseSelect *bs, LONG count);
	Bool						(*Merge 							)(BaseSelect *bs, BaseSelect *src);
	Bool						(*DeselectBS					)(BaseSelect *bs, BaseSelect *src);
	Bool						(*FindSegment					)(const BaseSelect *bs, LONG num, LONG *segment);
	LONG*						(*GetData							)(BaseSelect *bs);
	Bool						(*CopyFrom						)(BaseSelect *bs, LONG *ndata, LONG ncnt);
	LONG						(*GetDirty						)(const BaseSelect *bs);
};

struct C4D_CAnimation
{
	BaseTime        (CKey::*GetTime               )(void) const;
	Bool            (CKey::*CopyDataTo            )(CCurve *destseq, CKey *dest, AliasTrans *trans) const;
	void            (CKey::*FlushData1            )(void);
	BaseTime				(CKey::*GetTimeLeft						)(void) const;
	BaseTime				(CKey::*GetTimeRight					)(void) const;
	Real						(CKey::*GetValue							)(void) const;
	Real						(CKey::*GetValueLeft					)(void) const;
	Real						(CKey::*GetValueRight					)(void) const;
	CInterpolation  (CKey::*GetInterpolation      )(void) const;
	void						(CKey::*SetTime								)(CCurve *seq, const BaseTime &t);
	void						(CKey::*SetTimeLeft						)(CCurve *seq, const BaseTime &t);
	void						(CKey::*SetTimeRight					)(CCurve *seq, const BaseTime &t);
	void						(CKey::*SetValue							)(CCurve *seq, Real v);
	void						(CKey::*SetValueLeft					)(CCurve *seq, Real v);
	void						(CKey::*SetValueRight					)(CCurve *seq, Real v);
	void						(CKey::*SetGeData							)(CCurve *seq, const GeData &d);
	void						(CKey::*SetInterpolation      )(CCurve *seq, CInterpolation inter);
	CTrack*					(CKey::*GetTrackCKey					)(void);
	CCurve*	    		(CKey::*GetSequenceCKey				)(void);
	const GeData&   (CKey::*GetGeData             )(void) const;
	CKey*						(*CKey_Alloc									)(void);
	void						(*CKey_Free										)(CKey *&ckey);

	LONG            (CCurve::*GetKeyCount         )(void) const;
	CKey*           (CCurve::*GetKey1             )(LONG index);
	const CKey*     (CCurve::*GetKey2             )(LONG index) const;
	CKey*           (CCurve::*FindKey1            )(const BaseTime &time, LONG *nidx, FINDANIM_TYPE match);
	const CKey*     (CCurve::*FindKey2            )(const BaseTime &time, LONG *nidx, FINDANIM_TYPE match) const;
	CKey*           (CCurve::*AddKey              )(const BaseTime &time, LONG *nidx);
	Bool						(CCurve::*InsertKey				    )(const CKey *key);
	Bool            (CCurve::*DelKey              )(LONG index);
	LONG						(CCurve::*MoveKey					    )(const BaseTime &time, LONG idx, CCurve *dseq);
	void            (CCurve::*FlushKeys           )(void);
	void						(CCurve::*SortKeysByTime		  )(void);
	void            (CCurve::*CalcSoftTangents    )(LONG kidx, Real *vl, Real *vr, BaseTime *tl, BaseTime *tr) const;
	LReal           (CCurve::*CalcHermite         )(LReal time, LReal t1, LReal t2, LReal val1, LReal val2, LReal tan1_val, LReal tan2_val, LReal tan1_t, LReal tan2_t, Bool deriv) const;
	void	          (CCurve::*GetTangents         )(LONG kidx, LReal *vl, LReal *vr, LReal *tl, LReal *tr) const;

	Real            (CCurve::*GetValue1           )(const BaseTime &time,LONG fps) const;
	CTrack*					(CCurve::*GetTrackCSeq			  )(void);


	CTrack*			  	(*CTrackAlloc								  )(BaseList2D *bl, const DescID &id);
	Bool            (CTrack::*Animate             )(const CAnimInfo *info, Bool *chg, void *data);
	const DescID&   (CTrack::*GetDescriptionID    )(void) const;
	Bool            (CTrack::*SetDescriptionID    )(BaseList2D *object, const DescID &id);

	Bool            (CTrack::*Draw                )(GeClipMap *map, const BaseTime &clip_left, const BaseTime &clip_right) const;
	CLoopType				(CTrack::*GetBefore           )(void) const;
	CLoopType				(CTrack::*GetAfter            )(void) const;
	void						(CTrack::*SetBefore           )(CLoopType type);
	void						(CTrack::*SetAfter            )(CLoopType type);

	CTrack*         (CTrack::*GetTimeTrack        )(BaseDocument *doc);
	CCurve*         (CTrack::*GetCurve            )(CCurveType type,Bool bCreate);
	void            (CTrack::*SetTimeTrack        )(CTrack *track);
	void            (CTrack::*FlushData           )(void);
	Real            (CTrack::*GetValue3           )(BaseDocument *doc, const BaseTime &time, LONG fps);
	Bool            (CTrack::*Remap								)(LReal time, LReal *ret_time, LONG *ret_cycle) const;
	LONG						(CTrack::*GuiMessage					)(const BaseContainer &msg,BaseContainer &result);
	LONG						(CTrack::*GetHeight						)();
	Bool						(CTrack::*FillKey							)(BaseDocument *doc, BaseList2D *bl, CKey *key);
	Bool						(CTrack::*TrackInformation    )(BaseDocument *doc, CKey *key, String *str, Bool set);

	const BaseContainer *(CTrack::*GetParameterDescription)(BaseContainer &temp) const;

	LONG						(CTrack::*GetTrackCategory    )(void) const;
	Bool            (CTrack::*AnimateTrack        )(BaseDocument *doc, BaseList2D *op, const BaseTime &tt, const LONG flags, Bool *chg, void *data);
	LONG						(CTrack::*GetUnit							)(Real *step);

  LONG						(CTrack::*GetTLHeight					)(LONG id);
  void						(CTrack::*SetTLHeight					)(LONG id,LONG size);
};


struct C4D_BaseSound
{
	BaseSound*			(*Alloc								)(void);
	void						(*Free								)(BaseSound *bs);
	BaseSound*			(*GetClone						)(BaseSound *bs);
	Bool						(*CopyTo							)(BaseSound *bs, BaseSound *dest);
	Bool						(*Init								)(BaseSound *bs, LONG samples, LONG fmode, Bool stereo, Bool b16);
	void						(*FlushAll						)(BaseSound *bs);
	Bool						(*Load								)(BaseSound *bs, const Filename *fn);
	Bool						(*Save								)(BaseSound *bs, const Filename *fn);
	void						(*GetSoundInfoEx			)(BaseSound *bs, Bool *stereo, Bool *b16, LONG *frequency, LONG *samples, BaseTime *length);
	void						(*GetSample						)(BaseSound *bs, LONG i, SData *data);
	void						(*SetSample						)(BaseSound *bs, LONG i, SData *data);
	BaseBitmap*			(*GetBitmap						)(BaseSound *bs, LONG width, LONG height, const BaseTime &start, const BaseTime &stop);
	BaseKey*				(*GetFirstMarkerEx		)(BaseSound *bs);
	Bool						(*InsertMarkerEx			)(BaseSound *bs, BaseKey *mk, BaseKey *pred);
	CHAR*						(*GetRAW							)(BaseSound *bs);
	Bool            (*WriteIt             )(BaseSound *bs, HyperFile *hf);
	Bool            (*ReadIt              )(BaseSound *bs, HyperFile *hf, LONG level);
	BaseBitmap*			(*GetBitmap2					)(BaseSound *bs, LONG width, LONG height, const BaseTime &start, const BaseTime &stop, const Vector &draw_col, const Vector &back_col);
	GeListHead*     (*GetMarkerRoot       )(BaseSound *bs);
	BaseSound*			(*GetClonePart				)(BaseSound *bs,	const BaseTime &start,	const BaseTime &stop,	Bool reverse);
	CHAR*						(*GetSoundInfo				)(BaseSound *bs, Bool *stereo, Bool *b16, LONG *frequency, LONG *samples, BaseTime *length);
};

struct C4D_BaseDraw
{
	// basedraw
	Bool						(*HasCameraLink				)(BaseDraw *bd);
	void						(*SetSceneCameraEx		)(BaseDraw *bd, BaseObject *op);
	BaseObject*			(*GetSceneCameraEx		)(BaseDraw *bd);
	BaseObject*			(*GetEditorCamera			)(BaseDraw *bd);
	Vector					(*GetObjectColorEx		)(BaseDraw *bd, BaseObject *op);
	Vector					(*CheckColor					)(BaseDraw *bd, const Vector &col);
	Bool						(*ZBufAvailable				)(BaseDraw *bd);
	BaseBitmap*			(*GetBitmapEx					)(BaseDraw *bd);
	void						(*SetTransparency			)(BaseDraw *bd, LONG trans);
	LONG						(*GetTransparency			)(BaseDraw *bd);
	Bool						(*PointInRange				)(BaseDraw *bd, const Vector &p, LONG x, LONG y);
	void						(*SetPen							)(BaseDraw *bd, const Vector &col);
	Real						(*SimpleShade					)(BaseDraw *bd, const Vector &p, const Vector &n);
	void						(*Begin2DEx						)(BaseDraw *bd);
	void						(*End2DEx							)(BaseDraw *bd);
	void						(*Point2D							)(BaseDraw *bd, const Vector &p);
	void						(*Line2D							)(BaseDraw *bd, const Vector &p1, const Vector &p2); // draw line with 2D clipping
	void						(*Handle2D						)(BaseDraw *bd, const Vector &p, LONG type);
	void						(*Circle2D						)(BaseDraw *bd, LONG mx, LONG my, Real rad);
	void						(*LineCSEx						)(BaseDraw *bd, const Vector &p1, const Vector &p2, Bool clip2d, Bool clipz);
	void						(*Point3D							)(BaseDraw *bd, const Vector &p);
	void						(*Line3D							)(BaseDraw *bd, const Vector &p1, const Vector &p2);
	void						(*Handle3D						)(BaseDraw *bd, const Vector &p, LONG type);
	void						(*Circle3D						)(BaseDraw *bd, const Matrix &m);
	void						(*Box3D								)(BaseDraw *bd, const Matrix &m, Real size, const Vector &col);
	void						(*Polygon3D						)(BaseDraw *bd, Vector *p, Vector *f, Bool quad);
	Bool						(*DrawPObject					)(BaseDraw *bd, BaseDrawHelp *bh, BaseObject *op, LONG drawpolyflags);
	void						(*GetDataEx						)(BaseDraw *bd, BaseContainer *bc);

	// basedraw help
	BaseDocument*		(*BbGetDocument				)(BaseDrawHelp *bb);
	BaseTag*				(*BbGetActiveTag			)(BaseDrawHelp *bb);
	Matrix					(*BbGetMgEx						)(BaseDrawHelp *bb);
	void						(*BbGetDisplay				)(BaseDrawHelp *bb, BaseContainer *bc);

	BaseObject*			(*GetSceneCamera			)(BaseDraw *bd, BaseDocument *doc);
	void						(*LineCS							)(BaseDraw *bd, const Vector &p1, const Vector &p2, Bool clip2d, Bool clipz,Bool offset);
	Vector					(*GetObjectColor			)(BaseDraw *bd, BaseObject *op, BaseDrawHelp *bh);
	void            (*LineZOffset         )(BaseDraw *bd, LONG offset);
	void            (*SetMatrix_Projection)(BaseDraw *bd);
	void            (*SetMatrix_Screen    )(BaseDraw *bd);
	void            (*SetMatrix_Camera    )(BaseDraw *bd);
	void            (*SetMatrix_Matrix    )(BaseDraw *bd, BaseObject *op,const Matrix &mg);
	void            (*LineNew             )(BaseDraw *bd, const Vector &p1, const Vector &p2,LONG flags);
	void            (*LineStripBegin      )(BaseDraw *bd);
	void            (*LineStrip           )(BaseDraw *bd, const Vector &vp,const Vector &vc,LONG flags);
	void            (*LineStripEnd        )(BaseDraw *bd);
	void            (*DrawHandle          )(BaseDraw *bd, const Vector &vp,LONG type,LONG flags);
	void						(*DrawTexture					)(BaseDraw *bd, BaseBitmap *bmp, Vector *padr4, Vector *cadr, Vector *vnadr, Vector *uvadr, LONG pntcnt, Bool interpolation, LONG alphamode);
	void						(*SetLightList				)(BaseDraw *bd, LONG mode);

	LONG						(*GetInitTimer				)(BaseDraw *bd);
	void						(*InitUndo						)(BaseDraw *bd, BaseDocument *doc);
	void						(*DoUndo							)(BaseDraw *bd, BaseDocument *doc);
	void						(*SetDrawParam				)(BaseDraw *bd, LONG id,const GeData &data);
	GeData					(*GetDrawParam				)(BaseDraw *bd, LONG id);

	void						(*DrawPoly						)(BaseDraw *bd, Vector *vp,Vector *vf,Vector *vn,LONG anz,LONG flags);
	LONG						(*GetDisplayFilter				)(BaseDraw *bd);
	LONG						(*GetEditState					)(BaseDraw *bd);
	Bool						(*IsValidEditState				)(BaseDraw *bd, BaseDocument *doc);
	Bool						(*IsViewOpen					)(BaseDraw *bd, BaseDocument *doc);

	void						(*CircleNew						)(BaseDraw *bd, const Matrix &m);
	void						(*Box3DNew						)(BaseDraw *bd, const Matrix &m, Real size, const Vector &col, Bool wire);
	void						(*PolygonNew					)(BaseDraw *bd, Vector *p, Vector *f, Bool quad);
	void						(*DrawSphere					)(BaseDraw *bd, const Vector &off, const Vector &size, const Vector &col, LONG flags);
	Bool						(*TestBreak						)(BaseDraw *bd);
	void						(*DrawArrayEnd				)(BaseDraw *bd);
	OITInfo&				(*GetOITInfo					)(BaseDraw *bd);
	Bool						(*AddToPostPass				)(BaseDraw *bd, BaseObject *op,BaseDrawHelp *bh, LONG flags);

	void						(*BbSetMg							)(BaseDrawHelp *bb, const Matrix &mg);
	void            (*SetMatrix_MatrixO   )(BaseDraw *bd, BaseObject *op,const Matrix &mg, LONG zoffset);
	void            (*SetMatrix_ScreenO   )(BaseDraw *bd, LONG zoffset);
	void            (*SetMatrix_CameraO   )(BaseDraw *bd, LONG zoffset);

	EditorWindow *(*GetEditorWindow)(BaseDraw *bd);

	void						(*Point3DArray				)(BaseDraw *bd, LONG cnt, const Vector *vp, const Real *vc, LONG colcnt, const Vector *vn);
	void						(*DrawTexture1				)(BaseDraw *bd, C4DGLuint bmp, Vector *padr4, Vector *cadr, Vector *vnadr, Vector *uvadr, LONG pntcnt, LONG alphamode);
	void						(*InitClipbox					)(BaseDraw *bd, LONG left, LONG top, LONG right, LONG bottom, LONG flags);
	void						(*InitView						)(BaseDraw *bd, BaseContainer *camera, const Matrix &op_m, Real sv, Real pix_x, Real pix_y, Bool fitview);
	void						(*InitializeView			)(BaseDraw *bd, BaseDocument *doc, BaseObject *cam, Bool editorsv);
	void						(*AddMessageHook			)(BaseDraw *bd, BaseDrawMessageHook fn);
	void						(*SetTexture					)(BaseDraw *bd, BaseBitmap *bm, Bool tile, LONG alphamode);
	void						(*SetSceneCamera			)(BaseDraw *bd, BaseObject *op, Bool animate);
	void            (*SetMatrix_ScreenOM  )(BaseDraw *bd, LONG zoffset, const Matrix4* m);

	void						(*BbSetDisplay				)(BaseDrawHelp *bb, BaseContainer *bc);
	BaseDrawHelp   *(*BbAlloc   					)(BaseDraw *bd, BaseDocument *doc);
	void            (*BbFree    					)(BaseDrawHelp *&p);

	Bool						(*InitDrawXORLine			)(BaseDraw *bd);
	void						(*FreeDrawXORLine			)(BaseDraw *bd);
	void						(*DrawXORPolyLine			)(BaseDraw *bd, const Real* p, LONG cnt);
	void						(*BeginDrawXORPolyLine)(BaseDraw *bd);
	void						(*EndDrawXORPolyLine	)(BaseDraw *bd, Bool blit);
	BaseDraw*				(*AllocBaseDraw				)();
	void						(*FreeBaseDraw				)(BaseDraw*& bv);

	Bool						(*DrawScene						)(BaseDraw* bd, LONG flags);
	const Matrix&		(*BbGetMg							)(BaseDrawHelp *bb);
};

struct C4D_BaseView
{
	void						(*GetFrame						)(BaseView *bv, LONG *cl, LONG *ct, LONG *cr, LONG *cb);
	void						(*GetSafeFrame				)(BaseView *bv, LONG *from, LONG *to, LONG *horizontal);
	void						(*GetParameter				)(BaseView *bv, Vector *offset, Vector *scale, Vector *scale_z);
	Matrix					(*GetMg								)(BaseView *bv);
	Matrix					(*GetMi								)(BaseView *bv);
	LONG						(*GetProjection				)(BaseView *bv);
	Bool						(*TestPoint						)(BaseView *bv, Real x, Real y);
	Bool						(*TestPointZ					)(BaseView *bv, const Vector &p);
	Bool						(*TestClipping3D			)(BaseView *bv, const Vector &mp, const Vector &rad, const Matrix &mg, Bool *clip2d, Bool *clipz);
	Bool						(*ClipLine2D					)(BaseView *bv, Vector *p1, Vector *p2);
	Bool						(*ClipLineZ						)(BaseView *bv, Vector *p1, Vector *p2);
	Vector					(*WS									)(BaseView *bv, const Vector &p);
	Vector					(*SW									)(BaseView *bv, const Vector &p);
	Vector					(*SW_R								)(BaseView *bv, Real x, Real y, const Vector &wp);
	Vector					(*WC									)(BaseView *bv, const Vector &p);
	Vector					(*CW									)(BaseView *bv, const Vector &p);
	Vector					(*SC									)(BaseView *bv, const Vector &p);
	Vector					(*CS									)(BaseView *bv, const Vector &p, Bool z_inverse);
	Vector					(*WC_V								)(BaseView *bv, const Vector &v);
	Vector					(*CW_V								)(BaseView *bv, const Vector &v);
	Bool						(*BackfaceCulling			)(BaseView *bv, const Vector &n, const Vector &p);
	Bool						(*ZSensitive					)(BaseView *bv);

	ViewportSelect* (*VSAlloc   					)();
	void            (*VSFree    					)(ViewportSelect *&p);
	Bool						(*VSInitObj 					)(ViewportSelect *vs, LONG w, LONG h, BaseDraw* bd, BaseObject* op, LONG mode, Bool onlyvisible, LONG flags);
	Bool						(*VSInitAr  					)(ViewportSelect *vs, LONG w, LONG h, BaseDraw* bd, AtomArray* ar, LONG mode, Bool onlyvisible, LONG flags);
	ViewportPixel*	(*VSGetPixelInfoPoint )(ViewportSelect *vs, LONG x, LONG y);
	ViewportPixel*	(*VSGetPixelInfoPolygon)(ViewportSelect *vs, LONG x, LONG y);
	ViewportPixel*	(*VSGetPixelInfoEdge  )(ViewportSelect *vs, LONG x, LONG y);
	void            (*VSShowHotspot				)(ViewportSelect *p, EditorWindow *bw, LONG x, LONG y);
	void            (*VSSetBrushRadius		)(ViewportSelect *p, LONG r);
	ViewportPixel*	(*VSGetNearestPointEx )(ViewportSelect *vs, BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected);
	ViewportPixel*	(*VSGetNearestPolygonEx)(ViewportSelect *vs, BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected);
	ViewportPixel*	(*VSGetNearestEdgeEx  )(ViewportSelect *vs, BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected);
	void          	(*VSClearPixelInfo    )(ViewportSelect *vs, LONG x, LONG y, UCHAR mask);
	Bool						(*VSGetCameraCoordinates)(ViewportSelect *vs, Real x, Real y, Real z, Vector &v);
	Real						(*ZSensitiveNearClipping)(BaseView *bv);
	Bool						(*VSDrawPolygon				)(ViewportSelect *vs, const Vector* p, LONG ptcnt, LONG i, BaseObject* op, Bool onlyvisible);
	Bool						(*VSDrawHandle				)(ViewportSelect *vs, const Vector& p, LONG i, BaseObject* op, Bool onlyvisible);
	LONG						(*GetFrameScreen			)(BaseDraw *bv, LONG *cl, LONG *ct, LONG *cr, LONG *cb);
	const Matrix4&	(*GetViewMatrix				)(BaseDraw *bv, LONG n);
	Bool						(*VSPickObject				)(BaseDraw* bd, BaseDocument* doc, LONG x, LONG y, LONG rad, Bool allowOpenGL, LassoSelection* ls, C4DObjectList* list);
	ViewportPixel*	(*VSGetNearestPoint   )(ViewportSelect *vs, BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected, LONG* ignorelist, LONG ignorecnt);
	ViewportPixel*	(*VSGetNearestPolygon )(ViewportSelect *vs, BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected, LONG* ignorelist, LONG ignorecnt);
	ViewportPixel*	(*VSGetNearestEdge    )(ViewportSelect *vs, BaseObject* op, LONG &x, LONG &y, LONG maxrad, Bool onlyselected, LONG* ignorelist, LONG ignorecnt);
	void            (*VSShowHotspotS			)(EditorWindow *bw, LONG x, LONG y, LONG rad, Bool bRemove);

};

struct C4D_Pool
{
	MemoryPool*			(*Alloc								)(VLONG block_size);
	void						(*Free								)(MemoryPool *pool);
	void*						(*AllocElement				)(MemoryPool *pool, VLONG size, Bool clear);
	void						(*FreeElement					)(MemoryPool *pool, void *mem, VLONG size);
	void*						(*AllocElementS				)(MemoryPool *pool, VLONG size, Bool clear);
	void						(*FreeElementS				)(MemoryPool *pool, void *mem);
};

typedef void (*GeExecuteProgramExCallback)(LONG cmd, void *userdata, const Filename &logfile);

struct C4D_General
{
	void*						(*AllocEx							)(VLONG size);
	void						(*Free								)(void *data);
	void						(*Print								)(const String *str);

	Bool						(*FExist							)(const Filename *name, Bool isdir);
	Bool						(*SearchFile					)(const Filename *directory, const Filename *name, Filename *found);
	Bool						(*FKill								)(const Filename *name, LONG flags);
	Bool						(*FCopyFile						)(const Filename *source, const Filename *dest, LONG flags);
	Bool						(*FRename							)(const Filename *source, const Filename *dest);
	Bool						(*FCreateDir					)(const Filename *name);
	Bool						(*ExecuteFile					)(const Filename *path);
	Filename*				(*GetStartupPath			)(void);
	Bool						(*ExecuteProgram      )(const Filename *program, const Filename *file);

	void						(*ShowMouse						)(LONG v);
	void						(*GetSysTime					)(LONG *year, LONG *month, LONG *day, LONG *hour, LONG *minute, LONG *second);
	LONG						(*GetTimer						)(void);
	void						(*GetLineEnd					)(String *str);
	LONG						(*GetDefaultFPS				)(void);
	LONG						(*OutString						)(const String *str, LONG flags);
	LONG						(*GetCurrentOS				)(void);
	LONG						(*GetByteOrder				)(void);
	void						(*GetGray							)(LONG *r, LONG *g, LONG *b);
	Bool						(*ChooseColor					)(Vector *col);
	void						(*GetSerialInfoEx			)(String *s1, String *s2, String *s3, String *s4, String *s5, String *s6);
	Bool						(*RegisterPluginEx		)(LONG api_version, LONG type, LONG id,String *str,void *data);
	void						(*GetNewMarkerEx			)(ULONG *l1, ULONG *l2);
	void						(*SetMousePointer			)(LONG l);
	Bool						(*ShowBitmap1					)(const Filename *fn);
	Bool						(*ShowBitmap2					)(BaseBitmap *bm);
	void						(*StopAllThreads			)(void);
	void						(*StatusClear					)(void);
	void						(*StatusSetSpin				)(void);
	void						(*StatusSetBar				)(LONG p);
	void						(*StatusSetText				)(const String *str);
	void						(*SpecialEventAdd			)(LONG type, VULONG p1, VULONG p2);
	Bool						(*DrawViews						)(LONG flags, BaseDraw *bd); // the new parameter is safe because it's enabled with a flag!
	void*						(*SendModelingCommandEx)(LONG command, BaseDocument *doc, BaseObject *op, const BaseContainer *bc, LONG mode);
	void						(*GetGlobalTexturePath)(LONG i, Filename *fn);
	void						(*SetGlobalTexturePath)(LONG i, const Filename *fn);
	Bool						(*GenerateTexturePathEx)(const Filename *docpath, const Filename *srcname, Filename *dstname);
	void						(*FlushTextureEx			)(const String *name);
	void						(*FlushUnusedTextures	)(void);
	void						(*GetWorldContainer		)(BaseContainer *bc);
	void						(*ErrorStringDialog   )(LONG type, Real x, Real y, LONG is);

	void						(*lSwapEx							)(void *adr, LONG cnt);
	void						(*wSwapEx							)(void *adr, LONG cnt);
	void						(*lIntelEx						)(void *adr, LONG cnt);
	void						(*wIntelEx						)(void *adr, LONG cnt);
	void						(*lMotorEx						)(void *adr, LONG cnt);
	void						(*wMotorEx						)(void *adr, LONG cnt);

	void						(*InsertBaseDocument	)(BaseDocument *doc);
	void						(*SetActiveDocument		)(BaseDocument *doc);
	BaseDocument*		(*GetActiveDocument		)(void);
	BaseDocument*		(*GetFirstDocument		)(void);
	void						(*KillDocument				)(BaseDocument *doc);
	Bool						(*LoadFile						)(const Filename *name);
	Bool						(*LoadDocumentEx			)(BaseDocument *doc, const Filename *name, Bool show_error);
	Bool						(*SaveDocument				)(BaseDocument *doc, const Filename *name, LONG saveflags, LONG format);
	LONG						(*RenderDocument			)(BaseDocument *doc, ProgressHook *pr, void *private_data, BaseBitmap *bmp, const BaseContainer *rdata, LONG renderflags, Bool dummy, BaseThread *th, LONG v_left, LONG v_top, LONG v_right, LONG v_bottom);
	Vector					(*GetColor						)(LONG i);
	Bool						(*RegisterPlugin			)(LONG api_version, LONG type, LONG id, const String *str,void *data,LONG datasize);
	void						(*GetSerialInfo				)(LONG type, String *s1, String *s2, String *s3, String *s4, String *s5, String *s6);
	LONG						(*GetVersionType			)(void);
	void						(*FlushTextureExEx		)(const Filename *docpath, const String *name);
	Bool						(*ReadPluginInfo			)(LONG pluginid, CHAR *buffer, LONG size);
	Bool						(*WritePluginInfo			)(LONG pluginid, CHAR *buffer, LONG size);

	void						(*EwDrawXORLine				)(EditorWindow *win, LONG x1,LONG y1,LONG x2,LONG y2);
	void						(*EwMouseDragStart		)(EditorWindow *win, LONG button,Real mx,Real my,LONG flag);
	LONG						(*EwMouseDrag					)(EditorWindow *win, Real *mx,Real *my,BaseContainer *channels);
	LONG						(*EwMouseDragEnd			)(EditorWindow *win);
	Bool						(*EwBfGetInputState		)(EditorWindow *win, LONG askdevice,LONG askchannel,BaseContainer *res);
	Bool						(*EwBfGetInputEvent		)(EditorWindow *win, LONG askdevice,BaseContainer *res);

	Bool						(*GetMovieInfoEx			)(const Filename *name, LONG *frames, LONG *fps);
	LONG						(*ShowPopupMenuEx     )(CDialog *parent,LONG screenx,LONG screeny,const BaseContainer *bc,LONG flags);

	Bool						(*RegistryAdd         )(LONG sub_id, LONG main_id, void *data);
	Bool						(*RegistryRemove      )(LONG sub_id, LONG main_id);
	Registry*				(*RegistryFind				)(LONG sub_id, LONG main_id);
	Registry*				(*RegistryFindLast		)(LONG main_id);
	Registry*				(*RegistryFindFirst		)(LONG main_id);
	Registry*				(*RegistryFindPrev		)(Registry *last);
	Registry*				(*RegistryFindNext		)(Registry *last);
	Bool						(*RegistryGetAutoID		)(LONG *id);
	Bool						(*RegistryGetData			)(Registry *reg, LONG *main_id, LONG *sub_id, void **data);

	void*						(*Alloc								)(VLONG size,LONG line,const CHAR *file);
	void						(*BoomEx							)(void);
	BaseContainer*	(*GetWorldPluginData  )(LONG id);
	Bool						(*SetWorldPluginData  )(LONG id, const BaseContainer *bc, Bool add);
	Bool            (*SyncMessage         )(LONG message, LONG core_id, VLONG par1, VLONG par2);
	void						(*SetWorldContainer		)(const BaseContainer *bc);
	Bool						(*PluginMessage				)(LONG id, void *data);

	BasePlugin*			(*FindPlugin										)(LONG id, LONG type);
	BasePlugin*			(*GetFirstPlugin								)(void);
	void*						(BasePlugin::*GetPluginStructure)();
	Filename				(BasePlugin::*GetFilename				)(void);
	LONG						(BasePlugin::*GetID							)(void) const;
	LONG						(BasePlugin::*GetInfo						)(void) const;

	Bool						(*ChooseFont					)(BaseContainer *col);

	void						(*GeDebugBreak				)(LONG line, const CHAR *file);
	void						(*GeDebugOut					)(const CHAR* s,...);
	Bool						(*RenameDialog				)(String *str);
	Bool						(*OpenHTML						)(const String &webaddress);
	Bool						(*SendModelingCommand )(LONG command, ModelingCommandData &data);

	void						(*EventAdd						)(LONG flags);
	void						(*FindInManager				)(BaseList2D *bl);

	CUSTOMDATATYPEPLUGIN*		(*FindCustomDataTypePlugin		)(LONG type);
	RESOURCEDATATYPEPLUGIN*	(*FindResourceDataTypePlugin	)(LONG type);

	void						(*GeSleep							)(LONG milliseconds);
	GeData					(*SendCoreMessage			)(LONG coreid, const BaseContainer &msg, LONG eventid);
	Bool						(*CheckIsRunning			)(LONG type);
	BaseContainer*	(*GetWorldContainerInstance)(void);

	Bool						(*GenerateTexturePath )(const Filename &docpath, const Filename &srcname, const Filename &suggestedpath, Filename *dstname);
	Bool						(*IsInSearchPath			)(const Filename &texfilename, const Filename &docpath);

	BaseContainer*	(*GetToolPluginData   )(BaseDocument *doc, LONG id);
	Bool						(*IsMainThread				)(void);


	Filename				(*GetDefaultFilename  )(LONG id);

	Bool						(*AddBackgroundHandler					)(BackgroundHandler *handler, void *tdata, LONG typeclass, LONG priority);
	Bool						(*RemoveBackgroundHandler				)(void *tdata, LONG typeclass);
	void						(*StopBackgroundThreads					)(LONG typeclass, LONG flags);
	Bool						(*CheckBackgroundThreadsRunning	)(LONG typeclass, Bool all);
	void						(*ProcessBackgroundThreads			)(LONG typeclass);

	void						(*FlushTexture									)(const Filename *docpath, const String *name, const Filename &suggestedfolder);

	Bool						(*GetMovieInfo									)(const Filename *name, LONG *frames, Real *fps);
	String          (*GetObjectName                 )(LONG type);
	String          (*GetTagName                    )(LONG type);
	LONG            (*GetObjectType                 )(const String &name);
	LONG            (*GetTagType                    )(const String &name);

	void            (*CopyToClipboard               )(const String &str);

	void*						(*AllocNC												)(VLONG size,LONG line,const CHAR *file);
	BaseContainer*	(*GetToolData										)(BaseDocument *doc,LONG pluginid);
	Bool						(*GeGetMemoryStat								)(BaseContainer &stat);
	Bool						(*PopupEditText									)(LONG screenx,LONG screeny, LONG width, LONG height,const String &changeme,LONG flags,PopupEditTextCallback *func, void *userdata);

	Bool						(*EWScreen2Local								)(EditorWindow *win, LONG *x, LONG *y);
	Bool						(*EWLocal2Screen								)(EditorWindow *win, LONG *x, LONG *y);

	void						(*StartEditorRender							)(Bool active_only, Bool raybrush, LONG x1, LONG y1, LONG x2, LONG y2, BaseThread *bt, BaseDraw *bd, Bool newthread);

	String					(*FormatNumberEx								)(GeData val, LONG format, LONG fps);
	GeData					(*StringToNumber								)(const String &text, LONG format, LONG fps);

	Bool						(*IsActiveToolEnabled						)();
	LONG						(*GetSystemInfo									)(void);
	Bool						(*PrivateSystemFunction01				)(void *par1);
	Bool						(*GetLanguage										)(LONG index, String *extension, String *name, Bool *default_language);

	GeListHead*			(*GetScriptHead									)(LONG type);
	LONG						(*GetDynamicScriptID						)(BaseList2D *bl);
	Real						(*GetToolScale									)(BaseDraw* bd, AtomArray* arr, Bool all, LONG mode);
	Bool						(*GetCommandLineArgs						)(C4DPL_CommandLineArgs &args);
	Bool						(*FilterPluginList							)(AtomArray &arr, LONG type, Bool sortbyname);

	Bool						(*LoadDocument									)(BaseDocument *doc, const Filename &name, LONG loadflags, BaseThread *bt);
	void						(*FrameScene										)(BaseDocument *doc);
	LONG						(*IdentifyFile									)(const Filename &name, UCHAR *probe, LONG probesize, LONG recognition, BasePlugin **bp);
	Filename				(*GetC4DPath										)(LONG whichpath);

	void						(*llSwapEx											)(void *adr, LONG cnt);
	void						(*llIntelEx											)(void *adr, LONG cnt);
	void						(*llMotorEx											)(void *adr, LONG cnt);

	Bool						(*FMove													)(const Filename &source, const Filename &dest);

	Bool						(*HandleViewCommand							)(LONG command_id, BaseDocument *doc, BaseDraw *bd, LONG *value);

	Bool						(*AddUndoHandler								)(BaseDocument *doc, void *dat, LONG type);

	String					(*GeGetDegreeChar               )();
	String					(*GeGetPercentChar              )();
	Bool						(*HandleCommand									)(LONG command_id, LONG *value);

	void						(*lSwap  												)(void *adr, VLONG cnt);
	void						(*wSwap  												)(void *adr, VLONG cnt);
	void						(*lIntel  											)(void *adr, VLONG cnt);
	void						(*wIntel  											)(void *adr, VLONG cnt);
	void						(*lMotor  											)(void *adr, VLONG cnt);
	void						(*wMotor  											)(void *adr, VLONG cnt);
	void						(*llSwap												)(void *adr, VLONG cnt);
	void						(*llIntel												)(void *adr, VLONG cnt);
	void						(*llMotor												)(void *adr, VLONG cnt);

	void*						(*GeCipher256Open								)(const UCHAR *key, LONG klength, Bool stream);
	void						(*GeCipher256Close							)(void* h);
	void						(*GeCipher256EncryptEx					)(void* h, UCHAR *bytes256);
	void						(*GeCipher256DecryptEx					)(void* h, UCHAR *bytes256);

	IpConnection*		(*IpOpenListenerEx							)(ULONG ipAddr, LONG port, BaseThread* thread, LONG* ferr);
	IpConnection*		(*IpWaitForIncoming							)(IpConnection* listener, BaseThread* connection, LONG *ferr);
	IpConnection*		(*IpOpenOutgoingEx							)(CHAR* hostname, BaseThread* thread, LONG* ferr);
	void						(*IpCloseConnection							)(IpConnection* ipc);
	void						(*IpKillConnection							)(IpConnection *ipc);
	LONG						(*IpBytesInInputBuffer					)(IpConnection* ipc);
	LONG						(*IpReadBytes										)(IpConnection* ipc, void* buf, LONG size);
	LONG						(*IpSendBytes										)(IpConnection* ipc, void* buf, LONG size);
	void						(*IpGetHostAddr									)(IpConnection* ipc, CHAR *buf, LONG bufsize);
	void						(*IpGetRemoteAddr								)(IpConnection* ipc, CHAR *buf, LONG bufsize);

	Bool						(*RecordCommand									)(LONG command_id, LONG flags, const String &str);

	Bool						(*SendMailAvailable							)();
	Bool						(*SendMail											)(const String &t_subject, const String *t_to, const String *t_cc, const String *t_bcc, Filename *t_attachments,const String &t_body, LONG flags);
	Bool						(*GetSystemEnvironmentVariable  )(const String &varname, String &result);
	Bool						(*CallHelpBrowser								)(const String &optype, const String &main, const String &group, const String &property);
	String					(*FormatNumber                  )(GeData val, LONG format, LONG fps, Bool bUnit);

	void			      (*BuildGlobalTagPluginContainer	 )(BaseContainer *plugincontainer,LONG *id);
	LONG			      (*ResolveGlobalTagPluginContainer)(LONG *id);
	Vector					(*GetGuiWorldColor							)(LONG cid);

	LONG						(*GetShortcutCount							)();
	BaseContainer		(*GetShortcut										)(LONG index);
	Bool						(*AddShortcut										)(const BaseContainer &bc);
	Bool						(*RemoveShortcut								)(LONG index);
	Bool						(*LoadShortcutSet								)(const Filename &fn, Bool add);
	Bool						(*SaveShortcutSet								)(const Filename &fn);
	LONG						(*FindShortcutsFromID						)(LONG pluginid, LONG *indexarray, LONG maxarrayelements);
	LONG						(*FindShortcuts									)(const BaseContainer &scut, LONG *pluginidarray, LONG maxarrayelements);
	void						(*SetViewColor									)(LONG colid, const Vector &col);

	void						(*RemovePlugin									)(BasePlugin *plug);

	Bool						(*GetAllocSize									)( void *p, VLONG *out_size );
	void            (*InsertCreateObject            )(BaseDocument *doc, BaseObject *op, BaseObject *activeobj);

	void						(*GeCipher256Encrypt						)(void *h, UCHAR *mem, LONG size);
	void						(*GeCipher256Decrypt						)(void *h, UCHAR *mem, LONG size);

	IpConnection*		(*IpOpenListener								)(ULONG ipAddr, LONG port, BaseThread* thread, LONG timeout, Bool dontwait, LONG* ferr);
	IpConnection*		(*IpOpenOutgoing								)(CHAR* hostname, BaseThread* thread, LONG initial_timeout, LONG timeout, Bool dontwait, LONG* ferr);
	String					(*DateToString									)(const LocalFileTime &t, Bool date_only);
	Bool						(*ShowInFinder									)(const Filename &fn, Bool open);

	Bool						(*WriteLayout										)(const Filename &fn);
	Bool						(*WritePreferences							)(const Filename &fn);
	Bool						(*SaveProjectCopy								)(BaseDocument *t_doc, const Filename &directory, Bool allow_gui);

	LONG						(*ShowPopupMenu									)(CDialog *parent,LONG screenx,LONG screeny,const BaseContainer *bc,LONG flags, LONG *res_mainid);

	Bool						(*AskForAdministratorPrivileges	)(const String &msg, const String &caption, Bool bAllowSuperUser, void **token);
	void						(*EndAdministratorPrivileges		)();
	void						(*RestartApplication						)(const UWORD* param, LONG exitcode, const UWORD** path);
	Filename*				(*GetStartupApplication					)(void);

	Bool						(*EWGlobal2Local								)(EditorWindow *win, LONG *x, LONG *y);
	Bool						(*EWLocal2Global								)(EditorWindow *win, LONG *x, LONG *y);

	Bool						(*RequestFileFromServer					)(const Filename &fn, Filename &res);
	Bool						(*ReadPluginReg									)(LONG pluginid, CHAR *buffer, LONG size);
	Bool						(*WritePluginReg								)(LONG pluginid, CHAR *buffer, LONG size);
	Bool						(*GeFGetDiskFreeSpace						)(const Filename &vol, LULONG &freecaller, LULONG &total, LULONG &freespace);
	ULONG						(*GeFGetAttributes							)(const Filename *name);
	Bool						(*GeFSetAttributes							)(const Filename *name, ULONG flags, ULONG mask);

	void						(*BrowserLibraryPopup						)(LONG mx, LONG my, LONG defw, LONG defh, LONG pluginwindowid, LONG presettypeid, void *userdata, BrowserPopupCallback callback);
	Bool						(*GeExecuteProgramEx						)(const Filename &program, const String *args, LONG argcnt, GeExecuteProgramExCallback callback, void *userdata);
	LReal						(*GeGetMilliSeconds							)(void);

	void*						(*ReallocNC											)(void *old_data, VLONG new_size, LONG line, const CHAR *file);
	Bool						(*GeGetAllocatorStatistics			)( BaseContainer &stat, void *in_allocator );
	VULONG					(*GeMemGetFreePhysicalMemoryEstimate)( void );
	void            (*CopyToClipboardB              )(BaseBitmap *map, LONG ownerid);
	Bool            (*GetStringFromClipboard        )(String *txt);
	Bool            (*GetBitmapFromClipboard        )(BaseBitmap *map);
	ClipboardType   (*GetClipboardType              )(void);

	void						(*EndGlobalRenderThread					)(Bool external_only);
	LONG						(*GeDebugSetFloatingPointChecks	)(LONG on);
	LONG						(*GetC4DClipboardOwner					)(void);
	void						(*GeCheckMem										)(void *memptr);
};

struct C4D_Link
{
	BaseLink*				(*Alloc								)(void);
	void						(*Free								)(BaseLink *link);
	BaseList2D*			(*GetLink							)(const BaseLink *link, const BaseDocument *doc, LONG instanceof);
	void						(*SetLink							)(BaseLink *link, C4DAtomGoal *list);
	Bool						(*Read								)(BaseLink *link, HyperFile *hf);
	Bool						(*Write								)(const BaseLink *link, HyperFile *hf);
	BaseLink*				(*GetClone						)(const BaseLink *link, LONG flags, AliasTrans *trn);
	Bool						(*CopyTo							)(const BaseLink *src, BaseLink *dst, LONG flags, AliasTrans *trn);
	AliasTrans*			(*TrnAlloc						)(void);
	Bool						(*TrnInit							)(AliasTrans *trn, const BaseDocument *doc);
	void						(*TrnFree							)(AliasTrans *trn);
	void						(*TrnTranslate				)(AliasTrans *trn, Bool connect_oldgoals);
	BaseList2D*			(*ForceGetLink				)(const BaseLink *link);
	Bool						(*IsCacheLink					)(const BaseLink *link);
	C4DAtomGoal*		(*GetLinkAtom					)(const BaseLink *link, const BaseDocument *doc, LONG instanceof);
	C4DAtomGoal*		(*ForceGetLinkAtom		)(const BaseLink *link);
};

struct C4D_Neighbor
{
	EnumerateEdges*	(*Alloc								)(LONG pcnt, const CPolygon *vadr, LONG vcnt, BaseSelect *bs);
	void						(*Free								)(EnumerateEdges *nb);
	void						(*GetEdgePolys				)(EnumerateEdges *nb, LONG a, LONG b,LONG *first,LONG *second);
	void						(*GetPointPolys				)(EnumerateEdges *nb, LONG pnt, LONG **dadr, LONG *dcnt);
	LONG						(*GetEdgeCount				)(EnumerateEdges *nb);
	PolyInfo*				(*GetPolyInfo					)(EnumerateEdges *nb, LONG poly);
	Bool    				(*GetNGons  					)(EnumerateEdges *nb, PolygonObject* op, LONG &ngoncnt, NgonNeighbor *&ngons);
	void						(*ResetAddress				)(EnumerateEdges *nb, const CPolygon *a_polyadr);
};

struct C4D_Painter
{
	void*						(*SendPainterCommand  )(LONG command, BaseDocument *doc, PaintTexture *tex, const BaseContainer *bc);
	Bool						(*OptimalMappingEx		)(PMStruct *pm_adr, CPolygon *vadr, LONG vcnt, Vector *padr, LONG pcnt, Bool progressbar, const BaseContainer *bc);

	// new in BP2
	Bool						(*CallUVCommand				)(const Vector *padr, LONG PointCount, const CPolygon *polys, LONG lPolyCount, UVWStruct *uvw, BaseSelect *polyselection,
																						BaseSelect* pointselection, BaseObject*op, LONG mode, LONG cmdid, const BaseContainer &settings);

	TempUVHandle*		(*GetActiveUVSet			)(BaseDocument* doc, LONG flags);
	void						(*FreeActiveUVSet			)(TempUVHandle *handle);

	LONG						(*UVSetGetMode				)(TempUVHandle *handle);
	const Vector*		(*UVSetGetPoint				)(TempUVHandle *handle);
	LONG						(*UVSetGetPointCount	)(TempUVHandle *handle);
	const CPolygon*	(*UVSetGetPoly				)(TempUVHandle *handle);
	LONG						(*UVSetGetPolyCount		)(TempUVHandle *handle);
	UVWStruct*			(*UVSetGetUVW					)(TempUVHandle *handle);
	BaseSelect*			(*UVSetGetPolySel			)(TempUVHandle *handle);
	BaseSelect*			(*UVSetGetPointSel		)(TempUVHandle *handle);
	BaseObject*			(*UVSetGetBaseObject	)(TempUVHandle *handle);

	Bool						(*UVSetSetUVW					)(TempUVHandle *handle, UVWStruct *uv);

	Bool						(*Private1						)(LONG lCommand, AtomArray* pArray, BaseSelect **polyselection,BaseContainer& setttings, BaseThread* th);

	PaintTexture*		(*CreateNewTexture		)(const Filename &path, const BaseContainer &settings);
	Bool						(*GetTextureDefaults	)(LONG channel,BaseContainer &settings);

	Bool						(*UVSetIsEditable			)(TempUVHandle *handle);

	LONG						(*IdentifyImage				)(const Filename &texpath);
	Bool						(*BPSetupWizardWithParameters)(BaseDocument *doc, const BaseContainer &settings, AtomArray &objects, AtomArray &material);

	// 8.6 extension
	Bool						(*CalculateTextureSize)(BaseDocument *doc, AtomArray &materials, TextureSize *&sizes);

	// 9.1 extension
	LONG						(*PB_GetBw)(PaintBitmap *bmp);
	LONG						(*PB_GetBh)(PaintBitmap *bmp);
	PaintLayer*			(*PB_GetLayerDownFirst)(PaintBitmap *tex);
	PaintLayer*			(*PB_GetLayerDownLast)(PaintBitmap *tex);
	PaintLayerBmp*	(*PT_AddLayerBmp)(PaintTexture *tex,PaintLayer *insertafter,PaintLayer *layerset,LONG mode,Bool useundo, Bool activate);
	GeListHead*			(*PT_GetPaintTextureHead)();
	Bool						(*PLB_ImportFromBaseBitmap)(PaintLayerBmp *layer,BaseBitmap *bmp, Bool usealpha);
	Bool						(*PLB_ImportFromBaseBitmapAlpha)(PaintLayerBmp *layer,BaseBitmap *bmp,AlphaBitmap *channel);
	Bool						(*PLB_GetPixelCnt)(PaintLayerBmp *layer,LONG x,LONG y,LONG num,PIX *dst,LONG dstmode,LONG flags);
	PaintTexture*		(*GetPaintTextureOfBaseChannel)(BaseDocument *doc,BaseChannel *bc);

	LayerSetSelection*(*LSL_Alloc)();
	void						(*LSL_Free)(LayerSetSelection *layerset);
	Bool						(*LSL_Content)(const LayerSetSelection *l);
	Bool						(*LSL_IsLayerEnabled)(const LayerSetSelection *l,const String &name);
	Bool						(*LSL_FindLayerSet)(const LayerSetSelection *l,const String &name);
	String					(*LSL_GetName)(const LayerSetSelection *l);
	LONG						(*LSL_GetMode)(const LayerSetSelection *l);
	void						(*LSL_SetMode)(LayerSetSelection *l,LONG t_mode);
	void						(*LSL_RemoveLayer)(LayerSetSelection *l,const String &layer);
	void						(*LSL_AddLayer)(LayerSetSelection *l,const String &layer);
	void						(*LSL_FlushLayers)(LayerSetSelection *l);
	Bool						(*LSL_operator_cmp)(const LayerSetSelection *l,const LayerSetSelection &layerset);
	void						(*LSL_CopyTo)(const LayerSetSelection *l,LayerSetSelection &dst);
	Bool						(*GetAllStrings_AddTexture)(const void *msgdata, const BaseContainer &d);

	PaintTexture*		(*PB_GetPaintTexture)(PaintBitmap *bmp);
	PaintBitmap*		(*PB_GetParent)(PaintBitmap *bmp);
	PaintLayer*			(*PB_GetAlphaFirst)(PaintBitmap *bmp);
	PaintLayer*			(*PB_GetAlphaLast)(PaintBitmap *bmp);
	PaintLayerBmp*	(*PB_AddAlphaChannel)(PaintBitmap *bmp,LONG bitdepth,PaintLayer *prev,Bool undo, Bool activate);
	Bool						(*PB_AskApplyAlphaMask)(PaintBitmap *bmp);
	void						(*PB_ApplyAlphaMask)(PaintBitmap *bmp,LONG x,LONG y,LONG num,PIX *bits,LONG mode,Bool inverted, LONG flags);
	PaintLayerMask*	(*PB_FindSelectionMask)(PaintBitmap *bmp,PaintBitmap **toplevel,LONG *bitdepth);
	LONG						(*PB_GetColorMode)(PaintBitmap *bmp);
	ULONG						(*PB_GetDirty)(PaintBitmap *bmp,LONG flags);
	void						(*PB_UpdateRefresh)(PaintBitmap *bmp,LONG xmin,LONG ymin,LONG xmax,LONG ymax,ULONG flags);
	void						(*PB_UpdateRefreshAll)(PaintBitmap *bmp,ULONG flags,Bool reallyall);
	Bool						(*PB_ReCalc)(PaintBitmap *bmpthis,BaseThread *thread,LONG x1,LONG y1,LONG x2,LONG y2,BaseBitmap *bmp,LONG flags,ULONG showbit);
	Bool						(*PB_ConvertBits)(LONG num,const PIX *src,LONG srcinc,LONG srcmode,PIX *dst,LONG dstinc,LONG dstmode,LONG dithery,LONG ditherx);
	Bool						(*PLB_SetPixelCnt)(PaintLayerBmp *layer,LONG x,LONG y,LONG num,const PIX *src,LONG incsrc,LONG srcmode,LONG flags);
	void						(*PLB_GetBoundingBox)(PaintLayerBmp *layer,LONG &x1,LONG &y1,LONG &x2,LONG &y2, Bool hasselectionpixels);
	PaintLayerFolder*(*PT_AddLayerFolder)(PaintTexture *tex,PaintLayer *insertafter,PaintLayer *insertunder,Bool useundo, Bool activate);
	void						(*PT_SetActiveLayer)(PaintTexture *tex,PaintLayer *layer,Bool activatetexture,Bool show);
	PaintLayer*			(*PT_GetActive)(PaintTexture *tex);
	void						(*PT_GetLinkLayers)(PaintTexture *tex,AtomArray &layers, Bool addfolders);
	Bool						(*PT_SetSelected_Texture)(PaintBitmap *bmp, PaintMaterial *preferred);
	PaintTexture*		(*PT_GetSelectedTexture)();
	PaintTexture*		(*PT_GetSelectedTexturePP)(PaintMaterial **ppmat);
	void						(*PM_EnableMaterial)(PaintMaterial *,BaseDocument *doc,Bool on,Bool suppressevent,Bool domaterialundo);
	PaintMaterial*	(*PM_GetActivePaintMaterial)(BaseDocument *doc,BaseMaterial **mat);
	PaintMaterial*	(*PM_GetPaintMaterialFromTexture)(PaintTexture *tex,Bool onlyeditable);
	PaintMaterial*	(*PM_GetPaintMaterial)(BaseDocument *dok,BaseMaterial *material,Bool create);
	Bool						(*PM_UnloadPaintMaterial)(BaseDocument *doc,BaseMaterial *material,Bool forcesave);
	Bool						(*PT_SetColorMode)(PaintTexture *tex,LONG newcolormode,Bool doundo);

	void						(*LSL_SetPreviewMode)(LayerSetSelection *l, LONG mode);
	LONG						(*LSL_GetPreviewMode)(const LayerSetSelection *l);
	LayerSetHelper *(*LSH_Alloc)();
	void						(*LSH_Free)(LayerSetHelper *lsh);
	Bool						(*LSH_Init)(LayerSetHelper *lsh, const Filename &fn, const LayerSetSelection *selection);
	Bool						(*LSH_EditLayerSet)(LayerSetHelper *lsh,const String &dialogtitle, LayerSetSelection *layerset, LayerSetSelection *layerset_a);

	Bool						(*CLL_CalculateResolution)(BaseDocument *doc, const Filename &filename, LONG *xres, LONG *yres);
	Bool						(*CLL_CalculateFilename)(BaseDocument *doc, Filename &fn, LayerSetSelection *lsl);

	Bool						(*PL_GetShowBit)(PaintLayer *bmp,Bool hierarchy, ULONG bit);
	Bool						(*PL_SetShowBit)(PaintLayer *bmp,Bool onoff, ULONG bit);
	PaintTexture*		(*PT_CreateNewTextureDialog)(String &result,Filename &resultdirectory,LONG channelid,BaseMaterial *bmat);
	void						(*PN_ActivateChannel)(LONG channel, Bool multi, Bool enable);
	const Filename  (*PT_GetFilename)(PaintTexture *tex);

	Bool						(*LSH_MergeLayerSet)(LayerSetHelper *lsh, const LayerSetSelection &selection, BaseBitmap *bmp, Bool preview);
};

struct C4D_GLSL
{
	// GlString
	void						(GlString::*SDKInit1)();
	void						(GlString::*SDKInit2)(const char* pchString);
	void						(GlString::*SDKInit3)(const GlString& str);
	void						(GlString::*SDKInit4)(LONG n);
	void						(GlString::*SDKFree)();

	const GlString&	(GlString::*SDKAssign1)(const GlString &str);
	const GlString&	(GlString::*SDKAssign2)(const char* pszString);

	GlString				(*GlStringAdd1)(const GlString &str1, const GlString &str2);
	GlString				(*GlStringAdd2)(const GlString &str1, const char* str2);

	const GlString&	(GlString::*GlStringAdd3)(const GlString &str);
	const GlString&	(GlString::*GlStringAdd4)(const char* str);

	const char*			(GlString::*GetCString)() const;
	VLONG						(GlString::*GetLength)() const;

	// GlProgramFactory
	GlProgramFactory* (*GetFactory)(C4DAtom* pObj, LONG lIndex, BaseDraw* pBaseDraw, GlLight* pLights, LONG lLightCount,
		void* pIdentity, VLONG lIdentityLength, LONG lTexCoordIndex, Bool bAllowSharing);
	void						(*RemoveReference)(C4DAtom* pObj, LONG lIndex);
	void						(*RemoveTextureReference)(C4DAtom* pObj, LONG lIndex);
	void*						(*IncreaseBufferSize)(GlGetIdentity* pIdentity, VLONG lNeededSize, LONG lLine, const char* pszFile);

	Bool						(GlProgramFactory::*BindToView)(BaseDraw* pDraw);
	Bool						(GlProgramFactory::*CompilePrograms)();
	Bool						(GlProgramFactory::*BindPrograms)();
	Bool						(GlProgramFactory::*UnbindPrograms)();
	Bool						(GlProgramFactory::*DestroyPrograms)(Bool bChangeContext);
	void						(GlProgramFactory::*LockFactory)();
	void						(GlProgramFactory::*Unlock)();
	void*						(GlProgramFactory::*GetPrivateData)(C4DAtom* pObj, LONG lDataIndex, GlProgramFactoryAllocPrivate fnAlloc, GlProgramFactoryFreePrivate fnFree);
	void*						(GlProgramFactory::*GetDescriptionData)(LONG lObjIndex, LONG lDataIndex, GlProgramFactoryAllocDescription fnAlloc, GlProgramFactoryFreeDescription fnFree);
	Bool						(GlProgramFactory::*IsProgram)(GlProgramType t);

	void						(GlProgramFactory::*InitSetParameters)();
	void						(GlProgramFactory::*SetScreenCoordinates)(BaseDraw* pBaseDraw);
	void						(GlProgramFactory::*AddErrorHandler)(GlProgramFactoryErrorHandler fn);
	Bool						(GlProgramFactory::*SetParameterMatrixState)(GlProgramType t, const char* pszName);
	Bool						(GlProgramFactory::*SetParameterMatrix1)(GlProgramType t, const char* pszName, const Matrix4 &m);
	Bool						(GlProgramFactory::*SetParameterMatrix3x3)(GlProgramType t, const char* pszName, const Real* r);
	Bool						(GlProgramFactory::*SetParameterMatrix4x4)(GlProgramType t, const char* pszName, const Real* r);
	Bool						(GlProgramFactory::*SetParameterVector1)(GlProgramType t, const char* pszName, const Vector &v);
	Bool						(GlProgramFactory::*SetParameterVector2)(GlProgramType t, const char* pszName, const Vector &v, Real w);
	Bool						(GlProgramFactory::*SetParameterReal)(GlProgramType t, const char* pszName, Real r);
	Bool						(GlProgramFactory::*SetParameterReal2a)(GlProgramType t, const char* pszName, Real a, Real b);
	Bool						(GlProgramFactory::*SetParameterReal2b)(GlProgramType t, const char* pszName, const Real* v);
	Bool						(GlProgramFactory::*SetParameterReal3a)(GlProgramType t, const char* pszName, Real a, Real b, Real c);
	Bool						(GlProgramFactory::*SetParameterReal3b)(GlProgramType t, const char* pszName, const Real* v);
	Bool						(GlProgramFactory::*SetParameterReal4a)(GlProgramType t, const char* pszName, Real a, Real b, Real c, Real d);
	Bool						(GlProgramFactory::*SetParameterReal4b)(GlProgramType t, const char* pszName, const Real* v);
	Bool						(GlProgramFactory::*SetParameterTexture2D1Ex)(GlProgramType t, const char* pszName, const BaseBitmap* pBmp, Bool bTile, LONG lAlphaMode, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTexture2D2Ex)(GlProgramType t, const char* pszName, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, Bool bTile, LONG lAlphaMode, Bool bInterpolate, LONG lMaxSize, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTexture)(GlProgramType t, const char* pszName, LONG lDimension, C4DGLuint nTexture);
	Bool						(GlProgramFactory::*SetParameterGradient)(GlProgramType t, const char* pszName, Gradient* pGradient, C4DAtom* pObj, LONG lIndex, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterFunctionTexture)(GlProgramType t, const char* pszName, C4DAtom* pObj, LONG lIndex, GlProgramFactoryCreateFnCallback fn, void* pData, VLONG lDataLen, LONG lInParams, LONG lOutParams, LONG lCycle, Bool bInterpolate, LONG lSizeX, LONG lSizeY, LONG lSizeZ, Bool bParallel, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterMatrixStateP)(GlProgramParameter param);
	Bool						(GlProgramFactory::*SetParameterMatrix1P)(GlProgramParameter param, const Matrix4 &m);
	Bool						(GlProgramFactory::*SetParameterMatrix3x3P)(GlProgramParameter param, const Real* r);
	Bool						(GlProgramFactory::*SetParameterMatrix4x4P)(GlProgramParameter param, const Real* r);
	Bool						(GlProgramFactory::*SetParameterVector1P)(GlProgramParameter param, const Vector &v);
	Bool						(GlProgramFactory::*SetParameterVector2P)(GlProgramParameter param, const Vector &v, Real w);
	Bool						(GlProgramFactory::*SetParameterRealP)(GlProgramParameter param, Real r);
	Bool						(GlProgramFactory::*SetParameterReal2aP)(GlProgramParameter param, Real a, Real b);
	Bool						(GlProgramFactory::*SetParameterReal2bP)(GlProgramParameter param, const Real* v);
	Bool						(GlProgramFactory::*SetParameterReal3aP)(GlProgramParameter param, Real a, Real b, Real c);
	Bool						(GlProgramFactory::*SetParameterReal3bP)(GlProgramParameter param, const Real* v);
	Bool						(GlProgramFactory::*SetParameterReal4aP)(GlProgramParameter param, Real a, Real b, Real c, Real d);
	Bool						(GlProgramFactory::*SetParameterReal4bP)(GlProgramParameter param, const Real* v);
	Bool						(GlProgramFactory::*SetParameterTexture2D1PEx)(GlProgramParameter param, const BaseBitmap* pBmp, Bool bTile, LONG lAlphaMode, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTexture2D2PEx)(GlProgramParameter param, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, Bool bTile, LONG lAlphaMode, Bool bInterpolate, LONG lMaxSize, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTextureP)(GlProgramParameter param, LONG lDimension, C4DGLuint nTexture);
	Bool						(GlProgramFactory::*SetParameterGradientP)(GlProgramParameter param, Gradient* pGradient, C4DAtom* pObj, LONG lIndex, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterFunctionTextureP)(GlProgramParameter param, C4DAtom* pObj, LONG lIndex, GlProgramFactoryCreateFnCallback fn, void* pData, VLONG lDataLen, LONG lInParams, LONG lOutParams, LONG lCycle, Bool bInterpolate, LONG lSizeX, LONG lSizeY, LONG lSizeZ, Bool bParallel, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetLightParameters)(GlLight* pLights, LONG lLightCount, const Matrix4& mObject);

	ULONG						(GlProgramFactory::*Init)();
	void						(GlProgramFactory::*AddParameters)(ULONG ulParameters, ULONG ulFormat);
	ULONG						(GlProgramFactory::*GetParameters)();
	ULONG						(GlProgramFactory::*GetParameterFormats)();
	GlString				(GlProgramFactory::*AddUniformParameter1)(GlProgramType t, GlUniformParamType type, const char* pszName);
	Bool						(GlProgramFactory::*HeaderFinished)();
	Bool						(GlProgramFactory::*AddLightProjection)();
	void						(GlProgramFactory::*AddLine)(GlProgramType t, const GlString &strLine);
	void						(GlProgramFactory::*StartLightLoop)();
	Bool						(GlProgramFactory::*EndLightLoop)();
	GlString				(GlProgramFactory::*GetUniqueID)();
	Bool						(GlProgramFactory::*InitLightParameters)();
	LONG						(GlProgramFactory::*GetMaxLights)();
	UCHAR*					(GlProgramFactory::*GetIdentity)();
	GlProgramParameter		(GlProgramFactory::*GetParameterHandle)(GlProgramType t, const char* pszName);
	GlString				(GlProgramFactory::*AddColorBlendFunction)(GlProgramType t, LONG lBlendMode);
	GlString				(GlProgramFactory::*AddRGBToHSVFunction)(GlProgramType t);
	GlString				(GlProgramFactory::*AddHSVToRGBFunction)(GlProgramType t);
	GlString				(GlProgramFactory::*AddRGBToHLSFunction)(GlProgramType t);
	GlString				(GlProgramFactory::*AddHLSToRGBFunction)(GlProgramType t);

	// GlFrameBuffer
	GlFrameBuffer*	(*GetFrameBufferEx)(BaseDraw* pBaseDraw, VULONG lID1, LONG lID2, UINT nWidth, UINT nHeight, LONG lColorTextureCount, LONG lDepthTextureCount, LONG lFlags);
	void						(*RemoveObjectF)(VULONG lID1, LONG lID2);

	void						(GlFrameBuffer::*PrepareForRendering)(LONG lTexture);
	void						(GlFrameBuffer::*SetInterpolation)(LONG lInterpolate, LONG lTexture);
	Bool						(GlFrameBuffer::*Activate)(BaseDraw* pBaseDraw);
	void						(GlFrameBuffer::*Deactivate)(BaseDraw* pBaseDraw);
	Bool						(GlFrameBuffer::*SetRenderTarget)(LONG lTexture, LONG lFlags);
	void						(GlFrameBuffer::*GetRatios)(Real& rWidth, Real& rHeight);
	void						(GlFrameBuffer::*GetSize)(UINT &nWidth, UINT &nHeight, Bool bFramesize);
	C4DGLuint				(GlFrameBuffer::*GetTexture)(LONG lTexture, LONG lFlags);
	LONG						(GlFrameBuffer::*SaveTextureToDisk)(const Filename &fn, LONG lTexture, LONG lFlags);
	Bool						(GlFrameBuffer::*CopyToBitmap)(BaseBitmap* pBmp, LONG lTexture, LONG lFlags);
	void						(GlFrameBuffer::*Clear1)();
	void						(GlFrameBuffer::*Clear2)(const Vector &vColor, Real rAlpha);
	Bool						(GlFrameBuffer::*DrawBuffer)(LONG lTexture, LONG lFlags, Real rAlpha, const Vector &vColor);
	Bool						(GlFrameBuffer::*IsNPOTBuffer)();

	// GlVertexBuffer
	GlVertexBuffer* (*GetVertexBuffer)(BaseDraw* pBaseDraw, C4DAtom* pObj, LONG lIndex, void* pIdentity, VLONG lIdentityLen, LONG lFlags);
	void						(*RemoveObjectV)(C4DAtom* pObj, LONG lIndex);
	VLONG						(*GetDefaultSize)();
	void						(*SetDefaultSize)(VLONG lSize);

	VLONG						(GlVertexBuffer::*GetBufferSize)();
	void 						(GlVertexBuffer::*SetSubBufferSize)(VLONG lSize);

	Bool 						(GlVertexBuffer::*SetDataOffset)(LONG lElement, LONG lID, LONG lDataFormat, LONG lCount, VLONG lOffset, VLONG lStride);
	void 						(GlVertexBuffer::*ResetDataOffsets)();
	Bool 						(GlVertexBuffer::*IsDirty)();
	void 						(GlVertexBuffer::*SetDirty)(Bool bDirty);
	Bool 						(GlVertexBuffer::*Draw)(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, const Vector* pvColor, Real* prAlpha);
	Bool 						(GlVertexBuffer::*DrawSubBuffer)(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lMode, LONG lIndex, LONG lFirst, LONG lCount,
		BaseSelect* pDrawElements, const Vector* pvColor, Real* prAlpha);
	Bool 						(GlVertexBuffer::*DrawSubBufferFan)(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lMode, LONG lIndex, LONG lStripCount,
		LONG lFirst, LONG *plCount, const Vector* pvColor, Real* prAlpha, GlVertexBufferDrawFanCallback fn, void* pCallbackData, Bool bReverse);
	Bool 						(GlVertexBuffer::*AllocSubBuffers)(LONG lID1, VLONG lID2, LONG lElementCount, VLONG lElementSize, LONG &lCount, VLONG &lBufferElementCount);
	Bool						(GlVertexBuffer::*AllocSubBuffersFan)(LONG lID1, VLONG lID2, LONG lPolyCount, LONG* plCount, VLONG lElementSize, LONG &lCount, VLONG &lBufferElementCount);
	VLONG 					(GlVertexBuffer::*GetSubBufferElementCount)(LONG lID1, VLONG lID2);
	LONG 						(GlVertexBuffer::*GetSubBufferCount)(LONG lID1, VLONG lID2);
	void* 					(GlVertexBuffer::*GetSubBufferData)(LONG lID1, VLONG lID2);
	Bool						(GlVertexBuffer::*UpdateSubBuffer)(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lIndex, Bool bFreeTempData);
	void 						(GlVertexBuffer::*TouchAllBuffers)();
	void 						(GlVertexBuffer::*FreeUnusedBuffers)();

	// 10.020
	void						(GlString::*SDKInit5)(Real r, const char* pszFormat);
	const GlString&	(GlProgramFactory::*AddNoiseFunction)(GlProgramType t, LONG lNoise, LONG lFlags);
	GlString				(GlProgramFactory::*AddUniformParameter2)(GlProgramType t, GlUniformParamType type, LONG lCount, const char* pszName);
	Bool						(GlProgramFactory::*SetParameterRealArray)(GlProgramType t, const char* pszName, LONG lElements, const Real *r);
	Bool						(GlProgramFactory::*SetParameterRealArrayP)(GlProgramParameter param, LONG lElements, const Real *r);
	Bool						(*HasNoiseSupportEx)(GlProgramType t, LONG lNoise, BaseDraw* pBaseDraw);
	Bool						(GlProgramFactory::*AddEncryptedBlock)(GlProgramType t, const char* pchData, VLONG lDataLength, const UCHAR* pchKey, LONG lKeyLength);
	Bool						(GlProgramFactory::*EncryptBlock)(const GlString &strLine, const UCHAR* pchKey, LONG lKeyLength, char *&pchData, VLONG &lDataLength, Bool bCStyle);
	Bool						(GlProgramFactory::*SetParameterTexture2D3PEx)(GlProgramParameter param, const BaseBitmap* pBmp, ULONG ulDirty, C4DAtom* pObj, LONG lIndex, Bool bTile, LONG lAlphaMode, Bool bInterpolate, LONG lMaxSize, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(*CacheTextureFnEx)(BaseDraw* pBaseDraw, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, Bool bTile, LONG lAlphaMode, Bool bInterpolate, LONG lMaxSize, GlProgramType progType, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(*CacheTextureBmpEx)(BaseDraw* pBaseDraw, const BaseBitmap* pBmp, ULONG ulDirty, C4DAtom* pObj, LONG lIndex, Bool bTile, LONG lAlphaMode, Bool bInterpolate, LONG lMaxSize, GlProgramType progType, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);

	// 10.6
	Bool						(GlProgramFactory::*SetParameterTexture2D1)(GlProgramType t, const char* pszName, const BaseBitmap* pBmp, LONG lFlags, LONG lAlphaMode, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTexture2D2)(GlProgramType t, const char* pszName, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTexture2D1P)(GlProgramParameter param, const BaseBitmap* pBmp, LONG lFlags, LONG lAlphaMode, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTexture2D2P)(GlProgramParameter param, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(GlProgramFactory::*SetParameterTexture2D3P)(GlProgramParameter param, const BaseBitmap* pBmp, ULONG ulDirty, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(*CacheTextureFn)(BaseDraw* pBaseDraw, const Filename &fn, LONG lFrame, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, GlProgramType progType, LayerSetSelection* pLayerSet, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	Bool						(*CacheTextureBmp)(BaseDraw* pBaseDraw, const BaseBitmap* pBmp, ULONG ulDirty, C4DAtom* pObj, LONG lIndex, LONG lFlags, LONG lAlphaMode, LONG lMaxSize, GlProgramType progType, LONG* plWidth, LONG* plHeight, LONG* plTextureDepth, C4DGLuint* pnHandle);
	GlFrameBuffer*	(*GetFrameBuffer)(BaseDraw* pBaseDraw, VULONG lID1, LONG lID2, UINT nWidth, UINT nHeight, LONG lColorTextureCount, LONG lDepthTextureCount, LONG lFlags, LONG lAAMode);
	ULONG						(*GetLanguageFeatures)(LONG lCompiler, LONG lFlags);
	LONG						(GlProgramFactory::*GetCompiler)();
	Bool						(*HasNoiseSupport)(GlProgramType t, LONG lNoise, BaseDraw* pBaseDraw, LONG lCompiler);
	GlFrameBuffer*	(*FindFrameBuffer)(BaseDraw* pBaseDraw, VULONG lID1, LONG lID2);
	void*						(GlVertexBuffer::*MapBuffer)(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lIndex, LONG lFlags);
	Bool						(GlVertexBuffer::*UnmapBuffer)(BaseDraw* pBaseDraw, LONG lID1, VLONG lID2, LONG lIndex);
	Bool						(GlFrameBuffer::*GetTextureData)(LONG x1, LONG y1, LONG x2, LONG y2, void* pData, LONG lTexture, LONG lFlags);
	Bool						(GlProgramFactory::*SetParameterTexture2DDepthP)(GlProgramParameter param, C4DGLuint nTexture);
};
 
#define MSG_GICSEX						1000969
#define MSG_GINEW							1021096
#define ID_OLDCAUSTICS				1000970
#define VPglobalillumination	1021096

struct MsgGICSExData
{
	LONG			action; // 0: load; 1: save; 2:flush
	Filename  *fn;
	Bool			success;
};

struct MsgGINewData
{
	LONG						action; // 0: Animation Prepass, 1 - Net Cache File Notify, 2 - NET Cache File, 3 - Cache Reload, 10 - Baker State
	VideoPostStruct	*vps;
	Filename				*fn;
	Bool						success;
	LONG						state;
	Real						scale;
};

typedef void (*C4D_CrashHandler)(CHAR *crashinfo);
typedef void (*C4D_CreateOpenGLContext)(void* context, void* root, ULONG flags);
typedef void (*C4D_DeleteOpenGLContext)(void* context, ULONG flags);

struct OperatingSystem
{
	LONG version;

	C4D_General				*Ge;
	C4D_Shader				*Sh;
	C4D_HyperFile			*Hf;
	C4D_BaseContainer *Bc;
	C4D_String				*St;
	C4D_Bitmap				*Bm;
	C4D_MovieSaver		*Ms;
	C4D_BaseChannel		*Ba;
	C4D_Filename			*Fn;
	C4D_File					*Fl;
	C4D_BrowseFiles		*Bf;
	C4D_Dialog				*Cd;
	C4D_UserArea			*Cu;
	C4D_Parser				*Pr;
	C4D_Resource			*Lr;
	C4D_BaseList			*Bl;
	C4D_Tag						*Tg;
	C4D_Object				*Bo;
	C4D_Document			*Bd;
	C4D_Thread				*Bt;
	C4D_Material			*Mt;
	C4D_Texture				*Tx;
	C4D_BaseSelect		*Bs;
	C4D_Key						*Bk;
	C4D_Sequence			*Bq;
	C4D_Track					*Be;
	C4D_BaseSound			*Bu;
	C4D_BaseDraw			*Br;
	C4D_BaseView			*Bv;
	C4D_Neighbor			*Nb;
	C4D_Pool					*Pl;
	C4D_BitmapFilter	*Fi;
	C4D_Painter				*Pa;
	void							*RaEx;
	void							*CsEx;
	C4D_Link					*Ln;
	C4D_GraphView			*Gv;
	C4D_GeData				*Gd;
	C4D_Atom					*At;
	C4D_Coffee				*Co;
	C4D_CAnimation		*CA;
	C4D_CrashHandler	CrashHandler;
	C4D_CreateOpenGLContext	CreateOpenGLContext;
	C4D_DeleteOpenGLContext DeleteOpenGLContext;
	C4D_GLSL					*GL;
};

#ifndef __API_INTERN__
	#define C4DOS (*t_C4DOS)
	LONG InitOS(void *p);
#endif

extern OperatingSystem C4DOS;

#endif
