#ifndef _VECTOR4_H_
#define _VECTOR4_H_

#include "ge_vector.h"

class Vector4
{
public:
	Vector4(_DONTCONSTRUCT dc) 
	{ 
	}

	Vector4()
	{
		m_prElements[0] = 0.0f; m_prElements[1] = 0.0; m_prElements[2] = 0.0f; m_prElements[3] = 1.0f;
	}

	Vector4(Real x, Real y, Real z, Real w)
	{
		m_prElements[0] = x; m_prElements[1] = y; m_prElements[2] = z; m_prElements[3] = w;
	}

	explicit Vector4(Real v)
	{
		// sets all (including w) elements to v
		m_prElements[0] = m_prElements[1] = m_prElements[2] = m_prElements[3] = v;
	}

	explicit Vector4(const Vector &v)
	{
		m_prElements[0] = v.x; m_prElements[1] = v.y; m_prElements[2] = v.z; m_prElements[3] = 1.0f; 
	}

	void SetZero()
	{
		m_prElements[0] = m_prElements[1] = m_prElements[2] = m_prElements[3] = 0.0f;
	}

	void MakeVector3()
	{
		if (m_prElements[3] == 0.0f)
		{
			m_prElements[0] = Real(MAXREAL);
			m_prElements[1] = Real(MAXREAL);
			m_prElements[2] = Real(MAXREAL);
		}
		else
		{
			m_prElements[0] /= m_prElements[3];
			m_prElements[1] /= m_prElements[3];
			m_prElements[2] /= m_prElements[3];
		}
		m_prElements[3] = 1.0f;
	}

	friend const Vector4 operator - (const Vector4 &a, const Vector4 &b)
	{
		return Vector4(a.x - b.x, a.y - b.y, a.z - b.z, a.w - b.w);
	}

	friend const Vector4 operator + (const Vector4 &a, const Vector4 &b)
	{
		return Vector4(a.x + b.x, a.y + b.y, a.z + b.z, a.w + b.w);
	}

	const Vector4& operator += (const Vector4 &a)
	{
		x += a.x;
		y += a.y;
		z += a.z;
		w += a.w;
		return *this;
	}

	const Vector4& operator *= (const Real a)
	{
		x *= a;
		y *= a;
		z *= a;
		w *= a;
		return *this;
	}

	friend const Vector4 operator ^ (const Vector4 &a, const Vector4 &b)
	{
		return Vector4(a.x * b.x, a.y * b.y, a.z * b.z, a.w * b.w);
	}

	friend const Real operator * (const Vector4 &a, const Vector4 &b)
	{
		return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
	}

	friend const Vector4 operator * (const Vector4 &a, Real b)
	{
		return Vector4(a.x * b, a.y * b, a.z * b, a.w * b);
	}

	friend const Vector& GetVector3(const Vector4 &v)
	{
		return *((Vector*)(v.m_prElements));
	}

	friend const Vector4 Mix(const Vector4 &a, const Vector4 &b, Real t)
	{
		return a + (b - a) * t;
	}

	union
	{
		struct { Real x, y, z, w; };
		Real m_prElements[4];
	};
};

#endif // _VECTOR4_H_
