RN.PARAMS.push({
	"From" 			: "",
	"From_DESC"		: "将要被替换的字符串",
	"UseRegex"		: false,
	"UseRegex_DESC"	: "From字段是否为正则表达式",
	"GlobalRegex"	: true,		
	"GlobalRegex_DESC" : "如果使用正则表达式时，是否使用全局模式",
	
	"To"			: "",
	"To_DESC"		: "替换到的字符串",
	
	"TargetType"			: 0,
	"TargetType_DESC"		: "目标类型：0->同时应用文件和文件夹（默认）；1->只应用文件；2->只应用文件夹"
});

RN.RULES.push(function(filePath, isFile, params)
{
	if ( (params["TargetType"] != 0 && ((params["TargetType"]==1&& !isFile) || (params["TargetType"]==2&& isFile))) ||
		 (params["TargetType"] != 0 && params["TargetType"] != 1 && params["TargetType"] != 2) )
		return "";
		
	if (!params["From"] || params["From"] == "")
		return "";
	
	var fileName = RN.GetFileName(filePath);
	if (params["UseRegex"])
	{
		var regstr = params["From"];
		regstr.replace(/\\/g, "\\\\");
		var reg = new RegExp(regstr, (params["GlobalRegex"]? "g" : "") );
		fileName = fileName.replace(reg, params["To"]);	
	}
	else
	{
		fileName = fileName.ReplaceG(params["From"], params["To"]);
	}
	
	var newFilePath = RN.GetPath(filePath) + "\\" + fileName;
	return newFilePath;
});