//
//  DefaultRegistrationDelegate.h
//  BERegistration
//
//  Created by Philipp on 2/13/10.
//  Copyright 2010 Dare to be Creative Ltd.. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BERegistrationDelegate.h"
#import "BERegistrationController.h"


@interface BEDefaultRegistrationDelegate : NSObject <BERegistrationDelegate> {
	IBOutlet NSWindow *registerWindow;
	IBOutlet NSView *containerView, *registerView, *registeredView, *willExpireView, *hasExpiredView, *upgradableWillExpire, *upgradableHasExpired, *registeredFileView, *willExpireCustomView, *hasExpiredCustomView;
    IBOutlet NSTextField *lostLicenseLink;
	BERegistrationController *registrationController;
	BOOL invalidLicenseEntered;
}

#pragma mark Properties

@property (retain) BERegistrationController *registrationController;

@property (assign) BOOL invalidLicenseEntered;

@property (readonly) BOOL showInvalidLicenseMessage;


#pragma mark Action methods

- (IBAction) closeWindow:(id)sender;

- (IBAction) cancelRegister:(id)sender;

- (IBAction) showLicenseFileInFinder:(id)sender;


@end
