//
//  RegistrationDelegate.h
//  BERegistration
//
//  Created by Philipp on 2/13/10.
//  Copyright 2010 Dare to be Creative Ltd.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class BERegistrationController;

@protocol BERegistrationDelegate <NSObject>

/**
 * If your delegate needs to keep a reference to the \ref RegistrationController
 * then do it in this method.
 */
-(void) registrationSetRegistrationController:(BERegistrationController *) regController;

/**
 * \brief Called when a check finds a valid serial number.
 *
 * This method indicates that the application is good to run without any
 * trial restrictions. If you have a modal dialog window or sheet then this
 * is the place to stop the modal and close the window/sheet.
 */
-(void) registrationCheckSuccess:(BERegistrationController *) regController;

/**
 * \brief Called when the user is in trial mode.
 *
 * Trial mode means the user doesn't have a valid or upgradable license but
 * is still within the trial period.
 *
 * You can query \p regController about the number of days until the trial
 * period expires with the RegistrationController::trialDaysLeft method.
 * Alternatively, if you would like to show the user on what day the trial
 * will expire then you can use the RegistrationController::expiryDate
 * method directly.
 */
-(void) registrationWillExpire:(BERegistrationController *) regController;

/**
 * \brief Called when user's trial period has expired.
 */
-(void) registrationHasExpired:(BERegistrationController *) regController;

/**
 * \brief Called when the user has an upgradable license and is in trial mode.
 */
-(void) registrationUpgradableWillExpire:(BERegistrationController *) regController;

/**
 * \brief Called when the user has an upgradable license but this trial period has expired.
 */
-(void) registrationUpgradableHasExpired:(BERegistrationController *) regController;

/**
 * \brief Called when the user wants to register his license key.
 *
 * Normally you would bring up a dialog where the user can enter his license key.
 * You can check the user entered a valid license with the
 * RegistrationController::canSaveLicenseKey method, and once he has done so
 * save the license key with RegistrationController::saveLicenseKey.
 */
-(void) registrationRegister:(BERegistrationController *) regController;

/**
 * \brief Called when the user wants to see his license key.
 */
-(void) registrationShowLicense:(BERegistrationController *) regController;

/**
 * \brief Called when the user wants to see his license file.
 */
-(void) registrationShowLicenseFile:(BERegistrationController *) regController;

/**
 * \brief Called when a valid license key was saved to persistent storage.
 *
 * This will be called whenever RegistrationController::saveLicenseKey is called
 * and a valid license was saved to persistent storage.
 *
 * This method is not called when an upgradable license is saved; in this case
 * either the registrationUpgradableWillExpire:() or registrationUpgradableHasExpired:()
 * method will be called, depending on whether the user is still in trial mode.
 */
-(void) registrationSuccessful:(BERegistrationController *) regController;

/**
 * \brief Called when the user enters an invalid license.
 */
-(void) registrationInvalidLicenseEntered:(BERegistrationController *) regController;

@end
