//
//  BESerialNumberValidating.h
//  BERegistration
//
//  Created by Philipp on 2/14/10.
//  Copyright 2010 Dare to be Creative Ltd.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@protocol BESerialNumberValidating <NSObject>

/**
 * \brief Validates a serial number
 * \param aSerialNumber the serial number to validate
 */
-(BOOL) isValidSerial:(NSString *)aSerialNumber;

/**
 * \brief Validates a License file
 * \param aLicenseFileURL the URL to the license file
 */
-(BOOL) isValidLicenseFile:(NSURL *)licenseFile;

@end
