//
//  MPAbstractScroller.h
//  MPServices
//
//  Created by Oleksii Dykan on 11/6/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MPAbstractScroller : NSScroller

// requires 4 resourses: <imageName>_back, <imageName>_top, <imageName>_center, <imageName>_bottom
@property (nonatomic, copy) IBInspectable NSString *scrollerImagesName;
@property (nonatomic, copy) IBInspectable NSString *backImageName;

/*!
 * @brief color of the knob
 */
@property (strong, nonatomic) IBInspectable NSColor *knobColor;

/*!
 * @brief width of knob
 */
@property (strong, nonatomic) IBInspectable NSNumber *scrollerWidth;

@property (nonatomic, strong) IBInspectable NSColor *backColor;

/*!
 * @brief width of KnobSlot
 */
@property (strong, nonatomic) IBInspectable NSNumber *knobSlotWidth;

@property (nonatomic, assign) IBInspectable CGFloat cornerRadius;

@property (nonatomic, copy) IBInspectable NSString *bundleIdentifier;

- (void)commonInit;

+ (CGFloat)defaultScrollerWidth;
+ (void)setDefaultScrollerWidth:(CGFloat)width;

+ (NSString *)defaultScrollerImagesName;
+ (void)setDefaultScrollerImagesName:(NSString *)imagesName;

@end
