//
//  MPAbstractSecureTextField.h
//  MPServices
//
//  Created by Kirill Kovalenko on 30.11.15.
//  Copyright © 2015 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum
{
    MPSecureTextFieldTextAlignementLeft,
    MPSecureTextFieldTextAlignementRight,
    MPSecureTextFieldTextAlignementCenter
} MPSecureTextAlignement;

@interface MPAbstractSecureTextField : NSSecureTextField

@property (nonatomic, assign) IBInspectable BOOL localizePlaceholder; // YES - default
@property (nonatomic, assign) IBInspectable CGFloat lineSpacing;
@property (nonatomic, assign) IBInspectable CGFloat textLineMaxHeight;
@property (nonatomic, strong) IBInspectable NSColor* placeholderColor;

@property(nonatomic, assign) IBInspectable CGPoint textOffset;
@property(nonatomic, assign) IBInspectable MPSecureTextAlignement alignment;

#pragma mark - config
- (void)commonInit;
- (void)setPlaceholderString:(NSString *)placeholderString;
- (NSString*)placeholderString;
- (void)setPlaceholderAttributedString:(NSAttributedString*)attributedString;
- (NSAttributedString*)placeholderAttributedString;
- (void)setPlaceholderColor:(NSColor*)placeholderColor;
- (void)updateAttributes;

@end
