//
//  MPBatchProcessViewController.h
//  Phoenix
//
//  Created by Oleksii Dykan on 6/4/15.
//  Copyright (c) 2015 MacPhun LLC. All rights reserved.
//

#import "MPUserInterface.h"
#import "MPBatchProcessingController.h"

@interface MPBatchProcessViewController : NSViewController

@property (nonatomic, strong) MPBatchProcessingController *processingController;
@property (nonatomic, copy) MPBatchProcessingCompletionBlock completionHandler;

- (void)startProcessing;

@end

#ifdef MPBatchProcessViewController_Protected

#import "MPBatchProgressIndicator.h"

@interface MPBatchProcessViewController ()

@property (nonatomic, weak) IBOutlet MPBatchProgressIndicator *progressIndicator;
@property (nonatomic, weak) IBOutlet NSTextField *imagePathLabel;
@property (nonatomic, weak) IBOutlet NSTextField *destPathLabel;
@property (nonatomic, weak) IBOutlet NSTextField *completionTextfield;
@property (nonatomic, weak) IBOutlet NSTextField *statusLabel;
@property (nonatomic, weak) IBOutlet NSImageView *previewImageView;
@property (nonatomic, weak) IBOutlet NSImageView *completionImage;

@property (nonatomic, weak) IBOutlet NSView *processingContainer;
@property (nonatomic, weak) IBOutlet NSView *completionContainer;

@property (nonatomic, strong) NSArray *destinationPaths;

- (void)updateStatusLabel;
- (void)showCompletionView:(BOOL)success;
//- (void)openOutputFolderIfNeeded;
- (void)updateMainImage:(NSImage *)newImage;
- (IBAction)cancelButtonPressed:(id)sender;
- (IBAction)okButtonPressed:(id)sender;

@end
#endif
