//
//  MPLocalizedTextField.h
//  MPServices
//
//  Created by Oleksii Dykan on 28/08/2014.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MPLocalizedTextField;

typedef void(^MPLocalizedTextFieldCallBack)();

@interface MPLocalizedTextField : NSTextField
{
    @protected
    BOOL _localizeStringValue;
}
@property (nonatomic, assign) IBInspectable BOOL localizeStringValue; // YES - default
@property (nonatomic, assign) IBInspectable BOOL localizePlaceholder; // YES - default
@property (nonatomic, assign) IBInspectable CGFloat lineSpacing;
@property (nonatomic, assign) IBInspectable CGFloat textLineMaxHeight;
@property (nonatomic, strong) IBInspectable NSColor* placeholderColor;
@property (nonatomic, copy) MPLocalizedTextFieldCallBack becomeFirstResponderCallBack;
@property (nonatomic, strong) IBInspectable NSColor *strokeColor;
@property (nonatomic, assign) IBInspectable CGFloat strokeWidth;

- (void)commonInit;
- (void)setPlaceholderString:(NSString *)placeholderString;
- (NSString*)placeholderString;
- (void)setPlaceholderAttributedString:(NSAttributedString*)attributedString;
- (NSAttributedString*)placeholderAttributedString;
- (void)setPlaceholderColor:(NSColor*)placeholderColor;
- (void)updateAttributes;

@end
