//
//  MPSRegUtils.h
//  Phoenix
//
//  Created by Andrey Shekhovtsov on 9/2/16.
//  Copyright © 2016 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void(^MPSRegUtilsCallback)(BOOL success, NSDate *expirationDate);

@interface MPSRegUtils : NSObject

// ************** Validation Methods ****************
+ (void)validateUserName:(NSString *)userName password:(NSString *)password completionHandler:(MPSRegUtilsCallback)completionHandler;

+ (void)logout;
+ (void)logoutWithBundleId:(NSString *)bundleId;

+ (void)getUserInfoWithBundleId:(NSString *)bundleId completionHandler:(MPSRegUtilsCallback)completionHandler;

// ************** Registration Keys *****************
+ (void)setUserStatusKey:(NSString *)key;
+ (NSString *)userStatusKey;

+ (void)setEmailKey:(NSString *)key;
+ (NSString *)emailKey;

+ (void)setUserNameKey:(NSString *)key;
+ (NSString *)userNameKey;

+ (void)setExpirationDateKey:(NSString *)key;
+ (NSString *)expirationDateKey;

+ (void)setIndexKey:(NSString *)key;
+ (NSString *)indexKey;

+ (void)setUserDateKey:(NSString *)key;
+ (NSString *)userDateKey;

+ (void)setOfflineTimeKey:(NSString *)key;
+ (NSString *)offlineTimeKey;

+ (void)setUserPictureKey:(NSString *)key;
+ (NSString *)userPictureKey;

+ (void)setSessionImagesCountKey:(NSString *)key;
+ (NSString *)sessionImagesCountKey;

+ (void)setAppGroupContainerId:(NSString *)groupContainerId;
+ (NSString *)appGroupContainerId;

// ****************  Helpers  **********************
+ (NSUserDefaults *)userDefaults;

// **************** Offline Check ******************
+ (BOOL)offlineUserDateValidation;
+ (BOOL)offlineValidation;
+ (void)check:(NSInteger)randomtime; // TODO: make define from this method

@end
