//
//  MPNewSliderView.h
//  slider
//
//  Created by Alexey Voitenko on 15.01.16.
//  Copyright © 2016 macphun. All rights reserved.
//


#import <Cocoa/Cocoa.h>


static NSString * const MPSSliderCellMouseDidEnterNotification   = @"MPSSliderCellMouseDidEnterNotification";
static NSString * const MPSSliderCellDeselectNotification        = @"MPSSliderCellDeselectNotification";


typedef NS_ENUM(NSUInteger, MPSSliderViewState) {
    MPSSliderViewStateBegan,
    MPSSliderViewStateDragging,
    MPSSliderViewStateEnded
};

typedef NS_ENUM(NSUInteger, MPSSliderViewType) {
    MPSSliderViewTypeLinear = 0,
    MPSSliderViewTypeExponential = 1,
    MPSSliderViewTypeLogariphmic = 2,
};


@protocol MPSSliderViewDelegate <NSObject>

@optional
- (void)mouseEntered:(NSEvent *)theEvent;
- (void)mouseExited:(NSEvent *)theEvent;

@end


@interface MPSSliderView : NSView

// Current slider value
@property (nonatomic) CGFloat value;

@property (nonatomic) IBInspectable CGFloat defaultValue;
@property (nonatomic) IBInspectable CGFloat minimumValue;
@property (nonatomic) IBInspectable CGFloat maximumValue;

/*!
 * @brief value for drawing the bar fill value's line from. Should be between min and max values.
 */
@property (strong, nonatomic) IBInspectable NSNumber *fillValueFrom;

@property (copy, nonatomic) IBInspectable NSString *titleString;
@property (copy, nonatomic) IBInspectable NSString *rightTitleString;

@property (strong, nonatomic) IBInspectable NSString *valueString;
@property (strong, nonatomic) IBInspectable NSString *keyForLocalizedLabel;

@property (strong, nonatomic) IBInspectable NSColor *titleTextColor;
@property (strong, nonatomic) IBInspectable NSColor *valueTextColor;
@property (strong, nonatomic) IBInspectable NSColor *editValueTextColor;
@property (strong, nonatomic) IBInspectable NSColor *highlightedTitleTextColor;
@property (strong, nonatomic) IBInspectable NSColor *highlightedValueTextColor;

@property (strong, nonatomic) IBInspectable NSFont *titleFont;
@property (strong, nonatomic) IBInspectable NSFont *valueFont;

@property (nonatomic) IBInspectable BOOL isHighlighted;
@property (nonatomic) IBInspectable BOOL showOnlyBody;
@property (nonatomic) IBInspectable BOOL useFullWidth;
@property (nonatomic) IBInspectable BOOL showGrid;
@property (nonatomic) IBInspectable BOOL isHighlightedEnabled;
@property (nonatomic) IBInspectable BOOL valueEditingEnabled;
@property (nonatomic) IBInspectable BOOL valueFillEnabled;

@property (copy, nonatomic) IBInspectable NSString *knobImageName;
@property (copy, nonatomic) IBInspectable NSString *knobHighlightedImageName;

@property (copy, nonatomic) IBInspectable NSString *barFillImageName;
@property (copy, nonatomic) IBInspectable NSString *barFillValueHighlightImageName;
@property (copy, nonatomic) IBInspectable NSString *barLeftAgeImageName;
@property (copy, nonatomic) IBInspectable NSString *barHighlitedLeftAgeImageName;
@property (copy, nonatomic) IBInspectable NSString *barRightAgeImageName;
@property (copy, nonatomic) IBInspectable NSString *barHighlitedRightAgeImageName;

@property (copy, nonatomic) IBInspectable NSString *barMaskImageName;

@property (copy, nonatomic) IBInspectable NSString *centerMarkImageName;

/*!
 * @brief name for images that will be used as three part image for drawing background of bar (will be suffixed with _left, _center and _right)
 */
@property (copy, nonatomic) IBInspectable NSString *barBackThreePartImageName;
@property (copy, nonatomic) IBInspectable NSString *barBackHightlightedThreePartImageName;

/*!
 * @brief name for images that will be used as three part image for filling value line (will be suffixed with _left, _center and _right)
 */
@property (copy, nonatomic) IBInspectable NSString *barFillValueThreePartImageName;
@property (copy, nonatomic) IBInspectable NSString *barFillValueHightlightedThreePartImageName;

@property (nonatomic) IBInspectable BOOL isLiveValueUpdatingEnabled;

/*!
 * @brief resize slider to full width of view, below title and value
 */
@property (assign, nonatomic) IBInspectable BOOL sliderToFullWidth;

/*!
 * @brief pass touches through labels to slider
 */
@property (assign, nonatomic) IBInspectable BOOL passTouchesToSlider;

/*!
 * @brief horizontal offset of labels from tail and head of superview
 */
@property (assign, nonatomic) IBInspectable CGFloat labelsOffsetX;

/*!
 * @brief vertical offset of labels from center Y of superview
 */
@property (assign, nonatomic) IBInspectable CGFloat labelsOffsetY;

/*!
 * @brief leading offset of the value label from MPSSlider view's trail
 */
@property (assign, nonatomic) IBInspectable NSNumber *valueLabelLeadingOffset;

/*!
 * @brief width of value's label
 */
@property (strong, nonatomic) NSNumber *valueLabelWidth;

/*!
 * @brief alignment of value's label
 */
@property (strong, nonatomic) NSNumber *valueLabelAlignment;

@property (assign, nonatomic) IBInspectable BOOL showKnobOnMouseInside;

/*!
 * @brief hides value label when current value is equal to default value
 */
@property (assign, nonatomic) IBInspectable BOOL hideValueWhenDefault;

/*!
 * @brief shows default value if it's set after any value changes
 */
@property (assign, nonatomic) IBInspectable BOOL showDefaultValueAfterDidChange;

/*!
 * @brief distance between label's end and slider's start
 */
@property (strong, nonatomic) NSNumber *titleLabelTrailingOffset;

@property (nonatomic, strong) NSCursor *slidingCursor;

@property (nonatomic, strong) NSArray<NSColor *> *gradientColors;

@property (strong, nonatomic) id representedObject;

/*!
 * @brief  flag that determines if cursorRect should be enabled on the event of mouseup
 */
@property (assign, nonatomic) IBInspectable BOOL cursorRectEnabledOnMouseUp;

@property (nonatomic) BOOL enabled;
@property (nonatomic) BOOL showPlusSign;
@property (nonatomic) BOOL highlightOnMouseEntered;
@property (nonatomic) BOOL highlightTextOnMouseEntered;

// Using for displaying value if isLiveValueUpdatingEnabled == YES
@property (strong, nonatomic) NSNumberFormatter *numberFormatter;

@property (nonatomic, copy) void (^sliderDidChangeValueBlock)(CGFloat newValue);
- (void)setSliderDidChangeValueBlock:(void (^)(CGFloat newValue))sliderDidChangeValueBlock;

@property (nonatomic) MPSSliderViewState state;
@property (nonatomic) MPSSliderViewType type;

@property (weak, nonatomic) id<MPSSliderViewDelegate> delegate;

- (void)load;

@end


@interface MPSSliderView (Protected)

@property (weak, nonatomic, readonly) NSSlider *slider;

- (IBAction)sliderDidChangeValue:(NSSlider *)slider;

- (NSString *)nibName;
- (void)load;

@end
