//
//  MPSharingObject.h
//  MPServices
//
//  Created by Andrey on 11/4/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef BOOL(^ShareValidationHandler)();
typedef NSArray *(^ShareObjectsHandler)();
typedef void (^ShareCompletionHandler) ();

typedef void(^ShareAsyncCompletionHandler)(NSArray *objectsToShare);
typedef void(^ShareAsyncPrepareImagesHandler)(ShareAsyncCompletionHandler completionHandler);

typedef NS_ENUM(NSUInteger, MPShareManagerType) {
    // Show all application
    MPShareManagerTypeAll,
    // Show applications that are installed on the system
    MPShareManagerTypeSystemInstalled,
    // Only CK products
    MPShareManagerTypeCK,
    // Only MAS products
    MPShareManagerTypeMAS,
    // Only PRO products in old sharing controller
    MPShareManagerTypeAuroraHDRPro,
    MPShareManagerTypeAuroraHDR2017,
};

@interface MPSharingObject : NSObject

@property (nonatomic, copy) ShareValidationHandler validationHandler;
@property (nonatomic, copy) ShareValidationHandler preactionValidation;

@property (nonatomic, copy) ShareObjectsHandler objectsToShare;
@property (nonatomic, copy) ShareCompletionHandler didStartHandler;
@property (nonatomic, copy) ShareCompletionHandler didEndHandler;

@property (nonatomic, copy) ShareAsyncPrepareImagesHandler asyncPrepareHandler;
@property (nonatomic, copy) ShareAsyncCompletionHandler asyncCompletionHandler;

// additional info
@property (nonatomic, copy) NSString *exportItemID;
@property (nonatomic, strong) NSSharingService *sharingService;
@property (nonatomic, assign) MPShareManagerType type;

@end
