//
//  MPControl.h
//  MPServices
//
//  Created by George's iMac on 10/13/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MPControl : NSControl
@property(assign) SEL action;
@property(assign) id target;

@property(nonatomic, assign) CGFloat dimmValue;

- (void)setTag:(NSInteger)tag;
- (NSInteger)tag;

- (BOOL)sendAction:(SEL)theAction to:(id)theTarget;
- (BOOL)enabled;
- (BOOL)isEnabled;
- (void)setEnabled:(BOOL)enabled;
- (void)setNeedsDisplay;

- (void)setButtonEnabled:(BOOL)enabled;
- (BOOL)buttonEnabled;
- (void)validateEnabledState;

- (void)drawInRect:(NSRect)rect inContext:(CGContextRef)ctx;

@end
