//
//  MPPopoverView.h
//  TestButton
//
//  Created by Oleksii Dykan on 10/15/14.
//  Copyright (c) 2014 ViolentOctopus. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef NS_ENUM(NSUInteger, MPPopoverArrowPosition) {
    MPPopoverArrowPositionBottom = 0,
    MPPopoverArrowPositionLeft = 1,
    MPPopoverArrowPositionTop = 2,
    MPPopoverArrowPositionRight = 3,
    MPPopoverArrowPositionBottomLeft = 4,
    MPPopoverArrowPositionBottomRight = 5,
    MPPopoverArrowPositionNone = 6,
};

@interface MPPopoverView : NSView

@property (nonatomic, copy) IBInspectable NSString *arrowImageName;
@property (nonatomic, copy) IBInspectable NSString *ninePartBackgroundImageName;

@property (nonatomic, copy) IBInspectable NSString *blurMaskArrowImageName;
@property (nonatomic, copy) IBInspectable NSString *ninePartBlurMaskImageName;
@property (nonatomic, copy) IBInspectable NSString *blurBorderArrowImageName;
@property (nonatomic, copy) IBInspectable NSString *ninePartBlurBorderImageName;

@property (nonatomic, assign) IBInspectable NSInteger arrowPosition;
@property (nonatomic, assign) IBInspectable CGPoint arrowOffset;

@property (nonatomic, assign) IBInspectable BOOL blurBackground;

/*!
 * @brief flag that determines existence of background image for shape and border
 */
@property (assign, nonatomic) IBInspectable BOOL backgroundImageExisted;

- (void)commonInit;

+ (MPPopoverArrowPosition)defaultArrowPosition;
+ (void)setDefaultArrowPosition:(MPPopoverArrowPosition)defaultArrowPosition;

+ (NSString *)defaultNinePartBackgroundImageName;
+ (void)setDefaultNinePartBackgroundImageName:(NSString *)defaultNinePartBackgroundImageName;

+ (NSString *)defaultArrowImageName;
+ (void)setDefaultArrowImageName:(NSString *)defaultArrowImageName;

+ (CGPoint)defaultArrowOffset;
+ (void)setDefaultArrowOffset:(CGPoint)defaultArrowOffset;

@end
