//
//  MPPluginModeManager.h
//  Memphis
//
//  Created by yurk on 11/25/13.
//  Copyright (c) 2013 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum
{
	kMPSLightRoomPluginOwner,
	kMPSPhotoshopPluginOwner,
	kMPSAperturePluginOwner
} MPSPluginOwner;

@interface MPSPluginModeManager : NSObject

@property (strong, readonly) NSString *imagePath;
@property (strong, readonly) NSArray *arguments;
@property (assign, readonly) BOOL isPluginMode;
@property (nonatomic, assign, readonly) BOOL isProcessAutomatically;
@property (nonatomic, assign, readonly) MPSPluginOwner pluginOwner;
@property (nonatomic, strong, readonly) NSString *originalImageName;
@property (nonatomic, strong, readonly) NSString *lightroomExtrasResPath;
@property (nonatomic, strong ,readonly) NSString *savePath;
@property (nonatomic, strong, readonly) NSArray *HDRPaths;
@property (nonatomic, assign, readonly) BOOL alignment;
@property (nonatomic, assign, readonly) BOOL ghostsReduction;
@property (nonatomic, assign, readonly) BOOL chromaticAberrationReduction;

@property (nonatomic, strong, readonly) NSString    *presetName;
@property (nonatomic, strong, readonly) NSString    *presetID;
@property (assign, readonly, nonatomic) CGFloat     presetAmount;

@property (nonatomic, strong, readonly) NSString *exportPresetsPath;
@property (nonatomic, assign) BOOL isHideWindow;

+ (MPSPluginModeManager *)sharedManager;

- (void)cancelPluginMode;
- (void)applyPluginMode;

- (void)storeSmartPressetData:(NSData *)aData;
- (NSData *)smartPressetData;

- (void)applyImage:(CGImageRef)image withType:(NSString *)type error:(nullable void (^)(void))error;
- (void)cancelEditImage;
@end
