//
//  MPNewSlider.h
//  slider
//
//  Created by Alexey Voitenko on 20.01.16.
//  Copyright © 2016 macphun. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class MPSSliderCell;


@interface MPSSlider : NSSlider

@property (nonatomic, weak) id mouseDownDoubleClickNextResponder;

/*!
 * @brief link to slider cell instance
 */
@property (strong, nonatomic) MPSSliderCell *cell;

/*
 Return LADSlider with custom knob and standard NSSlider bar
 If the argument is nil
 the method will return nil
 */
- (id)initWithKnobImage:(NSImage *)knob;

/*
 Return LADSlider with custom knob and tack
 isProgressType == NO
 If the one of the followings arguments is nil
 the method will return nil
 */
- (id)initWithKnobImage:(NSImage *)knob barFillImage:(NSImage *)barFill
        barLeftAgeImage:(NSImage *)barLeftAge andbarRightAgeImage:(NSImage *)barRightAge;

/*
 Return LADSlider with custom knob and bar
 isProgressType == YES
 If the one of the followings arguments is nil
 the method will return nil
 */
- (id)initWithKnobImage:(NSImage *)knob barFillImage:(NSImage *)barFill
  barFillHighlitedImage:(NSImage *)barFillHighlited
        barLeftAgeImage:(NSImage *)barLeftAge barRightAgeImage:(NSImage *)barRightAge;

- (NSImage *)knobImage;
- (void)setKnobImage:(NSImage *)image;

- (NSImage *)centerMarkImage;
- (void)setCenterMarkImage:(NSImage *)image;

@end
