//
//  MPSuperMenuItemSettings.h
//  MPServices
//
//  Created by Kirill Kovalenko on 6/16/16.
//  Copyright © 2016 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MPSuperMenuItemSettings : NSObject

#pragma mark -
#pragma mark Properties

/* Settings */

@property (nonatomic, strong, nonnull) NSColor *onStateColor;
@property (nonatomic, strong, nonnull) NSColor *offStateColor;
@property (nonatomic, assign) CGFloat disabledStateAlpha;
@property (nonatomic, strong, nonnull) NSColor *highlightStateColor;
@property (nonatomic, strong, nonnull) NSColor *selectionColor;
@property (nonatomic, strong, nonnull) NSColor *separatorColor;
@property (nonatomic, strong, nonnull) NSFont  *font;
@property (nonatomic, assign) CGFloat separatorLineWidth;
@property (nonatomic, assign) CGFloat leftMargin;
@property (nonatomic, assign) CGFloat rightMargin;
@property (nonatomic, assign) CGFloat separatorHeight;

#pragma mark -
#pragma mark Methods

/* Default special setting for Tokio. */
+ (MPSuperMenuItemSettings * _Nonnull)defaultSettings;

@end
