//
//  NSBezierPath+Additions.h
//  MPServices
//
//  Created by Oleksii Dykan on 8/5/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>


typedef NS_OPTIONS(NSUInteger, MPBezierPathCorner) {
    MPBezierPathCornerBottomLeft    = 1 << 0,
    MPBezierPathCornerBottomRight   = 1 << 1,
    MPBezierPathCornerTopLeft       = 1 << 2,
    MPBezierPathCornerTopRight      = 1 << 3,
};


@interface NSBezierPath (Additions)

+ (NSBezierPath *)bezierPathWithRect:(NSRect)rect cornerRadius:(CGFloat)cornerRadius roundedCorners:(MPBezierPathCorner)corners;

- (CGPathRef)quartzPath;

@end
