//
//  MPAbstractSliderCell.h
//  MPServices
//
//  Created by Alick Dikan on 10/31/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MPAbstractSliderCell : NSSliderCell

@property (nonatomic, copy) IBInspectable NSString *barThreePartImageName;
@property (nonatomic, copy) IBInspectable NSString *knobImageName;
@property (nonatomic, assign) IBInspectable CGFloat knobIndent;
@property (nonatomic, assign) IBInspectable CGFloat verticalOffset;
@property (nonatomic, assign) IBInspectable BOOL alwaysNeedsTickMark;

- (void)commonInit;

+ (NSString *)defaultBarThreePartImageName;
+ (void)setDefaultBarThreePartImageName:(NSString *)threePartImageName;

+ (NSString *)defaultKnobImageName;
+ (void)setDefaultKnobImageName:(NSString *)knobImageName;

+ (CGFloat)defaultKnobIndent;
+ (void)setDefaultKnobIndent:(CGFloat)knobIndent;

+ (BOOL)defaultAlwaysNeedsTickMark;
+ (void)setDefaultAlwaysNeedsTickMark:(BOOL)alwaysNeedsTickMark;

+ (CGFloat)defaultVerticalOffset;
+ (void)setDefaultVerticalOffset:(CGFloat)verticalOffset;

@end
