//
//  MPShareManager.h
//  MPServices
//
//  Created by Andrey on 11/4/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPSharingObject.h"

extern NSString *const kMPShareManagerKeyShare;
extern NSString *const kMPShareManagerKeyOpenIn;

extern NSString *const MPApplicationShouldTerminateWithoutSaving;

// macphun apps
extern NSString * const MPExportToCreativeKit;
extern NSString * const MPExportToIntensify;
extern NSString * const MPExportToTonality;
extern NSString * const MPExportToSnapheal;
extern NSString * const MPExportToFXPhotoStudio;
extern NSString * const MPExportToFiltersForPhotos;
extern NSString * const MPExportToFocus;
extern NSString * const MPExportToNoiseless;
extern NSString * const MPExportToSnapselect;
extern NSString * const MPExportToColorStrokes;
// macphun apps end

extern NSString *const MPSeparatorItem;

extern NSString *const MPExportToIPhoto;
extern NSString *const MPExportToAperture;
extern NSString *const MPExportToPhotoshop;
extern NSString *const MPExportToPhotoshopElements;
extern NSString *const MPExportToLightroom;
extern NSString *const MPExportToPhotos;

@interface MPShareManager : NSObject

///Getting sharingObjects
+ (NSArray *)shareSharingObjects;
+ (NSArray *)exportSharingObjectsWithSeparator:(BOOL)withSeparator withType:(MPShareManagerType)type;
+ (NSArray *)exportSharingObjectsWithSeparator:(BOOL)withSeparator;
+ (NSArray *)exportCreativeKitSharingObjectsWithSeparator:(BOOL)withSeparator withType:(MPShareManagerType)type;
+ (NSArray *)exportCreativeKitSharingObjectsWithSeparator:(BOOL)withSeparator;

+ (NSString *)shareViewImageNameForSharingObject:(MPSharingObject *)sharingObject;
+ (NSString *)titleForSharingObject:(MPSharingObject *)sharingObject;
+ (NSString *)descriptionForSharingObject:(MPSharingObject *)sharingObject;

/// Sharing menu items
/// Use either these methods
+ (NSMenuItem *)shareMenuItemWithImagesPaths:(ShareObjectsHandler)pathsToShare
                           validationHandler:(ShareValidationHandler)validationHandler;
+ (NSMenuItem *)shareMenuItemWithImagesPaths:(ShareObjectsHandler)pathsToShare
                         preactionValidation:(ShareValidationHandler)preactionValidation
                           validationHandler:(ShareValidationHandler)validationHandler;

/// or this
+ (NSMenuItem *)shareMenuItemWithAsyncPrepareBlock:(ShareAsyncPrepareImagesHandler)asyncPrepareBlock
                                 validationHandler:(ShareValidationHandler)validationHandler;
/// if you want to get a specific type of
+ (NSMenuItem *)shareMenuItemWithAsyncPrepareBlock:(ShareAsyncPrepareImagesHandler)asyncPrepareBlock
                                 validationHandler:(ShareValidationHandler)validationHandler
                                          withType:(MPShareManagerType)type;

/// Export menu items
/// Use either these methods
+ (NSMenuItem *)exportMenuItemWithImagesPaths:(ShareObjectsHandler)pathsToShare
                            validationHandler:(ShareValidationHandler)validationHandler;
+ (NSMenuItem *)exportMenuItemWithImagesPaths:(ShareObjectsHandler)pathsToShare
                          preactionValidation:(ShareValidationHandler)preactionValidation
                            validationHandler:(ShareValidationHandler)validationHandler;

/// or this
+ (NSMenuItem *)exportMenuItemWithAsyncPrepareBlock:(ShareAsyncPrepareImagesHandler)asyncPrepareBlock
                                  validationHandler:(ShareValidationHandler)validationHandler;
/// if you want to get a specific type of
+ (NSMenuItem *)exportMenuItemWithAsyncPrepareBlock:(ShareAsyncPrepareImagesHandler)asyncPrepareBlock
                                  validationHandler:(ShareValidationHandler)validationHandler
                                           withType:(MPShareManagerType)type;

/// Show in Finder
+ (NSMenuItem *)showInFinderMenuItemWithImagesPaths:(ShareObjectsHandler)pathsToShow
                                  validationHandler:(ShareValidationHandler)validationHandler;


/// Help menu
+ (NSMenuItem *)linksToMacphunProductsMenuItem;
+ (NSMenuItem *)linksToMacphunProductsMenuItemWithType:(MPShareManagerType)type;

// Configure
+ (void)addSharingWithIdentifier:(NSString *)identidier
                           title:(NSString *)title
                   menuImageName:(NSString *)menuImageName
              shareViewImageName:(NSString *)shareViewImageName
               completionHandler:(ShareAsyncCompletionHandler)completionHandler;

+ (NSMenuItem *)addMenuItemWithExportID:(NSString *)exportID
                               withType:(MPShareManagerType)type;

+ (void)configureCustomSharingText:(NSString *)sharingText;

+ (void)configureShareMenuItemsOrderWithServices:(NSArray *)services;
+ (void)configureExportItemsWithItems:(NSArray *)exportItems;

+ (void)excludeSharingService:(NSString *)sharingServiceType;
+ (void)excludeExportItems:(NSArray *)exportItems;
+ (void)excludeExportItem:(NSString *)exportItem;

+ (void)configureExportMenuItem:(NSMenuItem *)menuItem
            withDidStartHandler:(ShareCompletionHandler)didStartBlock
                    didEndBlock:(ShareCompletionHandler)didEndBlock;
+ (void)configureExportMenuItem:(NSMenuItem *)menuItem
                 forExportItems:(NSArray *)exportItems
            withDidStartHandler:(ShareCompletionHandler)didStartBlock
                    didEndBlock:(ShareCompletionHandler)didEndBlock;

+ (void)configureShareMenuItem:(NSMenuItem *)menuItem
           withDidStartHandler:(ShareCompletionHandler)didStartBlock
                   didEndBlock:(ShareCompletionHandler)didEndBlock;
+ (void)configureShareMenuItem:(NSMenuItem *)menuItem
       forSharingServicesTypes:(NSArray *)sharingServicesTypes
           withDidStartHandler:(ShareCompletionHandler)didStartBlock
                   didEndBlock:(ShareCompletionHandler)didEndBlock;
+ (void)configureShareMenuItem:(NSMenuItem *)menuItem
    forSharingServiceNameTypes:(NSArray *)sharingServiceNameTypes
         withAsyncPrepareBlock:(ShareAsyncPrepareImagesHandler)asyncPrepareBlock
             validationHandler:(ShareValidationHandler)validationHandler;

+ (void)configureImagesPaths:(ShareObjectsHandler)pathToShare
           validationHandler:(ShareValidationHandler)validationHandler
         preactionValidation:(ShareValidationHandler)preactionValidation
              forExportItems:(NSArray *)exportItems
                  inMenuItem:(NSMenuItem *)menuItem;
+ (void)configureImagesPaths:(ShareObjectsHandler)pathToShare
           validationHandler:(ShareValidationHandler)validationHandler
         preactionValidation:(ShareValidationHandler)preactionValidation
               forExportItem:(NSString *)exportItem
                  inMenuItem:(NSMenuItem *)menuItem;

+ (void)configureImagesPaths:(ShareObjectsHandler)pathToShare
           validationHandler:(ShareValidationHandler)validationHandler
              forExportItems:(NSArray *)exportItems
                  inMenuItem:(NSMenuItem *)menuItem;
+ (void)configureImagesPaths:(ShareObjectsHandler)pathToShare
           validationHandler:(ShareValidationHandler)validationHandler
               forExportItem:(NSString *)exportItem
                  inMenuItem:(NSMenuItem *)menuItem;

+ (void)configureImagesPaths:(ShareObjectsHandler)pathToShare
              forExportItems:(NSArray *)exportItems
                  inMenuItem:(NSMenuItem *)menuItem;
+ (void)configureImagesPaths:(ShareObjectsHandler)pathToShare
               forExportItem:(NSString *)exportItem
                  inMenuItem:(NSMenuItem *)menuItem;

+ (void)configureValidationHandler:(ShareValidationHandler)validationHandler
                    forExportItems:(NSArray *)exportItems
                        inMenuItem:(NSMenuItem *)menuItem;
+ (void)configureValidationHandler:(ShareValidationHandler)validationHandler
                     forExportItem:(NSString *)exportItem
                        inMenuItem:(NSMenuItem *)menuItem;

+ (void)configurePrepareImagesHandler:(ShareAsyncPrepareImagesHandler)prepareBlock
                       forExportItems:(NSArray *)exportItems // pass nil or empty array to configure all items
                           inMenuItem:(NSMenuItem *)menuItem;
+ (void)configurePrepareImagesHandler:(ShareAsyncPrepareImagesHandler)prepareBlock
                        forShareItems:(NSArray *)shareItems // pass nil or empty array to configure all items
                           inMenuItem:(NSMenuItem *)menuItem;

+ (void)hideServices:(NSArray *)services inMenuItem:(NSMenuItem *)menuItem;
+ (void)hideExportItems:(NSArray *)exportItems inMenuItem:(NSMenuItem *)menuItem;

+ (void)setPerformExportToApertureScript:(BOOL)performScript;

// Perform specific actions
+ (BOOL)canPerformExportWithExportItem:(NSString *)exportItem;

+ (void)performWithSharingObject:(MPSharingObject *)sharingObject;

+ (BOOL)saveImage:(CGImageRef)exportImage URL:(NSURL *)url type:(NSString *)type properties:(NSDictionary *)imageProperties;

+ (void)performExportWithExportItem:(NSString *)exportItem pathsToShare:(NSArray *)pathsToShare;
+ (void)performExportWithExportItem:(NSString *)exportItem pathsToShareBlock:(ShareObjectsHandler)pathsToShare;
+ (void)performExportWithExportItem:(NSString *)exportItem
                  pathsToShareBlock:(ShareObjectsHandler)pathsToShare
                      didStartBlock:(ShareCompletionHandler)didStartHandler
                        didEndBlock:(ShareCompletionHandler)didEndHandler;
+ (void)performExportWithExportItem:(NSString *)exportItem
                  pathsToShareBlock:(ShareObjectsHandler)pathsToShare
                preactionValidation:(ShareValidationHandler)preactionValidationHandler
                      didStartBlock:(ShareCompletionHandler)didStartHandler
                        didEndBlock:(ShareCompletionHandler)didEndHandler;

+ (void)performSharingWithSharingServiceType:(NSString *)sharingServiceType pathsToShare:(NSArray *)pathsToShare;
+ (void)performSharingWithSharingServiceType:(NSString *)sharingServiceType pathsToShareBlock:(ShareObjectsHandler)pathsToShare;
+ (void)performSharingWithSharingServiceType:(NSString *)sharingServiceType
                           pathsToShareBlock:(ShareObjectsHandler)pathsToShare
                               didStartBlock:(ShareCompletionHandler)didStartHandler
                                 didEndBlock:(ShareCompletionHandler)didEndHandler;
+ (void)performSharingWithSharingServiceType:(NSString *)sharingServiceType
                           pathsToShareBlock:(ShareObjectsHandler)pathsToShare
                         preactionValidation:(ShareValidationHandler)preactionValidationHandler
                               didStartBlock:(ShareCompletionHandler)didStartHandler
                                 didEndBlock:(ShareCompletionHandler)didEndHandler;

/// Getting app store links for app

+ (NSString *)appStoreLinkForBundleId:(NSString *)bundleId;

/// Check for Install app
+ (BOOL)isCKVersionInstalledForAppWithShareObject:(MPSharingObject *)sharingObject;
+ (BOOL)installedAppInSystemWithShareObject:(MPSharingObject *)sharingObject;

+ (void)refreshMenus;
+ (void)refreshMenuIfNeeded:(NSMenu *)menu;

@end
