//
//  MPShareViewController.h
//  MPServices
//
//  Created by Oleksii Dykan on 4/16/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import "MPPopoverViewController.h"
#import "MPSharingObject.h"

typedef enum : NSUInteger {
    MPShareViewControllerTypeStandart,
    MPShareViewControllerTypeCreativeKit,
    MPShareViewControllerTypeAuroraHDRPro,
    MPShareViewControllerTypeNoiseless,
} MPShareViewControllerType;

@class MPShareViewController;

@protocol MPShareViewControllerDelegate <NSObject>
- (void)shareViewControllerDidSelectItem:(MPShareViewController *)shareViewController;
@end


@interface MPShareViewController : MPPopoverViewController

+ (id)shareViewController;
+ (id)shareViewControllerWithType:(MPShareViewControllerType)type;

@property (nullable, nonatomic, weak) id <MPShareViewControllerDelegate> delegate;

@property (nonatomic, assign) BOOL blurredBackground;
@property (nonatomic, assign) MPShareViewControllerType controllerType;

@property (nonatomic, copy) ShareAsyncPrepareImagesHandler prepareImagesHandler;
@property (nonatomic, copy) void(^exportToImageCallback)(id sender);
@property (nonatomic, copy) NSColor* selectedTextColor;

- (void)setPrepareImagesHandler:(ShareAsyncPrepareImagesHandler)prepareImagesHandler forShareServiceTypes:(NSArray *)shareServiceTypes;
- (void)setTextOffsetForExportToImageButton:(NSPoint)point; // TODO: hack for FFP

@end
