-- http://manual.mailmate-app.com/extended_url_scheme

set theTo to "%@"
set theSubject to "%@"
set theBody to "%@"
set theAttachmentPath to "%@"
set theCC to "%@"
set theBCC to "%@"

set theLocation to "mailto:" & theTo
set theLocation to theLocation & "?subject=" & encode_text(theSubject, false, false)
set theLocation to theLocation & "&body=" & encode_text(theBody, true, true)
set theLocation to theLocation & "&attachment-url=file://" & encode_text(theAttachmentPath, true, false)

tell application "MailMate" 
	activate
	open location theLocation with trust
end tell

-- http://www.macosxautomation.com/applescript/sbrt/sbrt-08.html
on encode_char(this_char)
	set the ASCII_num to (the ASCII number this_char)
	set the hex_list to {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"}
	set x to item ((ASCII_num div 16) + 1) of the hex_list
	set y to item ((ASCII_num mod 16) + 1) of the hex_list
	-- I have to use two percent signs here because I replace variables with stringWithFormat
	return ("%%" & x & y) as string
end encode_char
on encode_text(this_text, encode_URL_A, encode_URL_B)
	set the standard_characters to "abcdefghijklmnopqrstuvwxyz0123456789"
	-- I have to use two percent signs here because I replace variables with stringWithFormat
	set the URL_A_chars to "$+!'/?;&@=#%%><{}[]\"~`^\\|*"
	set the URL_B_chars to ".-_:"
	set the acceptable_characters to the standard_characters
	if encode_URL_A is false then set the acceptable_characters to the acceptable_characters & the URL_A_chars
	if encode_URL_B is false then set the acceptable_characters to the acceptable_characters & the URL_B_chars
	set the encoded_text to ""
	repeat with this_char in this_text
		if this_char is in the acceptable_characters then
			set the encoded_text to (the encoded_text & this_char)
		else
			set the encoded_text to (the encoded_text & encode_char(this_char)) as string
		end if
	end repeat
	return the encoded_text
end encode_text