///<------------------------------------------------------------------------------
//< @file:   cxx_clean.h
//< @author: 
//< @brief:  ʵclang﷨йصĸֻ
//< Copyright (c) 2016 game. All rights reserved.
///<------------------------------------------------------------------------------

#ifndef _cxx_clean_h_
#define _cxx_clean_h_

#include "clang/AST/ASTConsumer.h"
#include "clang/AST/RecursiveASTVisitor.h"
#include "clang/Lex/Preprocessor.h"
#include "llvm/Support/CommandLine.h"
#include "llvm/Support/Path.h"
#include "clang/Frontend/TextDiagnosticPrinter.h"
#include "clang/Frontend/FrontendAction.h"
#include "clang/Frontend/CompilerInstance.h"
#include "clang/Tooling/Tooling.h"

using namespace std;
using namespace clang;
using namespace clang::driver;
using namespace clang::tooling;
using namespace llvm;
using namespace llvm::sys;
using namespace llvm::sys::path;
using namespace llvm::sys::fs;

class ParsingFile;
class VsProject;

// Ԥ#define#if#elseԤؼֱԤʱʹñԤ
class CxxCleanPreprocessor : public PPCallbacks
{
public:
	explicit CxxCleanPreprocessor(ParsingFile *mainFile);

public:
	// ļл
	void FileChanged(SourceLocation loc, FileChangeReason reason, SrcMgr::CharacteristicKind FileType, FileID prevFileID = FileID()) override;

	// ļ
	void FileSkippedWithFileID(FileID);

	// ꣬#if defined DEBUG
	void Defined(const Token &macroName, const MacroDefinition &definition, SourceRange range) override;

	// #define
	void MacroDefined(const Token &macroName, const MacroDirective *direct) override;

	// 걻#undef
	void MacroUndefined(const Token &macroName, const MacroDefinition &definition) override;

	// չ
	void MacroExpands(const Token &macroName, const MacroDefinition &definition, SourceRange range, const MacroArgs *args) override;

	// #ifdef
	void Ifdef(SourceLocation loc, const Token &macroName, const MacroDefinition &definition) override;

	// #ifndef
	void Ifndef(SourceLocation loc, const Token &macroName, const MacroDefinition &definition) override;

private:
	// ǰڽcppļϢ
	ParsingFile *m_root;
};

// ͨʵRecursiveASTVisitor࣬Զc++﷨ʱĲ
class CxxCleanASTVisitor : public RecursiveASTVisitor<CxxCleanASTVisitor>
{
public:
	explicit CxxCleanASTVisitor(ParsingFile *rootFile);

	// ʵ
	bool VisitStmt(Stmt *s);

	// ʺ
	bool VisitFunctionDecl(FunctionDecl *f);

	// classstructunionenumʱ
	bool VisitCXXRecordDecl(CXXRecordDecl *r);

	// ֱʱýӿڱ
	bool VisitVarDecl(VarDecl *var);

	// 磺typedef int A;
	bool VisitTypedefDecl(clang::TypedefDecl *d);

	// 磺namespace A{}
	bool VisitNamespaceDecl(clang::NamespaceDecl *d);

	// 磺namespace s = std;
	bool VisitNamespaceAliasDecl(clang::NamespaceAliasDecl *d);

	// 磺using namespace std;
	bool VisitUsingDirectiveDecl(clang::UsingDirectiveDecl *d);

	// 磺using std::string;
	bool VisitUsingDecl(clang::UsingDecl *d);

	// ʳԱ
	bool VisitFieldDecl(FieldDecl *decl);

	// 
	bool VisitCXXConstructorDecl(CXXConstructorDecl *decl);

	// 
	bool VisitCXXConstructExpr(CXXConstructExpr *expr);

private:
	// ǰڽcppļϢ
	ParsingFile*	m_root;
};

// ʵASTConsumerӿڶȡclangɵast﷨
class CxxCleanASTConsumer : public ASTConsumer
{
public:
	explicit CxxCleanASTConsumer(ParsingFile *rootFile);

	// ǣķ
	bool HandleTopLevelDecl(DeclGroupRef declgroup) override;

	// ÿԴļһΣ磬һhello.cpp#includeͷļҲֻһα
	void HandleTranslationUnit(ASTContext& context) override;

public:
	// ǰڽcppļϢ
	ParsingFile*		m_root;

	// ﷨
	CxxCleanASTVisitor	m_visitor;
};

// `TextDiagnosticPrinter`ԽϢӡڿ̨ϣΪ˵Է㽫Ϊ
class CxxcleanDiagnosticConsumer : public TextDiagnosticPrinter
{
public:
	explicit CxxcleanDiagnosticConsumer(DiagnosticOptions *diags);

	void Clear();

	void BeginSourceFile(const LangOptions &LO, const Preprocessor *PP) override;

	virtual void EndSourceFile() override;

	// һʱô˺¼ʹ
	virtual void HandleDiagnostic(DiagnosticsEngine::Level diagLevel, const Diagnostic &info) override;

	std::string			m_errorTip;
	raw_string_ostream	m_log;
};

// ClangToolյÿcppԴļnewһCxxCleanAction
class CxxCleanAction : public ASTFrontendAction
{
public:
	CxxCleanAction()
		: m_root(nullptr)
	{}

	// ʼļ
	bool BeginSourceFileAction(CompilerInstance &compiler, StringRef filename) override;

	// ļ
	void EndSourceFileAction() override;

	// ﷨
	std::unique_ptr<ASTConsumer> CreateASTConsumer(CompilerInstance &compiler, StringRef file) override;

private:
	// ǰڽcppļϢ
	ParsingFile	*m_root;
};

// ߵвclangCommonOptionParserʵֶ
class CxxCleanOptionsParser
{
public:
	CxxCleanOptionsParser() {}

	// ѡӦĶӦ;˳򷵻true򷵻false
	bool ParseOptions(int &argc, const char **argv);

	// ִв"--"ָǰв߽вclang
	// ע⣺argcΪ"--"ָǰĲ
	// 磺
	//		ʹcxxclean -clean ./hello/ -- -include log.h
	//		-clean ./hello/߽-include log.hclang
	static FixedCompilationDatabase *CxxCleanOptionsParser::SplitCommandLine(int &argc, const char *const *argv, Twine directory = ".");

	// clang
	void AddClangArgument(ClangTool &tool, const char *arg) const;

	// clang
	void AddClangArgumentByOption(ClangTool &tool) const;

	// ϵͳͷļ·
	void AddSystemHeaderSearchPath(ClangTool &tool, const char *path) const;

	// ûͷļ·
	void AddHeaderSearchPath(ClangTool &tool, const char *path) const;

	// vsļclangĲ
	bool AddVsArgument(const VsProject &vs, ClangTool &tool) const;

	// ȡvisual studioİװ·
	std::string GetVsInstallDir() const;

	// visual studioĶİ·Ϊclang©һ·ᵼ#include <atlcomcli.h>ʱҲͷļ
	void AddVsSearchDir(ClangTool &tool) const;

	// Ŀ-cleanѡ
	bool ParseCleanOption();

	// ־ӡ-vѡ
	bool ParseLogOption();

	CompilationDatabase &getCompilations() const {return *m_compilation;}

private:
	std::unique_ptr<CompilationDatabase> m_compilation;
};

#endif // _cxx_clean_h_