//------------------------------------------------------------------------------
// ļ: history.h
// : 
// ˵: ļʷ
// Copyright (c) 2016 game. All rights reserved.
//------------------------------------------------------------------------------

#ifndef _history_h_
#define _history_h_

#include <iterator>
#include <vector>
#include <set>
#include <map>

using namespace std;

class ParsingFile;

// ļӦУ[ļ] -> [ļЩнֹɾ]
typedef std::map<string, std::set<int>> FileSkipLineMap;

// ӦɾУõ#includeУ
struct DelLine
{
	DelLine()
		: beg(0)
		, end(0)
	{}

	int							beg;				// ʼƫ
	int							end;				// ƫ
	string						text;				// ı
};

// ǰ
struct ForwardLine
{
	ForwardLine()
		: offset(0)
	{}

	int							offset;				// ļڵƫ
	string						oldText;			// ԭı
	std::set<string>			classes;			// ǰб
};

// е
struct BeAdd
{
	string						fileName;			// ļ
	string						text;				// ı
};

// 
struct AddLine
{
	AddLine()
		: offset(0)
	{}

	int							offset;				// ļڵƫ
	string						oldText;			// ԭı
	std::vector<BeAdd>			adds;				// 
};

// 滻#includeϢ
struct ReplaceTo
{
	ReplaceTo()
		: line(0)
	{}

	string						fileName;			// #includeӦļ
	string						inFile;				// #includeĸļ
	int							line;				// #includeڵ
	string						oldText;			// #includeԭ: #include "../b/../b/../a.h"
	string						newText;			// ԭ#include·#include: #include "../b/../b/../a.h" -> #include "../a.h"
	FileSkipLineMap				m_rely;				// 滻ļеļ
};

// 滻#include
struct ReplaceLine
{
	ReplaceLine()
		: isSkip(false)
		, beg(0)
		, end(0)
	{}

	bool						isSkip;				// ¼滻ǷӦΪЩ#includeǱ-includeģ޷滻ȻдӡıҪ
	int							beg;				// ʼƫ
	int							end;				// ƫ
	string						oldText;			// 滻ǰ#includeı: #include "../b/../b/../a.h
	string						oldFile;			// 滻ǰ#includeӦļ
	ReplaceTo					replaceTo;			// 滻#includeб
};

// ÿļıʷ
struct CompileErrorHistory
{
	CompileErrorHistory()
		: errNum(0)
		, hasTooManyError(false)
	{}

	// Ƿر
	bool HaveFatalError() const
	{
		return !fatalErrorIds.empty();
	}

	// ӡ
	void Print() const;

	int							errNum;				// 
	bool						hasTooManyError;	// Ƿ[clangò]
	std::set<int>				fatalErrorIds;		// شб
	std::vector<std::string>	errors;				// б
};

// ļʷ¼c++ļĴ¼
class FileHistory
{
public:
	FileHistory()
		: m_isWindowFormat(false)
		, m_isSkip(false)
	{}

	// ӡļʷ
	void Print(int id /* ļ */, bool isPrintCompiliError = true) const;

	// ӡļĿɱɾ#include¼
	void PrintUnusedInclude() const;

	// ӡļĿǰ¼
	void PrintForwardClass() const;

	// ӡļĿɱ滻#include¼
	void PrintReplace() const;

	// ӡļڵ
	void PrintAdd() const;

	const char* GetNewLineWord() const
	{
		return (m_isWindowFormat ? "\r\n" : "\n");
	}

	bool IsNeedClean() const
	{
		return !(m_delLines.empty() && m_replaces.empty() && m_forwards.empty() && m_adds.empty());
	}

	bool IsLineUnused(int line) const
	{
		return m_delLines.find(line) != m_delLines.end();
	}

	bool IsLineBeReplaced(int line) const
	{
		return m_replaces.find(line) != m_replaces.end();
	}

	bool HaveFatalError() const
	{
		return m_compileErrorHistory.HaveFatalError();
	}

	typedef std::map<int, AddLine> AddLineMap;
	typedef std::map<int, DelLine> DelLineMap;
	typedef std::map<int, ForwardLine> ForwardLineMap;
	typedef std::map<int, ReplaceLine> ReplaceLineMap;

	std::string			m_filename;
	bool				m_isSkip;				// ¼ļǷֹĶЩļstdafx.hstdafx.cpp־ͲҪ
	bool				m_isWindowFormat;		// ļǷWindowsʽĻз[\r\n]ΪUnixʽ[\n]ͨļһлзжϣ

	CompileErrorHistory m_compileErrorHistory;	// ļı
	DelLineMap			m_delLines;
	ForwardLineMap		m_forwards;
	ReplaceLineMap		m_replaces;
	AddLineMap			m_adds;
};

// ļ[ļ] -> [ļ]
typedef std::map<string, FileHistory> FileHistoryMap;

// ڴ洢ͳƽԸc++ļʷ־
class ProjectHistory
{
	ProjectHistory()
		: m_printIdx(0)
		, g_fileNum(0)
	{}

public:
	void OnCleaned(const string &file)
	{
		m_cleanedFiles.insert(file);
	}

	bool HasCleaned(const string &file) const
	{
		return m_cleanedFiles.find(file) != m_cleanedFiles.end();
	}

	bool HasFile(const string &file) const
	{
		return m_files.find(file) != m_files.end();
	}

	// ָļָбǳɽֹĶ
	void AddSkipLine(const string &file, int line);

	// ָļǷһЩнֹĶ
	bool IsAnyLineSkip(const string &file);

	// ӡ + 1
	std::string AddPrintIdx() const;

	// 
	void Fix();

	// ӡ־
	void Print() const;

	// ӡļΪɾ
	void PrintSkip() const;

public:
	static ProjectHistory instance;

public:
	// c++ļķʷעҲc++ͷļ
	FileHistoryMap		m_files;

	// ļӦУɾЩУ
	FileSkipLineMap		m_skips;

	// ļעѱļظ
	std::set<string>	m_cleanedFiles;

	// ڴӡǰڴڼļ
	int					g_fileNum;

private:
	// ǰڲӡ־ӡ
	mutable int			m_printIdx;
};

#endif // _history_h_