///<------------------------------------------------------------------------------
//< @file:   html_log.h
//< @author: 
//< @brief:  html־࣬ӡ־
//< Copyright (c) 2016 game. All rights reserved.
///<------------------------------------------------------------------------------

#ifndef _html_log_h_
#define _html_log_h_

#include <iterator>
#include <vector>

namespace llvm
{
	class raw_ostream;
}

// 1. 
static const wchar_t* cn_log_name_project			= L"%s";
static const wchar_t* cn_log_name_folder			= L"[ %s ] ļ";
static const wchar_t* cn_log_name_cpp_file			= L"[ %s ] c++ ļ";
static const wchar_t* cn_log						= L"%s־-%s.html";

static const char* cn_time							= "%04d%02d%02d%02dʱ%02d%02d";
static const char* cn_project						= "[ %s ] visual studio";
static const char* cn_clean							= "ҳǶ %s ķ־սԱҳײͳƽΪ׼";
static const char* cn_project_text					= "c++ļбԼc++Դļб";
static const char* cn_project_allow_files			= "c++ļбļ = %sڸбc++ļĶ";
static const char* cn_project_allow_file			= "ļ = %s";
static const char* cn_project_source_list			= "c++Դļбļ = %sڸбc++ļᱻ";
static const char* cn_project_source				= "c++Դļ = %s";

static const char* cn_file_history					= "%sļ%sɱ£";
static const char* cn_file_history_compile_error	= "%sļ%sر޷һ־£";
static const char* cn_file_history_title			= "%s/%s. %sļ־";
static const char* cn_file_skip						= "ע⣺⵽ļΪԤļļᱻĶ";

static const char* cn_error							= "󣺱뱾ļʱ±";
static const char* cn_error_num_tip					= "˵%s󣬱 = %s";
static const char* cn_fatal_error_num_tip			= "˵%s󣬱 = %sر";
static const char* cn_error_fatal					= "==> ע⣺ڷش[=%s]ļķ";
static const char* cn_error_too_many				= "==> ע⣺ٲ%sڱ࣬ļķ";
static const char* cn_error_ignore					= "==> %sڴٻأļķԽͳ";

static const char* cn_file_unused_count				= "ļ%sж#include";
static const char* cn_file_unused_line				= "Ƴ%s";
static const char* cn_file_unused_include			= "ԭ#includeı = %s";

static const char* cn_file_can_replace_num			= "ļ%s#includeɱ滻";
static const char* cn_file_can_replace_line			= "%sпԱ滻ԭ = %s";
static const char* cn_file_replace_same_text		= "Ա滻Ϊµ = %s";
static const char* cn_file_replace_old_text			= "ԭ#include = %s";
static const char* cn_file_replace_new_text			= "·óµ#include = %s";
static const char* cn_file_force_include_text		= " ==>  [ע: 滻Ϊпѱǿư]";
static const char* cn_file_replace_in_file			= "עµ#include%sļĵ%sУ";

static const char* cn_file_add_forward_num			= "ļп%sǰ";
static const char* cn_file_add_forward_line			= "ڵ%sǰԭ = %s";
static const char* cn_file_add_forward_old_text		= "ԭ = %s";
static const char* cn_file_add_forward_new_text		= "ǰ = %s";
static const char* cn_file_add_line_num				= "ļп%s";
static const char* cn_file_add_line					= "ڵ%sУԭ = %s";
static const char* cn_file_add_line_new				= " = %s(Ӧļ = %s)";

static const char* cn_file_min_use					= "%s. ļսӦļӦǰļ = %s";
static const char* cn_file_min_kid					= "%s. ļյСļļ = %s";
static const char* cn_file_sys_ancestor				= "%s. ϵͳļļļ = %s";
static const char* cn_file_user_use					= "%s. ûļü¼ļ = %s";

static const char* cn_project_history_title			= "ͳƽ";
static const char* cn_project_history_clean_count	= "%sc++ļɱ";
static const char* cn_project_history_src_count		= "ι%scppcxxccԴļ";

static const char* cn_parent_file_debug_text		= "ļ = %s, ļ = %s";
static const char* cn_file_debug_text				= "%s[%s](ļID = %d)( = %s){ļ%s}";
static const char* cn_file_include_line				= "[%s%s%s]";
static const char* cn_main_file_debug_text			= "[%s](ļID = %d)( = %s)";
static const char* cn_outer_file_flag				= "[ⲿļ]";

std::string escape_html(const char* html);

std::string escape_html(const std::string &html);

std::string get_file_html(const char *filename);

std::string get_short_file_name_html(const char *filename);

std::string get_include_html(const std::string &text);

std::string get_number_html(int num);

std::string get_warn_html(const char *text);

// 
enum RowType
{
	Row_None	= 0,	// 
	Row_Error	= 1,	// 
};

// 
enum GridType
{
	Grid_None	= 0,	// 
	Grid_Ok		= 1,	// ȷ
	Grid_Error	= 2,	// 
};

struct DivGrid
{
	DivGrid()
		: width(0)
		, gridType(Grid_None)
	{}

	std::string text;
	int			width;
	GridType	gridType;	// ӵ
};

struct DivRow
{
	DivRow()
		: tabCount(0)
		, rowType(Row_None)
	{}

	RowType					rowType;	// е
	int						tabCount;
	std::vector<DivGrid>	grids;
};

struct HtmlDiv
{
	HtmlDiv()
		: hasErrorTip(false)
	{}

	void Clear()
	{
		titles.clear();
		rows.clear();
		hasErrorTip = false;
	}

	void AddTitle(const char* title, int width = 100);

	void AddTitle(const std::string &title, int width = 100);

	void AddRow(const char* text, int tabCount = 0, int width = 100, bool needEscape = false, RowType rowType = Row_None, GridType gridType = Grid_None);

	void AddRow(const std::string &text, int tabCount = 0 /* tab */, int width = 100, bool needEscape = false, RowType rowType = Row_None, GridType gridType = Grid_None);

	void AddGrid(const char* text, int width = 0, bool needEscape = false, GridType gridType = Grid_None);

	void AddGrid(const std::string &text, int width = 0, bool needEscape = false, GridType gridType = Grid_None);

	std::vector<DivGrid>	titles;
	std::vector<DivRow>		rows;
	bool					hasErrorTip;
};

// ڽ־תhtmlʽ鿴
class HtmlLog
{
public:
	HtmlLog();

	static inline llvm::raw_ostream& GetLog() { return *instance.m_log; }

	bool Init(const std::wstring &htmlPath, const std::string &htmlTitle, const std::string &tip);

	void BeginLog();

	void EndLog();

	void AddDiv(const HtmlDiv &div);

	// Ӵ
	void AddBigTitle(const std::string &title);

public:
	static HtmlLog instance;

public:
	std::wstring		m_htmlPath;

	// ҳļ
	std::string			m_htmlTitle;

	// ҳڵʾ
	std::string			m_tip;

	// ǰdiv
	HtmlDiv				m_newDiv;

	llvm::raw_ostream*	m_log;

	llvm::raw_ostream*	m_newfdLog;
};

#endif // _html_log_h_