//------------------------------------------------------------------------------
// ļ: main.cpp
// : 
// ˵: ļ
// Copyright (c) 2016 game. All rights reserved.
//------------------------------------------------------------------------------

#include "cxx_clean.h"

#include <llvm/Support/Signals.h>
#include <llvm/Support/TargetSelect.h>

#include "project.h"
#include "vs.h"
#include "history.h"
#include "tool.h"
#include "html_log.h"

// ʼ
bool Init(CxxCleanOptionsParser &optionParser, int argc, const char **argv)
{
	llvm::sys::PrintStackTraceOnErrorSignal("");

	llvm::InitializeNativeTarget();				// ʼǰƽ̨
	llvm::InitializeNativeTargetAsmParser();	// ֽ֧asm

	// в
	bool ok = optionParser.ParseOptions(argc, argv);
	return ok;
}

// ʼ
void Run(const CxxCleanOptionsParser &optionParser)
{
	ClangTool tool(optionParser.getCompilations(), Project::instance.m_cpps);
	tool.clearArgumentsAdjusters();
	tool.appendArgumentsAdjuster(getClangSyntaxOnlyAdjuster());

	optionParser.AddClangArgumentByOption(tool);
	optionParser.AddClangArgument(tool, "-fcxx-exceptions");	
	optionParser.AddClangArgument(tool, "-nobuiltininc");		// ֹʹclangõͷļ
	optionParser.AddClangArgument(tool, "-w");					// þ
	optionParser.AddClangArgument(tool, "-Wno-everything");		// κξ棬-w
	optionParser.AddClangArgument(tool, "-ferror-limit=5");		// Ƶcppıٱ
	optionParser.AddClangArgument(tool, "-fpermissive");		// ԲĳЩϱ׼ΪͨԱ׼

	DiagnosticOptions diagnosticOptions;
	diagnosticOptions.ShowOptionNames = 1;
	tool.setDiagnosticConsumer(new CxxcleanDiagnosticConsumer(&diagnosticOptions)); // ע⣺newûϵᱻͷ

	// ÿļ﷨
	std::unique_ptr<FrontendActionFactory> factory = newFrontendActionFactory<CxxCleanAction>();
	tool.run(factory.get());

	ProjectHistory::instance.Print();
}

int main(int argc, const char **argv)
{
	Log("-- now = " << timetool::get_now() << " --!");

	// н
	CxxCleanOptionsParser optionParser;

	// ʼ
	if (!Init(optionParser, argc, argv))
	{
		return 0;
	}

	// ʼ
	Run(optionParser);

	Log("-- now = " << timetool::get_now() << " --!");
	Log("-- finished --!");

	system(ws2s(HtmlLog::instance.m_htmlPath).c_str());
	return 0;
}