//------------------------------------------------------------------------------
// ļ: parser.h
// : 
// ˵: ǰcppļ
// Copyright (c) 2016 game. All rights reserved.
//------------------------------------------------------------------------------

#ifndef _parser_h_
#define _parser_h_

#include <string>
#include <vector>
#include <set>
#include <map>

#include <clang/Basic/SourceLocation.h>
#include <clang/Basic/SourceManager.h>
#include <clang/Rewrite/Core/Rewriter.h>

#include "history.h"
#include <unordered_set>

using namespace std;
using namespace clang;

namespace clang
{
	class HeaderSearch;
	class MacroDefinition;
	class Token;
	class QualType;
	class CXXRecordDecl;
	class NamedDecl;
	class Rewriter;
	class CompilerInstance;
	class NestedNameSpecifier;
	class Type;
	class NamespaceDecl;
	class NamespaceAliasDecl;
	class UsingDirectiveDecl;
	class FunctionDecl;
	class MacroArgs;
	class VarDecl;
	class ValueDecl;
	class RecordDecl;
	class UsingDecl;
	class TemplateArgument;
	class TemplateArgumentList;
	class TemplateDecl;
	class CXXConstructorDecl;
	class DeclContext;
}

// [ļ] -> [·ϵͳ·û·]
typedef std::map<string, SrcMgr::CharacteristicKind> IncludeDirMap;

// classstructunion
typedef std::set<const CXXRecordDecl*> RecordSet;

// usingб
typedef std::vector<const UsingDecl*> UsingVec;

// [λ] -> [ʹõclassstructûָ]
typedef std::map<SourceLocation, RecordSet> LocUseRecordsMap;

// [ļ] -> [ʹõclassstructûָ]
typedef std::map<FileID, RecordSet> FileUseRecordsMap;

// [ļ] -> [ļʹõclassstructunionָ]
typedef std::map<FileID, LocUseRecordsMap> UseRecordsByFileMap;

// ļ
typedef std::set<FileID> FileSet;

// ļб
typedef std::vector<FileID> FileVec;

// ļ
typedef std::set<std::string> FileNameSet;

// setset
template <typename Container1, typename Container2>
inline void Add(Container1 &a, const Container2 &b)
{
	a.insert(b.begin(), b.end());
}

// setmap
template <typename Key, typename Val>
inline void Add(std::set<Key> &a, const std::map<Key, Val> &b)
{
	for (const auto &itr : b)
	{
		a.insert(itr.first);
	}
}

template <typename Container, typename Key>
inline bool Has(Container& container, const Key &key)
{
	return container.find(key) != container.end();
}

// ǰڽc++ļϢ
class ParsingFile
{
	// ڵԣõ
	struct UseNameInfo
	{
		inline void AddName(const char* name, int line)
		{
			if (nameMap.find(name) == nameMap.end())
			{
				nameVec.push_back(name);
			}

			nameMap[name].insert(line);
		}

		FileID									file;
		std::vector<string>						nameVec;
		std::map<string, std::set<int>>			nameMap;
	};

	// ռϢ
	struct NamespaceInfo
	{
		NamespaceInfo()
			: ns(nullptr) {}

		std::string			name;		// ռ磺namespace A{ namespace B { namespace C {} } }
		const NamespaceDecl	*ns;		// ռĶ
	};

public:
	// ͷļ·
	struct HeaderSearchDir
	{
		HeaderSearchDir(const string& dir, SrcMgr::CharacteristicKind dirType)
			: m_dir(dir)
			, m_dirType(dirType)
		{}

		string						m_dir;
		SrcMgr::CharacteristicKind	m_dirType;
	};

public:
	ParsingFile(clang::CompilerInstance &compiler);

	~ParsingFile();

	inline clang::SourceManager& GetSrcMgr() const { return *m_srcMgr; }

	// ӳԱļ
	void AddFile(FileID file);

	// ǰcppļʼ
	void Begin();

	// ǰcppļ
	void End();

	// 
	void Analyze();

	// ļ
	int GetDeepth(FileID file) const;

	// ǷΪǰ
	bool IsForwardType(const QualType &var);

	// Ƿе޶ռ䣨::std::vector<int>::еvectorͲռ䣩
	bool IsAllQualifierNamespace(const NestedNameSpecifier *specifier);

	// aļʹbļ
	inline void UseInclude(FileID a, FileID b, const char* name = nullptr, int line = 0);

	// ǰλʹָĺ
	void UseMacro(SourceLocation loc, const MacroDefinition &macro, const Token &macroName, const MacroArgs *args = nullptr);

	// ȥָ룬ȡָ
	QualType GetPointeeType(const QualType &var);

	// ʹñ¼
	void UseVarType(SourceLocation loc, const QualType &var);

	// ù캯
	void UseConstructor(SourceLocation loc, const CXXConstructorDecl *constructor);

	// ñ
	void UseVarDecl(SourceLocation loc, const VarDecl *var);

	// ñΪֵʾenum
	void UseValueDecl(SourceLocation loc, const ValueDecl *valueDecl);

	// ôƵ
	void UseNameDecl(SourceLocation loc, const NamedDecl *nameDecl);

	// ʹú¼
	void UseFuncDecl(SourceLocation loc, const FunctionDecl *funcDecl);

	// ģ
	void UseTemplateArgument(SourceLocation loc, const TemplateArgument &arg);

	// ģб
	void UseTemplateArgumentList(SourceLocation loc, const TemplateArgumentList *args);

	// ģ嶨
	void UseTemplateDecl(SourceLocation loc, const TemplateDecl *decl);

	// ʹclassstructunion¼
	void UseRecord(SourceLocation loc, const RecordDecl *record);

	// ǷΪϵͳͷļ<vector><iostream>Ⱦϵͳļ
	inline bool IsSystemHeader(FileID file) const;

	// ָλǷϵͳͷļڣ<vector><iostream>Ⱦϵͳļ
	inline bool IsInSystemHeader(SourceLocation loc) const;

	// aλõĴʹbλõĴ
	inline void Use(SourceLocation a, SourceLocation b, const char* name = nullptr);

	// ǰλʹĿͣעQualTypeĳ͵constvolatilestaticȵΣ
	void UseQualType(SourceLocation loc, const QualType &t);

	// ǰλʹĿͣעTypeĳͣconstvolatilestaticȵΣ
	void UseType(SourceLocation loc, const Type *t);

	// ģռ
	void UseContext(SourceLocation loc, const DeclContext*);

	// Ƕη
	void UseQualifier(SourceLocation loc, const NestedNameSpecifier*);

	// Ƕη
	void UseUsingQualifier(SourceLocation loc, const NestedNameSpecifier*);

	// ռ
	void UseNamespaceDecl(SourceLocation loc, const NamespaceDecl*);

	// using namespace
	void UseUsingNamespace(SourceLocation loc, const NamespaceDecl*);

	// using
	void UseUsing(SourceLocation loc, const NamedDecl*);

	// ռ
	void UseNamespaceAliasDecl(SourceLocation loc, const NamespaceAliasDecl*);

	// ռ
	void DeclareNamespace(const NamespaceDecl *d);

	// usingռ䣬磺using namespace std;
	void UsingNamespace(const UsingDirectiveDecl *d);

	// usingռµĳ࣬磺using std::string;
	void UsingXXX(const UsingDecl *d);

	// ȡռȫ·磬namespace A{ namespace B{ class C; }}
	std::string GetNestedNamespace(const NamespaceDecl *d);

	// aʹbʱ跨ҵһaϹϵbⲿ
	inline FileID GetBestAncestor(FileID a, FileID b) const;

	// ʼļĶc++Դļ
	void Clean();

	// дc++Դļأtrueдɹfalseдʧ
	// ӿڲοRewriter::overwriteChangedFiles
	bool Overwrite();

	// ӡ + 1
	std::string AddPrintIdx() const;

	// ӡϢ
	void Print();

	// ȡļıʷ
	CompileErrorHistory& GetCompileErrorHistory() { return m_compileErrorHistory; }

	// ȡָΧı
	std::string GetSourceOfRange(SourceRange range) const;

	// ȡָλõı
	const char* GetSourceAtLoc(SourceLocation loc) const;

	// ļǷǱ-includeǿư
	inline bool IsForceInclude(FileID file) const;

	// ȡļͨclangӿڣļδǾ·Ҳ·
	// 磺ܷأd:/hello.hҲܷأ./hello.h
	inline const char* GetFileName(FileID file) const;

	// ȡļľ·
	inline string GetAbsoluteFileName(FileID file) const;

	// ȡļľ·
	inline const char* GetFileNameInCache(FileID file) const;

	// ȡļСд·
	inline const char* GetLowerFileNameInCache(FileID file) const;

	// ڵԣȡļľ·Ϣ
	string GetDebugFileName(FileID file) const;

	// ȡļıϢݰļļļ#includeкšļ#includeԭʼı
	std::string DebugBeIncludeText(FileID file) const;

private:
	// ȡͷļ·
	std::vector<HeaderSearchDir> TakeHeaderSearchPaths(const clang::HeaderSearch &headerSearch) const;

	// ͷļ·ݳɳ
	std::vector<HeaderSearchDir> SortHeaderSearchPath(const IncludeDirMap& include_dirs_map) const;

	// 2ļǷļһ
	inline bool IsSameName(FileID a, FileID b) const;

	// ȡļȣļĸ߶Ϊ0
	int GetDepth(FileID child) const;

	// ȡָλеı
	std::string GetSourceOfLine(SourceLocation loc) const;

	/*
		ݴĴλ÷ظеķΧз[пͷĩ]
		磺
			windowsʽ
				int			a		=	100;\r\nint b = 0;
				^			^				^
							λ		ĩ

			linuxʽ
				int			a		=	100;\n
				^			^				^
							λ		ĩ
	*/
	SourceRange GetCurLine(SourceLocation loc) const;

	// ͬGetCurLineз[пͷһпͷ]
	SourceRange GetCurFullLine(SourceLocation loc) const;

	// ݴĴλ÷һеķΧ
	SourceRange GetNextLine(SourceLocation loc) const;

	// ȡк
	int GetLineNo(SourceLocation loc) const;

	// ȡļӦıк
	int GetIncludeLineNo(FileID) const;

	// ȡļӦ#includeΧ
	SourceRange GetIncludeRange(FileID) const;

	// Ƿǻз
	bool IsNewLineWord(SourceLocation loc) const;

	// ȡļӦ#includeڵУз
	// ע⣺һcppļ£е1к͵2аa.hȻͬһļFileIDǲһ
	//		1. #include "./a.h"
	//		2. #include "a.h"
	//	ִһa.hӦFileID = #include "./a.h"
	std::string GetBeIncludeLineText(FileID file) const;

	// ¼ϵļaļbĳеĳ
	inline void UseName(FileID file, FileID beusedFile, const char* name = nullptr, int line = 0);

	// ȡļļûиļ
	FileID GetParent(FileID child) const;

	// ȡc++classstructunionȫռ
	// 磺CCռAеռBأnamespace A{ namespace B{ class C; }}
	string GetRecordName(const RecordDecl &recordDecl) const;

	// ʹǰ¼ڲҪӵǰ֮
	inline void UseForward(SourceLocation loc, const CXXRecordDecl *cxxRecordDecl);

	// Ƿc++ļļݲκα仯
	inline bool CanClean(FileID file) const;
	inline bool CanCleanByName(const char *fileName) const;

	// ȡļϢ
	std::string DebugParentFileText(FileID file, int n) const;

	// ȡλеϢеıļк
	std::string DebugLocText(SourceLocation loc) const;

	// ȡļʹϢļʹõԼӦк
	void DebugUsedNames(FileID file, const std::vector<UseNameInfo> &useNames) const;

	// ȡƴдλ
	inline SourceLocation GetSpellingLoc(SourceLocation loc) const;

	// ȡչλ
	inline SourceLocation GetExpasionLoc(SourceLocation loc) const;

	// ȡļID
	inline FileID GetFileID(SourceLocation loc) const;

	// ȡ1ļ#include2ļı
	std::string GetRelativeIncludeStr(FileID f1, FileID f2) const;

	// ͷļ··תΪ˫ŰΧı
	// 磺ͷļ·"d:/a/b/c" "d:/a/b/c/d/e.h" -> "d/e.h"
	string GetQuotedIncludeStr(const char *absoluteFilePath) const;

	// 滻ָΧı
	void ReplaceText(FileID file, int beg, int end, const char* text);

	// ı뵽ָλ֮ǰ
	// 磺"abcdefg"ıc123Ľǣ"ab123cdefg"
	void InsertText(FileID file, int loc, const char* text);

	// ƳָΧı
	void RemoveText(FileID file, int beg, int end);

	// Ƴָļڵ
	void CleanByDelLine(const FileHistory &history, FileID file);

	// ָļǰ
	void CleanByForward(const FileHistory &history, FileID file);

	// ָļ滻#include
	void CleanByReplace(const FileHistory &history, FileID file);

	// ָļ
	void CleanByAdd(const FileHistory &history, FileID file);

	// ʷָļ
	void CleanByHistory(const FileHistoryMap &historys);

	// ļʽǷwindowsʽзΪ[\r\n]UnixΪ[\n]
	bool IsWindowsFormat(FileID) const;

	// ȡԵǰcppļķ
	void TakeHistorys(FileHistoryMap &out) const;

	// ļǷԤͷļ
	bool IsPrecompileHeader(FileID file) const;

	// ȡļıʷ
	void TakeCompileErrorHistory(FileHistoryMap &out) const;

	// aļǷbλ֮ǰ
	bool IsFileBeforeLoc(FileID a, SourceLocation b) const;

	// aļǷbļ֮ǰ
	bool IsFileBeforeFile(FileID a, FileID b) const;

	// ǰcppļĴ¼֮ǰcppļĴ¼ϲ
	void MergeTo(FileHistoryMap &old) const;

	// ļǷĬϱ
	bool IsDefaultIncluded(FileID file) const;

	// 2ļǷǵ1ļ
	inline bool IsAncestorByName(FileID young, FileID old) const;

	// 2ļǷǵ1ļ
	inline bool IsAncestorByName(const char *young, const char *old) const;

	// սУļaǷļb
	inline bool Contains(FileID a, FileID b) const;

	// ȡļһαʱļIDͬһļܰΣӦжļID
	FileID GetFirstFileID(FileID file) const;

	// ȡļӦļIDͬһļܰΣӦжļIDȡһ
	FileID GetFileIDByFileName(const char *fileName) const;

	// ļǷӦõclassstructunionǰ
	bool IsShouldKeepForwardClass(FileID, const CXXRecordDecl &cxxRecord) const;

	// ɾļֵtrueɾfalseδɾ
	bool CutInclude(FileID top, FileSet &done, FileSet &includes);

	// ϲļÿļ¼ӦеļһѾļˣƳ
	bool MergeMinInclude();

	// Ƿûļɱ޸ĵļΪûļΪⲿļ
	inline bool IsUserFile(FileID file) const;

	// Ƿⲿļɱ޸ĵļΪûļΪⲿļ
	inline bool IsOuterFile(FileID file) const;

	// ȡⲿļ
	inline FileID GetOuterFileAncestor(FileID file) const;

	// Ĭϱļб
	void GenerateDefaultIncludes();

	// ⲿļȼ¼
	void GenerateOutFileAncestor();

	// ûļ¼
	void GenerateUserUse();

	// ÿļӦļ
	void GenerateMinInclude();

	// ǰб
	void GenerateForwardClass();

	// üǰбɾظģ
	void MinimizeForwardClass();

	// ȡָļļǰб
	void GetAllForwardsInKids(FileID top, RecordSet &forwards);

	// ȡļĿɾ#include
	void TakeDel(FileHistory &history, const FileSet &dels) const;

	// ȡͷļ滻Ϣ
	void TakeReplaceLine(ReplaceLine &replaceLine, FileID from, FileID to) const;

	// ȡǰϢ
	void TakeForwardClass(FileHistory &history, FileID insertAfter, FileID top) const;

	// ȡļϢ
	void TakeAdd(FileHistory &history, FileID top, const std::map<FileID, FileVec> &inserts) const;

	// °ļ򣬼ÿļӦλ
	void SortAddFiles(FileID top, const FileSet &adds, const FileSet &keeps, FileID insertAfter, std::map<FileID, FileVec> &inserts) const;

	// Ӧһо#include#include
	FileID CalcInsertLoc(const FileSet &includes, const FileSet &dels) const;

	// ȡָļķ
	void TakeHistory(FileID top, FileHistory &out) const;

	// ļǷĬϱ
	inline bool IsAncestorDefaultInclude(FileID file) const;

	// ļǷǿƺ
	inline bool IsAncestorSkip(FileID file) const;

	// ǷбҪӡļ
	bool IsNeedPrintFile(FileID) const;

// ӡ
private:
	// ӡļĸļ
	void PrintParent();

	// ӡü¼
	void PrintUse() const;

	// ӡ#include¼
	void PrintInclude() const;

	// ӡȵļ¼
	void PrintUseName() const;

	// ӡתΪǰָü¼
	void PrintUseRecord() const;

	// ӡյǰ¼
	void PrintForwardClass() const;

	// ӡļб
	void PrintAllFile() const;

	// ӡ־
	void PrintHistory() const;

	// ӡļڵռ
	void PrintNamespace() const;

	// ӡļڵusing namespace
	void PrintUsingNamespace() const;

	// ӡͷļ·
	void PrintHeaderSearchPath() const;

	// ڵԣӡļ¼#includeı
	void PrintRelativeInclude() const;

	// ӡÿļԭʼļ¼
	void PrintKidsByName();

	// ӡεļ
	void PrintSameFile() const;

	// ӡÿļӦļǰ
	void PrintMinInclude() const;

	// ӡÿļյĺļ
	void PrintMinKid() const;

	// ӡ
	void PrintOutFileAncestor() const;

	// ӡ
	void PrintUserUse() const;

public:
	// ǰڽļ
	static ParsingFile *g_nowFile;

	//================== շ ==================//
private:
	// [շ]. ǰcppļĽ[c++ļ] -> [ļ]
	FileHistoryMap								m_historys;

	// ļСļб[ļID] -> [ļӦֱӰļIDб]
	std::map<FileID, FileSet>					m_minInclude;

	// ÿļӦǰ
	FileUseRecordsMap							m_fowardClass;


	//================== [ԭʼݽзĽ] ==================//
private:
	// ļĺļб[ļ] -> [ļȫļ]
	std::map<std::string, FileNameSet>			m_kidsByName;

	// ļӦĺļб[ļID] -> [ļӦĺļIDб]
	std::map<FileID, FileSet>					m_minKids;

	// ûļбɱ޸ĵļΪûļΪⲿļ磬ĳļ#include <vector>Ϊ<vector>ǿļֹĶvectorⲿļ
	FileSet										m_userFiles;

	// ⲿļⲿļ[ļID] -> [ӦⲿļID]
	std::map<FileID, FileID>					m_outFileAncestor;

	// Ŀļùϵ[ûļ] -> [õûļIDб + ⲿļIDб]
	std::map<std::string, FileSet>				m_userUses;

	// ĬϱļIDбЩļкļ޸ģ
	FileSet										m_defaultIncludes;

	// ǿƺԵļIDбЩļкļ޸ģ
	FileSet										m_skips;


	//================== [ԭʼ] ==================//
private:
	//------ 1. ϵ ------//

	// ļļļ¼[ļID] -> [õļб]磬A.hõB.hеclass BΪA.hB.h
	std::map<FileID, FileSet>					m_uses;

	// ڴӡļʹõȵƼ¼[ļID] -> [ļʹõļе]
	std::map<FileID, std::vector<UseNameInfo>>	m_useNames;

	//------ 2. ʹࡢṹļ¼ ------//

	// ÿλʹõclassstructָ롢ãǰ[λ] -> [ʹõclassstructunionָ]
	LocUseRecordsMap							m_locUseRecordPointers;

	// ÿļʹõclassstructָ롢ãǰ[ļ] -> [ʹõclassstructunionָ]
	FileUseRecordsMap							m_fileUseRecordPointers;

	// ÿļʹõclassstructָ롢ãڱɶǰ
	FileUseRecordsMap							m_fileUseRecords;

	//------ 3. usingйصļ¼ ------//

	// using namespace¼磺using namespace std;[using namespaceλ] -> [Ӧnamespace]
	map<SourceLocation, const NamespaceDecl*>	m_usingNamespaces;
	
	// using¼磺using std::string;[usingĿӦλ] -> [using]
	map<const NamedDecl*, UsingVec>				m_usings;

	// ڴӡļռ¼[ļ] -> [ļڵռ¼]
	std::map<FileID, std::set<std::string>>		m_namespaces;

	//------ 4. ļļ ------//

	// ļļϣ[ļ] -> [includeļ]
	std::map<std::string, FileSet>				m_includes;

	// ļID
	FileSet										m_files;

	// ļϵ[ļID] -> [ļID]
	std::map<FileID, FileID>					m_parents;

	// ͬһļӦĲͬļID[ļ] -> [ͬļIDб]
	std::map<std::string, FileSet>				m_sameFiles;

	// ļIDӦļ[ļID] -> [ļ]
	std::map<FileID, std::string>				m_fileNames;

	// ļIDӦļ[ļID] -> [Сдļ]
	std::map<FileID, std::string>				m_lowerFileNames;

	// ļӦļID[ļ] -> [ļID]
	std::map<std::string, FileID>				m_fileNameToFileIDs;	

	// ͷļ·б
	std::vector<HeaderSearchDir>				m_headerSearchPaths;
	
	// ļid
	FileID										m_root;

	//================== [clang] ==================//
private:
	// clangļд࣬޸c++Դ
	clang::Rewriter								m_rewriter;

	// clangԴ
	clang::SourceManager*						m_srcMgr;

	// clangʵ
	clang::CompilerInstance*					m_compiler;

	// ļıʷ
	CompileErrorHistory							m_compileErrorHistory;

	// ǰӡ־ӡ
	mutable int									m_printIdx;
};

#endif // _parser_h_