///<------------------------------------------------------------------------------
//< @file:   project.h
//< @author: 
//< @brief:  c++
//< Copyright (c) 2016. All rights reserved.
///<------------------------------------------------------------------------------

#ifndef _project_h_
#define _project_h_

#include <iterator>
#include <set>
#include <vector>

enum LogLvl
{
	LogLvl_0 = 0,		// ӡյͳƽ
	LogLvl_1 = 1,		// Ĭϣӡļյͳƽ
	LogLvl_2,			// ڵԣӡļɾӡļõļĿԱļ
	LogLvl_3,			// ڵԣӡļֱӻ߼ļ
	LogLvl_Max			// ڵԣӡ쳣ӡ﷨
};

typedef std::set<std::string> FileNameSet;
typedef std::vector<std::string> FileNameVec;

// Ŀ
class Project
{
public:
	Project()
		: m_isOverWrite(false)
		, m_logLvl(LogLvl_0)
		, m_printIdx(0)
	{
	}

public:
	// ļǷ
	static inline bool CanClean(const std::string &filename)
	{
		return CanClean(filename.c_str());
	}

	// ļǷ
	static bool CanClean(const char* filename);

	// ǷӦԸļ
	static bool IsSkip(const char* filename);

	// Ƴc++׺Դļ
	void Fix();

	// ӡ + 1
	std::string AddPrintIdx() const;

	// ӡļб
	void Print() const;

public:
	static Project instance;

public:
	// ļбֻڱбڵc++ļĶ
	FileNameSet					m_canCleanFiles;

	// c++Դļбֻc++׺ļcppcxx
	FileNameVec					m_cpps;

	// ļб
	FileNameSet					m_skips;

	// Ŀ¼
	std::string					m_workingDir;

	// ѡǷ񸲸ԭc++ļѡرʱĿڵc++ļκθĶ
	bool						m_isOverWrite;

	// ѡӡϸ̶ȣ0 ~ 90ʾӡĬΪ1ϸ9
	LogLvl						m_logLvl;

	// ǰӡ־ӡ
	mutable int					m_printIdx;
};

#endif // _project_h_