//------------------------------------------------------------------------------
// ļ: vs.h
// : 
// ˵: visual studioйصͽӿ
// Copyright (c) 2016 game. All rights reserved.
//------------------------------------------------------------------------------

#ifndef _vs_h_
#define _vs_h_

#include <iterator>
#include <vector>
#include <set>

class Project;

using namespace std;

// vsѡ
struct VsConfig
{
	// ģʽƽ̨һ˵4֣Debug|Win32Debug|Win64Release|Win32Release|Win64
	std::string					mode;

	std::vector<std::string>	forceIncludes;	// ǿincludeļб
	std::vector<std::string>	preDefines;		// Ԥ#defineĺб
	std::vector<std::string>	searchDirs;		// ·б
	std::vector<std::string>	extraOptions;	// ѡ

	// һЩҪ·
	void Fix();

	void Print() const;

	static bool FindMode(const std::string text, std::string &mode);
};

// vsļӦ.vcproj.vcxproj
class VsProject
{
public:
	VsProject()
		: m_version(0)
	{}

public:
	// vs2005汾Ĺļvcproj׺
	static bool ParseVs2005(const std::string &vcproj, VsProject &vs2005);

	// vs2008vs2008ϰ汾Ĺļvcxproj׺
	static bool ParseVs2008AndUppper(const std::string &vcxproj, VsProject &vs2008);

	// visual studioļ
	bool ParseVs(const std::string &vsproj_path);

public:
	VsConfig* GetVsconfigByMode(const std::string &modeAndPlatform);

	void GenerateMembers();

	// ӡvs
	void Print() const;

public:
	static VsProject				instance;

	int								m_version;				// vs汾
	std::string						m_project_dir;			// ļ·
	std::string						m_project_full_path;	// ļȫ·:../../hello.vcproj

	std::vector<VsConfig>			m_configs;
	std::vector<std::string>		m_headers;				// ڵhhpphhhxxͷļб
	std::vector<std::string>		m_cpps;					// ڵcppcccxxԴļб

	std::set<std::string>			m_all;					// c++ļ
};

#endif // _vs_h_