sampler base : register(s0) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};

sampler frame : register(s1) = sampler_state
{
    minfilter = linear;
    magfilter = linear;
};


float4 Color( float2 uv : texcoord0 ) : color0
{
    float4 color = tex2D(base, uv);
    float4 frame_color = tex2D(frame, uv);
    float alpha = frame_color.a;
    if ((uv.x > 0.01) && (uv.x < 0.99) && (uv.y > 0.01) && (uv.y < 0.99))
	color = float4(frame_color.r*alpha + color.r*(1-alpha), frame_color.g*alpha + color.g*(1-alpha), frame_color.b*alpha + color.b*(1-alpha), 1.0);
    else
	color = frame_color;
	
    return color;
}

technique BasicEffect
{
    pass P1
    {
        PixelShader = compile ps_2_0 Color();
    } 
}
