//
//  TTFont.h
//  GSFontTools
//
//  Created by Georg Seifert on 23.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SFNTReader;
@class TTable;
@class GSXMLWriter;
@protocol SFNTWriter;
@class TTGlyph;


#define TTsfntVersionCFF @"OTTO"
#define TTsfntVersionTrueType @"0100"
#define TTsfntVersionAppleTrueType @"true"
#define TTsfntVersionTTC @"ttcf"

@protocol GlyphSet <NSObject>

- (id)glyphForName:(NSString *)glyphName;
- (NSArray *)allKeys;
- (NSArray *)allValues;
- (NSUInteger)count;
@end

@interface TTFont : NSObject {
	NSString *_path;
	NSMutableDictionary *_tables;
	SFNTReader *_reader;
	NSArray *_glyphOrder;
	BOOL _disassembleInstructions;
	BOOL _verbose;
	BOOL _ignoreDecompileErrors;
	BOOL _recalcBBoxes;
	NSMutableDictionary *VIDDict;
	NSUInteger last_vid;
	NSMutableDictionary *reverseVIDDict;
	NSDictionary *_reverseGlyphOrderDict;
	NSString* _sfntVersion;
}
@property(retain, nonatomic) NSString* sfntVersion;
@property(retain, nonatomic) NSString *path;
@property(retain, nonatomic) NSMutableDictionary *tables;
@property(retain, nonatomic) NSArray *glyphOrder;
@property(nonatomic) BOOL verbose;
@property(nonatomic) BOOL ignoreDecompileErrors;
@property(nonatomic, assign) BOOL recalcBBoxes;
@property(nonatomic, assign) NSUInteger fontIndex; //for TTC fonts

@property(nonatomic, readonly) NSArray *allKeys;

- (id)initWithPath:(NSString *)Path;
- (id)initWithData:(NSData *)Data;
- (BOOL)saveFont:(NSString *)SavePath error:(NSError **)error;
- (NSData *) fontDataError:(NSError **) error;
- (void)saveToXML:(NSString *)XMLPath ;
- (void)saveToXML:(NSString *)XMLPath writeTables:(NSArray*)WriteTables skipTables:(NSArray *)SkipTables splitTables:(BOOL)SplitTables disassembleInstructions:(BOOL)DisassembleInstructions;
- (BOOL)isLoaded:(NSString *)Tag ;
- (BOOL)has_key:(NSString *)Tag;
//- (NSString *)sfntVersion;
- (NSUInteger)count ;
- (id)tableForKey:(NSString *)Key;
- (void)setTable:(TTable*)Table forKey:(NSString *)Tag ;
- (void)removeTableForKey:(NSString *)tag ;
- (NSArray *)glyphNames ;
- (NSArray *)glyphNames2 ;
- (NSString *)glyphNameAtIndex:(NSUInteger)GlyphIndex ;
- (NSUInteger)indexOfGlyphForName:(NSString *)GlyphName ;
- (BOOL)_writeTable:(NSString *)Tag writer:(id <SFNTWriter>)Writer done:(NSMutableArray *)Done error:(NSError **)error;
- (NSData *)tableDataForKey:(NSString *)Tag error:(NSError **)error;
- (id <GlyphSet>)glyphSet;
- (NSUInteger)numFonts;
- (NSDictionary *)reverseGlyphMap:(BOOL)rebuild;

+ (NSString*)stringFromSfntVersionChar:(char *)sfntVersion;
@end

Class getTableClass(NSString *tag);
