//
//  cffIndexes.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class GSXMLWriter;
@class CFFPrivateDict;
@class IndexedStrings;
@class GSFileData;
@class FDArrayIndex;
@class FDSelect;

@interface Index : NSObject {
	NSMutableArray * _items;
	NSMutableArray * _offsets;
	GSFileData * _file;
	NSUInteger _count;
	NSUInteger _offsetBase;
}
@property (readonly, nonatomic) NSMutableArray * items;

- (id) initWithFile:(GSFileData*) File ;
- (Class) compilerClass ;
- (NSUInteger) count ;
- (id) objectAtIndex:(NSUInteger) aIndex ;
- (id) produceItem:(NSUInteger)i /*data:(NSData*)Data*/ file:(GSFileData*)File offset:(NSUInteger)offset size:(NSUInteger)size;
//- (id) produceItem:(NSUInteger)i data:(NSData*)Data file:(GSFileData*) File offset:(NSUInteger)offset size:(NSUInteger)size ;
//- (id) produceItem:(NSUInteger)i data:(GSFileData*)File offset:(NSUInteger)offset size:(NSUInteger)size ;
- (void) addObject:(id) Item ;
- (void) toXML:(GSXMLWriter*)Writer ;
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content ;
@end


@interface GlobalSubrsIndex : Index {
	GlobalSubrsIndex * _globalSubrs;
	CFFPrivateDict * _private;
	FDSelect * _fdSelect;
	FDArrayIndex* _fdArray;
}
@property (retain, nonatomic) GlobalSubrsIndex * globalSubrs;

- (id) initWithFile:(GSFileData*)File globalSubrs:(GlobalSubrsIndex*)GlobalSubrs private:(CFFPrivateDict*)Private fdSelect:(FDSelect*)FdSelect fdArray:(FDArrayIndex*) FdArray ;
- (id) selectorAtIndex:(NSUInteger) aIndex ;
@end


@interface TopDictIndex : Index {
	IndexedStrings * _strings;
	GlobalSubrsIndex * _globalSubrs;
}
@property (retain, nonatomic) IndexedStrings * strings;
@property (retain, nonatomic) GlobalSubrsIndex * globalSubrs;
@end


@interface FDArrayIndex : TopDictIndex {
}
@end


@interface SubrsIndex : GlobalSubrsIndex {
}
@end




