//
//  table__m_a_x_p.h
//  GSFontTools
//
//  Created by Georg Seifert on 24.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"

@class TTFont;

@interface table__m_a_x_p : TTable {

	uint32_t _tableVersion;
	NSUInteger _glyphCount;
	uint16_t _maxPoints;
	uint16_t _maxContours;
	uint16_t _maxCompositePoints;
	uint16_t _maxCompositeContours;
	uint16_t _maxZones;
	uint16_t _maxTwilightPoints;
	uint16_t _maxStorage;
	uint16_t _maxFunctionDefs;
	uint16_t _maxInstructionDefs;
	uint16_t _maxStackElements;
	uint16_t _maxSizeOfInstructions;
	uint16_t _maxComponentElements;
	uint16_t _maxComponentDepth;
}

@property (nonatomic, assign) NSUInteger glyphCount;
@property (nonatomic, assign) uint32_t tableVersion;
@property (nonatomic, assign) uint16_t maxPoints;
@property (nonatomic, assign) uint16_t maxContours;
@property (nonatomic, assign) uint16_t maxCompositePoints;
@property (nonatomic, assign) uint16_t maxCompositeContours;
@property (nonatomic, assign) uint16_t maxZones;
@property (nonatomic, assign) uint16_t maxTwilightPoints;
@property (nonatomic, assign) uint16_t maxStorage;
@property (nonatomic, assign) uint16_t maxFunctionDefs;
@property (nonatomic, assign) uint16_t maxInstructionDefs;
@property (nonatomic, assign) uint16_t maxStackElements;
@property (nonatomic, assign) uint16_t maxSizeOfInstructions;
@property (nonatomic, assign) uint16_t maxComponentElements;
@property (nonatomic, assign) uint16_t maxComponentDepth;

- (void) recalc:(TTFont*)Font ;
@end
