//
//  COGlyphRecord.h
//  GSFontTools
//
//  Created by Georg Seifert on 04.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class OTValueRecord;

NSMutableArray * glyphNamesToGlyphRecords(NSArray * glyphList) ;
NSMutableArray * glyphRecordsToGlyphNames(NSArray* glyphRecords) ;

@interface COGlyphRecord : NSObject {
	id _glyph;
	NSString * _glyphName;
	NSInteger _xPlacement;
	NSInteger _yPlacement;
	NSInteger _xAdvance;
	NSInteger _yAdvance;
	NSInteger _advanceWidth;
	NSInteger _advanceHeight;
	NSMutableArray * _alternates;
	NSString * _alternatesReference;
	NSArray * _ligatureComponents;
	NSArray * _ligatureComponentsReference;
	NSMutableArray * _substitutionHistory;
	
	NSDictionary * _attributes;
}
@property (retain, nonatomic) NSString * glyphName;
@property (retain, nonatomic) NSArray * ligatureComponents;
@property (retain, nonatomic) NSMutableArray * alternates;
@property (retain, nonatomic) NSString * alternatesReference;
@property (nonatomic, retain) NSDictionary *attributes;
@property (nonatomic, retain) NSMutableArray *substitutionHistory;

/**
 The number of glyphs with which the original glyph was substituted. The sign indicates the direction of substitution, with negative for many-to-one substitutions and positive for one-to-many substitutions.
 
 Example 1: f and i are replaced with ﬁ (‘liga’ feature), `substitutionGlyphCount` is -2.
 Example 2: a is replaced with bcd (‘multi’ feature), `substitutionGlyphCount` is +3.
 */
@property (nonatomic, assign) NSInteger substitutionGlyphCount;

@property (nonatomic, assign) NSInteger xPlacement;
@property (nonatomic, assign) NSInteger yPlacement;
@property (nonatomic, assign) NSInteger xAdvance;
@property (nonatomic, assign) NSInteger yAdvance;
@property (nonatomic, assign) NSInteger advanceWidth;
@property (nonatomic, assign) NSInteger advanceHeight;

- (id) initWithGlyphName:(NSString*) GlyphName ;
- (void) addValues:(OTValueRecord*) aValueRecord ;

/**
 Appends the given glyph names to the receiver’s substitution history.
 Also decrements the receiver’s `substitutionIndexOffset` property by the number of glyph names.

 @param GlyphNames An array of glyph names (as NSString objects) to append.
 */
- (void) saveState:(NSArray*) GlyphNames ;

/**
 Increments the receiver’s `substitutionIndexOffset` property by the number of glyph names.

 @param glyphNames An array of glyph names (as NSString objects) to append.
 */
- (void)saveFutureState:(NSArray*)glyphNames;

- (NSString*) side1GlyphNameWithUnicodeValue:(NSDictionary*) reversedCMAP;
- (NSString*) side2GlyphNameWithUnicodeValue:(NSDictionary*) reversedCMAP;
@end
