//
//  GSIntArray.h
//  GSFontTools
//
//  Created by Georg Seifert on 19/03/16.
//
//

#import <Foundation/Foundation.h>

@interface GSIntArray : NSObject <NSCopying>

- (instancetype)initWithCapacity:(NSUInteger)capacity;
- (instancetype)initWithInts:(int*)ints count:(NSUInteger)count;
- (int)elementAtIndex:(NSUInteger)idx;
- (void)setElement:(int)element atIndex:(NSUInteger)idx;
- (void)addElement:(int)element;
- (int*)elements;
- (NSUInteger)count;

- (instancetype)copySubarrayWithRange:(NSRange)range;

- (NSInteger)lastElement;
- (NSInteger)firstElement;
- (void)removeElementAtIndex:(NSUInteger)idx;
- (void)insertElement:(int)Element atIndex:(NSUInteger)idx;
- (void)addElementsFromArray:(GSIntArray *)array;

- (NSUInteger)firstIndexOfElement:(int)element;
- (NSUInteger)firstIndexOfElement:(int)element inRange:(NSRange)range;
- (NSUInteger)lastIndexOfElement:(int)element;
@end
