//
//  NSDataToInteger.h
//  Tests
//
//  Created by Georg Seifert on 2.3.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
NSString *num2binary(NSInteger l, short bits);
NSInteger binary2num(NSString *bin);

@interface NSData (DataToInteger)

- (u_int8_t)unsignedInt8AtOffset:(NSUInteger *)offsetPtr;
- (int8_t)int8AtOffset:(NSUInteger*)offsetPtr;

- (int16_t)int16AtOffset:(NSUInteger *)offsetPtr;
- (u_int16_t)unsignedInt16AtOffset:(NSUInteger*)offsetPtr;

- (int32_t)int32AtOffset:(NSUInteger *)offsetPtr;
- (u_int32_t)unsignedInt32AtOffset:(NSUInteger *)offsetPtr;

- (NSUInteger)unsignedIntegerAtOffset:(NSUInteger*)offsetPtr ofSize: (NSUInteger)size;

- (NSData *)subdataFromIndex:(NSUInteger)aIndex;
@end

@interface NSMutableData (Wrinting)
- (void)appendUInt8:(uint8_t)value;
- (void)appendInt8:(int8_t)value;
- (void)appendUInt16:(uint16_t)value;
- (void)appendInt16:(int16_t)value;
- (void)appendUInt32:(uint32_t)value;
- (void)appendInt32:(int32_t)value;
	
@end
