//
//  OTBase.h
//  GSFontTools
//
//  Created by Georg Seifert on 26.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"


@class OTTableStack;
@class OTValueRecord;
@class OTDevice;

@interface OTTableReader : NSObject {
	NSData * _data;
	NSString* _tableType;
	NSUInteger _offset;
	NSUInteger _pos;
	NSMutableArray* _valueFormat;
	id _cachingStats;
}
@property (readonly, nonatomic) NSData * data;
@property (nonatomic) NSUInteger pos;
@property (nonatomic) NSUInteger offset;
@property (nonatomic, retain) NSMutableArray *valueFormat;

- (id) initWithData:(NSData*)Data tableTag:(NSString*)TableType ;
- (id) initWithData:(NSData*)Data tableTag:(NSString*)TableType offset:(NSUInteger) Offset valueFormat:(id)ValueFormat cachingStats:(id)CachingStats ;
- (NSString*) tableType ;
- (OTTableReader*) subReader:(NSUInteger) Offset;
- (uint8_t) readUInt8 ;
- (int8_t) readInt8 ;
- (uint16_t) readUInt16 ;
- (int16_t) readInt16 ;
- (uint32_t) readUInt32 ;
- (int32_t) readInt32 ;
- (NSString*) readTag ;
- (uint32_t) readUInt24;
- (NSData*) readData:(uint16_t)length;
- (void) setValueFormat:(NSUInteger)format which:(int)which ;

- (OTValueRecord*) valueRecord:(int) Which font:(TTFont*)Font ;
@end

@interface OTTableWriter : NSObject <NSCopying> {
	OTTableWriter *__unsafe_unretained _parent;
	NSMutableArray * _items;
	NSString* _tableType;
	NSMutableArray * _valueFormat;
	NSUInteger _pos;
	BOOL _sortCoverageLast;
	NSUInteger _repeatIndex;
	NSString *_name;
}
@property (nonatomic, unsafe_unretained) OTTableWriter *parent;
@property (nonatomic, retain) NSMutableArray *items;
@property (nonatomic, copy) NSString* tableType;
@property (nonatomic, retain) NSMutableArray *valueFormat;
@property (nonatomic) NSUInteger pos;
@property (nonatomic) BOOL sortCoverageLast;
@property (nonatomic) NSUInteger repeatIndex;
@property (nonatomic, retain) NSString *name;
@property (nonatomic) bool longOffset;

- (id) initWithTableType:(id)TableType valueFormat:(NSArray*)ValueFormat ;

- (OTTableWriter *)subWriter;
- (NSData*)allData;
- (NSUInteger)dataLength;
- (void)writeUInt8:(NSUInteger)Value;
- (void)writeInt8:(NSInteger)Value;
- (void)writeUInt16:(NSUInteger)Value;
- (void)writeInt16:(NSInteger)Value;
- (void)writeInt32:(NSInteger)Value;
- (void)writeUInt32:(NSUInteger)Value;
- (void)writeUInt24:(NSUInteger)Value;
- (void)writeTag:(NSString *)Tag;
- (void)writeSubTable:(OTTableWriter *)SubWriter;
- (void)writeCountReference:(id)Table name:(NSString *)Name;
//- (void)writeOffsetReference:(NSDictionary *)RawTable name:(NSString*)Name size:(uint8_t)size;
- (void)writeStruct:(int)Format values:(NSArray *)Value;
- (void)writeData:(NSData *)Data;
- (void)setValueFormat:(int)Format which:(int)Which;
@end

@interface OTTableStack :NSObject {
	NSMutableArray* _stack;
}
@property (readonly, nonatomic) NSArray* stack;

- (void) push:(NSDictionary*) Table ;
- (void) pop ;
- (NSDictionary*) top ;
- (id) getValue:(NSString*) Name ;
- (void) storeValue:(id) Value forKey:(NSString*) Name ;
@end

@interface OTBaseTable : NSObject {
	NSUInteger _compileStatus;
	NSUInteger _recurse;
//	NSString * _start;
//	NSString * _end;
	OTTableReader * _reader;
	TTFont *__unsafe_unretained _font;
	NSArray * _converters;
	//NSMutableDictionary * _converterByName;
	NSMutableDictionary * __rawTable;
	NSInteger _format;
	NSString * _name;
}

@property (readonly, nonatomic) NSArray * converters;
@property (nonatomic) NSInteger format;
@property (retain, nonatomic) NSString * name;
@property (nonatomic) NSUInteger compileStatus;
@property (retain, nonatomic) OTTableReader * reader;
@property (unsafe_unretained, nonatomic) TTFont * font;
@property (nonatomic, assign) BOOL sortCoverageLast;

//@property (retain, nonatomic) NSString *  start;
//@property (retain, nonatomic) NSString *  end;

//- (BOOL) decompile:(OTTableReader*)Reader font:(TTFont*)Font error:(NSError**)error;
- (Class) lookupListClass ;
- (BOOL) decompile:(OTTableReader*)Reader font:(TTFont*)Font tableStack:(OTTableStack*) aTableStack error:(NSError**) error ;
- (BOOL) decompile:(NSData *)data font:(TTFont *)Font error:(NSError **)error;
- (void) preCompile ;
- (void) compile:(OTTableWriter*)Writer font:(TTFont*)Font tableStack:(OTTableStack *)TableStack ;
- (void) readFormat:(OTTableReader*) Reader ;
- (void) writeFormat:(OTTableWriter*) Writer ;

- (void) postRead:(NSDictionary*) Table font:(TTFont*)Font ;
- (NSMutableDictionary*) preWrite:(TTFont*)Font ;
- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font attrs:(NSMutableDictionary*)Attrs; 
- (void) toXML2:(GSXMLWriter*)Writer font:(TTFont*)Font;
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content font:(TTFont*)Font ;

- (NSString*) fdkFeatureCodeLookups:(NSMutableDictionary*)lookups;
- (NSString*) attributeNameFromConverterName:(NSString*)ConvName;
@end


@interface BaseTTXConverter : TTable {
	//NSString * _tableTag;
	OTBaseTable * _table;
}
@property (retain, nonatomic) OTBaseTable* table;
@end


@interface OTFormatSwitchingBaseTable : OTBaseTable {
	//NSUInteger _format;
}
//@property (nonatomic) NSUInteger format;
@end


@interface ValueRecordFactory : NSObject <NSCopying> {
	NSMutableArray * _format;
}
- (void) setFormat:(unsigned short) ValueFormat;
- (OTValueRecord*) readValueRecord:(OTTableReader*)Reader font:(TTFont*)Font;
- (void) writeValueRecord:(OTTableWriter*) Writer font:(TTFont*)Font valueRecord:(OTValueRecord*) aValueRecord;
@end


@interface OTValueRecord : NSObject
@property (nonatomic, strong) OTDevice* xPlaDevice;
@property (nonatomic, strong) OTDevice* yPlaDevice;
@property (nonatomic, strong) OTDevice* xAdvDevice;
@property (nonatomic, strong) OTDevice* yAdvDevice;
@property (nonatomic) NSInteger xPlacement;
@property (nonatomic) NSInteger yPlacement;
@property (nonatomic) NSInteger xAdvance;
@property (nonatomic) NSInteger yAdvance;
- (void) toXML:(GSXMLWriter *)Writer font:(TTFont *)Font name:(NSString *)Name attrs:(NSMutableDictionary*)Attrs;
@end


@interface OTValueRecordFormat : NSObject <NSCopying>
@property (nonatomic, retain) NSString* name;
@property (nonatomic) uint16_t mask;
@property (nonatomic) BOOL isDevice;
@property (nonatomic) BOOL isSigned;
@end
